const neg = @import("negXi2.zig");
const testing = @import("std").testing;

fn test__negdi2(a: i64, expected: i64) !void {
    const result = neg.__negdi2(a);
    try testing.expectEqual(expected, result);
}

test "negdi2" {
    // TODO ensuring that math.minInt(i64); returns error

    try test__negdi2(-3, 3);
    try test__negdi2(-2, 2);
    try test__negdi2(-1, 1);
    try test__negdi2(0, 0); // special case for 2s complement
    try test__negdi2(1, -1);
    try test__negdi2(2, -2);
    try test__negdi2(3, -3);

    // max_usable == MAX(i32) == -MIN(i32)
    // == 9223372036854775807 == 7fffffffffffffff
    // divTrunc: max_usable / i, i=1,2,3,5,100
    // 7fffffffffffffff / i
    try test__negdi2(-3074457345618258602, 3074457345618258602);
    try test__negdi2(3074457345618258602, -3074457345618258602);
    try test__negdi2(-1844674407370955161, 1844674407370955161);
    try test__negdi2(1844674407370955161, -1844674407370955161);
    try test__negdi2(-922337203685477580, 922337203685477580);
    try test__negdi2(922337203685477580, -922337203685477580);
    // shifting: max_usable >> i, i=0..bitsize-4
    // 7fffffffffffffff >> i
    // 7fffffffffffffff >> i + 1
    // 7fffffffffffffff >> i + 3
    // 7fffffffffffffff >> i + 7
    try test__negdi2(-9223372036854775807, 9223372036854775807);
    try test__negdi2(9223372036854775807, -9223372036854775807);
    try test__negdi2(-9223372036854775806, 9223372036854775806);
    try test__negdi2(9223372036854775806, -9223372036854775806);
    try test__negdi2(-9223372036854775804, 9223372036854775804);
    try test__negdi2(9223372036854775804, -9223372036854775804);
    try test__negdi2(-9223372036854775800, 9223372036854775800);
    try test__negdi2(9223372036854775800, -9223372036854775800);
    try test__negdi2(-4611686018427387903, 4611686018427387903);
    try test__negdi2(4611686018427387903, -4611686018427387903);
    try test__negdi2(-4611686018427387902, 4611686018427387902);
    try test__negdi2(4611686018427387902, -4611686018427387902);
    try test__negdi2(-4611686018427387900, 4611686018427387900);
    try test__negdi2(4611686018427387900, -4611686018427387900);
    try test__negdi2(-4611686018427387896, 4611686018427387896);
    try test__negdi2(4611686018427387896, -4611686018427387896);
    try test__negdi2(-2305843009213693951, 2305843009213693951);
    try test__negdi2(2305843009213693951, -2305843009213693951);
    try test__negdi2(-2305843009213693950, 2305843009213693950);
    try test__negdi2(2305843009213693950, -2305843009213693950);
    try test__negdi2(-2305843009213693948, 2305843009213693948);
    try test__negdi2(2305843009213693948, -2305843009213693948);
    try test__negdi2(-2305843009213693944, 2305843009213693944);
    try test__negdi2(2305843009213693944, -2305843009213693944);
    try test__negdi2(-1152921504606846975, 1152921504606846975);
    try test__negdi2(1152921504606846975, -1152921504606846975);
    try test__negdi2(-1152921504606846974, 1152921504606846974);
    try test__negdi2(1152921504606846974, -1152921504606846974);
    try test__negdi2(-1152921504606846972, 1152921504606846972);
    try test__negdi2(1152921504606846972, -1152921504606846972);
    try test__negdi2(-1152921504606846968, 1152921504606846968);
    try test__negdi2(1152921504606846968, -1152921504606846968);
    try test__negdi2(-576460752303423487, 576460752303423487);
    try test__negdi2(576460752303423487, -576460752303423487);
    try test__negdi2(-576460752303423486, 576460752303423486);
    try test__negdi2(576460752303423486, -576460752303423486);
    try test__negdi2(-576460752303423484, 576460752303423484);
    try test__negdi2(576460752303423484, -576460752303423484);
    try test__negdi2(-576460752303423480, 576460752303423480);
    try test__negdi2(576460752303423480, -576460752303423480);
    try test__negdi2(-288230376151711743, 288230376151711743);
    try test__negdi2(288230376151711743, -288230376151711743);
    try test__negdi2(-288230376151711742, 288230376151711742);
    try test__negdi2(288230376151711742, -288230376151711742);
    try test__negdi2(-288230376151711740, 288230376151711740);
    try test__negdi2(288230376151711740, -288230376151711740);
    try test__negdi2(-288230376151711736, 288230376151711736);
    try test__negdi2(288230376151711736, -288230376151711736);
    try test__negdi2(-144115188075855871, 144115188075855871);
    try test__negdi2(144115188075855871, -144115188075855871);
    try test__negdi2(-144115188075855870, 144115188075855870);
    try test__negdi2(144115188075855870, -144115188075855870);
    try test__negdi2(-144115188075855868, 144115188075855868);
    try test__negdi2(144115188075855868, -144115188075855868);
    try test__negdi2(-144115188075855864, 144115188075855864);
    try test__negdi2(144115188075855864, -144115188075855864);
    try test__negdi2(-72057594037927935, 72057594037927935);
    try test__negdi2(72057594037927935, -72057594037927935);
    try test__negdi2(-72057594037927934, 72057594037927934);
    try test__negdi2(72057594037927934, -72057594037927934);
    try test__negdi2(-72057594037927932, 72057594037927932);
    try test__negdi2(72057594037927932, -72057594037927932);
    try test__negdi2(-72057594037927928, 72057594037927928);
    try test__negdi2(72057594037927928, -72057594037927928);
    try test__negdi2(-36028797018963967, 36028797018963967);
    try test__negdi2(36028797018963967, -36028797018963967);
    try test__negdi2(-36028797018963966, 36028797018963966);
    try test__negdi2(36028797018963966, -36028797018963966);
    try test__negdi2(-36028797018963964, 36028797018963964);
    try test__negdi2(36028797018963964, -36028797018963964);
    try test__negdi2(-36028797018963960, 36028797018963960);
    try test__negdi2(36028797018963960, -36028797018963960);
    try test__negdi2(-18014398509481983, 18014398509481983);
    try test__negdi2(18014398509481983, -18014398509481983);
    try test__negdi2(-18014398509481982, 18014398509481982);
    try test__negdi2(18014398509481982, -18014398509481982);
    try test__negdi2(-18014398509481980, 18014398509481980);
    try test__negdi2(18014398509481980, -18014398509481980);
    try test__negdi2(-18014398509481976, 18014398509481976);
    try test__negdi2(18014398509481976, -18014398509481976);
    try test__negdi2(-9007199254740991, 9007199254740991);
    try test__negdi2(9007199254740991, -9007199254740991);
    try test__negdi2(-9007199254740990, 9007199254740990);
    try test__negdi2(9007199254740990, -9007199254740990);
    try test__negdi2(-9007199254740988, 9007199254740988);
    try test__negdi2(9007199254740988, -9007199254740988);
    try test__negdi2(-9007199254740984, 9007199254740984);
    try test__negdi2(9007199254740984, -9007199254740984);
    try test__negdi2(-4503599627370495, 4503599627370495);
    try test__negdi2(4503599627370495, -4503599627370495);
    try test__negdi2(-4503599627370494, 4503599627370494);
    try test__negdi2(4503599627370494, -4503599627370494);
    try test__negdi2(-4503599627370492, 4503599627370492);
    try test__negdi2(4503599627370492, -4503599627370492);
    try test__negdi2(-4503599627370488, 4503599627370488);
    try test__negdi2(4503599627370488, -4503599627370488);
    try test__negdi2(-2251799813685247, 2251799813685247);
    try test__negdi2(2251799813685247, -2251799813685247);
    try test__negdi2(-2251799813685246, 2251799813685246);
    try test__negdi2(2251799813685246, -2251799813685246);
    try test__negdi2(-2251799813685244, 2251799813685244);
    try test__negdi2(2251799813685244, -2251799813685244);
    try test__negdi2(-2251799813685240, 2251799813685240);
    try test__negdi2(2251799813685240, -2251799813685240);
    try test__negdi2(-1125899906842623, 1125899906842623);
    try test__negdi2(1125899906842623, -1125899906842623);
    try test__negdi2(-1125899906842622, 1125899906842622);
    try test__negdi2(1125899906842622, -1125899906842622);
    try test__negdi2(-1125899906842620, 1125899906842620);
    try test__negdi2(1125899906842620, -1125899906842620);
    try test__negdi2(-1125899906842616, 1125899906842616);
    try test__negdi2(1125899906842616, -1125899906842616);
    try test__negdi2(-562949953421311, 562949953421311);
    try test__negdi2(562949953421311, -562949953421311);
    try test__negdi2(-562949953421310, 562949953421310);
    try test__negdi2(562949953421310, -562949953421310);
    try test__negdi2(-562949953421308, 562949953421308);
    try test__negdi2(562949953421308, -562949953421308);
    try test__negdi2(-562949953421304, 562949953421304);
    try test__negdi2(562949953421304, -562949953421304);
    try test__negdi2(-281474976710655, 281474976710655);
    try test__negdi2(281474976710655, -281474976710655);
    try test__negdi2(-281474976710654, 281474976710654);
    try test__negdi2(281474976710654, -281474976710654);
    try test__negdi2(-281474976710652, 281474976710652);
    try test__negdi2(281474976710652, -281474976710652);
    try test__negdi2(-281474976710648, 281474976710648);
    try test__negdi2(281474976710648, -281474976710648);
    try test__negdi2(-140737488355327, 140737488355327);
    try test__negdi2(140737488355327, -140737488355327);
    try test__negdi2(-140737488355326, 140737488355326);
    try test__negdi2(140737488355326, -140737488355326);
    try test__negdi2(-140737488355324, 140737488355324);
    try test__negdi2(140737488355324, -140737488355324);
    try test__negdi2(-140737488355320, 140737488355320);
    try test__negdi2(140737488355320, -140737488355320);
    try test__negdi2(-70368744177663, 70368744177663);
    try test__negdi2(70368744177663, -70368744177663);
    try test__negdi2(-70368744177662, 70368744177662);
    try test__negdi2(70368744177662, -70368744177662);
    try test__negdi2(-70368744177660, 70368744177660);
    try test__negdi2(70368744177660, -70368744177660);
    try test__negdi2(-70368744177656, 70368744177656);
    try test__negdi2(70368744177656, -70368744177656);
    try test__negdi2(-35184372088831, 35184372088831);
    try test__negdi2(35184372088831, -35184372088831);
    try test__negdi2(-35184372088830, 35184372088830);
    try test__negdi2(35184372088830, -35184372088830);
    try test__negdi2(-35184372088828, 35184372088828);
    try test__negdi2(35184372088828, -35184372088828);
    try test__negdi2(-35184372088824, 35184372088824);
    try test__negdi2(35184372088824, -35184372088824);
    try test__negdi2(-17592186044415, 17592186044415);
    try test__negdi2(17592186044415, -17592186044415);
    try test__negdi2(-17592186044414, 17592186044414);
    try test__negdi2(17592186044414, -17592186044414);
    try test__negdi2(-17592186044412, 17592186044412);
    try test__negdi2(17592186044412, -17592186044412);
    try test__negdi2(-17592186044408, 17592186044408);
    try test__negdi2(17592186044408, -17592186044408);
    try test__negdi2(-8796093022207, 8796093022207);
    try test__negdi2(8796093022207, -8796093022207);
    try test__negdi2(-8796093022206, 8796093022206);
    try test__negdi2(8796093022206, -8796093022206);
    try test__negdi2(-8796093022204, 8796093022204);
    try test__negdi2(8796093022204, -8796093022204);
    try test__negdi2(-8796093022200, 8796093022200);
    try test__negdi2(8796093022200, -8796093022200);
    try test__negdi2(-4398046511103, 4398046511103);
    try test__negdi2(4398046511103, -4398046511103);
    try test__negdi2(-4398046511102, 4398046511102);
    try test__negdi2(4398046511102, -4398046511102);
    try test__negdi2(-4398046511100, 4398046511100);
    try test__negdi2(4398046511100, -4398046511100);
    try test__negdi2(-4398046511096, 4398046511096);
    try test__negdi2(4398046511096, -4398046511096);
    try test__negdi2(-2199023255551, 2199023255551);
    try test__negdi2(2199023255551, -2199023255551);
    try test__negdi2(-2199023255550, 2199023255550);
    try test__negdi2(2199023255550, -2199023255550);
    try test__negdi2(-2199023255548, 2199023255548);
    try test__negdi2(2199023255548, -2199023255548);
    try test__negdi2(-2199023255544, 2199023255544);
    try test__negdi2(2199023255544, -2199023255544);
    try test__negdi2(-1099511627775, 1099511627775);
    try test__negdi2(1099511627775, -1099511627775);
    try test__negdi2(-1099511627774, 1099511627774);
    try test__negdi2(1099511627774, -1099511627774);
    try test__negdi2(-1099511627772, 1099511627772);
    try test__negdi2(1099511627772, -1099511627772);
    try test__negdi2(-1099511627768, 1099511627768);
    try test__negdi2(1099511627768, -1099511627768);
    try test__negdi2(-549755813887, 549755813887);
    try test__negdi2(549755813887, -549755813887);
    try test__negdi2(-549755813886, 549755813886);
    try test__negdi2(549755813886, -549755813886);
    try test__negdi2(-549755813884, 549755813884);
    try test__negdi2(549755813884, -549755813884);
    try test__negdi2(-549755813880, 549755813880);
    try test__negdi2(549755813880, -549755813880);
    try test__negdi2(-274877906943, 274877906943);
    try test__negdi2(274877906943, -274877906943);
    try test__negdi2(-274877906942, 274877906942);
    try test__negdi2(274877906942, -274877906942);
    try test__negdi2(-274877906940, 274877906940);
    try test__negdi2(274877906940, -274877906940);
    try test__negdi2(-274877906936, 274877906936);
    try test__negdi2(274877906936, -274877906936);
    try test__negdi2(-137438953471, 137438953471);
    try test__negdi2(137438953471, -137438953471);
    try test__negdi2(-137438953470, 137438953470);
    try test__negdi2(137438953470, -137438953470);
    try test__negdi2(-137438953468, 137438953468);
    try test__negdi2(137438953468, -137438953468);
    try test__negdi2(-137438953464, 137438953464);
    try test__negdi2(137438953464, -137438953464);
    try test__negdi2(-68719476735, 68719476735);
    try test__negdi2(68719476735, -68719476735);
    try test__negdi2(-68719476734, 68719476734);
    try test__negdi2(68719476734, -68719476734);
    try test__negdi2(-68719476732, 68719476732);
    try test__negdi2(68719476732, -68719476732);
    try test__negdi2(-68719476728, 68719476728);
    try test__negdi2(68719476728, -68719476728);
    try test__negdi2(-34359738367, 34359738367);
    try test__negdi2(34359738367, -34359738367);
    try test__negdi2(-34359738366, 34359738366);
    try test__negdi2(34359738366, -34359738366);
    try test__negdi2(-34359738364, 34359738364);
    try test__negdi2(34359738364, -34359738364);
    try test__negdi2(-34359738360, 34359738360);
    try test__negdi2(34359738360, -34359738360);
    try test__negdi2(-17179869183, 17179869183);
    try test__negdi2(17179869183, -17179869183);
    try test__negdi2(-17179869182, 17179869182);
    try test__negdi2(17179869182, -17179869182);
    try test__negdi2(-17179869180, 17179869180);
    try test__negdi2(17179869180, -17179869180);
    try test__negdi2(-17179869176, 17179869176);
    try test__negdi2(17179869176, -17179869176);
    try test__negdi2(-8589934591, 8589934591);
    try test__negdi2(8589934591, -8589934591);
    try test__negdi2(-8589934590, 8589934590);
    try test__negdi2(8589934590, -8589934590);
    try test__negdi2(-8589934588, 8589934588);
    try test__negdi2(8589934588, -8589934588);
    try test__negdi2(-8589934584, 8589934584);
    try test__negdi2(8589934584, -8589934584);
    try test__negdi2(-4294967295, 4294967295);
    try test__negdi2(4294967295, -4294967295);
    try test__negdi2(-4294967294, 4294967294);
    try test__negdi2(4294967294, -4294967294);
    try test__negdi2(-4294967292, 4294967292);
    try test__negdi2(4294967292, -4294967292);
    try test__negdi2(-4294967288, 4294967288);
    try test__negdi2(4294967288, -4294967288);
    try test__negdi2(-2147483647, 2147483647);
    try test__negdi2(2147483647, -2147483647);
    try test__negdi2(-2147483646, 2147483646);
    try test__negdi2(2147483646, -2147483646);
    try test__negdi2(-2147483644, 2147483644);
    try test__negdi2(2147483644, -2147483644);
    try test__negdi2(-2147483640, 2147483640);
    try test__negdi2(2147483640, -2147483640);
    try test__negdi2(-1073741823, 1073741823);
    try test__negdi2(1073741823, -1073741823);
    try test__negdi2(-1073741822, 1073741822);
    try test__negdi2(1073741822, -1073741822);
    try test__negdi2(-1073741820, 1073741820);
    try test__negdi2(1073741820, -1073741820);
    try test__negdi2(-1073741816, 1073741816);
    try test__negdi2(1073741816, -1073741816);
    try test__negdi2(-536870911, 536870911);
    try test__negdi2(536870911, -536870911);
    try test__negdi2(-536870910, 536870910);
    try test__negdi2(536870910, -536870910);
    try test__negdi2(-536870908, 536870908);
    try test__negdi2(536870908, -536870908);
    try test__negdi2(-536870904, 536870904);
    try test__negdi2(536870904, -536870904);
    try test__negdi2(-268435455, 268435455);
    try test__negdi2(268435455, -268435455);
    try test__negdi2(-268435454, 268435454);
    try test__negdi2(268435454, -268435454);
    try test__negdi2(-268435452, 268435452);
    try test__negdi2(268435452, -268435452);
    try test__negdi2(-268435448, 268435448);
    try test__negdi2(268435448, -268435448);
    try test__negdi2(-134217727, 134217727);
    try test__negdi2(134217727, -134217727);
    try test__negdi2(-134217726, 134217726);
    try test__negdi2(134217726, -134217726);
    try test__negdi2(-134217724, 134217724);
    try test__negdi2(134217724, -134217724);
    try test__negdi2(-134217720, 134217720);
    try test__negdi2(134217720, -134217720);
    try test__negdi2(-67108863, 67108863);
    try test__negdi2(67108863, -67108863);
    try test__negdi2(-67108862, 67108862);
    try test__negdi2(67108862, -67108862);
    try test__negdi2(-67108860, 67108860);
    try test__negdi2(67108860, -67108860);
    try test__negdi2(-67108856, 67108856);
    try test__negdi2(67108856, -67108856);
    try test__negdi2(-33554431, 33554431);
    try test__negdi2(33554431, -33554431);
    try test__negdi2(-33554430, 33554430);
    try test__negdi2(33554430, -33554430);
    try test__negdi2(-33554428, 33554428);
    try test__negdi2(33554428, -33554428);
    try test__negdi2(-33554424, 33554424);
    try test__negdi2(33554424, -33554424);
    try test__negdi2(-16777215, 16777215);
    try test__negdi2(16777215, -16777215);
    try test__negdi2(-16777214, 16777214);
    try test__negdi2(16777214, -16777214);
    try test__negdi2(-16777212, 16777212);
    try test__negdi2(16777212, -16777212);
    try test__negdi2(-16777208, 16777208);
    try test__negdi2(16777208, -16777208);
    try test__negdi2(-8388607, 8388607);
    try test__negdi2(8388607, -8388607);
    try test__negdi2(-8388606, 8388606);
    try test__negdi2(8388606, -8388606);
    try test__negdi2(-8388604, 8388604);
    try test__negdi2(8388604, -8388604);
    try test__negdi2(-8388600, 8388600);
    try test__negdi2(8388600, -8388600);
    try test__negdi2(-4194303, 4194303);
    try test__negdi2(4194303, -4194303);
    try test__negdi2(-4194302, 4194302);
    try test__negdi2(4194302, -4194302);
    try test__negdi2(-4194300, 4194300);
    try test__negdi2(4194300, -4194300);
    try test__negdi2(-4194296, 4194296);
    try test__negdi2(4194296, -4194296);
    try test__negdi2(-2097151, 2097151);
    try test__negdi2(2097151, -2097151);
    try test__negdi2(-2097150, 2097150);
    try test__negdi2(2097150, -2097150);
    try test__negdi2(-2097148, 2097148);
    try test__negdi2(2097148, -2097148);
    try test__negdi2(-2097144, 2097144);
    try test__negdi2(2097144, -2097144);
    try test__negdi2(-1048575, 1048575);
    try test__negdi2(1048575, -1048575);
    try test__negdi2(-1048574, 1048574);
    try test__negdi2(1048574, -1048574);
    try test__negdi2(-1048572, 1048572);
    try test__negdi2(1048572, -1048572);
    try test__negdi2(-1048568, 1048568);
    try test__negdi2(1048568, -1048568);
    try test__negdi2(-524287, 524287);
    try test__negdi2(524287, -524287);
    try test__negdi2(-524286, 524286);
    try test__negdi2(524286, -524286);
    try test__negdi2(-524284, 524284);
    try test__negdi2(524284, -524284);
    try test__negdi2(-524280, 524280);
    try test__negdi2(524280, -524280);
    try test__negdi2(-262143, 262143);
    try test__negdi2(262143, -262143);
    try test__negdi2(-262142, 262142);
    try test__negdi2(262142, -262142);
    try test__negdi2(-262140, 262140);
    try test__negdi2(262140, -262140);
    try test__negdi2(-262136, 262136);
    try test__negdi2(262136, -262136);
    try test__negdi2(-131071, 131071);
    try test__negdi2(131071, -131071);
    try test__negdi2(-131070, 131070);
    try test__negdi2(131070, -131070);
    try test__negdi2(-131068, 131068);
    try test__negdi2(131068, -131068);
    try test__negdi2(-131064, 131064);
    try test__negdi2(131064, -131064);
    try test__negdi2(-65535, 65535);
    try test__negdi2(65535, -65535);
    try test__negdi2(-65534, 65534);
    try test__negdi2(65534, -65534);
    try test__negdi2(-65532, 65532);
    try test__negdi2(65532, -65532);
    try test__negdi2(-65528, 65528);
    try test__negdi2(65528, -65528);
    try test__negdi2(-32767, 32767);
    try test__negdi2(32767, -32767);
    try test__negdi2(-32766, 32766);
    try test__negdi2(32766, -32766);
    try test__negdi2(-32764, 32764);
    try test__negdi2(32764, -32764);
    try test__negdi2(-32760, 32760);
    try test__negdi2(32760, -32760);
    try test__negdi2(-16383, 16383);
    try test__negdi2(16383, -16383);
    try test__negdi2(-16382, 16382);
    try test__negdi2(16382, -16382);
    try test__negdi2(-16380, 16380);
    try test__negdi2(16380, -16380);
    try test__negdi2(-16376, 16376);
    try test__negdi2(16376, -16376);
    try test__negdi2(-8191, 8191);
    try test__negdi2(8191, -8191);
    try test__negdi2(-8190, 8190);
    try test__negdi2(8190, -8190);
    try test__negdi2(-8188, 8188);
    try test__negdi2(8188, -8188);
    try test__negdi2(-8184, 8184);
    try test__negdi2(8184, -8184);
    try test__negdi2(-4095, 4095);
    try test__negdi2(4095, -4095);
    try test__negdi2(-4094, 4094);
    try test__negdi2(4094, -4094);
    try test__negdi2(-4092, 4092);
    try test__negdi2(4092, -4092);
    try test__negdi2(-4088, 4088);
    try test__negdi2(4088, -4088);
    try test__negdi2(-2047, 2047);
    try test__negdi2(2047, -2047);
    try test__negdi2(-2046, 2046);
    try test__negdi2(2046, -2046);
    try test__negdi2(-2044, 2044);
    try test__negdi2(2044, -2044);
    try test__negdi2(-2040, 2040);
    try test__negdi2(2040, -2040);
    try test__negdi2(-1023, 1023);
    try test__negdi2(1023, -1023);
    try test__negdi2(-1022, 1022);
    try test__negdi2(1022, -1022);
    try test__negdi2(-1020, 1020);
    try test__negdi2(1020, -1020);
    try test__negdi2(-1016, 1016);
    try test__negdi2(1016, -1016);
    try test__negdi2(-511, 511);
    try test__negdi2(511, -511);
    try test__negdi2(-510, 510);
    try test__negdi2(510, -510);
    try test__negdi2(-508, 508);
    try test__negdi2(508, -508);
    try test__negdi2(-504, 504);
    try test__negdi2(504, -504);
    try test__negdi2(-255, 255);
    try test__negdi2(255, -255);
    try test__negdi2(-254, 254);
    try test__negdi2(254, -254);
    try test__negdi2(-252, 252);
    try test__negdi2(252, -252);
    try test__negdi2(-248, 248);
    try test__negdi2(248, -248);
    try test__negdi2(-127, 127);
    try test__negdi2(127, -127);
    try test__negdi2(-126, 126);
    try test__negdi2(126, -126);
    try test__negdi2(-124, 124);
    try test__negdi2(124, -124);
    try test__negdi2(-120, 120);
    try test__negdi2(120, -120);
    try test__negdi2(-63, 63);
    try test__negdi2(63, -63);
    try test__negdi2(-62, 62);
    try test__negdi2(62, -62);
    try test__negdi2(-60, 60);
    try test__negdi2(60, -60);
    try test__negdi2(-56, 56);
    try test__negdi2(56, -56);
    try test__negdi2(-31, 31);
    try test__negdi2(31, -31);
    try test__negdi2(-30, 30);
    try test__negdi2(30, -30);
    try test__negdi2(-28, 28);
    try test__negdi2(28, -28);
    try test__negdi2(-24, 24);
    try test__negdi2(24, -24);
    try test__negdi2(-15, 15);
    try test__negdi2(15, -15);
    try test__negdi2(-14, 14);
    try test__negdi2(14, -14);
    try test__negdi2(-12, 12);
    try test__negdi2(12, -12);
    try test__negdi2(-8, 8);
    try test__negdi2(8, -8);
}
