/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.util.MyVector;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.ChangedListener;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Interpreter;
import rene.zirkel.constructors.AngleConstructor;
import rene.zirkel.constructors.AreaConstructor;
import rene.zirkel.constructors.BoundedPointConstructor;
import rene.zirkel.constructors.Circle3Constructor;
import rene.zirkel.constructors.CircleConstructor;
import rene.zirkel.constructors.ExpressionConstructor;
import rene.zirkel.constructors.FunctionConstructor;
import rene.zirkel.constructors.ImageConstructor;
import rene.zirkel.constructors.IntersectionConstructor;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.constructors.MidpointConstructor;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.constructors.PlumbConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.constructors.QuadricConstructor;
import rene.zirkel.constructors.RayConstructor;
import rene.zirkel.constructors.SegmentConstructor;
import rene.zirkel.constructors.TextConstructor;
import rene.zirkel.expression.Translator;
import rene.zirkel.listener.AddEventListener;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.tools.ObjectTracker;

public class Construction {
    static final long serialVersionUID = 110L;
    public Vector V;
    public Vector Parameters;
    public Vector Targets;
    public String Comment = "";
    public String JobComment = "";
    public Vector PromptFor = new Vector();
    public Vector Prompts;
    private double X = 0.0;
    private double Y = 0.0;
    private double W = 8.0;
    private double H = 8.0;
    public boolean Partial = Global.getParameter("options.partial", false);
    public boolean Restricted = Global.getParameter("options.restricted", true);
    public boolean PartialLines = Global.getParameter("options.plines", false);
    public boolean Vectors = Global.getParameter("options.arrow", false);
    public boolean ShowNames = Global.getParameter("options.shownames", false);
    public boolean ShowValues = Global.getParameter("options.showvalues", false);
    public boolean LongNames = Global.getParameter("options.longnames", false);
    public boolean LargeFont = Global.getParameter("options.largefont", false);
    public boolean BoldFont = Global.getParameter("options.boldfont", false);
    public boolean Hidden = false;
    public boolean Obtuse = Global.getParameter("options.obtuse", false);
    public boolean Solid = Global.getParameter("options.solid", false);
    public boolean Animate = false;
    public boolean Paint = false;
    public boolean ShowAll = false;
    public boolean SuperHide = false;
    public int DefaultColor = Global.getParameter("options.color", 0);
    public int DefaultType = Global.getParameter("options.type", 0);
    public int DefaultColorType = Global.getParameter("options.colortype", 0);
    public boolean Changed = false;
    int Count = 0;
    public Construction TranslateInto;
    public boolean BlockSimulation = false;
    public boolean DontAlternateIntersections = false;
    ObjectConstructor[] ObjectConstructors = new ObjectConstructor[]{new PointConstructor(), new LineConstructor(), new SegmentConstructor(), new RayConstructor(), new CircleConstructor(), new IntersectionConstructor(), new ParallelConstructor(), new PlumbConstructor(), new Circle3Constructor(), new MidpointConstructor(), new AngleConstructor(), new BoundedPointConstructor(), new ExpressionConstructor(), new AreaConstructor(), new TextConstructor(), new QuadricConstructor(), new ImageConstructor(), new ObjectTracker(), new FunctionConstructor()};
    private AddEventListener AEL = null;
    Vector Undo = new Vector();
    public String TrackP = null;
    public String TrackPM = null;
    public String TrackO = null;
    public String AnimateP = null;
    public Vector TrackPO;
    public Vector AnimateV = null;
    public int Omit = 0;
    public boolean AnimateNegative = false;
    public boolean AnimateOriginal = false;
    public String AnimateDelay = null;
    public String Icons = "";
    public boolean AnimateBreakpoints = false;
    public long AnimateTime = 1000L;
    public boolean AnimateLoop = false;
    public boolean ResizeBackground = false;
    public String BackgroundFile = null;
    boolean NeedsOrdering = false;
    Interpreter Int = new Interpreter(this);
    boolean IntersectionBecameInvalid;
    boolean ShouldSwitch = false;
    boolean NoteSwitch = false;
    public ChangedListener CL = null;
    public MyVector TranslatorList = new MyVector();
    Vector VOld = null;
    public boolean Loading = false;
    Vector Errors = new Vector();
    double Pixel = 100.0;

    public Construction() {
        this.clear();
        this.Changed = false;
    }

    public void addAddEventListener(AddEventListener addEventListener) {
        this.AEL = addEventListener;
    }

    public void removeAddEventListener(AddEventListener addEventListener) {
        this.AEL = null;
    }

    public void add(ConstructionObject constructionObject) {
        if (!constructionObject.isGotNCount()) {
            constructionObject.setNCount(this.Count++);
        } else {
            constructionObject.setGotNCount(false);
        }
        this.V.addElement(constructionObject);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        constructionObject.setConstruction(this);
        if (this.AEL != null) {
            this.AEL.added(this, constructionObject);
        }
        this.haveChanged();
    }

    public void addNoCheck(ConstructionObject constructionObject) {
        if (!constructionObject.isGotNCount()) {
            constructionObject.setNCount(this.Count++);
        } else {
            constructionObject.setGotNCount(false);
        }
        this.V.addElement(constructionObject);
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        constructionObject.setConstruction(this);
        this.haveChanged();
    }

    public void added(ConstructionObject constructionObject) {
        if (this.AEL != null) {
            this.AEL.added(this, constructionObject);
        }
    }

    public synchronized void clear() {
        this.V = new Vector();
        if (!this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        this.Comment = "";
        this.JobComment = "";
        this.clearParameters();
        this.clearTargets();
        this.Prompts = new Vector();
        this.X = 0.0;
        this.Y = 0.0;
        this.W = 8.0;
        this.Changed = false;
        this.Count = 0;
    }

    public void back() {
        ConstructionObject constructionObject = this.last();
        if (constructionObject == null) {
            return;
        }
        constructionObject.setInConstruction(false);
        this.Undo.addElement(constructionObject);
        if (this.V.size() > 0) {
            this.V.removeElementAt(this.V.size() - 1);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete(boolean bl) {
        if (bl && !this.Undo.isEmpty()) {
            this.Undo.removeAllElements();
        }
        for (int i = this.V.size() - 1; i >= 0; --i) {
            ConstructionObject constructionObject = (ConstructionObject)this.V.elementAt(i);
            if (!constructionObject.isFlag() || constructionObject.isJobTarget()) continue;
            constructionObject.setInConstruction(false);
            this.Undo.addElement(constructionObject);
            this.V.removeElementAt(i);
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
        this.haveChanged();
    }

    public void delete() {
        this.delete(true);
    }

    public void undo() {
        if (this.Undo.isEmpty()) {
            return;
        }
        Object[] objectArray = new ConstructionObject[this.Undo.size()];
        this.Undo.copyInto(objectArray);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            this.V.addElement(objectArray[i]);
            ((ConstructionObject)objectArray[i]).setConstruction(this);
        }
        this.Undo.removeAllElements();
        this.haveChanged();
    }

    public Enumeration elements() {
        return this.V.elements();
    }

    public Enumeration getSortedElements() {
        Object[] objectArray = new ConstructionObject[this.V.size()];
        this.V.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ((ConstructionObject)objectArray[i]).Value = ((ConstructionObject)objectArray[i]).getNCount();
        }
        Sorter.sort((SortObject[])objectArray);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector.elements();
    }

    public ConstructionObject last() {
        if (this.V.size() > 0) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 1);
        }
        return null;
    }

    public ConstructionObject lastByNumber() {
        ConstructionObject constructionObject = null;
        int n = -1;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject2.getNCount() <= n) continue;
            n = constructionObject2.getNCount();
            constructionObject = constructionObject2;
        }
        return constructionObject;
    }

    public ConstructionObject lastButOne() {
        if (this.V.size() > 1) {
            return (ConstructionObject)this.V.elementAt(this.V.size() - 2);
        }
        return null;
    }

    public void clearAfter(ConstructionObject constructionObject) {
        ConstructionObject constructionObject2;
        while ((constructionObject2 = this.last()) != null && constructionObject2 != constructionObject) {
            constructionObject2.setInConstruction(false);
            this.V.removeElementAt(this.V.size() - 1);
            this.haveChanged();
        }
        this.updateCircleDep();
        this.clearParameters();
        this.clearTargets();
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String string) {
        if (string.length() <= 2) {
            string = "";
        }
        this.Comment = string;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getW() {
        return this.W;
    }

    public double getH() {
        return this.H;
    }

    public void setH(double d2) {
        this.H = d2;
    }

    public void setXYW(double d2, double d3, double d4) {
        this.X = d2;
        this.Y = d3;
        this.W = d4;
    }

    public void save(XmlWriter xmlWriter) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).save(xmlWriter);
        }
        this.Changed = false;
    }

    public synchronized void load(XmlTree xmlTree, ZirkelCanvas zirkelCanvas) throws ConstructionException {
        Enumeration enumeration = xmlTree.getContent();
        this.TrackP = null;
        this.TrackPO = new Vector();
        this.AnimateP = null;
        this.AnimateNegative = false;
        this.AnimateOriginal = false;
        this.AnimateBreakpoints = false;
        this.AnimateLoop = false;
        this.AnimateTime = 1000L;
        this.Icons = "";
        this.BackgroundFile = null;
        this.ResizeBackground = false;
        zirkelCanvas.clearDrawings();
        while (enumeration.hasMoreElements()) {
            int n;
            xmlTree = (XmlTree)enumeration.nextElement();
            XmlTag xmlTag = xmlTree.getTag();
            if (xmlTag.name().equals("Comment")) {
                try {
                    this.setComment(xmlTree.parseComment());
                    continue;
                }
                catch (Exception exception) {
                    throw new ConstructionException("Illegal Comment");
                }
            }
            if (xmlTag.name().equals("Assignment")) {
                try {
                    this.setJobComment(xmlTree.parseComment());
                    continue;
                }
                catch (Exception exception) {
                    throw new ConstructionException("Illegal Assignment");
                }
            }
            if (xmlTag.name().equals("Track")) {
                if (!xmlTag.hasParam("track")) {
                    throw new ConstructionException(Zirkel.name("exception.track"));
                }
                this.TrackP = xmlTag.getValue("track");
                this.TrackPO = new Vector();
                n = 0;
                while (xmlTag.hasParam("track" + n)) {
                    this.TrackPO.addElement(xmlTag.getValue("track" + n));
                    ++n;
                }
                this.TrackPM = xmlTag.hasParam("move") ? xmlTag.getValue("move") : null;
                this.TrackO = xmlTag.hasParam("on") ? xmlTag.getValue("on") : null;
                this.Animate = false;
                this.Paint = true;
                if (xmlTag.hasParam("animate")) {
                    if (xmlTag.getValue("animate").equals("nopaint")) {
                        this.Paint = false;
                    }
                    this.Animate = true;
                }
                this.Omit = 0;
                if (!xmlTag.hasParam("omit")) continue;
                try {
                    this.Omit = Integer.parseInt(xmlTag.getValue("omit"));
                }
                catch (Exception exception) {}
                continue;
            }
            if (xmlTag.name().equals("Animate")) {
                if (!xmlTag.hasParam("animate") || !xmlTag.hasParam("via0")) {
                    throw new ConstructionException(Zirkel.name("exception.animate"));
                }
                this.AnimateP = xmlTag.getValue("animate");
                n = 0;
                this.AnimateV = new Vector();
                while (xmlTag.hasParam("via" + n)) {
                    this.AnimateV.addElement(xmlTag.getValue("via" + n));
                    ++n;
                }
                this.AnimateNegative = false;
                if (xmlTag.hasParam("negative") && xmlTag.getValue("negative").equals("true")) {
                    this.AnimateNegative = true;
                }
                if (xmlTag.hasParam("original") && xmlTag.getValue("original").equals("true")) {
                    this.AnimateOriginal = true;
                }
                this.AnimateDelay = null;
                if (!xmlTag.hasParam("delay")) continue;
                this.AnimateDelay = xmlTag.getValue("delay");
                continue;
            }
            if (xmlTag.name().equals("AnimateBreakpoints")) {
                this.AnimateBreakpoints = true;
                try {
                    if (xmlTag.hasParam("time")) {
                        this.AnimateTime = new Long(xmlTag.getValue("time"));
                    }
                    if (!xmlTag.hasParam("loop")) continue;
                    this.AnimateLoop = true;
                    continue;
                }
                catch (Exception exception) {
                    throw new ConstructionException("exception.animate");
                }
            }
            if (xmlTag.name().equals("Window")) {
                try {
                    if (xmlTag.hasParam("x")) {
                        this.X = new Double(xmlTag.getValue("x"));
                    }
                    if (xmlTag.hasParam("y")) {
                        this.Y = new Double(xmlTag.getValue("y"));
                    }
                    if (xmlTag.hasParam("w")) {
                        this.W = new Double(xmlTag.getValue("w"));
                    }
                    zirkelCanvas.ShowGrid = xmlTag.hasTrueParam("showgrid");
                    continue;
                }
                catch (Exception exception) {
                    throw new ConstructionException("Illegal Window Parameters");
                }
            }
            if (xmlTag.name().equals("Grid")) {
                try {
                    if (xmlTag.hasParam("color") && (n = new Integer(xmlTag.getValue("color")).intValue()) >= 0 && n < ZirkelFrame.Colors.length) {
                        zirkelCanvas.GridColor = n;
                    }
                    if (xmlTag.hasParam("thickness") && (n = new Integer(xmlTag.getValue("thickness")).intValue()) >= 0 && n < 4) {
                        zirkelCanvas.GridThickness = n;
                    }
                    zirkelCanvas.GridLabels = !xmlTag.hasTrueParam("nolables");
                    zirkelCanvas.GridLarge = xmlTag.hasTrueParam("large");
                    zirkelCanvas.GridBold = xmlTag.hasTrueParam("bold");
                    zirkelCanvas.AxesOnly = xmlTag.hasTrueParam("axesonly");
                    continue;
                }
                catch (Exception exception) {
                    throw new ConstructionException("Illegal Grid Parameters");
                }
            }
            if (xmlTag.name().equals("Background")) {
                try {
                    if (xmlTag.hasTrueParam("resize")) {
                        this.ResizeBackground = true;
                    }
                    this.BackgroundFile = xmlTag.getValue("file");
                    if (this.BackgroundFile != null) continue;
                    throw new ConstructionException("Illegal Background Parameters");
                }
                catch (Exception exception) {
                    throw new ConstructionException("Illegal Background Parameters");
                }
            }
            if (xmlTag.name().equals("Draw")) {
                zirkelCanvas.loadDrawings(xmlTree);
                continue;
            }
            if (xmlTag.name().equals("Objects")) {
                this.readConstruction(xmlTree);
                this.updateCount();
                this.computeNeedsOrdering();
                this.doOrder();
                break;
            }
            if (!xmlTag.name().equals("Restrict")) continue;
            if (!xmlTag.hasParam("icons")) {
                throw new ConstructionException("Illegal Window Parameters");
            }
            this.Icons = xmlTag.getValue("icons");
        }
    }

    public void translateOffsets(ZirkelCanvas zirkelCanvas) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).translateOffset(zirkelCanvas);
        }
    }

    public synchronized void readConstruction(XmlTree xmlTree) throws ConstructionException {
        Enumeration enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            int n;
            xmlTree = (XmlTree)enumeration.nextElement();
            int n2 = this.ObjectConstructors.length;
            for (n = 0; n < n2; ++n) {
                try {
                    if (!this.ObjectConstructors[n].construct(xmlTree, this)) continue;
                    break;
                }
                catch (ConstructionException constructionException) {
                    if (xmlTree.getTag().hasParam("name")) {
                        String string = xmlTree.getTag().getValue("name");
                        throw new ConstructionException(constructionException.getDescription() + " (in " + string + ")");
                    }
                    throw constructionException;
                }
            }
            if (n < n2) continue;
            throw new ConstructionException(xmlTree.getTag().name() + " unknown!");
        }
        enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).laterBind(this);
        }
        this.dovalidate();
        this.updateCircleDep();
        this.Changed = false;
    }

    public ConstructionObject find(String string) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.getName().equals(string)) continue;
            return constructionObject;
        }
        return null;
    }

    public ConstructionObject find(String string, ConstructionObject constructionObject) {
        ConstructionObject constructionObject2;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements() && (constructionObject2 = (ConstructionObject)enumeration.nextElement()) != constructionObject) {
            if (!constructionObject2.getName().equals(string)) continue;
            return constructionObject2;
        }
        return null;
    }

    public ConstructionObject findInclusive(String string, ConstructionObject constructionObject) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject2.getName().equals(string)) {
                return constructionObject2;
            }
            if (constructionObject2 != constructionObject) continue;
            break;
        }
        return null;
    }

    public boolean before(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject3 == constructionObject) {
                return true;
            }
            if (constructionObject3 != constructionObject2) continue;
            break;
        }
        return false;
    }

    public boolean dependsDirectlyOn(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        Enumeration enumeration = constructionObject.depending();
        while (enumeration.hasMoreElements()) {
            if (constructionObject2 != enumeration.nextElement()) continue;
            return true;
        }
        return false;
    }

    public void clearRekFlags() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setRekFlag(false);
        }
    }

    public boolean dependsOn(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        this.clearRekFlags();
        boolean bl = this.dependsOnRek(constructionObject, constructionObject2);
        return bl;
    }

    public boolean dependsOnRek(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        constructionObject.setRekFlag(true);
        if (constructionObject == constructionObject2) {
            return true;
        }
        ConstructionObject[] constructionObjectArray = constructionObject.getDepArray();
        for (int i = 0; i < constructionObjectArray.length; ++i) {
            if (constructionObjectArray[i] == constructionObject || constructionObjectArray[i].isRekFlag() || !this.dependsOnRek(constructionObjectArray[i], constructionObject2)) continue;
            return true;
        }
        return false;
    }

    public void reorderConstruction() {
        int n;
        Object[] objectArray = new ConstructionObject[this.V.size()];
        this.V.copyInto(objectArray);
        int n2 = objectArray.length;
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            ((ConstructionObject)objectArray[n]).Scratch = 0;
            ((ConstructionObject)objectArray[n]).Flag = false;
        }
        for (n = 0; n < n2; ++n) {
            this.countTail((ConstructionObject)objectArray[n]);
        }
        if (n2 < 500) {
            for (n = 1; n < n2; ++n) {
                int n3;
                int n4 = ((ConstructionObject)objectArray[n]).Scratch;
                for (n3 = n; n3 > 0 && ((ConstructionObject)objectArray[n3 - 1]).Scratch > n4; --n3) {
                }
                if (n3 >= n) continue;
                Object object = objectArray[n];
                for (int i = n; i > n3; --i) {
                    objectArray[i] = objectArray[i - 1];
                }
                objectArray[n3] = object;
            }
        } else {
            for (n = 0; n < objectArray.length; ++n) {
                ((ConstructionObject)objectArray[n]).Value = ((ConstructionObject)objectArray[n]).Scratch;
            }
            Sorter.sort((SortObject[])objectArray);
        }
        this.V = new Vector();
        for (n = 0; n < n2; ++n) {
            this.V.addElement(objectArray[n]);
        }
    }

    public int countTail(ConstructionObject constructionObject) {
        if (constructionObject.Flag) {
            return constructionObject.Scratch;
        }
        constructionObject.Flag = true;
        int n = 0;
        ConstructionObject[] constructionObjectArray = constructionObject.getDepArray();
        if (constructionObjectArray.length == 0) {
            constructionObject.Scratch = 0;
        } else {
            for (int i = 0; i < constructionObjectArray.length; ++i) {
                int n2;
                if (constructionObjectArray[i] == constructionObject || (n2 = this.countTail(constructionObjectArray[i])) <= n) continue;
                n = n2;
            }
            constructionObject.Scratch = n + 1;
        }
        return constructionObject.Scratch;
    }

    public void needsOrdering() {
        this.NeedsOrdering = true;
    }

    public void doOrder() {
        if (!this.NeedsOrdering) {
            return;
        }
        this.reorderConstruction();
        this.NeedsOrdering = false;
    }

    public void computeNeedsOrdering() {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).Flag = false;
        }
        enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((ConstructionObject)enumeration.nextElement()).depending();
            while (enumeration2.hasMoreElements()) {
                if (((ConstructionObject)enumeration2.nextElement()).Flag) continue;
                this.NeedsOrdering = true;
                return;
            }
        }
        this.NeedsOrdering = false;
    }

    public int indexOf(ConstructionObject constructionObject) {
        return this.V.indexOf(constructionObject);
    }

    public ConstructionObject lastDep(ConstructionObject constructionObject) {
        int n = -1;
        ConstructionObject constructionObject2 = null;
        Enumeration enumeration = constructionObject.depending();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
            int n2 = this.indexOf(constructionObject3);
            if (n2 <= n) continue;
            n = n2;
            constructionObject2 = constructionObject3;
        }
        return constructionObject2;
    }

    public boolean reorder(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        int n = -1;
        if (constructionObject2 != null) {
            n = constructionObject2.getNCount();
        }
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject3.getNCount() <= n) continue;
            constructionObject3.setNCount(constructionObject3.getNCount() + 1);
        }
        constructionObject.setNCount(n + 1);
        this.haveChanged();
        return true;
    }

    public void updateTexts(ConstructionObject constructionObject, String string) {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (!this.dependsDirectlyOn(constructionObject2, constructionObject)) continue;
            constructionObject2.updateText();
        }
    }

    public String getJobComment() {
        return this.JobComment;
    }

    public void setJobComment(String string) {
        this.JobComment = string;
    }

    public void updateCircleDep() {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).clearCircleDep();
        }
        enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).updateCircleDep();
        }
    }

    public Vector getParameters() {
        return this.Parameters;
    }

    public int countParameters() {
        if (this.Parameters == null) {
            return 0;
        }
        return this.Parameters.size();
    }

    public Vector getTargets() {
        return this.Targets;
    }

    public int countTargets() {
        if (this.Targets == null) {
            return 0;
        }
        return this.Targets.size();
    }

    public void addParameter(ConstructionObject constructionObject) {
        this.Parameters.addElement(constructionObject);
    }

    public void addTarget(ConstructionObject constructionObject) {
        this.Targets.addElement(constructionObject);
    }

    public void clearParameters() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.clearParameter();
            constructionObject.setSpecialParameter(false);
        }
        this.Parameters = new Vector();
    }

    public void clearTargets() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setTarget(false);
        }
        this.Targets = new Vector();
    }

    public void testParameter(ConstructionObject constructionObject) throws ConstructionException {
        throw new ConstructionException(Zirkel.name("exception.null"));
    }

    public void interpret(ZirkelCanvas zirkelCanvas, String string, String string2) throws ConstructionException {
        this.Int.interpret(zirkelCanvas, string, string2);
    }

    public void interpret(ZirkelCanvas zirkelCanvas, String string) throws ConstructionException {
        this.Int.interpret(zirkelCanvas, string, "");
    }

    public void dovalidate() {
        boolean bl;
        this.doOrder();
        do {
            Enumeration enumeration = this.elements();
            bl = true;
            this.IntersectionBecameInvalid = false;
            while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                boolean bl2 = constructionObject.valid();
                constructionObject.validate();
                if (constructionObject instanceof IntersectionObject && bl2 && !constructionObject.valid()) {
                    this.IntersectionBecameInvalid = true;
                }
                if (!(constructionObject.changedBy() > 1.0E-6)) continue;
                bl = false;
            }
        } while (!bl);
    }

    public boolean intersectionBecameInvalid() {
        return this.IntersectionBecameInvalid;
    }

    public void dovalidateDebug() {
        boolean bl;
        this.doOrder();
        System.out.println("--- Time validate() ---");
        do {
            Enumeration enumeration = this.elements();
            bl = true;
            while (enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                long l = System.currentTimeMillis();
                for (int i = 0; i < 100; ++i) {
                    constructionObject.validate();
                }
                l = System.currentTimeMillis() - l;
                if (l > 0L) {
                    System.out.println(constructionObject.getName() + " - " + (double)l / 100.0 + " msec");
                }
                if (!(constructionObject.changedBy() > 1.0E-6)) continue;
                bl = false;
            }
        } while (!bl);
    }

    public void validate(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        ConstructionObject constructionObject3;
        if (constructionObject.RekValidating) {
            return;
        }
        constructionObject.RekValidating = true;
        if (constructionObject.VRek == null) {
            constructionObject.VRek = new MyVector();
        } else {
            constructionObject.VRek.removeAllElements();
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((ConstructionObject)enumeration.nextElement()).setRekFlag(false);
        }
        this.recursiveValidate(constructionObject, constructionObject2);
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            constructionObject3 = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject3.isRekFlag()) continue;
            constructionObject.VRek.addElement(constructionObject3);
        }
        enumeration = constructionObject.VRek.elements();
        while (enumeration.hasMoreElements()) {
            constructionObject3 = (ConstructionObject)enumeration.nextElement();
            constructionObject3.validate();
        }
        constructionObject.RekValidating = false;
    }

    public void recursiveValidate(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        if (constructionObject.isRekFlag() || constructionObject == constructionObject2) {
            return;
        }
        constructionObject.setRekFlag(true);
        ConstructionObject[] constructionObjectArray = constructionObject.getDepArray();
        for (int i = 0; i < constructionObjectArray.length; ++i) {
            this.recursiveValidate(constructionObjectArray[i], constructionObject2);
        }
    }

    public void computeTracks(ZirkelCanvas zirkelCanvas) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof TrackObject)) continue;
            ((TrackObject)constructionObject).compute(zirkelCanvas);
        }
    }

    public void clearTranslations() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setTranslation(null);
        }
    }

    public void determineConstructables() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isParameter()) {
                constructionObject.setFlag(true);
                continue;
            }
            Enumeration enumeration2 = constructionObject.depending();
            boolean bl2 = bl = constructionObject instanceof ExpressionObject || constructionObject instanceof FunctionObject;
            while (enumeration2.hasMoreElements()) {
                ConstructionObject constructionObject2 = (ConstructionObject)enumeration2.nextElement();
                if (constructionObject == constructionObject2) continue;
                if (constructionObject2.isFlag()) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
            constructionObject.setFlag(bl);
        }
    }

    public boolean determineConstructables(ConstructionObject constructionObject) {
        if (constructionObject.isFlag()) {
            return true;
        }
        ConstructionObject[] constructionObjectArray = constructionObject.getDepArray();
        boolean bl = constructionObject instanceof ExpressionObject || constructionObject instanceof FunctionObject;
        for (int i = 0; i < constructionObjectArray.length; ++i) {
            if (constructionObjectArray[i] == null) {
                return false;
            }
            if (constructionObjectArray[i] == constructionObject) continue;
            if (!this.determineConstructables(constructionObjectArray[i])) {
                return false;
            }
            bl = true;
        }
        constructionObject.setFlag(bl);
        return true;
    }

    public void clearConstructables() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setFlag(false);
        }
    }

    public void determineChildren() {
        Enumeration enumeration = this.elements();
        block0: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isFlag()) continue;
            Enumeration enumeration2 = constructionObject.depending();
            while (enumeration2.hasMoreElements()) {
                ConstructionObject constructionObject2 = (ConstructionObject)enumeration2.nextElement();
                if (!constructionObject2.isFlag()) continue;
                constructionObject.setFlag(true);
                continue block0;
            }
        }
    }

    public void setParameterAsConstructables() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!constructionObject.isParameter() && !constructionObject.isMainParameter()) continue;
            constructionObject.setFlag(true);
        }
    }

    public String[] getPromptFor() {
        Object[] objectArray = new String[this.PromptFor.size()];
        this.PromptFor.copyInto(objectArray);
        return objectArray;
    }

    public boolean shouldSwitch() {
        return this.ShouldSwitch;
    }

    public boolean noteSwitch() {
        return this.NoteSwitch;
    }

    public void shouldSwitch(boolean bl, boolean bl2) {
        this.ShouldSwitch = bl;
        this.NoteSwitch = bl2;
    }

    public void shouldSwitch(boolean bl) {
        this.ShouldSwitch = bl;
        this.NoteSwitch = true;
    }

    public void switchBack() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof IntersectionObject)) continue;
            ((IntersectionObject)constructionObject).switchBack();
        }
    }

    public void clearSwitches() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof IntersectionObject)) continue;
            ((IntersectionObject)constructionObject).switchBack();
        }
    }

    public boolean haveSwitched() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (!(constructionObject instanceof IntersectionObject) || !((IntersectionObject)constructionObject).isSwitched()) continue;
            return true;
        }
        return false;
    }

    public boolean changed() {
        return this.Changed;
    }

    public void haveChanged() {
        this.changed(true);
        if (this.CL != null) {
            this.CL.notifyChanged();
        }
    }

    public void changed(boolean bl) {
        this.Changed = bl;
    }

    public void addTranslator(Translator translator) {
        this.TranslatorList.addElement(translator);
    }

    public void runTranslators(Construction construction) {
        Enumeration enumeration = this.TranslatorList.elements();
        while (enumeration.hasMoreElements()) {
            Translator translator = (Translator)enumeration.nextElement();
            translator.laterTranslate(construction);
        }
    }

    public void clearTranslators() {
        this.TranslatorList.removeAllElements();
    }

    public void updateCount() {
        int n = 0;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = ((ConstructionObject)enumeration.nextElement()).getNCount();
            if (n2 <= n) continue;
            n = n2;
        }
        this.Count = n + 1;
    }

    public void setOriginalOrder(boolean bl) {
        if (this.V == null) {
            return;
        }
        if (bl) {
            Object[] objectArray = new ConstructionObject[this.V.size()];
            this.V.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                ((ConstructionObject)objectArray[i]).Value = ((ConstructionObject)objectArray[i]).getNCount();
            }
            Sorter.sort((SortObject[])objectArray);
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
            this.VOld = this.V;
            this.V = vector;
        } else if (this.VOld != null) {
            this.V = this.VOld;
            this.VOld = null;
        }
    }

    public Construction getTranslation() {
        return this.TranslateInto;
    }

    public void setTranslation(Construction construction) {
        this.TranslateInto = construction;
    }

    public boolean loading() {
        return this.Loading;
    }

    public void addError(String string) {
        this.Errors.addElement(string);
    }

    public Enumeration getErrors() {
        return this.Errors.elements();
    }

    public void clearErrors() {
        this.Errors.removeAllElements();
    }

    public void dontAlternate(boolean bl) {
        this.DontAlternateIntersections = bl;
    }

    public boolean canAlternate() {
        return !this.DontAlternateIntersections;
    }

    public void setPixel(double d2) {
        this.Pixel = d2;
    }

    public double getPixel() {
        return this.Pixel;
    }
}

