/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef DATEGROUPWIDGET_H
#define DATEGROUPWIDGET_H

#include "dateedit.h"
#include "calendarwidget.h"
#include <QWidget>
#include <QComboBox>
#include <QLabel>
#include <QHBoxLayout>
#include <QTimerEvent>
#ifdef KY_SDK_SYSTIME
#include <kysdk/kysdk-system/libkydate.h>
#endif

class DategroupWidget : public QWidget
{
    Q_OBJECT
public:
    DategroupWidget(QWidget *parent = nullptr);
    ~DategroupWidget();
    void initHour();
    void initMinAndSec();
    void updateTime();
    void initConnect();

public Q_SLOTS:
    void dataChangedSlot(QString key);
    void resetDateEdit(QString date);

Q_SIGNALS:
    void dateChanged(QDate date, QTime time);

protected:
    void timerEvent(QTimerEvent *e);

private:
    DateEdit       *dateEdit          = nullptr;
    CalendarWidget *calendarWidget    = nullptr;
    QComboBox      *hourComboBox      = nullptr;
    QComboBox      *minComboBox       = nullptr;
    QComboBox      *secComboBox       = nullptr;
    QLabel         *hourMinColonLabel = nullptr;
    QLabel         *MinSecColonLabel  = nullptr;

private:
    QDBusInterface *areaInterface = nullptr;
    int timerID;
};


#endif // DATEGROUPWIDGET_H
