C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CPHYSO
C                       *****************
C
C      ---------------------------------------------------------------
     * (NDIM,NPOINS,COORDS,NREFS,NREFE,NELEMS,NODES,NDMATS,
     *  TMPSA,TMPS,PHYSOL,NPOUE,NPPEL,NBPHYS,VOLUME)
C      --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ENTREE DES CARACTERISTIQUES PHYSIQUES DU SOLIDE           *
C            RHO(x,y,z,t,T), CP(x,y,z,t,T), K(x,y,z,t,T)               *
C             + invariant de Gauss et epaisseur pour le modele coque   *
C                                                                      *
C     Dans la version 3.0 de SYRTHES, il est possible de definir       *
C     les caracteristiques soit par noeud soit par element soit        *
C     par noeud pour un element. Parmi les trois choix suivant,        *
C     un seul doit etre retenu et en coherence avec l'option prise     *
C     dans le fichier des mots-cles.                                   *
C     Pour plus de clarte, on engage meme les utilisateurs a           *
C     supprimer les lignes non utiles dans leur cas.                   *
C                                                                      *
C     Attention : toute variable utilisee doit etre declaree           *
C     =========                                                        *
C                                                                      *
C            (Sous-programme utilisateur)                              *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  TMPS     ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  PHYSOL   ! TR ! R  ! CARACTERISTIQUES PHYSIQUES DU SOLIDE         !
C !  NPOUE    !  E ! D  ! NOMBRE DE NOEUDS OU D'ELTS                   !
C !  NPPEL    !  E ! D  ! NOMBRE DE NOEUD PAR ELEMENTS                 !
C !  VOLUME   !  E ! D  ! VOLUME DE CHAQUE ELEMENT                     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /TEMPS /  !    ! D  !                                              !
C ! /OPTCT /  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "divct.h"
#include "optct.h"
#include "syrthu.h"
#include "nlofes.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NBPHYS,NPOUE,NPPEL,NELEMS,NDMATS
      INTEGER NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM),TMPSA(NPOINS),TMPS(NPOINS)
      DOUBLE PRECISION  PHYSOL(NPOUE,NPPEL,NBPHYS),VOLUME(NELEMS)
C
C.. Variables internes
      INTEGER I,J,K,N,NUMREF
      DOUBLE PRECISION  T,XX,YY,ZZ,TT1,TT2,TT
C
C***********************************************************************
C
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C
C
C     --------------------------------------------------
C     2- INTERVENTION UTILISATEUR POUR LE MODELE GENERAL 
C     --------------------------------------------------
C     Les conditions physiques peuvent etre fonction 
C     de l'espace (COORDS(...,1),COORDS(...,2),COORDS(...,3)),
C     du temps (TEMPS) et de la temperature TMPS(...)
C     On donne :
C     Si la conductivite est isotrope on donne :
C      - PHYSOL(.,.,1) : masse volumique rho
C      - PHYSOL(.,.,2) : chaleur specifique cp
C      - PHYSOL(.,.,3) : conductivite k 
C     Si la conductivite est orthotrope on donne :
C      - PHYSOL(.,.,1) : masse volumique rho
C      - PHYSOL(.,.,2) : chaleur specifique cp
C      - PHYSOL(.,.,3) : conductivite k suivant x       | 3     |
C      - PHYSOL(.,.,4) : conductivite k suivant y       |   4   |
C      - PHYSOL(.,.,5) : conductivite k suivant z       |     5 |
C     Si la conductivite est anisotrope on donne :
C      - PHYSOL(.,.,1) : masse volumique rho
C      - PHYSOL(.,.,2) : chaleur specifique cp
C      - PHYSOL(.,.,3) : conductivite k suivant x   
C      - PHYSOL(.,.,4) : conductivite k suivant y       | 3 6 7 |
C      - PHYSOL(.,.,5) : conductivite k suivant z       |   4 8 |
C      - PHYSOL(.,.,6) : conductivite k suivant xy      |     5 |
C      - PHYSOL(.,.,7) : conductivite k suivant xz
C      - PHYSOL(.,.,8) : conductivite k suivant yz
C     
C     Temps reel courant sur le solide
CUTI  T = TEMPSS
C
C     =====================================================
C     SI ON INDIQUE LES CARACTERISTIQUES PHYSIQUES PAR NOEUD
C     =====================================================
CUTI  IF(NDPROP .NE. 1) THEN
CUTI      WRITE(NFECRA,1000)
CUTI      STOP
CUTI  ENDIF
C
C     Pour chaque point solide
CUTI  DO N=1,NPOINS
C   
C        References du point courant
CUTI     NUMREF = NREFS(N)
C
C        Coordonnees du point courant
CUTI     XX = COORDS(N,1)
CUTI     YY = COORDS(N,2)
CUTI     IF (NDIM.EQ.3) ZZ = COORDS(N,3)
C
C        Temperature du noeud
CUTI     TT = TMPS(N)
C
C        Si la conductivite est isotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.1) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,1,1) =  <masse volumique>
CUTI          PHYSOL(N,1,2) =  <chaleur specifique>
CUTI          PHYSOL(N,1,3) =  <conductivite>
CUTI       ENDIF
CUTI     ENDIF
CUTI
C        Si la conductivite est orthotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.2) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,1,1) =  <masse volumique>
CUTI          PHYSOL(N,1,2) =  <chaleur specifique>
CUTI          PHYSOL(N,1,3) =  <conductivite en x>
CUTI          PHYSOL(N,1,4) =  <conductivite en y>
CUTI          IF (NDIM.EQ.3) PHYSOL(N,1,5) =  <conductivite en z>
CUTI       ENDIF
CUTI     ENDIF
C
C        Si la conductivite est anisotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.3) THEN
C
C          Cas de la dimension 2
CUTI       IF (NDIM.EQ.2) THEN
C
C            Si le noeud courant porte la reference 4
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,1,1) =  <masse volumique>
CUTI            PHYSOL(N,1,2) =  <chaleur specifique>
CUTI            PHYSOL(N,1,3) =  <conductivite en x>
CUTI            PHYSOL(N,1,4) =  <conductivite en y>
CUTI            PHYSOL(N,1,5) =  <conductivite en xy>
CUTI         ENDIF
C
CUTI       ELSEIF (NDIM.EQ.3) THEN
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,1,1) =  <masse volumique>
CUTI            PHYSOL(N,1,2) =  <chaleur specifique>
CUTI            PHYSOL(N,1,3) =  <conductivite en x>
CUTI            PHYSOL(N,1,4) =  <conductivite en y>
CUTI            PHYSOL(N,1,5) =  <conductivite en z>
CUTI            PHYSOL(N,1,6) =  <conductivite en xy>
CUTI            PHYSOL(N,1,7) =  <conductivite en xz>
CUTI            PHYSOL(N,1,8) =  <conductivite en yz>
CUTI         ENDIF
CUTI       ENDIF
C
CUTI     ENDIF
C
CUTI  ENDDO
C     =====================================================
C     FIN POUR LES CARACTERISTIQUES PHYSIQUES PAR NOEUD
C     =====================================================
C
C
C
C     =======================================================
C     SI ON INDIQUE LES CARACTERISTIQUES PHYSIQUES PAR ELEMENT
C     LES PROPRIETES SONTS CONSTANTES SUR l"ELEMENT
C     =======================================================
CUTI  IF(NDPROP .NE. 2) THEN
CUTI      WRITE(NFECRA,1000)
CUTI      STOP
CUTI  ENDIF
C
C     Pour chaque element du solide
CUTI  DO N=1,NELEMS
C   
C        References de l'element courant
CUTI     NUMREF = NREFE(N)
C
CUTI     Numero des noeuds de l'element ( 6 en 2D, 10 en 3D)
CUTI     point 1 a 6
CUTI     N1 = NODES(N,1)
CUTI     N2 = NODES(N,2)
CUTI     N3 = NODES(N,3)
CUTI     N4 = NODES(N,4)
CUTI     N5 = NODES(N,5)
CUTI     N6 = NODES(N,6)
C
CUTI     IF (NDIM .EQ. 3) THEN
CUTI        N7 = NODES(N,7)
CUTI        N8 = NODES(N,8)
CUTI        N9 = NODES(N,9)
CUTI        N10= NODES(N,10)
CUTI     ENDIF
C
C        Coordonnees des points de l'element courant
C        Pour le noeud n1 
CUTI     XX1 = COORDS(N1,1)
CUTI     YY1 = COORDS(N1,2)
CUTI     IF (NDIM.EQ.3) ZZ1 = COORDS(N1,3)
C        Pour le noeud n2 
CUTI     XX2 = COORDS(N2,1)
CUTI     YY2 = COORDS(N2,2)
CUTI     IF (NDIM.EQ.3) ZZ2 = COORDS(N2,3)
CUTI     .
CUTI     .
CUTI     etc
C
C        Temperature des noeuds de l'element
CUTI     TT1 = TMPS(N1)
CUTI     TT2 = TMPS(N2)
CUTI     .
CUTI     .
CUTI     etc
C
C        Si la conductivite est isotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.1) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,1,1) =  <masse volumique>
CUTI          PHYSOL(N,1,2) =  <chaleur specifique>
CUTI          PHYSOL(N,1,3) =  <conductivite>
CUTI       ENDIF
CUTI     ENDIF
CUTI
C        Si la conductivite est orthotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.2) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,1,1) =  <masse volumique>
CUTI          PHYSOL(N,1,2) =  <chaleur specifique>
CUTI          PHYSOL(N,1,3) =  <conductivite en x>
CUTI          PHYSOL(N,1,4) =  <conductivite en y>
CUTI          IF (NDIM.EQ.3) PHYSOL(N,1,5) =  <conductivite en z>
CUTI       ENDIF
CUTI     ENDIF
C
C        Si la conductivite est anisotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.3) THEN
C
C          Cas de la dimension 2
CUTI       IF (NDIM.EQ.2) THEN
C
C            Si le noeud courant porte la reference 4
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,1,1) =  <masse volumique>
CUTI            PHYSOL(N,1,2) =  <chaleur specifique>
CUTI            PHYSOL(N,1,3) =  <conductivite en x>
CUTI            PHYSOL(N,1,4) =  <conductivite en y>
CUTI            PHYSOL(N,1,5) =  <conductivite en xy>
CUTI         ENDIF
C
CUTI       ELSEIF (NDIM.EQ.3) THEN
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,1,1) =  <masse volumique>
CUTI            PHYSOL(N,1,2) =  <chaleur specifique>
CUTI            PHYSOL(N,1,3) =  <conductivite en x>
CUTI            PHYSOL(N,1,4) =  <conductivite en y>
CUTI            PHYSOL(N,1,5) =  <conductivite en z>
CUTI            PHYSOL(N,1,6) =  <conductivite en xy>
CUTI            PHYSOL(N,1,7) =  <conductivite en xz>
CUTI            PHYSOL(N,1,8) =  <conductivite en yz>
CUTI         ENDIF
CUTI       ENDIF
C
CUTI     ENDIF
C
CUTI  ENDDO
C
C     =======================================================
C     FIN DES CARACTERISTIQUES PHYSIQUES PAR ELEMENT
C     LES PROPRIETES SONTS CONSTANTES SUR l"ELEMENT
C     =======================================================
C
C
C
C
C
C     =======================================================
C     SI ON INDIQUE LES CARACTERISTIQUES PHYSIQUES PAR 
C     NOEUD POUR CHAQUE ELEMENT
C     LES PROPRIETES PEUVENT ALORS ETRE VARIABLE DANS UN ELEMENT
C     =======================================================
CUTI  IF(NDPROP .NE. 3) THEN
CUTI      WRITE(NFECRA,1000)
CUTI      STOP
CUTI  ENDIF
C
C     Pour chaque noeud de l'element
CUTI  DO J=1,NDMATS
C       Pour chaque element du solide
CUTI    DO N=1,NELEMS
C   
C         References de l'element courant
CUTI      NUMREF = NREFE(N)
C
CUTI      Numero global du noeud 
CUTI      N1 = NODES(N,J)
C
C        Coordonnees du noeud courant
CUTI     XX1 = COORDS(N1,1)
CUTI     YY1 = COORDS(N1,2)
CUTI     IF (NDIM.EQ.3) ZZ1 = COORDS(N1,3)
C
C        Temperature du noeud courant
CUTI     TT = TMPS(N1)
C
C        Si la conductivite est isotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.1) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,J,1) =  <masse volumique>
CUTI          PHYSOL(N,J,2) =  <chaleur specifique>
CUTI          PHYSOL(N,J,3) =  <conductivite>
CUTI       ENDIF
CUTI     ENDIF
CUTI
C        Si la conductivite est orthotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.2) THEN
C          Si le noeud courant porte la reference 4
CUTI       IF ( NUMREF.EQ.4 ) THEN
CUTI          PHYSOL(N,J,1) =  <masse volumique>
CUTI          PHYSOL(N,J,2) =  <chaleur specifique>
CUTI          PHYSOL(N,J,3) =  <conductivite en x>
CUTI          PHYSOL(N,J,4) =  <conductivite en y>
CUTI          IF (NDIM.EQ.3) PHYSOL(N,J,5) =  <conductivite en z>
CUTI       ENDIF
CUTI     ENDIF
C
C        Si la conductivite est anisotrope
C        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CUTI     IF (ISOTRO.EQ.3) THEN
C
C          Cas de la dimension 2
CUTI       IF (NDIM.EQ.2) THEN
C
C            Si le noeud courant porte la reference 4
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,J,1) =  <masse volumique>
CUTI            PHYSOL(N,J,2) =  <chaleur specifique>
CUTI            PHYSOL(N,J,3) =  <conductivite en x>
CUTI            PHYSOL(N,J,4) =  <conductivite en y>
CUTI            PHYSOL(N,J,5) =  <conductivite en xy>
CUTI         ENDIF
C
CUTI       ELSEIF (NDIM.EQ.3) THEN
CUTI         IF ( NUMREF.EQ.4 ) THEN
CUTI            PHYSOL(N,J,1) =  <masse volumique>
CUTI            PHYSOL(N,J,2) =  <chaleur specifique>
CUTI            PHYSOL(N,J,3) =  <conductivite en x>
CUTI            PHYSOL(N,J,4) =  <conductivite en y>
CUTI            PHYSOL(N,J,5) =  <conductivite en z>
CUTI            PHYSOL(N,J,6) =  <conductivite en xy>
CUTI            PHYSOL(N,J,7) =  <conductivite en xz>
CUTI            PHYSOL(N,J,8) =  <conductivite en yz>
CUTI         ENDIF
CUTI       ENDIF
C
CUTI     ENDIF
C
CUTI    ENDDO
CUTI  ENDDO

C     =======================================================
C     SI ON INDIQUE LES CARACTERISTIQUES PHYSIQUES PAR 
C     NOEUD POUR CHAQUE ELEMENT
C     LES PROPRIETES PEUVENT ALORS ETRE VARIABLE DANS UN ELEMENT
C     =======================================================
C
C
C
C***********************************************************************
C
 1000 FORMAT(' CPHYSO : ATTENTION LE CHOIX EST CONTRADICTOIRE AVEC',/,
     &         'CELUI RETENU DANS LES MOTS-CLES')
C----
C FIN
C----
      END
