/** @file cfgfile.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CFGFILE_H
#define CFGFILE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "sx.fcgi"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "sx.fcgi"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * socket_arg;	/**< @brief Set socket for connection with httpd.  */
  char * socket_orig;	/**< @brief Set socket for connection with httpd original value given at command line.  */
  const char *socket_help; /**< @brief Set socket for connection with httpd help description.  */
  int children_arg;	/**< @brief Start N children processes (default='24').  */
  char * children_orig;	/**< @brief Start N children processes original value given at command line.  */
  const char *children_help; /**< @brief Start N children processes help description.  */
  char * reserved_socket_arg;	/**< @brief Set httpd socket reserved for internode communication.  */
  char * reserved_socket_orig;	/**< @brief Set httpd socket reserved for internode communication original value given at command line.  */
  const char *reserved_socket_help; /**< @brief Set httpd socket reserved for internode communication help description.  */
  int reserved_children_arg;	/**< @brief Start N children processes reserved for internode communication (default='8').  */
  char * reserved_children_orig;	/**< @brief Start N children processes reserved for internode communication original value given at command line.  */
  const char *reserved_children_help; /**< @brief Start N children processes reserved for internode communication help description.  */
  int socket_mode_arg;	/**< @brief Set socket mode to MODE (octal number; unix sockets only).  */
  char * socket_mode_orig;	/**< @brief Set socket mode to MODE (octal number; unix sockets only) original value given at command line.  */
  const char *socket_mode_help; /**< @brief Set socket mode to MODE (octal number; unix sockets only) help description.  */
  char * data_dir_arg;	/**< @brief Path to data directory.  */
  char * data_dir_orig;	/**< @brief Path to data directory original value given at command line.  */
  const char *data_dir_help; /**< @brief Path to data directory help description.  */
  char * logfile_arg;	/**< @brief Write all log information to FILE.  */
  char * logfile_orig;	/**< @brief Write all log information to FILE original value given at command line.  */
  const char *logfile_help; /**< @brief Write all log information to FILE help description.  */
  char * pidfile_arg;	/**< @brief Write process ID to FILE.  */
  char * pidfile_orig;	/**< @brief Write process ID to FILE original value given at command line.  */
  const char *pidfile_help; /**< @brief Write process ID to FILE help description.  */
  int foreground_flag;	/**< @brief Do not daemonize (default=off).  */
  const char *foreground_help; /**< @brief Do not daemonize help description.  */
  int debug_flag;	/**< @brief Enable debug messages (default=off).  */
  const char *debug_help; /**< @brief Enable debug messages help description.  */
  char * run_as_arg;	/**< @brief Run as specified user[:group].  */
  char * run_as_orig;	/**< @brief Run as specified user[:group] original value given at command line.  */
  const char *run_as_help; /**< @brief Run as specified user[:group] help description.  */
  char * ssl_ca_arg;	/**< @brief Path to SSL CA certificate.  */
  char * ssl_ca_orig;	/**< @brief Path to SSL CA certificate original value given at command line.  */
  const char *ssl_ca_help; /**< @brief Path to SSL CA certificate help description.  */
  int gc_interval_arg;	/**< @brief How often to run the GC (default='3600').  */
  char * gc_interval_orig;	/**< @brief How often to run the GC original value given at command line.  */
  const char *gc_interval_help; /**< @brief How often to run the GC help description.  */
  int gc_max_batch_arg;	/**< @brief Maximum number of rows/transaction in the GC (default='100').  */
  char * gc_max_batch_orig;	/**< @brief Maximum number of rows/transaction in the GC original value given at command line.  */
  const char *gc_max_batch_help; /**< @brief Maximum number of rows/transaction in the GC help description.  */
  float gc_max_batch_time_arg;	/**< @brief Maximum time for a transaction in the GC in seconds (default='1').  */
  char * gc_max_batch_time_orig;	/**< @brief Maximum time for a transaction in the GC in seconds original value given at command line.  */
  const char *gc_max_batch_time_help; /**< @brief Maximum time for a transaction in the GC in seconds help description.  */
  float gc_yield_time_arg;	/**< @brief Time to yield between GC transactions (default='1.1').  */
  char * gc_yield_time_orig;	/**< @brief Time to yield between GC transactions original value given at command line.  */
  const char *gc_yield_time_help; /**< @brief Time to yield between GC transactions help description.  */
  int gc_no_slow_check_flag;	/**< @brief Don't run the old GC (default=off).  */
  const char *gc_no_slow_check_help; /**< @brief Don't run the old GC help description.  */
  float blockmgr_delay_arg;	/**< @brief Blockmgr delay (default='3').  */
  char * blockmgr_delay_orig;	/**< @brief Blockmgr delay original value given at command line.  */
  const char *blockmgr_delay_help; /**< @brief Blockmgr delay help description.  */
  int db_min_passive_wal_pages_arg;	/**< @brief Minimum number of pages in WAL to trigger a passive checkpoint (default='5000').  */
  char * db_min_passive_wal_pages_orig;	/**< @brief Minimum number of pages in WAL to trigger a passive checkpoint original value given at command line.  */
  const char *db_min_passive_wal_pages_help; /**< @brief Minimum number of pages in WAL to trigger a passive checkpoint help description.  */
  int db_max_passive_wal_pages_arg;	/**< @brief Maximum number of pages in WAL to trigger a passive checkpoint (default='10000').  */
  char * db_max_passive_wal_pages_orig;	/**< @brief Maximum number of pages in WAL to trigger a passive checkpoint original value given at command line.  */
  const char *db_max_passive_wal_pages_help; /**< @brief Maximum number of pages in WAL to trigger a passive checkpoint help description.  */
  int db_max_wal_restart_pages_arg;	/**< @brief Maximum number of pages in WAL before forcing a WAL restart (default='20000').  */
  char * db_max_wal_restart_pages_orig;	/**< @brief Maximum number of pages in WAL before forcing a WAL restart original value given at command line.  */
  const char *db_max_wal_restart_pages_help; /**< @brief Maximum number of pages in WAL before forcing a WAL restart help description.  */
  int db_idle_restart_arg;	/**< @brief Interval to force a WAL restart when idle (default='60').  */
  char * db_idle_restart_orig;	/**< @brief Interval to force a WAL restart when idle original value given at command line.  */
  const char *db_idle_restart_help; /**< @brief Interval to force a WAL restart when idle help description.  */
  int db_busy_timeout_arg;	/**< @brief SQLite database busy timeout (default='20').  */
  char * db_busy_timeout_orig;	/**< @brief SQLite database busy timeout original value given at command line.  */
  const char *db_busy_timeout_help; /**< @brief SQLite database busy timeout help description.  */
  int db_max_mmapsize_arg;	/**< @brief SQLite mmap size (0 to disable) (default='2147418112').  */
  char * db_max_mmapsize_orig;	/**< @brief SQLite mmap size (0 to disable) original value given at command line.  */
  const char *db_max_mmapsize_help; /**< @brief SQLite mmap size (0 to disable) help description.  */
  int db_no_custom_vfs_flag;	/**< @brief Do not use custom SQLite VFS (default=off).  */
  const char *db_no_custom_vfs_help; /**< @brief Do not use custom SQLite VFS help description.  */
  int worker_max_wait_arg;	/**< @brief Maximum time to wait before killing a worker (default='300').  */
  char * worker_max_wait_orig;	/**< @brief Maximum time to wait before killing a worker original value given at command line.  */
  const char *worker_max_wait_help; /**< @brief Maximum time to wait before killing a worker help description.  */
  int worker_max_requests_arg;	/**< @brief Maximum number of requests / worker (default='5000').  */
  char * worker_max_requests_orig;	/**< @brief Maximum number of requests / worker original value given at command line.  */
  const char *worker_max_requests_help; /**< @brief Maximum number of requests / worker help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int socket_given ;	/**< @brief Whether socket was given.  */
  unsigned int children_given ;	/**< @brief Whether children was given.  */
  unsigned int reserved_socket_given ;	/**< @brief Whether reserved-socket was given.  */
  unsigned int reserved_children_given ;	/**< @brief Whether reserved-children was given.  */
  unsigned int socket_mode_given ;	/**< @brief Whether socket-mode was given.  */
  unsigned int data_dir_given ;	/**< @brief Whether data-dir was given.  */
  unsigned int logfile_given ;	/**< @brief Whether logfile was given.  */
  unsigned int pidfile_given ;	/**< @brief Whether pidfile was given.  */
  unsigned int foreground_given ;	/**< @brief Whether foreground was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int run_as_given ;	/**< @brief Whether run-as was given.  */
  unsigned int ssl_ca_given ;	/**< @brief Whether ssl_ca was given.  */
  unsigned int gc_interval_given ;	/**< @brief Whether gc-interval was given.  */
  unsigned int gc_max_batch_given ;	/**< @brief Whether gc-max-batch was given.  */
  unsigned int gc_max_batch_time_given ;	/**< @brief Whether gc-max-batch-time was given.  */
  unsigned int gc_yield_time_given ;	/**< @brief Whether gc-yield-time was given.  */
  unsigned int gc_no_slow_check_given ;	/**< @brief Whether gc-no-slow-check was given.  */
  unsigned int blockmgr_delay_given ;	/**< @brief Whether blockmgr-delay was given.  */
  unsigned int db_min_passive_wal_pages_given ;	/**< @brief Whether db-min-passive-wal-pages was given.  */
  unsigned int db_max_passive_wal_pages_given ;	/**< @brief Whether db-max-passive-wal-pages was given.  */
  unsigned int db_max_wal_restart_pages_given ;	/**< @brief Whether db-max-wal-restart-pages was given.  */
  unsigned int db_idle_restart_given ;	/**< @brief Whether db-idle-restart was given.  */
  unsigned int db_busy_timeout_given ;	/**< @brief Whether db-busy-timeout was given.  */
  unsigned int db_max_mmapsize_given ;	/**< @brief Whether db-max-mmapsize was given.  */
  unsigned int db_no_custom_vfs_given ;	/**< @brief Whether db-no-custom-vfs was given.  */
  unsigned int worker_max_wait_given ;	/**< @brief Whether worker-max-wait was given.  */
  unsigned int worker_max_requests_given ;	/**< @brief Whether worker-max-requests was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * The config file parser (deprecated version)
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_config_file() instead
 */
int cmdline_parser_configfile (const char *filename,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The config file parser
 * @param filename the name of the config file
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_config_file (const char *filename,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CFGFILE_H */
