/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_IMPORTDIALOG_H
#define _SC_IMPORTDIALOG_H

// sc
class ImportParam;
class ExternProvider;
class ExternButton;

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class ImportDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  ImportDialog( ExternProvider* p, bool recurse, QWidget *parent = 0 );
  virtual ~ImportDialog();

  void setDstUrl( const QString& url );

  ImportParam* getParameters() const;

public slots:
  void srcExtern();
  void dstExtern();
  void checkOk( const QString& text );

private:
  QComboBox*      _src;
  ExternButton*   _srcEx;
  QComboBox*      _dst;
  ExternButton*   _dstEx;

  QCheckBox*      _recursive;
  QPushButton*    _ok;

  ExternProvider* _p;
};

#endif // _SC_IMPORTDIALOG_H
