/* Public domain. */

#include "bytestr.h"

#ifdef USE_BASE_LIBC

#include <string.h>

unsigned int str_len (char const *s)
{
  return (unsigned int)strlen(s) ;
}

#else

unsigned int str_len (char const *s)
{
  register char const *t = s ;
  for (;;)
  {
    if (!*t) return t - s; ++t;
    if (!*t) return t - s; ++t;
    if (!*t) return t - s; ++t;
    if (!*t) return t - s; ++t;
  }
}

#endif
