#include "ScilabJavaObject.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/ScilabObjects.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

Copyright (C) 2012 - 2016 - Scilab Enterprises

This file is hereby licensed under the terms of the GNU GPL v2.0,
pursuant to article 5.3.4 of the CeCILL v.2.1.
This file was originally licensed under the terms of the CeCILL v2.1,
and continues to be available under such terms.
For more information, see the COPYING file which you should have received
along with this program.
*/

namespace org_scilab_modules_external_objects_java {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * ScilabJavaObject::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

ScilabJavaObject::~ScilabJavaObject() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintinvokejintintjstringjava_lang_StringjintArray_intintID=NULL;
jintextractjintintjintArray_intintID=NULL;
voidinsertjintintjintArray_intintjintintID=NULL;
jobjectArray_getInfosID=NULL;
voidinitScilabJavaObjectID=NULL;
voidgarbageCollectID=NULL;
jstringgetRepresentationjintintID=NULL;
jbooleanisValidJavaObjectjintintID=NULL;
voidenableTracejstringjava_lang_StringID=NULL;
voiddisableTraceID=NULL;
voidwriteLogjstringjava_lang_StringID=NULL;
voidsetFieldjintintjstringjava_lang_StringjintintID=NULL;
jintgetFieldjintintjstringjava_lang_StringID=NULL;
jintgetFieldTypejintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjintintID=NULL;
jstringgetClassNamejintintID=NULL;
jintgetArrayElementjintintjintArray_intintID=NULL;
voidsetArrayElementjintintjintArray_intintjintintID=NULL;
voidremoveScilabJavaObjectjintintID=NULL;
voidremoveScilabJavaObjectjintArray_intintID=NULL;
voidlimitDirectBufferjintintID=NULL;
jintisUnwrappablejintintID=NULL;
jintwrapjdoubledoubleID=NULL;
jintwrapjdoubleArray_doubledoubleID=NULL;
jintwrapjobjectArray__doubledoubleID=NULL;
jintwrapjintintID=NULL;
jintwrapjintArray_intintID=NULL;
jintwrapjobjectArray__intintID=NULL;
jintwrapjbytebyteID=NULL;
jintwrapjbyteArray_bytebyteID=NULL;
jintwrapjobjectArray__bytebyteID=NULL;
jintwrapjshortshortID=NULL;
jintwrapjshortArray_shortshortID=NULL;
jintwrapjobjectArray__shortshortID=NULL;
jintwrapjstringjava_lang_StringID=NULL;
jintwrapjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintwrapjobjectArray__java_lang_Stringjava_lang_StringID=NULL;
jintwrapjbooleanbooleanID=NULL;
jintwrapjbooleanArray_booleanbooleanID=NULL;
jintwrapjobjectArray__booleanbooleanID=NULL;
jintwrapjcharcharID=NULL;
jintwrapjcharArray_charcharID=NULL;
jintwrapjobjectArray__charcharID=NULL;
jintwrapjfloatfloatID=NULL;
jintwrapjfloatArray_floatfloatID=NULL;
jintwrapjobjectArray__floatfloatID=NULL;
jintwrapjlonglongID=NULL;
jintwrapjlongArray_longlongID=NULL;
jintwrapjobjectArray__longlongID=NULL;
jintwrapListjintArray_intintID=NULL;
jintwrapPolyjdoubleArray_doubledoubleID=NULL;
jobjectArray_getAccessibleFieldsjintintID=NULL;
jobjectArray_getAccessibleMethodsjintintID=NULL;
jobjectArray_getCompletionjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;


}

ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintinvokejintintjstringjava_lang_StringjintArray_intintID=NULL;
jintextractjintintjintArray_intintID=NULL;
voidinsertjintintjintArray_intintjintintID=NULL;
jobjectArray_getInfosID=NULL;
voidinitScilabJavaObjectID=NULL;
voidgarbageCollectID=NULL;
jstringgetRepresentationjintintID=NULL;
jbooleanisValidJavaObjectjintintID=NULL;
voidenableTracejstringjava_lang_StringID=NULL;
voiddisableTraceID=NULL;
voidwriteLogjstringjava_lang_StringID=NULL;
voidsetFieldjintintjstringjava_lang_StringjintintID=NULL;
jintgetFieldjintintjstringjava_lang_StringID=NULL;
jintgetFieldTypejintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjintintID=NULL;
jstringgetClassNamejintintID=NULL;
jintgetArrayElementjintintjintArray_intintID=NULL;
voidsetArrayElementjintintjintArray_intintjintintID=NULL;
voidremoveScilabJavaObjectjintintID=NULL;
voidremoveScilabJavaObjectjintArray_intintID=NULL;
voidlimitDirectBufferjintintID=NULL;
jintisUnwrappablejintintID=NULL;
jintwrapjdoubledoubleID=NULL;
jintwrapjdoubleArray_doubledoubleID=NULL;
jintwrapjobjectArray__doubledoubleID=NULL;
jintwrapjintintID=NULL;
jintwrapjintArray_intintID=NULL;
jintwrapjobjectArray__intintID=NULL;
jintwrapjbytebyteID=NULL;
jintwrapjbyteArray_bytebyteID=NULL;
jintwrapjobjectArray__bytebyteID=NULL;
jintwrapjshortshortID=NULL;
jintwrapjshortArray_shortshortID=NULL;
jintwrapjobjectArray__shortshortID=NULL;
jintwrapjstringjava_lang_StringID=NULL;
jintwrapjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintwrapjobjectArray__java_lang_Stringjava_lang_StringID=NULL;
jintwrapjbooleanbooleanID=NULL;
jintwrapjbooleanArray_booleanbooleanID=NULL;
jintwrapjobjectArray__booleanbooleanID=NULL;
jintwrapjcharcharID=NULL;
jintwrapjcharArray_charcharID=NULL;
jintwrapjobjectArray__charcharID=NULL;
jintwrapjfloatfloatID=NULL;
jintwrapjfloatArray_floatfloatID=NULL;
jintwrapjobjectArray__floatfloatID=NULL;
jintwrapjlonglongID=NULL;
jintwrapjlongArray_longlongID=NULL;
jintwrapjobjectArray__longlongID=NULL;
jintwrapListjintArray_intintID=NULL;
jintwrapPolyjdoubleArray_doubledoubleID=NULL;
jobjectArray_getAccessibleFieldsjintintID=NULL;
jobjectArray_getAccessibleMethodsjintintID=NULL;
jobjectArray_getCompletionjintintjobjectArray_java_lang_Stringjava_lang_StringID=NULL;


}

// Generic methods

void ScilabJavaObject::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}

void ScilabJavaObject::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}
// Method(s)

int ScilabJavaObject::invoke (JavaVM * jvm_, int id, char const* methodName, int const* args, int argsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintinvokejintintjstringjava_lang_StringjintArray_intintID = curEnv->GetStaticMethodID(cls, "invoke", "(ILjava/lang/String;[I)I" ) ;
if (jintinvokejintintjstringjava_lang_StringjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "invoke");
}

jstring methodName_ = curEnv->NewStringUTF( methodName );
if (methodName != NULL && methodName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jintArray args_ = curEnv->NewIntArray( argsSize ) ;

if (args_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( args_, 0, argsSize, (jint*)(args) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintinvokejintintjstringjava_lang_StringjintArray_intintID ,id, methodName_, args_));
                        curEnv->DeleteLocalRef(methodName_);
curEnv->DeleteLocalRef(args_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::extract (JavaVM * jvm_, int id, int const* args, int argsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintextractjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "extract", "(I[I)I" ) ;
if (jintextractjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "extract");
}

jintArray args_ = curEnv->NewIntArray( argsSize ) ;

if (args_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( args_, 0, argsSize, (jint*)(args) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintextractjintintjintArray_intintID ,id, args_));
                        curEnv->DeleteLocalRef(args_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::insert (JavaVM * jvm_, int id, int const* keys, int keysSize, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidinsertjintintjintArray_intintjintintID = curEnv->GetStaticMethodID(cls, "insert", "(I[II)V" ) ;
if (voidinsertjintintjintArray_intintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "insert");
}

jintArray keys_ = curEnv->NewIntArray( keysSize ) ;

if (keys_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( keys_, 0, keysSize, (jint*)(keys) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidinsertjintintjintArray_intintjintintID ,id, keys_, value);
                        curEnv->DeleteLocalRef(keys_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char** ScilabJavaObject::getInfos (JavaVM * jvm_, int *lenRow){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jobjectArray_getInfosID = curEnv->GetStaticMethodID(cls, "getInfos", "()[Ljava/lang/String;" ) ;
if (jobjectArray_getInfosID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getInfos");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getInfosID ));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 
* lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[*lenRow];
for (jsize i = 0; i < *lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

void ScilabJavaObject::initScilabJavaObject (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidinitScilabJavaObjectID = curEnv->GetStaticMethodID(cls, "initScilabJavaObject", "()V" ) ;
if (voidinitScilabJavaObjectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidinitScilabJavaObjectID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::garbageCollect (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidgarbageCollectID = curEnv->GetStaticMethodID(cls, "garbageCollect", "()V" ) ;
if (voidgarbageCollectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "garbageCollect");
}

                         curEnv->CallStaticVoidMethod(cls, voidgarbageCollectID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* ScilabJavaObject::getRepresentation (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jstringgetRepresentationjintintID = curEnv->GetStaticMethodID(cls, "getRepresentation", "(I)Ljava/lang/String;" ) ;
if (jstringgetRepresentationjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getRepresentation");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetRepresentationjintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

bool ScilabJavaObject::isValidJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jbooleanisValidJavaObjectjintintID = curEnv->GetStaticMethodID(cls, "isValidJavaObject", "(I)Z" ) ;
if (jbooleanisValidJavaObjectjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isValidJavaObject");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisValidJavaObjectjintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void ScilabJavaObject::enableTrace (JavaVM * jvm_, char const* filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidenableTracejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "enableTrace", "(Ljava/lang/String;)V" ) ;
if (voidenableTracejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "enableTrace");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidenableTracejstringjava_lang_StringID ,filename_);
                        curEnv->DeleteLocalRef(filename_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::disableTrace (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voiddisableTraceID = curEnv->GetStaticMethodID(cls, "disableTrace", "()V" ) ;
if (voiddisableTraceID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "disableTrace");
}

                         curEnv->CallStaticVoidMethod(cls, voiddisableTraceID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::writeLog (JavaVM * jvm_, char const* s){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidwriteLogjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "writeLog", "(Ljava/lang/String;)V" ) ;
if (voidwriteLogjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "writeLog");
}

jstring s_ = curEnv->NewStringUTF( s );
if (s != NULL && s_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidwriteLogjstringjava_lang_StringID ,s_);
                        curEnv->DeleteLocalRef(s_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::setField (JavaVM * jvm_, int id, char const* fieldName, int idarg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidsetFieldjintintjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "setField", "(ILjava/lang/String;I)V" ) ;
if (voidsetFieldjintintjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFieldjintintjstringjava_lang_StringjintintID ,id, fieldName_, idarg);
                        curEnv->DeleteLocalRef(fieldName_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::getField (JavaVM * jvm_, int id, char const* fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintgetFieldjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "getField", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldjintintjstringjava_lang_StringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::getFieldType (JavaVM * jvm_, int id, char const* fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintgetFieldTypejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "getFieldType", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldTypejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFieldType");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldTypejintintjstringjava_lang_StringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, char const* objName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintjavaCastjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "javaCast", "(ILjava/lang/String;)I" ) ;
if (jintjavaCastjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

jstring objName_ = curEnv->NewStringUTF( objName );
if (objName != NULL && objName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintintjstringjava_lang_StringID ,id, objName_));
                        curEnv->DeleteLocalRef(objName_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, int classId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintjavaCastjintintjintintID = curEnv->GetStaticMethodID(cls, "javaCast", "(II)I" ) ;
if (jintjavaCastjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintintjintintID ,id, classId));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char* ScilabJavaObject::getClassName (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jstringgetClassNamejintintID = curEnv->GetStaticMethodID(cls, "getClassName", "(I)Ljava/lang/String;" ) ;
if (jstringgetClassNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getClassName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetClassNamejintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

int ScilabJavaObject::getArrayElement (JavaVM * jvm_, int id, int const* index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintgetArrayElementjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "getArrayElement", "(I[I)I" ) ;
if (jintgetArrayElementjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetArrayElementjintintjintArray_intintID ,id, index_));
                        curEnv->DeleteLocalRef(index_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::setArrayElement (JavaVM * jvm_, int id, int const* index, int indexSize, int idArg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidsetArrayElementjintintjintArray_intintjintintID = curEnv->GetStaticMethodID(cls, "setArrayElement", "(I[II)V" ) ;
if (voidsetArrayElementjintintjintArray_intintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetArrayElementjintintjintArray_intintjintintID ,id, index_, idArg);
                        curEnv->DeleteLocalRef(index_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::removeScilabJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidremoveScilabJavaObjectjintintID = curEnv->GetStaticMethodID(cls, "removeScilabJavaObject", "(I)V" ) ;
if (voidremoveScilabJavaObjectjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveScilabJavaObjectjintintID ,id);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::removeScilabJavaObject (JavaVM * jvm_, int const* id, int idSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidremoveScilabJavaObjectjintArray_intintID = curEnv->GetStaticMethodID(cls, "removeScilabJavaObject", "([I)V" ) ;
if (voidremoveScilabJavaObjectjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeScilabJavaObject");
}

jintArray id_ = curEnv->NewIntArray( idSize ) ;

if (id_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( id_, 0, idSize, (jint*)(id) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidremoveScilabJavaObjectjintArray_intintID ,id_);
                        curEnv->DeleteLocalRef(id_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::limitDirectBuffer (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidlimitDirectBufferjintintID = curEnv->GetStaticMethodID(cls, "limitDirectBuffer", "(I)V" ) ;
if (voidlimitDirectBufferjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "limitDirectBuffer");
}

                         curEnv->CallStaticVoidMethod(cls, voidlimitDirectBufferjintintID ,id);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::isUnwrappable (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintisUnwrappablejintintID = curEnv->GetStaticMethodID(cls, "isUnwrappable", "(I)I" ) ;
if (jintisUnwrappablejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isUnwrappable");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintisUnwrappablejintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, double x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjdoubledoubleID = curEnv->GetStaticMethodID(cls, "wrap", "(D)I" ) ;
if (jintwrapjdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjdoubledoubleID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, double const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "wrap", "([D)I" ) ;
if (jintwrapjdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jdoubleArray x_ = curEnv->NewDoubleArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( x_, 0, xSize, (jdouble*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjdoubleArray_doubledoubleID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, double const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__doubledoubleID = curEnv->GetStaticMethodID(cls, "wrap", "([[D)I" ) ;
if (jintwrapjobjectArray__doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[D"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jdoubleArray xLocal = curEnv->NewDoubleArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( xLocal, 0, xSizeCol, (jdouble*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__doubledoubleID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, int x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjintintID = curEnv->GetStaticMethodID(cls, "wrap", "(I)I" ) ;
if (jintwrapjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjintintID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, int const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjintArray_intintID = curEnv->GetStaticMethodID(cls, "wrap", "([I)I" ) ;
if (jintwrapjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jintArray x_ = curEnv->NewIntArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( x_, 0, xSize, (jint*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjintArray_intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, int const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__intintID = curEnv->GetStaticMethodID(cls, "wrap", "([[I)I" ) ;
if (jintwrapjobjectArray__intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[I"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jintArray xLocal = curEnv->NewIntArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( xLocal, 0, xSizeCol, (jint*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, byte x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjbytebyteID = curEnv->GetStaticMethodID(cls, "wrap", "(B)I" ) ;
if (jintwrapjbytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjbytebyteID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, byte const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjbyteArray_bytebyteID = curEnv->GetStaticMethodID(cls, "wrap", "([B)I" ) ;
if (jintwrapjbyteArray_bytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jbyteArray x_ = curEnv->NewByteArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( x_, 0, xSize, (jbyte*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjbyteArray_bytebyteID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, byte const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__bytebyteID = curEnv->GetStaticMethodID(cls, "wrap", "([[B)I" ) ;
if (jintwrapjobjectArray__bytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[B"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jbyteArray xLocal = curEnv->NewByteArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( xLocal, 0, xSizeCol, (jbyte*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__bytebyteID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjshortshortID = curEnv->GetStaticMethodID(cls, "wrap", "(S)I" ) ;
if (jintwrapjshortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjshortshortID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, short const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjshortArray_shortshortID = curEnv->GetStaticMethodID(cls, "wrap", "([S)I" ) ;
if (jintwrapjshortArray_shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jshortArray x_ = curEnv->NewShortArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( x_, 0, xSize, (jshort*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjshortArray_shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, short const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__shortshortID = curEnv->GetStaticMethodID(cls, "wrap", "([[S)I" ) ;
if (jintwrapjobjectArray__shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[S"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jshortArray xLocal = curEnv->NewShortArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( xLocal, 0, xSizeCol, (jshort*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, char const* x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrap", "(Ljava/lang/String;)I" ) ;
if (jintwrapjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jstring x_ = curEnv->NewStringUTF( x );
if (x != NULL && x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjstringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, char const* const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrap", "([Ljava/lang/String;)I" ) ;
if (jintwrapjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, stringArrayClass, NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < xSize; i++)
{
jstring TempString = curEnv->NewStringUTF( x[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( x_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray_java_lang_Stringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, char const* const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrap", "([[Ljava/lang/String;)I" ) ;
if (jintwrapjobjectArray__java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < xSize; i++)
{
jobjectArray xLocal = curEnv->NewObjectArray( xSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < xSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( x[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( xLocal, j, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);

}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__java_lang_Stringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, bool x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "wrap", "(Z)I" ) ;
if (jintwrapjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jboolean x_ = (static_cast<bool>(x) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjbooleanbooleanID ,x_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, bool const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjbooleanArray_booleanbooleanID = curEnv->GetStaticMethodID(cls, "wrap", "([Z)I" ) ;
if (jintwrapjbooleanArray_booleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jbooleanArray x_ = curEnv->NewBooleanArray( xSize ) ;
curEnv->SetBooleanArrayRegion( x_, 0, xSize, (jboolean*)x ) ;

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjbooleanArray_booleanbooleanID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, bool const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__booleanbooleanID = curEnv->GetStaticMethodID(cls, "wrap", "([[Z)I" ) ;
if (jintwrapjobjectArray__booleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[Z"),NULL);
for (int i=0; i<xSize; i++){
                        jbooleanArray xLocal = curEnv->NewBooleanArray( xSizeCol ) ;
                        curEnv->SetBooleanArrayRegion( xLocal, 0, xSizeCol, (jboolean*)(x[i]) ) ;
                        curEnv->SetObjectArrayElement(x_, i, xLocal);
                        curEnv->DeleteLocalRef(xLocal);
                        }

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__booleanbooleanID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, unsigned short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjcharcharID = curEnv->GetStaticMethodID(cls, "wrap", "(C)I" ) ;
if (jintwrapjcharcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjcharcharID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, unsigned short const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjcharArray_charcharID = curEnv->GetStaticMethodID(cls, "wrap", "([C)I" ) ;
if (jintwrapjcharArray_charcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jcharArray x_ = curEnv->NewCharArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( x_, 0, xSize, (jchar*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjcharArray_charcharID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, unsigned short const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__charcharID = curEnv->GetStaticMethodID(cls, "wrap", "([[C)I" ) ;
if (jintwrapjobjectArray__charcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[C"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jcharArray xLocal = curEnv->NewCharArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( xLocal, 0, xSizeCol, (jchar*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__charcharID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, float x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjfloatfloatID = curEnv->GetStaticMethodID(cls, "wrap", "(F)I" ) ;
if (jintwrapjfloatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjfloatfloatID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, float const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjfloatArray_floatfloatID = curEnv->GetStaticMethodID(cls, "wrap", "([F)I" ) ;
if (jintwrapjfloatArray_floatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jfloatArray x_ = curEnv->NewFloatArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( x_, 0, xSize, (jfloat*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjfloatArray_floatfloatID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, float const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__floatfloatID = curEnv->GetStaticMethodID(cls, "wrap", "([[F)I" ) ;
if (jintwrapjobjectArray__floatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[F"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jfloatArray xLocal = curEnv->NewFloatArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( xLocal, 0, xSizeCol, (jfloat*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__floatfloatID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, long long x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjlonglongID = curEnv->GetStaticMethodID(cls, "wrap", "(J)I" ) ;
if (jintwrapjlonglongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjlonglongID ,x));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, long long const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjlongArray_longlongID = curEnv->GetStaticMethodID(cls, "wrap", "([J)I" ) ;
if (jintwrapjlongArray_longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

jlongArray x_ = curEnv->NewLongArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( x_, 0, xSize, (jlong*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjlongArray_longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrap (JavaVM * jvm_, long long const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapjobjectArray__longlongID = curEnv->GetStaticMethodID(cls, "wrap", "([[J)I" ) ;
if (jintwrapjobjectArray__longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrap");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[J"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jlongArray xLocal = curEnv->NewLongArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( xLocal, 0, xSizeCol, (jlong*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapjobjectArray__longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapList (JavaVM * jvm_, int const* ids, int idsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapListjintArray_intintID = curEnv->GetStaticMethodID(cls, "wrapList", "([I)I" ) ;
if (jintwrapListjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapList");
}

jintArray ids_ = curEnv->NewIntArray( idsSize ) ;

if (ids_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( ids_, 0, idsSize, (jint*)(ids) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapListjintArray_intintID ,ids_));
                        curEnv->DeleteLocalRef(ids_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapPoly (JavaVM * jvm_, double const* coefs, int coefsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintwrapPolyjdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "wrapPoly", "([D)I" ) ;
if (jintwrapPolyjdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapPoly");
}

jdoubleArray coefs_ = curEnv->NewDoubleArray( coefsSize ) ;

if (coefs_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( coefs_, 0, coefsSize, (jdouble*)(coefs) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapPolyjdoubleArray_doubledoubleID ,coefs_));
                        curEnv->DeleteLocalRef(coefs_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char** ScilabJavaObject::getAccessibleFields (JavaVM * jvm_, int id, int *lenRow){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jobjectArray_getAccessibleFieldsjintintID = curEnv->GetStaticMethodID(cls, "getAccessibleFields", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getAccessibleFieldsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getAccessibleFields");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getAccessibleFieldsjintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 
* lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[*lenRow];
for (jsize i = 0; i < *lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

char** ScilabJavaObject::getAccessibleMethods (JavaVM * jvm_, int id, int *lenRow){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jobjectArray_getAccessibleMethodsjintintID = curEnv->GetStaticMethodID(cls, "getAccessibleMethods", "(I)[Ljava/lang/String;" ) ;
if (jobjectArray_getAccessibleMethodsjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getAccessibleMethods");
}

                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getAccessibleMethodsjintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 
* lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[*lenRow];
for (jsize i = 0; i < *lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

char** ScilabJavaObject::getCompletion (JavaVM * jvm_, int id, char const* const* fieldPath, int fieldPathSize, int *lenRow){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jobjectArray_getCompletionjintintjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "getCompletion", "(I[Ljava/lang/String;)[Ljava/lang/String;" ) ;
if (jobjectArray_getCompletionjintintjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getCompletion");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray fieldPath_ = curEnv->NewObjectArray( fieldPathSize, stringArrayClass, NULL);
if (fieldPath_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < fieldPathSize; i++)
{
jstring TempString = curEnv->NewStringUTF( fieldPath[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( fieldPath_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                        jobjectArray res =  static_cast<jobjectArray>( curEnv->CallStaticObjectMethod(cls, jobjectArray_getCompletionjintintjobjectArray_java_lang_Stringjava_lang_StringID ,id, fieldPath_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 
* lenRow = curEnv->GetArrayLength(res);

char **arrayOfString;
arrayOfString = new char *[*lenRow];
for (jsize i = 0; i < *lenRow; i++){
jstring resString = reinterpret_cast<jstring>(curEnv->GetObjectArrayElement(res, i));
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(fieldPath_);
if (curEnv->ExceptionCheck()) {
delete[] arrayOfString;
                                throw GiwsException::JniCallMethodException(curEnv);
}
curEnv->DeleteLocalRef(res);
return arrayOfString;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

}
