#ifndef CounterModel_h
#define CounterModel_h

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "ListModel.h"
#include "Counter.h"
#include "Debug.h"

#include <QPair>

//* counter pair
class CounterPair: public QPair<QString, int>
{

    public:

    //* constructor
    CounterPair( void )
    {}

    //* constructor
    CounterPair( const QPair<QString, int>& pair ):
        QPair<QString, int>( pair )
    {}

    //* less than operator
    bool operator < ( const CounterPair& pair ) const
    {
        return first < pair.first;
    }

    //* equal to operator
    bool operator == (const CounterPair& pair ) const
    { return first == pair.first; }

};

//* qlistview for object counters
class CounterModel: public ListModel<CounterPair>
{

    Q_OBJECT

    public:

    //* column type enumeration
    enum ColumnType
    {
        Name,
        Count,
        nColumns
    };

    //*@name methods reimplemented from base class
    //@{

    // return data for a given index
    virtual QVariant data(const QModelIndex &index, int role) const;

    //* header data
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;

    //* number of columns for a given index
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const
    { return nColumns; }

    //@}

    protected:

    //* sort
    virtual void _sort( int column, Qt::SortOrder order = Qt::AscendingOrder );

    private:

    //* used to sort IconCaches
    class SortFTor: public ItemModel::SortFTor
    {

        public:

        //* constructor
        SortFTor( const int& type, Qt::SortOrder order = Qt::AscendingOrder ):
            ItemModel::SortFTor( type, order )
            {}

        //* prediction
        bool operator() ( CounterPair, CounterPair ) const;

    };

    //* column titles
    static const QString columnTitles_[ nColumns ];

};

#endif
