/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef LOGWGT_H
#define LOGWGT_H

#include <QWidget>
#include <QTextEdit>
#include <QColor>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class LogWgt : public QWidget
{
  Q_OBJECT
  private:
    QTextEdit* mw_text;

  public:
    LogWgt(QWidget *parent = 0);
    ~LogWgt(){};

    void addMessage(const QString &, const QColor & color = QColor(Qt::black));
    void addInfo   (const QString & msg){addMessage(QString("[Information]: ") + msg, QColor(Qt::blue));}
    void addError  (const QString & msg){addMessage(QString("[Error]: "      ) + msg, QColor(Qt::red));}
};

#endif
