/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "globals.h"

#include <assert.h>

#include <QObject>
#include <QNetworkInterface>

QString        Globals::m_profileName    = "";
QChatSettings* Globals::m_settings       = 0;
UserInfo*      Globals::m_info           = 0;
LogWgt*        Globals::m_log             = NULL;
const uint     Globals::VersionID         = 15;
const uint     Globals::Revision          = 37;
QString        Globals::VersionStr        = "0.3";
QString        Globals::StatusStr[7]      =
{
  QObject::tr("Busy"),
  QObject::tr("Free"),
  QObject::tr("Ready for chat"),
  QObject::tr("Do not disturb"),
  QObject::tr("Inactive"),
  QObject::tr("Away"),
  QObject::tr("Invisible"),
};

const char* Globals::VersionsTable[15]  =
{
  "0.0.1" , //1
  "0.0.2" , //2
  "0.0.3" , //3
  "0.0.4" , //4
  "0.1.0" , //5
  "0.1.1" , //6
  "0.1.2" , //7
  "0.1.3" , //8
  "0.1.4" , //9
  "0.1.5" , //10
  "0.1.6" , //11
  "0.2"   , //12
  "0.2.1" , //13
  "0.2.2" , //14
  "0.3" , //15
};

//\*****************************************************************************
quint32 Globals::localIp(QHostAddress* br)
{
  QList<QNetworkInterface> all_i = QNetworkInterface::allInterfaces();
  QList<QNetworkAddressEntry> all_e;

  foreach(QNetworkInterface i, all_i)
  {
     all_e = i.addressEntries();
     foreach(QNetworkAddressEntry e, all_e)
     {
       if(e.broadcast().isNull())
         continue;

       *br = e.broadcast();

       return e.ip().toIPv4Address();
     }
  }

  return 0;
}
//\*****************************************************************************
char* datadup(const char* src, int n)
{
  int i;
  char* dest = (char*)malloc(n);
  assert(NULL != dest);

  for(i = 0; i < n; i++)
    dest[i] = src[i];

  return dest;
}
//\*****************************************************************************
unsigned long long str2ULL(const char* str) // char[8] -> unsigned long long
{
  union{
    char str[8];
    unsigned long long num;
  }un;

  memcpy(un.str, str, 8);

  return un.num;
}
//\*****************************************************************************
unsigned long str2UL(const char* str) // char[4] -> unsigned long
{
  union{
    char str[4];
    unsigned long num;
  }un;

  memcpy(un.str, str, 4);

  return un.num;
}
//\*****************************************************************************
unsigned short str2US(const char* str) // char[2] -> unsigned short
{
  union{
    char str[2];
    unsigned long num;
  }un;

  memcpy(un.str, str, 2);

  return un.num;
}
//\*****************************************************************************
int catULL2str(char* str, unsigned long long num)
{
  union{
    char str[8];
    unsigned long long num;
  }un;

  un.num = num;
  memcpy(str, un.str, 8);

  return 1;
}
//\*****************************************************************************
int catUL2str(char* str, unsigned long num)
{
  union{
    char str[4];
    unsigned long num;
  }un;

  un.num = num;
  memcpy(str, un.str, 4);

  return 1;
}
//\*****************************************************************************
int catUS2str(char* str, unsigned short num)
{
  union{
    char str[2];
    unsigned short num;
  }un;

  un.num = num;
  memcpy(str, un.str, 2);

  return 1;
}
//\*****************************************************************************
QList<QNetworkInterface> Globals::validInterfeices()
{
  QList<QNetworkInterface> all_i = QNetworkInterface::allInterfaces();
  QList<QNetworkAddressEntry> all_e;
  QList<QNetworkInterface> valid_i;

  foreach(QNetworkInterface i, all_i)
  {
    if(i.flags() & QNetworkInterface::IsRunning &&
       i.flags() & QNetworkInterface::CanBroadcast &&
       i.flags() & QNetworkInterface::IsUp)
      valid_i.append(i);
  }

  return valid_i;
}
