/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "filtrationruleeditor.h"

#include <QGridLayout>

#include "filtrationrule.h"

FiltrationRuleEditor::FiltrationRuleEditor(QWidget *parent)
 : QDialog(parent),
  m_edited(false),
  m_rule(NULL)
{
  QGridLayout* grid    = new QGridLayout(this);

  m_nameEdit           = new QLineEdit(this);
  m_userNamesEdit      = new QTextEdit(this);
  m_compNamesEdit      = new QTextEdit(this);
  m_IPsEdit            = new QTextEdit(this);
  m_messageFilterEdit  = new QTextEdit(this);
  m_isRegExpChbx       = new QCheckBox(tr("Regular Expression"), this);
  m_okBtn              = new QPushButton(tr("Ok")    , this);
  m_applyBtn           = new QPushButton(tr("Apply") , this);
  m_cancelBtn          = new QPushButton(tr("Cancel"), this);

  grid->addWidget(new QLabel(tr("Rule name :")), 0, 0);
  grid->addWidget(m_nameEdit                   , 0, 1, 1, 2);
  grid->addWidget(new QLabel(tr("User(s) to ignore :"))         , 1, 0, 1, 3);
  grid->addWidget(m_userNamesEdit                               , 2, 0, 1, 3);
  grid->addWidget(new QLabel(tr("Computer name(s) to ignore :")), 3, 0, 1, 3);
  grid->addWidget(m_compNamesEdit                               , 4, 0, 1, 3);
  grid->addWidget(new QLabel(tr("IP address(es) to ignore :"))  , 5, 0, 1, 3);
  grid->addWidget(m_IPsEdit                                     , 6, 0, 1, 3);
  grid->addWidget(new QLabel(tr("Message filter(one word per line or regular expression):")), 7, 0, 1, 3);
  grid->addWidget(m_messageFilterEdit                           , 8, 0, 1, 3);
  grid->addWidget(m_isRegExpChbx                                , 9, 0, 1, 3);
  grid->addWidget(m_okBtn                                       , 10, 0);
  grid->addWidget(m_applyBtn                                    , 10, 1);
  grid->addWidget(m_cancelBtn                                   , 10, 2);

  setWindowTitle(tr("Filtration Rule Editor"));

  m_applyBtn->setEnabled(false);

  connect(m_nameEdit          , SIGNAL(textEdited (QString)), this, SLOT(edited()));
  connect(m_userNamesEdit     , SIGNAL(textChanged()), this, SLOT(edited()));
  connect(m_compNamesEdit     , SIGNAL(textChanged()), this, SLOT(edited()));
  connect(m_IPsEdit           , SIGNAL(textChanged()), this, SLOT(edited()));
  connect(m_messageFilterEdit , SIGNAL(textChanged()), this, SLOT(edited()));
  connect(m_isRegExpChbx      , SIGNAL(stateChanged(int)), this, SLOT(edited()));

  connect(m_okBtn    , SIGNAL(clicked()), this, SLOT(saveRule()));
  connect(m_okBtn    , SIGNAL(clicked()), this, SLOT(accept()));
  connect(m_applyBtn , SIGNAL(clicked()), this, SLOT(saveRule()));
  connect(m_cancelBtn, SIGNAL(clicked()), this, SLOT(reject()));
}


FiltrationRuleEditor::~FiltrationRuleEditor()
{
}

void FiltrationRuleEditor::init(FiltrationRule* rule)
{
  m_rule = rule;

  m_nameEdit         ->setText(m_rule->name());
  m_userNamesEdit    ->setText(m_rule->userNames());
  m_compNamesEdit    ->setText(m_rule->compNames());
  m_IPsEdit          ->setText(m_rule->IPs());
  m_messageFilterEdit->setText(m_rule->messageFilter());
  m_isRegExpChbx     ->setCheckState(m_rule->isRegExp() ? Qt::Checked : Qt::Unchecked );
}

void FiltrationRuleEditor::saveRule()
{
  if(m_edited && m_rule)
  {
    m_rule->setName         (m_nameEdit         ->text());
    m_rule->setUserNames    (m_userNamesEdit    ->toPlainText());
    m_rule->setCompNames    (m_compNamesEdit    ->toPlainText());
    m_rule->setIPs          (m_IPsEdit          ->toPlainText());
    m_rule->setMessageFilter(m_messageFilterEdit->toPlainText());
    m_rule->setIsRegExp     (m_isRegExpChbx->checkState() == Qt::Checked);
  }

  m_edited = false;
  m_applyBtn->setEnabled(false);
}


