/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef ABSTRACTPROTOCOL_H
#define ABSTRACTPROTOCOL_H

#include <QString>

#include "globals.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class AbstractProtocol
{
  public:
    AbstractProtocol();
    virtual ~AbstractProtocol();

    // Protocol information functions
    virtual uint protocolVersion () const = 0;
    virtual uint protocolLen     () const = 0;
    virtual const char* programId() const = 0;
    virtual uint optionsLen() const = 0;

    // NOTE size of char* buf in following functions must be at least ProtocolLen bytes

    virtual QString programId       (const char* buf) = 0;
    virtual uint    packetSize      (const char* buf) = 0;
    virtual uint    programVersion  (const char* buf) = 0;
    virtual uint    protocolVersion (const char* buf) = 0;
    virtual quint64 destIp          (const char* buf) = 0;
    virtual quint64 srcIp           (const char* buf) = 0;
    virtual uint    packetType      (const char* buf) = 0;
    virtual uint    packetId        (const char* buf) = 0;
    virtual uint    fragmentSize    (const char* buf) = 0;
    virtual uint    packetNum       (const char* buf) = 0;
    virtual quint64 time            (const char* buf) = 0;
    virtual uint    channelType     (const char* buf) = 0;
    virtual uint    compNameLen     (const char* buf) = 0;
    virtual uint    userNameLen     (const char* buf) = 0;
    virtual uint    messageLen      (const char* buf) = 0;
    virtual uint    parametrsLen    (const char* buf) = 0;
    virtual uint    optionsLen      (const char* buf) = 0;
    virtual bool    compressed      (const char* buf) = 0;

    virtual QString compName        (const char* buf, uint sz) = 0;
    virtual QString userName        (const char* buf, uint sz) = 0;
    virtual QString message         (const char* buf, uint sz) = 0;
    virtual QByteArray parametrs    (const char* buf, uint sz) = 0;

    virtual void setProgramId      (char* buf) = 0;
    virtual void setPacketSize     (char* buf, uint) = 0;
    virtual void setProgramVersion (char* buf) = 0;
    virtual void setProtocolVersion(char* buf) = 0;

    virtual void setDestIp         (char* buf, quint64 ip) = 0;
    virtual void setSrcIp          (char* buf, quint64 ip) = 0;
    virtual void setPacketType     (char* buf, uint  type) = 0;
    virtual void setPacketId       (char* buf, uint    id) = 0;
    virtual void setFragmentSize   (char* buf, uint    sz) = 0;
    virtual void setPacketNum      (char* buf, quint32 nm) = 0;
    virtual void setTime           (char* buf, quint64 tm) = 0;
    virtual void setChannelType    (char* buf, quint32 id) = 0;
    virtual void setCompNameLen    (char* buf, uint    sz) = 0;
    virtual void setUserNameLen    (char* buf, uint    sz) = 0;
    virtual void setMessageLen     (char* buf, quint32 sz) = 0;
    virtual void setParametrsLen   (char* buf, quint32 sz) = 0;
    virtual void setOptionsLen     (char* buf, quint32 sz) = 0;
    virtual void setCompressed     (char* buf, bool     b) = 0;
    virtual void setCompName       (char* buf, const QString& name) = 0;
    virtual void setUserName       (char* buf, const QString& name) = 0;
    virtual void setMessage        (char* buf, const QString& msg)  = 0;
    virtual void setParametrs      (char* buf, const QByteArray& pars) = 0;
};

#endif
