//
// C++ Implementation: CLampEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CLampEdit.hpp"

CLampEditDlg::CLampEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.color_amb, SIGNAL(released()), this, SLOT(slotEditColorAmb()));
   connect(ui.color_dif, SIGNAL(released()), this, SLOT(slotEditColorDif()));
   connect(ui.color_spe, SIGNAL(released()), this, SLOT(slotEditColorSpe()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CLampEditDlg::~CLampEditDlg() {
}

void CLampEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CLampEditDlg::slotGetData(FolderListItem *i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;

    point=i;
    
    ui.text->setText(i->text(0));
    ui.lensflare->setChecked(i->GetValue("lensflare",i).toInt());
    ui.on->setChecked(i->GetValue("on",i).toInt());
    ui.Headlight->setChecked(i->GetValue("headlight",i).toInt());
    ui.Spotlight->setChecked(i->GetValue("spotlight",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());
    
    ui.slocx->setText(i->GetValue("sx",i));
    ui.slocy->setText(i->GetValue("sy",i));
    ui.slocz->setText(i->GetValue("sz",i));

    ui.sdiffexpo->setText(i->GetValue("sdexpo",i));
    ui.sdiffcutoff->setText(i->GetValue("sdcut",i));

    ui.sconst->setText(i->GetValue("sconst",i));
    ui.slinear->setText(i->GetValue("slinear",i));
    ui.squadratic->setText(i->GetValue("squadratic",i));

    strncpy(mybuff,i->GetValue("color_amb",i).toAscii().constData() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor_amb.setRgb(colorr,colorg,colorb);
    if ( mycolor_amb.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor_amb );
      QIcon icon(pix);
      ui.color_amb->setIcon( icon );
      QSize size(100,15);
      ui.color_amb->setIconSize( size );      
    }
    strncpy(mybuff,i->GetValue("color_dif",i).toAscii().constData() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor_dif.setRgb(colorr,colorg,colorb);
    if ( mycolor_dif.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor_dif );
      QIcon icon(pix);
      ui.color_dif->setIcon( icon );
      QSize size(100,15);
      ui.color_dif->setIconSize( size );      
    }
    strncpy(mybuff,i->GetValue("color_spe",i).toAscii().constData() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor_spe.setRgb(colorr,colorg,colorb);
    if ( mycolor_spe.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor_spe );
      QIcon icon(pix);
      ui.color_spe->setIcon( icon );
      QSize size(100,15);
      ui.color_spe->setIconSize( size );      
    }
    qWarning( "CLampEditDlg::slotGetData(): Geht !" );
}

void CLampEditDlg::slotEditData()
{
    char mybuff[256];
    
    if(point != NULL){
        point->setText(0,ui.text->text());
    
        point->SetValue("lensflare",  ui.lensflare->isChecked() ? "1" : "0");
        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->SetValue("headlight", ui.Headlight->isChecked() ? "1" : "0");
        point->SetValue("spotlight", ui.Spotlight->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("sx",ui.slocx->text());
        point->SetValue("sy",ui.slocy->text());
        point->SetValue("sz",ui.slocz->text());

        point->SetValue("sdexpo",ui.sdiffexpo->text());
        point->SetValue("sdcut",ui.sdiffcutoff->text());

        point->SetValue("sconst",ui.sconst->text());
        point->SetValue("slinear",ui.slinear->text());
        point->SetValue("squadratic",ui.squadratic->text());

        sprintf(mybuff,"%02X%02X%02X",mycolor_amb.red(),mycolor_amb.green(),mycolor_amb.blue());
        point->SetValue("color_amb",mybuff);

        sprintf(mybuff,"%02X%02X%02X",mycolor_dif.red(),mycolor_dif.green(),mycolor_dif.blue());
        point->SetValue("color_dif",mybuff);

        sprintf(mybuff,"%02X%02X%02X",mycolor_spe.red(),mycolor_spe.green(),mycolor_spe.blue());
        point->SetValue("color_spe",mybuff);

        point->updategl();
    }
    qWarning( "CLampEditDlg::slotEditData(): Geht !" );
}
void CLampEditDlg::slotEditColorAmb()
{
    QColor color = QColorDialog::getColor(mycolor_amb,this );
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
        QIcon icon(pix);
        ui.color_amb->setIcon( icon );
        QSize size(100,15);
        ui.color_amb->setIconSize( size );      
        mycolor_amb = color;
    }
    qWarning( "CFogEditDlg::slotEditColorAmb(): Geht !" );
}
void CLampEditDlg::slotEditColorDif()
{
    QColor color = QColorDialog::getColor(mycolor_dif,this );
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
        QIcon icon(pix);
        ui.color_dif->setIcon( icon );
        QSize size(100,15);
        ui.color_dif->setIconSize( size );      
        mycolor_dif = color;
    }
    qWarning( "CFogEditDlg::slotEditColorAmb(): Geht !" );
}
void CLampEditDlg::slotEditColorSpe()
{
    QColor color = QColorDialog::getColor(mycolor_spe,this );
    if ( color.isValid() ) {
        QPixmap pix (100,15) ;
        pix.fill( color );
        QIcon icon(pix);
        ui.color_spe->setIcon( icon );
        QSize size(100,15);
        ui.color_spe->setIconSize( size );      
        mycolor_spe = color;
    }
    qWarning( "CFogEditDlg::slotEditColorAmb(): Geht !" );
}
