###############################################################################
# OpenVAS Vulnerability Test
# $Id: support_incident_tracker_37949.nasl 8291 2010-07-05 13:13:29Z mime $
#
# Support Incident Tracker Blank Password Authentication Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100467);
 script_tag(name:"cvss_base", value:"6.8");
 script_cve_id("CVE-2010-1596");
 script_bugtraq_id(37949);
 script_version ("1.0-$Revision: 8291 $");
 script_tag(name:"risk_factor", value:"High");

 script_name("Support Incident Tracker Blank Password Authentication Bypass Vulnerability");

desc = "Overview:
Support Incident Tracker (SiT!) is prone to an authentication-bypass
vulnerability.

An attacker can exploit this issue to gain unauthorized access to the
affected application.

Versions prior to Support Incident Tracker (SiT!) 3.51 are vulnerable.

Solution:
The vendor has released an update. Please see the references for more
information.

References:
http://www.securityfocus.com/bid/37949
http://sitracker.sourceforge.net
http://sitracker.org/wiki/ReleaseNotes351

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if Support Incident Tracker version is < 3.51");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("support_incident_tracker_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/support_incident_tracker")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "3.51")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
