# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 019-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53782);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 019-1 (squid)";
 script_name(name);

 desc = "The remote host is missing an update to squid
announced via advisory DSA 019-1.

WireX discovered a potential temporary file race condition in the way
that squid sends out email messages notifying the administrator about
updating the program.  This could lead to arbitrary files to get
overwritten.  However the code would only be executed if running a
very bleeding edge release of squid, running a server whose time is
set some number of months in the past and squid is crashing.  Read it
as hardly to exploit.  This version also containes more upstream
bugfixes wrt. dots in hostnames and unproper HTML quoting.

We recommend you upgrade your squid package..

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20019-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 019-1 (squid)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.2.5-3.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.2.5-3.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.2.5-3.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
