/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javafx.stage;

/**
Builder class for javafx.stage.Stage
@see javafx.stage.Stage
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public class StageBuilder<B extends javafx.stage.StageBuilder<B>> extends javafx.stage.WindowBuilder<B> implements javafx.util.Builder<javafx.stage.Stage> {
    protected StageBuilder() {
    }
    
    /** Creates a new instance of StageBuilder. */
    @SuppressWarnings({"deprecation", "rawtypes", "unchecked"})
    public static javafx.stage.StageBuilder<?> create() {
        return new javafx.stage.StageBuilder();
    }
    
    private int __set;
    private void __set(int i) {
        __set |= 1 << i;
    }
    public void applyTo(javafx.stage.Stage x) {
        super.applyTo(x);
        int set = __set;
        while (set != 0) {
            int i = Integer.numberOfTrailingZeros(set);
            set &= ~(1 << i);
            switch (i) {
                case 0: x.setFullScreen(this.fullScreen); break;
                case 1: x.setIconified(this.iconified); break;
                case 2: x.getIcons().addAll(this.icons); break;
                case 3: x.setMaxHeight(this.maxHeight); break;
                case 4: x.setMaxWidth(this.maxWidth); break;
                case 5: x.setMinHeight(this.minHeight); break;
                case 6: x.setMinWidth(this.minWidth); break;
                case 7: x.setResizable(this.resizable); break;
                case 8: x.setScene(this.scene); break;
                case 9: x.setTitle(this.title); break;
            }
        }
    }
    
    private boolean fullScreen;
    /**
    Set the value of the {@link javafx.stage.Stage#isFullScreen() fullScreen} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B fullScreen(boolean x) {
        this.fullScreen = x;
        __set(0);
        return (B) this;
    }
    
    private boolean iconified;
    /**
    Set the value of the {@link javafx.stage.Stage#isIconified() iconified} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B iconified(boolean x) {
        this.iconified = x;
        __set(1);
        return (B) this;
    }
    
    private java.util.Collection<? extends javafx.scene.image.Image> icons;
    /**
    Add the given items to the List of items in the {@link javafx.stage.Stage#getIcons() icons} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B icons(java.util.Collection<? extends javafx.scene.image.Image> x) {
        this.icons = x;
        __set(2);
        return (B) this;
    }
    
    /**
    Add the given items to the List of items in the {@link javafx.stage.Stage#getIcons() icons} property for the instance constructed by this builder.
    */
    public B icons(javafx.scene.image.Image... x) {
        return icons(java.util.Arrays.asList(x));
    }
    
    private double maxHeight;
    /**
    Set the value of the {@link javafx.stage.Stage#getMaxHeight() maxHeight} property for the instance constructed by this builder.
    * @since JavaFX 2.1
    */
    @SuppressWarnings("unchecked")
    public B maxHeight(double x) {
        this.maxHeight = x;
        __set(3);
        return (B) this;
    }
    
    private double maxWidth;
    /**
    Set the value of the {@link javafx.stage.Stage#getMaxWidth() maxWidth} property for the instance constructed by this builder.
    * @since JavaFX 2.1
    */
    @SuppressWarnings("unchecked")
    public B maxWidth(double x) {
        this.maxWidth = x;
        __set(4);
        return (B) this;
    }
    
    private double minHeight;
    /**
    Set the value of the {@link javafx.stage.Stage#getMinHeight() minHeight} property for the instance constructed by this builder.
    * @since JavaFX 2.1
    */
    @SuppressWarnings("unchecked")
    public B minHeight(double x) {
        this.minHeight = x;
        __set(5);
        return (B) this;
    }
    
    private double minWidth;
    /**
    Set the value of the {@link javafx.stage.Stage#getMinWidth() minWidth} property for the instance constructed by this builder.
    * @since JavaFX 2.1
    */
    @SuppressWarnings("unchecked")
    public B minWidth(double x) {
        this.minWidth = x;
        __set(6);
        return (B) this;
    }
    
    private boolean resizable;
    /**
    Set the value of the {@link javafx.stage.Stage#isResizable() resizable} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B resizable(boolean x) {
        this.resizable = x;
        __set(7);
        return (B) this;
    }
    
    private javafx.scene.Scene scene;
    /**
    Set the value of the {@link javafx.stage.Stage#getScene() scene} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B scene(javafx.scene.Scene x) {
        this.scene = x;
        __set(8);
        return (B) this;
    }
    
    private javafx.stage.StageStyle style = javafx.stage.StageStyle.DECORATED;
    /**
    Set the value of the {@link javafx.stage.Stage#getStyle() style} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B style(javafx.stage.StageStyle x) {
        this.style = x;
        return (B) this;
    }
    
    private java.lang.String title;
    /**
    Set the value of the {@link javafx.stage.Stage#getTitle() title} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B title(java.lang.String x) {
        this.title = x;
        __set(9);
        return (B) this;
    }
    
    /**
    Make an instance of {@link javafx.stage.Stage} based on the properties set on this builder.
    */
    public javafx.stage.Stage build() {
        javafx.stage.Stage x = new javafx.stage.Stage(this.style);
        applyTo(x);
        return x;
    }
}
