if (typeof T === 'undefined') require('../setup');

T('acos', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).acos().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('NaN', 40, 4, 'NaN');
  t('Infinity', 40, 4, 'NaN');
  t('-Infinity', 40, 4, 'NaN');
  t('1.0000000000000001', 40, 4, 'NaN');
  t('2', 40, 4, 'NaN');
  t('-1.0000000000000001', 40, 4, 'NaN');
  t('-2', 40, 4, 'NaN');
  t('1', 40, 4, '0');
  t('-1', 40, 4, '3.141592653589793238462643383279502884197');
  t('0', 20, 4, '1.5707963267948966192');
  t('-0', 20, 4, '1.5707963267948966192');

  t('-0.6403', 7, 1, '2.265685');
  t('-0.53', 2, 2, '2.2');
  t('0.4396178420823739355530719404', 10, 0, '1.115623176');
  t('0.496420101927875989152448746035981', 1, 5, '1');
  t('0.1', 2, 0, '1.5');
  t('-0.20878679', 6, 2, '1.78114');
  t('-0.541191262571486130575708261722416873899', 6, 5, '2.14265');
  t('0.5', 7, 1, '1.047197');
  t('-0.409325859', 10, 2, '1.992511392');
  t('0.551', 5, 6, '0.98723');
  t('0.5', 7, 2, '1.047198');
  t('-0.43419432724217379874620877899386037437997149166291587557428756984642427', 3, 1, '2.01');
  t('0.553', 9, 3, '0.984835716');
  t('0.7809790373261734623688348400648923431479560079817', 6, 1, '0.674564');
  t('0.75824031', 9, 0, '0.710186479');
  t('-0.8', 8, 2, '2.4980916');
  t('0.0799', 3, 5, '1.49');
  t('-0.38393812134692277325859', 4, 1, '1.964');
  t('-0.3907773773285398604336', 1, 1, '1');
  t('-0.69992716948032572772435', 9, 4, '2.34609185');
  t('-0.66158215731029676878636733180177567', 8, 0, '2.2937231');
  t('0.9147368246772431874', 37, 1, '0.415940230269184272745464503534348965');
  t('-0.4553', 27, 1, '2.04350546255828224507689468');
  t('-0.028011903303708804768053896701975443', 56, 1, '1.5988118947274791447123927148057628240666865110752680848');
  t('0.4065777430651635458256706', 14, 6, '1.1520912372989');
  t('-0.78468834561401325', 40, 6, '2.472989536549809027410129361828086088366');
  t('-0.04164046779', 31, 2, '1.61244883758340629332195244831');
  t('-0.117424541', 82, 1, '1.688492407881140013543521665402011226342602786603530341844248637463449252725522796');
  t('-0.1870116529272128766435079579825546176806042554995693356583', 108, 6, '1.75891557205606890020875163685374748628399727002149491921316335140511350243361347958082966501905347526802867');
  t('0.0769104749433424068', 66, 1, '1.49380982556189042854757067055954756775240858876530364274625200666');
  t('-0.027096519359', 92, 3, '1.5978961630571391095050365835267438779450813578907877311954803581546591891147373364143685647');
  t('-0.8', 33, 6, '2.49809154479650885165983415456218');
  t('0.67487482885692802659376964747029780872121304015294984476148189310252027478897761772', 54, 3, '0.830001261924669662461861851080065080704764574011647298');
  t('-0.0804595260228093312276197203', 26, 1, '1.6513429189757672993077865');
  t('0.50408248676517825230780010554261667827445182236535818843176765834864294167168', 73, 4, '1.042477051429539838709819977914186923616698698550378124843462531977088459');
  t('0.92980935280344761170800142822446189257', 42, 0, '0.376901826310506133287494991222901254976804');
  t('0.41923186648524998285699814886092351368793359300547574', 42, 3, '1.13819724675000902666504291062053681280681');
  t('-0.19508761025300975791021816036', 27, 1, '1.76714310275532020878366926');
  t('0.0623252416', 19, 0, '1.508430664767542249');

  /*
  t('0.95', 6, 5, '0.31756');
  t('0.6782122461122354137218760145906432', 10, 3, '0.8254691932');
  t('0.9', 2, 0, '0.46');
  t('0.8439967', 6, 6, '0.566105');
  t('-0.59046118436', 9, 1, '2.20242648');
  t('-0.00438975', 7, 2, '1.575187');
  t('-0.7', 4, 5, '2.346');
  t('-0.54048', 5, 4, '2.1418');
  t('-0.1', 9, 1, '1.67096374');
  t('-0.03', 1, 4, '2');
  t('0.477', 2, 1, '1');
  t('0.86633', 8, 4, '0.52298926');
  t('-0.18', 4, 6, '1.752');
  t('-0.8', 9, 3, '2.49809154');
  t('0.13725829263605', 1, 1, '1');
  t('0.1', 3, 5, '1.47');
  t('-0.1', 4, 3, '1.67');
  t('0.8', 4, 3, '0.6435');
  t('0.6497', 1, 4, '0.9');
  t('0.1', 6, 2, '1.47063');
  t('-0.593190985978055', 4, 6, '2.206');
  t('-0.6771975', 5, 4, '2.3147');
  t('0.5', 10, 3, '1.047197551');
  t('0.411', 6, 2, '1.14725');
  t('-0.4809827781413082812652', 5, 5, '2.0726');
  t('-0.952638735551551392839093035764802', 1, 5, '3');
  t('-0.6015876026815245199418429601227', 4, 6, '2.216');
  t('0.5', 6, 0, '1.0472');
  t('-0.76', 2, 2, '2.5');
  t('-0.6013', 1, 4, '2');
  t('-0.9619020953156049811208600576084629099216448796', 9, 3, '2.8646728');
  t('-0.3', 4, 0, '1.876');
  t('0.337084216260134216861133323767946303807138899466200313856035', 4, 2, '1.227');
  t('-0.75767230234522', 10, 5, '2.430535406');
  t('0.4', 9, 4, '1.15927948');
  t('-0.737', 1, 5, '2');
  t('0.8233161', 5, 2, '0.60357');
  t('-0.1', 2, 1, '1.6');
  t('0.6', 9, 4, '0.927295218');
  t('0.76', 2, 1, '0.7');
  t('-0.587319056', 5, 1, '2.1985');
  t('-0.5425', 9, 0, '2.14420658');
  t('-0.613', 2, 1, '2.2');
  t('-0.733', 7, 1, '2.393518');
  t('0.58568', 4, 2, '0.9451');
  t('-0.46', 10, 0, '2.048791526');
  t('-0.62', 9, 0, '2.23953903');
  t('0.35313', 4, 4, '1.21');
  t('-0.278790639682828162964860311', 7, 6, '1.853331');
  t('0.67962813723803580884418361', 7, 1, '0.8235407');
  t('-0.86771990862867', 8, 4, '2.6213929');
  t('0.616', 5, 5, '0.90714');
  t('-0.298192829', 5, 4, '1.8736');
  t('0.45246', 4, 5, '1.101');
  t('-0.8100687881', 2, 4, '2.5');
  t('-0.6055836687', 9, 0, '2.22129545');
  t('-0.20522811988416665729178720937411834014759998394524', 2, 6, '1.8');
  t('0.76781', 10, 3, '0.695380468');
  t('0.088', 2, 3, '1.4');
  t('-0.620448', 3, 1, '2.24');
  t('0.341092619', 5, 1, '1.2227');
  t('0.394', 9, 3, '1.16581673');
  t('-0.9358665715688378541360271216842', 10, 0, '2.781506787');
  t('0.9075', 4, 3, '0.4335');
  t('0.83', 9, 2, '0.591688643');
  t('0.062739', 3, 3, '1.5');
  t('-0.82857137318719627851264048744030581', 8, 3, '2.5473475');
  t('0.1', 1, 5, '1');
  t('0.63084461862774261096711391638623678987624404553597536466391646597157202402476445757', 10, 1, '0.8881550428');
  t('0.2284220686229836933172652354606909080856597257455321', 7, 6, '1.34034');
  t('0.4228867310325098114', 1, 0, '2');
  t('-0.222929803381779674485', 4, 0, '1.796');
  t('-0.951181739863743076901092296297469029', 2, 2, '2.9');
  t('0.094471294813741920908218807598153918875347786', 3, 0, '1.48');
  t('0.076', 3, 0, '1.5');
  t('0.7', 2, 2, '0.8');
  t('-0.86546', 5, 4, '2.6169');
  t('0.83', 5, 3, '0.59168');
  t('-0.9235418987963690856937924948640127834721109271761628', 4, 4, '2.748');
  t('0.487524009901115874295499714788', 2, 6, '1.1');
  t('0.8078522', 9, 6, '0.630297503');
  t('0.577343', 6, 2, '0.955326');
  t('0.2', 6, 0, '1.36944');
  t('-0.8', 4, 5, '2.498');
  t('-0.84662830373', 7, 0, '2.580414');
  t('-0.19700436573237763730516494933957191921146286', 2, 3, '1.7');
  t('0.3836295855006759034334943790438844484723154048614634089922502442080631201', 6, 2, '1.17708');
  t('-0.849485756377747570925803744679347155004858131625176072190759001257457647517968002', 5, 4, '2.5858');
  t('0.597582781241077407', 4, 2, '0.9304');
  t('0.31834', 3, 5, '1.25');
  t('-0.367', 3, 6, '1.95');
  t('0.893808596797515523019879332290496896237067857221860489', 7, 3, '0.4650289');
  t('0.374872972069827886017', 10, 1, '1.186536576');
  t('-0.5613162575574577608415066581055940977630188561133164966', 9, 0, '2.16677172');
  t('0.3678323679973177279659849134961285470583517301775754709620886174544308257638', 1, 3, '1');
  t('0.346', 8, 3, '1.2174919');
  t('-0.11', 9, 0, '1.68101938');
  t('-0.5', 1, 6, '2');
  t('0.03', 6, 3, '1.54079');
  t('-0.2564536384147918999674', 4, 5, '1.83');
  t('0.9029', 5, 0, '0.44433');
  t('0.17044875172902250879349842138284811', 4, 3, '1.399');
  t('-0.04', 6, 1, '1.6108');
  t('-0.72', 6, 5, '2.3746');
  t('-0.374445', 3, 5, '1.95');
  t('-0.756994371', 6, 5, '2.4295');
  t('-0.9081387325585673018085467898219', 2, 3, '2.7');
  t('-0.35829780053537939', 6, 4, '1.93724');
  t('0.94562511157430461974286', 4, 1, '0.3312');
  t('-0.268461392639090381541081', 8, 1, '1.8425917');
  t('0.818901', 2, 1, '0.61');
  t('-0.659675659513922964174536723050240843462', 9, 0, '2.29118345');
  t('-0.23', 8, 6, '1.802874');
  t('-0.25683', 5, 4, '1.8305');
  t('0.61811813899141487671644935007974504701896579769778704828587593327313038460755', 9, 6, '0.904449849');
  t('0.11', 7, 2, '1.460574');
  t('0.54', 1, 5, '1');
  t('0.45841299739334041851760970804079873999270095487034', 6, 0, '1.09459');
  t('0.18682442', 9, 5, '1.38286767');
  t('0.463108773900948823577630041761', 6, 6, '1.0893');
  t('0.36', 9, 0, '1.20252844');
  t('0.69167132409296405543909913923530533152982653044406335774061454983821414578034849', 6, 1, '0.806995');
  t('-0.48221', 7, 1, '2.073971');
  t('-0.8397196', 8, 6, '2.567563');
  t('0.2', 4, 5, '1.369');
  t('0.3', 5, 5, '1.2661');
  t('-0.8716217373065117836099194492152290209261081', 10, 0, '2.629297438');
  t('-0.235137992858192325004712921493793310063869506755', 10, 5, '1.808156866');
  t('0.74', 10, 6, '0.7377259685');
  t('-0.8', 5, 2, '2.4981');
  t('-0.75', 3, 0, '2.42');
  t('0.12', 4, 6, '1.451');
  t('0.249534', 8, 5, '1.3185973');
  t('0.6', 7, 0, '0.9272953');
  t('0.692812647977054453571424905868707335897749486748180167', 10, 1, '0.8054141439');
  t('0.22313303955564242995', 10, 1, '1.345768959');
  t('0.788581266389683', 4, 6, '0.6623');
  t('0.270395797', 5, 6, '1.297');
  t('-0.213', 9, 1, '1.78544072');
  t('0.731726836', 4, 1, '0.7499');
  t('0.9', 6, 5, '0.451027');
  t('0.21819724676955491867', 8, 1, '1.3508295');
  t('0.6', 6, 0, '0.927296');
  t('0.5', 8, 0, '1.0471976');
  t('-0.5687', 8, 3, '2.1757208');
  t('-0.205008836049605', 3, 3, '1.77');
  t('0.21815471602', 5, 3, '1.3508');
  t('0.6775921772444159658049243505289898942363754194629369209188593145100238910233763', 18, 1, '0.826312649886108325');
  t('0.8', 10, 5, '0.6435011088');
  t('-0.3894', 1, 2, '2');
  t('0.695', 10, 6, '0.802376426');
  t('-0.4789', 10, 3, '2.070197576');
  t('-0.257', 19, 4, '1.830712974317097882');
  t('-0.310869', 16, 5, '1.886903523783146');
  t('0.857378962252028391821219384', 19, 6, '0.5406409645523838012');
  t('0.2926612128408878223404892798081685677264279726117999272', 1, 5, '1');
  t('0.3', 1, 2, '2');
  t('-0.67425957', 10, 6, '2.310757949');
  t('-0.35', 12, 2, '1.92836743045');
  t('0.343097163897999328539202318652314827417671587533443281589', 8, 1, '1.220584');
  t('-0.47278', 14, 2, '2.0632393031958');
  t('-0.553', 9, 2, '2.15675694');
  t('0.8', 4, 4, '0.6435');
  t('0.82334138087823235917019871914520451457890998921366467128994864994757', 7, 3, '0.6035227');
  t('-0.49', 5, 0, '2.0829');
  t('-0.60599962528016354469467517115896723145207184671771676378971221483536', 14, 0, '2.2218182489755');
  t('0.13', 20, 1, '1.4404273470917511062');
  t('0.848677597574937211649010988442521035223542264485067207668', 1, 1, '0.5');
  t('0.1427835401559015373454', 19, 6, '1.42752312293440072');
  t('0.8940799877', 1, 0, '0.5');
  t('-0.6414958', 5, 5, '2.2672');
  t('-0.174395124142928078882432653', 17, 2, '1.7460877721215552');
  t('0.77', 1, 3, '0.6');
  t('0.993512018914577263250830193986713809523494639', 10, 2, '0.1139737593');
  t('0.525', 7, 2, '1.018082');
  t('0.71059635665084660234827', 6, 0, '0.780451');
  t('-0.3832', 18, 0, '1.96405460206347454');
  t('-0.876573822667242', 19, 2, '2.639492630186552352');
  t('-0.658049576261108648722957575603', 6, 4, '2.28902');
  t('-0.88', 15, 1, '2.64665852724889');
  t('0.0617850401147', 4, 4, '1.509');
  t('-0.44696060526747270690531041467035958398', 1, 5, '2');
  t('-0.638', 15, 2, '2.26269450893194');
  t('0.76808982171163819', 16, 2, '0.6949435946866321');
  t('0.15', 13, 0, '1.420228054019');
  t('-0.3165', 19, 4, '1.892833854735544125');
  t('-0.076053568152984328506148855', 2, 2, '1.7');
  t('0.31', 12, 6, '1.25560329435');
  t('-0.534346270088392', 4, 4, '2.135');
  t('0.166', 18, 4, '1.40402433239928283');
  t('0.812526806058078610617925321538', 11, 1, '0.6223225045');
  t('-0.585', 7, 3, '2.195676');
  t('-0.4', 5, 0, '1.9824');
  t('-0.37375109360492', 19, 6, '1.953846247754098002');
  t('0.3', 14, 0, '1.2661036727795');
  t('-0.5', 17, 0, '2.0943951023931955');
  t('-0.861442', 19, 5, '2.608898585907231241');
  t('0.79216439705858813560085919779023', 15, 4, '0.656449044348769');
  t('-0.4803', 13, 1, '2.071793041769');
  t('0.3', 9, 3, '1.26610367');
  t('0.9541394184', 5, 3, '0.30402');
  t('-0.28183', 8, 4, '1.8564972');
  t('0.9976436658898658296', 14, 0, '0.068662363447803');
  t('-0.03', 4, 4, '1.601');
  t('0.8', 13, 5, '0.6435011087933');
  t('0.862204474381801', 5, 1, '0.53119');
  t('-0.68227', 11, 5, '2.3216593903');
  t('-0.29955379438877625151779', 5, 2, '1.8751');
  t('0.70189454', 10, 6, '0.7927424822');
  t('-0.0422', 3, 5, '1.61');
  t('0.33649602321990285156925', 2, 6, '1.2');
  t('0.82324854841987959282', 10, 2, '0.6036863388');
  t('-0.4542', 16, 0, '2.042270366560878');
  t('-0.1881511386654035', 16, 6, '1.7600756503428');
  t('-0.6', 5, 5, '2.2143');
  t('0.94', 14, 6, '0.34816602127296');
  t('-0.24223', 13, 5, '1.815459971244');
  t('0.94039650137245854', 18, 3, '0.347001988302835689');
  t('0.567', 10, 0, '0.9679370805');
  t('0.817132', 11, 0, '0.6143782725');
  t('0.6', 14, 4, '0.92729521800161');
  t('-0.799', 1, 6, '2');
  t('-0.87', 15, 6, '2.6259986473437');
  t('0.98020631547840323825958', 7, 2, '0.1992955');
  t('0.969879', 3, 5, '0.246');
  t('-0.2', 2, 0, '1.8');
  t('0.2338', 13, 2, '1.334812148601');
  t('-0.6052271710195', 20, 0, '2.2208475350684965405');
  t('0.35', 18, 2, '1.21322522314938634');
  t('-0.842', 4, 3, '2.571');
  t('-0.87', 3, 0, '2.63');
  t('-0.9655321240665159038181161557768210603975229399719262078509071', 4, 1, '2.878');
  t('-0.5', 11, 5, '2.0943951024');
  t('0.0434470587364821086', 20, 1, '1.5273355876501416888');
  t('-0.9023189765', 18, 3, '2.6959155095591904');
  t('0.38472069', 6, 3, '1.17589');
  t('0.440445631', 13, 2, '1.114701343472');
  t('-0.814594975783447641302854969927109083375663', 19, 3, '2.522826897687134364');
  t('0.418635603', 15, 1, '1.13885391246007');
  t('-0.4', 8, 0, '1.9823132');
  t('-0.6268181837797543172087172579737915560087499381571', 11, 4, '2.2482591769');
  t('-0.5472', 16, 3, '2.149811619074141');
  t('0.593461545109287', 9, 4, '0.935443479');
  t('0.40718907579454', 19, 6, '1.151422002415415093');
  t('-0.245018', 12, 0, '1.81833458521');
  t('0.44892', 9, 1, '1.10523998');
  t('-0.53', 13, 4, '2.129396892138');
  t('-0.985380589907607895709633253258680714418853594643583209591678569023201332', 16, 0, '2.970390020375099');
  t('0.9981032', 18, 2, '0.0616019471315393363');
  t('-0.73', 11, 3, '2.3891182774');
  t('-0.4346623785953887710213039936159041301176386609468082123968425209464899', 17, 5, '2.0204596819508992');
  t('-0.702707075434218899650761988295540056760882930878615738869968', 7, 6, '2.349992');
  t('-0.1333913959628289', 13, 3, '1.704586502162');
  t('-0.1192760278033', 19, 1, '1.690356999485319758');
  t('-0.41863394314', 19, 3, '2.002736913401431522');
  t('0.57534149', 10, 0, '0.9577747264');
  t('-0.27020352178646799', 10, 0, '1.844400737');
  t('0.0749', 4, 1, '1.495');
  t('-0.01', 17, 1, '1.5807964934690637');
  t('-0.56933496', 7, 0, '2.176494');
  t('0.0543359319531926926616300067219154081091311532', 9, 3, '1.51643362');
  t('0.537208531389992347851842642220403924987048182', 14, 1, '1.0036723051327');
  t('-0.9', 6, 0, '2.69057');
  t('-0.65196', 2, 1, '2.2');
  t('-0.596369', 14, 3, '2.2097663690323');
  t('-0.81969737060322512599445554200607707', 14, 5, '2.5316788092947');
  t('0.7158013121084596', 12, 5, '0.773025382289');
  t('-0.48691272770447642687701691564767553210087668067888595005573562004647034891284152127623904', 14, 4, '2.0793480133353');
  t('-0.652459334707362898', 1, 5, '2');
  t('0.71518316684475522312650454100299950718622177628', 20, 4, '0.77391019054722174405');
  t('-0.4', 13, 3, '1.982313172862');
  t('0.6', 9, 0, '0.927295219');
  t('0.86051013', 9, 3, '0.534526132');
  t('-0.5990292', 10, 3, '2.213084487');
  t('0.503872932770429800477102963908324723723750975878', 8, 1, '1.0427196');
  t('-0.9', 8, 4, '2.6905658');
  t('0.076649293894779676736624', 12, 2, '1.49407177989');
  t('0.296691062886738', 11, 4, '1.2695704984');
  t('-0.1', 7, 0, '1.670964');
  t('-0.31752634972187205360626021192211627', 9, 1, '1.89391602');
  t('-0.81985', 17, 3, '2.5319453235267068');
  t('-0.8', 20, 1, '2.4980915447965088516');
  t('-0.55930690734709168137685108430804676248632899467905651835984911076', 7, 0, '2.164346');
  t('-0.116997', 19, 2, '1.688061899409209783');
  t('0.0592209012227646877316245910628199623', 10, 3, '1.511540755');
  t('-0.0268', 3, 2, '1.6');
  t('0.842', 16, 6, '0.5698164693561026');
  t('-0.8194571472489072894183365737', 20, 5, '2.5312595483958324092');
  t('0.9315217768190996504603342581382273458', 17, 6, '0.37222133562664327');
  t('-0.166', 16, 5, '1.73756832119051');
  t('0.62506424277363108339572043488301', 5, 0, '0.89559');
  t('-0.3', 18, 5, '1.87548898081029413');
  t('-0.3', 2, 2, '1.9');
  t('0.73664112061341491382261246495032839844086363068023119132', 17, 3, '0.74270616791967784');
  t('0.1363116363910698633', 15, 5, '1.43405898997327');
  t('-0.6412', 3, 1, '2.26');
  t('-0.65520448008523004450718', 11, 2, '2.2852495882');
  t('-0.1', 11, 0, '1.670963748');
  t('-0.5', 7, 1, '2.094395');
  t('-0.715944185372', 15, 1, '2.3687718931402');
  t('-0.052008519540913639299413025155059232', 17, 2, '1.6228283211074864');
  t('-0.3929169056735', 19, 6, '1.974597796614285806');
  t('0.387', 14, 5, '1.1734204790473');
  t('-0.30415385', 1, 4, '2');
  t('0.1638705685', 2, 1, '1.4');
  t('-0.0116', 17, 4, '1.5823965869599838');
  t('0.5', 10, 2, '1.047197552');
  t('-0.669195320584918483', 6, 5, '2.30392');
  t('-0.7', 16, 0, '2.34619382340565');
  t('-0.20965423961596854766427', 3, 3, '1.78');
  t('-0.3024517405802118186370971321888114487505427564342271246956948673272685264325594', 19, 5, '1.878060145630610698');
  t('0.5273934544340106053598398649874301142779', 3, 6, '1.02');
  t('0.4683', 21, 3, '1.08343054581451120153');
  t('0.30954842721709487429800843717695846301791', 17, 0, '1.2560782291134293');
  t('-0.888883921', 16, 1, '2.665699560033124');
  t('0.33', 6, 3, '1.23449');
  t('-0.68368', 13, 3, '2.323589730068');
  t('0.93', 34, 2, '0.3763834823177282451373449774361505');
  t('0.3698', 29, 0, '1.192002574767283291061864894');
  t('0.355441709936171846454531663', 39, 5, '1.20740973250614205677034142380633077623');
  t('0.517281812929938845773741996797199819632431620265311173775606', 37, 5, '1.027124574195724397997651700469089434');
  t('0.276034638', 14, 1, '1.2911303295406');
  t('-0.427378167812', 18, 4, '2.01238708626475883');
  t('0.7700912257488174', 32, 3, '0.69181218555632259942452962895323');
  t('0.65400722679265650897967', 30, 3, '0.857926796441501086370244464773');
  t('-0.623273844710841661', 28, 1, '2.2437185634166815917813569');
  t('-0.26081553123', 25, 1, '1.834663203274733703635477');
  t('-0.4', 27, 3, '1.98231317286238463861605958');
  t('0.8847', 11, 3, '0.484946264');
  t('-0.00705453784616009713900280021204402727', 18, 0, '1.57785092315564841');
  t('-0.552994', 31, 2, '2.156749735981633261782975084481');
  t('0.3458218138135', 9, 4, '1.21768183');
  t('0.6', 19, 6, '0.9272952180016122324');
  t('0.2', 40, 3, '1.369438406004565827776196139422128031858');
  t('0.009', 1, 2, '2');
  t('0.078144520570218640488786936480763017912996575464647691', 16, 4, '1.492572054428754');
  t('0.7471798900635237048453219283651', 8, 1, '0.7269876');
  t('0.441089398925', 30, 1, '1.11398415020876780936358454628');
  t('0.628', 37, 5, '0.891815777954216557189787158458505882');
  t('-0.68023958721527', 8, 3, '2.3188857');
  t('0.71248072864836', 3, 6, '0.778');
  t('-0.3223260041', 10, 3, '1.898981934');
  t('0.90324', 39, 0, '0.44353573953946010617241116802156115809');
  t('0.43979', 34, 1, '1.115431493591550771565404132943007');
  t('-0.96777723022207210864', 12, 5, '2.88704472691');
  t('-0.548906189625', 31, 0, '2.151851434325739845071909666811');
  t('0.7986831312105023986463', 19, 5, '0.6456926898464239449');
  t('0.36027708292732470568972', 5, 3, '1.2022');
  t('0.1239759983305', 5, 0, '1.4466');
  t('0.07901753495496', 3, 5, '1.49');
  t('0.413', 30, 5, '1.14505065822496118579891230509');
  t('0.91068968477719', 15, 0, '0.425845755053204');
  t('0.30263', 14, 4, '1.2633454839218');
  t('0.78', 10, 6, '0.6761305096');
  t('0.2006478079819', 14, 6, '1.368777195082');
  t('-0.914938674', 11, 1, '2.7261522711');
  t('-0.5733890985458260015744265648331', 4, 4, '2.181');
  t('-0.8817362', 11, 5, '2.6503263583');
  t('-0.691179745360921842839463887', 29, 5, '2.3339165602051750154716850506');
  t('-0.86013434148320042160096', 13, 5, '2.606329320599');
  t('-0.56321', 38, 0, '2.169061729824108952082619451199536328');
  t('-0.3809686109181847', 35, 4, '1.9616400110348963327898415391047344');
  t('-0.3674578693097749751321416', 35, 2, '1.9470705107419238730588826138179517');
  t('-0.6789714412976', 13, 3, '2.317157060405');
  t('0.4636951', 21, 0, '1.08863509185224814681');
  t('0.17', 6, 3, '1.39996');
  t('-0.16347979344782383279', 23, 4, '1.7350132034366210424417');
  t('0.13', 34, 0, '1.440427347091751106292071921279421');
  t('-0.4568311689455543481026372487467605716426168950490411', 30, 5, '2.04522598154871269469009608479');
  t('0.685', 4, 6, '0.8162');
  t('-0.39129255528511', 34, 3, '1.972832045588394975667410811377315');
  t('-0.57773716940117270440026', 28, 3, '2.18674996894552465533518379');
  t('-0.603138491308', 15, 4, '2.21822634845737');
  t('-0.9118', 25, 6, '2.718442734073602010844598');
  t('-0.739574055431132880066', 16, 0, '2.403233631361862');
  t('0.9731758', 28, 2, '0.2321421471498522462072000972');
  t('-0.59136105962890922019258161304658081566077026481343525054927313558', 37, 2, '2.203541932655967820115276584046538404');
  t('0.43', 29, 3, '1.1263035498590775804770150842');
  t('0.64295009', 12, 2, '0.872452504133');
  t('-0.378642', 24, 6, '1.95912493565735372489359');
  t('0.5741547035626488891023197557536', 6, 6, '0.959225');
  t('-0.7', 35, 6, '2.3461938234056496829716750443547386');
  t('-0.2877360645666564500650426183', 14, 3, '1.8626584166978');
  t('0.533704', 31, 0, '1.007821832304399887189667801188');
  t('0.0820877959282842675093', 15, 1, '1.48861606004085');
  t('0.062', 14, 4, '1.508756536594');
  t('-0.6185123976596686777', 19, 4, '2.237644450495232272');
  t('0.65222505744961845', 19, 1, '0.8602802496276147447');
  t('-0.6280221005', 35, 6, '2.2498052749859371174322830128160322');
  t('0.8', 30, 0, '0.643501108793284386802809228718');
  t('-0.58073372925', 25, 4, '2.19042601172867598461061');
  t('-0.2436111158334656566835968915745483254361591561617894670931192993333281623', 29, 3, '1.8168837343521768429429978149');
  t('0.32594603', 29, 5, '1.2387840924146365397084174317');
  t('-0.193', 33, 6, '1.76501504375806061758352773230609');
  t('0.84', 29, 5, '0.57351310442309675318190659631');
  t('0.5', 11, 0, '1.0471975512');
  t('0.871', 36, 2, '0.513562177804354568548134557993420381');
  t('0.368982751361', 14, 0, '1.1928820234029');
  t('0.1712', 19, 1, '1.398748804302325495');
  t('0.351270337501', 29, 5, '1.2118687670050583986698607212');
  t('-0.699225736349584631222591036', 35, 2, '2.3451102127031281962517387533766992');
  t('0.715', 19, 1, '0.7741722202788552068');
  t('0.3978', 24, 5, '1.16167862378453247801912');
  t('0.881533524564683538241186834202082230656252462120637976630481', 39, 5, '0.491695754181683639872008304433188603628');
  t('0.5576285618788362', 18, 5, '0.979270119860829926');
  t('0.47266909170552866482099697420334488643275907789', 22, 5, '1.078479209455072593699');
  t('0.924', 23, 2, '0.39238416526344147749216');
  t('0.4266148979496838153', 7, 3, '1.130049');
  t('0.95248930149898237254354792', 4, 2, '0.3095');
  t('-0.3803755463230198292', 1, 6, '2');
  t('0.63616257964482086511746610058781965642', 39, 0, '0.881281940373848573942912523070348525246');
  t('0.91107573183933620233506198986647507310508', 22, 3, '0.424910257848777432042');
  t('0.230881620049', 14, 0, '1.3378126399691');
  t('-0.15194967302', 23, 0, '1.7233368799846040718366');
  t('-0.98527666990776435190818735', 37, 1, '2.969781117147644790754445904859984188');
  t('-0.712674566242116630639454394595571196172785', 4, 2, '2.365');
  t('0.973676', 16, 2, '0.2299578648860333');
  t('0.14932', 5, 3, '1.4209');
  t('-0.627966', 19, 4, '2.249733186586581012');
  t('0.7019097158651', 37, 4, '0.792721175973902008928241143163213154');
  t('-0.67646550115434538573', 10, 2, '2.313749103');
  t('-0.7797435409217004', 19, 1, '2.465052425253286585');
  t('0.74491145527156867967', 4, 5, '0.7304');
  t('-0.7877586763196865', 24, 5, '2.47795820366566342997867');
  t('-0.9', 14, 2, '2.6905658417936');
  t('-0.12616755686940592231911937110254067742012318982260845535', 24, 6, '1.69730103219510438995958');
  t('0.85640125204661617', 18, 5, '0.542537595459998583');
  t('-0.6843352797718666022519805948705590458990070846', 7, 3, '2.324488');
  t('-0.1144005475', 30, 0, '1.68544789136862551495698303192');
  t('-0.9962406107327604060336197185492663754065722', 11, 5, '3.0548545751');
  t('-0.49239853349174', 31, 3, '2.085639701902881014513268549248');
  t('-0.38703', 1, 6, '2');
  t('-0.30989558207886659738122408437494', 10, 1, '1.885879532');
  t('0.2344', 6, 5, '1.33419');
  t('0.5240142239', 4, 2, '1.02');
  t('-0.263516968905', 12, 0, '1.83746255576');
  t('-0.417122759184410023369', 16, 0, '2.001073535012708');
  t('-0.2416', 30, 4, '1.81481068579491635442787452699');
  t('-0.739909163261513917297879', 40, 0, '2.403731643412244193737225862530426516613');
  t('0.1356394', 7, 0, '1.434738');
  t('-0.869620076510242247721951533264707151124', 39, 6, '2.62522861536152362801748375884439701208');
  t('-0.339602624', 23, 6, '1.9172907073969835576848');
  t('0.017511694193718879310386', 32, 5, '1.5532837374566082550189775183611');
  t('0.73', 12, 3, '0.752474376163');
  t('0.8767728451712575183140357919352558920865793840897121645508226631430124767821137087464982830694', 1, 6, '0.5');
  t('-0.62945736', 35, 0, '2.2516509937592804949618979578515389');
  t('-0.67496777075', 15, 5, '2.31171734801165');
  t('0.5541237285795442464136605749', 11, 6, '0.98348639126');
  t('0.4936701', 29, 5, '1.0544913973024303579736166248');
  t('0.7359626422679', 26, 1, '0.74370886543893828317996244');
  t('-0.81258482880823975964300849035305', 27, 2, '2.51936969343983255122864705');
  t('-0.798', 18, 3, '2.49476558001885526');
  t('0.303', 14, 3, '1.2629572563861');
  t('-0.531761150559325539159653135765', 4, 1, '2.131');
  t('0.21837132095563811659499349682271', 3, 2, '1.36');
  t('-0.87654669349386316544', 10, 4, '2.639436263');
  t('0.55599881124100880914905', 20, 1, '0.98123216878659329909');
  t('-0.9', 1, 5, '3');
  t('-0.0994585', 16, 4, '1.670419534835628');
  t('0.3835353', 4, 0, '1.178');
  t('0.074133851949109824042', 21, 5, '1.49659440187496306562');
  t('-0.5695297', 18, 2, '2.1767299070415695');
  t('-0.082294578832285565874', 31, 5, '1.653184078461796469957188779589');
  t('0.706931407957631528223644779278372246930532671142356259208913361850607887211902', 4, 6, '0.7856');
  t('0.9092254690272470335455059983367495206862722434884170271786431469657', 31, 3, '0.4293765549955734780236766825731');
  t('-0.26363', 40, 1, '1.83757973021581530828722378967886237641');
  t('0.3', 4, 2, '1.267');
  t('-0.269', 13, 6, '1.843150937025');
  t('0.15378831594967867896020917', 36, 0, '1.41639526280774981412175814145636564');
  t('-0.04', 29, 6, '1.610807001148885545451942411');
  t('0.94146', 6, 2, '0.343862');
  t('0.872727', 17, 3, '0.51003586214771626');
  t('0.9041', 4, 4, '0.4415');
  t('-0.2155827054536651047278', 33, 2, '1.78808485475341321435268125597743');
  t('0.24653472795149645605718818651000016078379434910037274479162362359749', 29, 6, '1.3216933447961048324572334663');
  t('0.349199369821701078117730067023243004429147382796990269201806253992646024667487755', 37, 3, '1.214079776377668998200248616829951619');
  t('0.58', 2, 6, '0.95');
  t('0.4209', 13, 1, '1.136359069683');
  t('-0.41038477', 45, 1, '1.99367228637117662280634121443861751831918764');
  t('-0.31116045577869746913649', 1, 6, '2');
  t('-0.89458959182595172982179132950365568935504520270574607', 58, 1, '2.678308315849602650979083916715169161293523872627488328763');
  t('-0.38177389251070463249295986289', 45, 5, '1.96251113013628840959999167084372012939265891');
  t('-0.297381368600690904', 32, 6, '1.8727450896484376106658245085839');
  t('0.96447860914282823', 64, 5, '0.2673338764583965056595452664757075342884110212933760072354323873');
  t('0.7', 38, 2, '0.79539883018414355549096833892476432855');
  t('0.5', 28, 6, '1.047197551196597746154214461');
  t('-0.941784995618647171108964', 73, 2, '2.798696834162398096824273566291833434835832045019504923062443786838796813');
  t('-0.1268166341092523321644606274393', 2, 1, '1.6');
  t('0.3732681688551236665680712', 64, 2, '1.18826700853646079710327722407745626055482945258180979790985196');
  t('-0.6147842718726245423041825', 74, 1, '2.2329087388214741515376633784834342239661875971468312676882930081671382864');
  t('0.814265392667839756993', 59, 3, '0.61933374656480991812912324224654554610639223399922810126199');
  t('0.385363198262368965', 78, 1, '1.17519493877750912826759101146202237112944933735187012538178951532649372996811');
  t('0.550692810464868714823007119560439980698985', 32, 6, '0.98760231256273164061236863606379');
  t('-0.818803565578189207029', 9, 0, '2.53012013');
  t('0.3', 5, 1, '1.2661');
  t('-0.62530074898142534880415533586145', 20, 4, '2.2463131862128663993');
  t('0.5872273691893032238', 4, 1, '0.9431');
  t('-0.74360419595807', 56, 3, '2.409241148137024575316420804409775448076859223033864812');
  t('-0.5682509980325305493060138', 5, 3, '2.1751');
  t('-0.5095748702244839264', 47, 0, '2.1054869527222323195892250907167080326451668515');
  t('0.77776470400275813159552917191573137608163', 24, 2, '0.679694618889250742773173');
  t('-0.8144074444023626453596890757995337858332033098894', 49, 6, '2.522503657913783335788994869448783061589079249114');
  t('-0.1321046778270826380798707409211872848', 72, 0, '1.70328829455603295162468625103917574443928143901258355139973017789991673');
  t('-0.959996893544', 56, 6, '2.8577874501067501906025870017562795735496078149396156855');
  t('-0.8', 20, 4, '2.4980915447965088517');
  t('-0.1412739085555074250696029139926107809501328922704958892373', 7, 1, '1.712544');
  t('0.6444908832122089099631985005111186', 8, 5, '0.87043908');
  t('0.023662116110526488758', 2, 1, '1.5');
  t('0.093414546026', 11, 6, '1.4772453843');
  t('-0.811935856242164773371267032443195866963447', 31, 1, '2.518257095665134397783009681201');
  t('-0.59517', 30, 6, '2.20827350700798996951507449987');
  t('-0.6106017434248', 28, 1, '2.227616532053828926595975852');
  t('0.2741', 43, 0, '1.293142590996333937911977608339668283498147');
  t('-0.8', 66, 4, '2.49809154479650885165983415456218024615565880825979343810933847359');
  t('-0.47371231194093762185', 49, 1, '2.064297629936015347130397124408414753491259257453');
  t('-0.04672398050288533857', 40, 1, '1.617537324777891244966149115165882928282');
  t('0.89687349800848360067214181405', 32, 5, '0.45814721827896360127759832503169');
  t('0.96151905592028982725822141785324969386810594790551', 67, 1, '0.278317464581809994254319824232402607470075238222846969096216952612');
  t('-0.3820600582', 43, 5, '1.962820767370997983830720540261225757661841');
  t('-0.9826568', 75, 5, '2.95507957497508074872380794355949520849228092652015138084170881464628067728');
  t('0.577', 55, 6, '0.9557455434855830843034185091026689267871037026347882646');
  t('0.2996', 80, 3, '1.2665229590830443727084509746595013836893715784203029306336973581027122731096411');
  t('0.963033254856637598696157174043586213908', 39, 3, '0.272751806828551377877161905656760692886');
  t('-0.7008592688571630410206184760241583012689532', 23, 4, '2.3473977511325660471012');
  t('-0.747035999607994360670377876253838750920241442523', 80, 0, '2.4143885707580698694184865756438011562404687632972577365924385379096135615648965');
  t('0.799', 16, 2, '0.6451659284796948');
  t('0.51552377', 53, 6, '1.0291775340422775021748573208335423987852461966422823');
  t('0.07518', 77, 0, '1.4955453260960560276684184003208069026700110641786550193147659999746474523676');
  t('-0.9891089139730374476043012642000835692995536636929603', 17, 5, '2.9938705297425854');
  t('0.8089359456348634', 56, 5, '0.62845640598870408215406015073840480957872762783685047049');
  t('0.4', 59, 3, '1.1592794807274085998465837940224158372428835645605270587035');
  t('0.892825002088385459769459625633707454703531406255004315063136951962546', 33, 1, '0.467217475965535618102551544528223');
  t('0.891960252246473775508532863093464574', 70, 3, '0.4691337812597733909248681063986149331783456566266652952524294252317377');
  t('-0.132222079443366921569265850830309383557904463446262183152554935828652', 74, 0, '1.7034067351395591259675062798433543215130066643204537034600483502522668922');
  t('0.35775973624261579803408099721007988618781244697', 70, 3, '1.204928587114612461725960999140753909944904546240802347787781772207922');
  t('-0.9738443991953', 42, 6, '2.91237475699298829381913988063436412037139');
  t('-0.4', 69, 1, '1.982313172862384638616059589257087046954285834814578762271419076854');
  t('0.941734093658941607', 74, 6, '0.34304718405883004924377455940151589638114516012043759173233415870637897075');
  t('-0.0104659663637400274026', 31, 3, '1.581262484235525489606957483601');
  t('-0.75870968723763548064918905372612612874074927467649971610664611', 52, 3, '2.432126408214800716705530666206580397000943257396207');
  t('0.9760176242392313884969058', 14, 4, '0.21944863924159');
  t('-0.0869699331087373410576368294343599051075628217', 14, 1, '1.6578762715137');
  t('0.9828713209120633505788915362943463337775979747619538744323382844115833295061', 26, 1, '0.18535264921046748860031794');
  t('-0.824263', 4, 5, '2.54');
  t('-0.814604127378602393518166', 33, 4, '2.52284267565292177787476068818384');
  t('-0.7167', 1, 1, '2');
  t('0.0960637', 7, 0, '1.474585');
  t('-0.96', 39, 0, '2.85779854438146539283694014907439671819');
  t('-0.36379', 24, 3, '1.94312979317772281291045');
  t('-0.9147643832304884', 69, 0, '2.72572063435772287060570214407728562761045739911794970181874397892663');
  t('-0.4232763219360933070190045943360291382', 44, 3, '2.0078548519078586315279235612984333833366902');
  t('-0.006031213670345208667624564', 71, 2, '1.5768275770306143837687610726175302600901738706800959136551669317069487');
  t('0.069', 36, 6, '1.50174145765903806624107047987393651');
  t('0.06616803042572538805115983509534257927', 34, 5, '1.504579918091063981237911125067135');
  t('0.54991852517259554', 42, 4, '0.988529641199323997650643102205815531892187');
  t('-0.62773266787726255742299551', 59, 4, '2.2494334028741534996711485347914580044326289844636031009177');
  t('-0.250414731', 20, 6, '1.8239049379733639368');
  t('0.23976', 79, 4, '1.328677693896657977849544696049099311673556676252969072639181835978873057438341');
  t('-0.440977353949844730560344659051585187697506087', 77, 0, '2.0274836608896403409980147120164289717641208329148076015978252288647590090354');
  t('0.87612374381941091382959062', 57, 2, '0.503034423325508597032033889492934190105195304571999312983');
  t('0.32481526634558839', 62, 3, '1.2399799299076323503828694428318075815713883836112449969531349');
  t('0.27397915175001', 28, 2, '1.293268249659131553452424186');
  t('0.04053884543308894304365341634441987538014552844165051753118914548', 79, 3, '1.530246369566171346124147978508443351824905061221292790494838258221931509644268');
  t('0.174089184487019751360968827828758746478', 80, 6, '1.3958155738381918908558246870833074886054402097147893996568914435836644022887351');
  t('-0.10194886029145684717521095458380859', 57, 1, '1.672922620324321811404494496701644310708218910174794537');
  t('-0.1274004827057525711608030542194140046350664250927884627658564069683447', 30, 1, '1.69854398834010132705743627032');
  t('-0.95455117759434022735987442780868831125842656754664202735210404899007480855', 8, 2, '2.8389466');
  t('0.016907949327511976057114414688337107', 10, 0, '1.553887572');
  t('-0.3217642590211733', 33, 6, '1.89838857801843494622622493657628');
  t('-0.423818083', 44, 5, '2.0084529053417197117713655958461449346046221');
  t('0.84273512060120259130952920734614096744023421', 23, 5, '0.56845236392986854462418');
  t('0.84', 49, 2, '0.5735131044230967531819065963145374827514347145194');
  t('-0.598', 73, 5, '2.211799772360693822846565077879486841931208002182007031934506787785326709');
  t('0.84667288307645509597693', 56, 6, '0.56109513385578413806039095933473567253118524040767696116');
  t('0.4633382152', 4, 5, '1.089');
  t('-0.821240849233283062200419918536744142946078481441', 46, 5, '2.534378663539126599977910757548121252669110429');
  t('0.1782796243430462510314130349750854257229782', 54, 4, '1.39155853847118572151230243859732186801788148524914491');
  t('0.0346677814563954408416453336703552431999124619055726', 6, 6, '1.53612');
  t('-0.2262991014529', 48, 5, '1.79907285730314637753804908303859548770795659337');
  t('-0.56270012731432884428668436471468157399411105', 80, 0, '2.1684448146235967762951293641691790797658622607486932564532596565781470731749366');
  t('0.94213383053997433', 75, 6, '0.341856774171689048584164195957701766777948867824850365033388574844952022382');
  t('-0.48877686839481567290504311702982', 70, 2, '2.08148351166758872919216516401124505180199160053655780114998352338592');
  t('0.920122', 6, 4, '0.402404');
  t('-0.73056823618', 73, 1, '2.389950073692985728953220800630620960300478006549524556056790844961548958');
  t('-0.434', 34, 4, '2.019724321162058362686353783759916');
  t('0.057245677227009681', 31, 2, '1.513519337044599366129295124267');
  t('-0.5770686483808800676', 77, 5, '2.1859311638676329561283221407360656523926793558485706321658724144400215181124');
  t('0.23194156351510905933472', 70, 6, '1.336723122511693349219241362845568980871286105099095494028659455998131');
  t('-0.16132784732273326', 69, 6, '1.73283230405568567848521323160946346079242897158360010518958506558185');
  t('-0.56477067105458714459638478310487690503899580950121626332', 41, 6, '2.170951662963568249680855866084598523972');
  t('-0.192', 26, 6, '1.7639959842119960163209638');
  t('-0.373912337363509284455226', 59, 0, '1.9540200961194170958685844882634861400179225721194278619888');
  t('0.366', 10, 4, '1.196089192');
  t('0.26392', 70, 3, '1.303712275705943801139766350563625513837507702730593308264540887097278');
  t('-0.1024396351529', 67, 1, '1.673415978184507652957110416235042090377403238657255271980324673824');
  t('-0.8969469581738383621279', 25, 4, '2.683611554854624298157742');
  t('-0.217879690484219885926133', 46, 0, '1.790437765989200396935090980754178638116052855');
  t('0.774', 31, 0, '0.6856620756439576790439867507044');
  t('0.1', 46, 5, '1.470628905633336822885798512187058123529908727');
  t('0.90722796814082093245169236477', 12, 6, '0.434149870078');
  t('0.6913801099169900959224', 9, 0, '0.807398806');
  t('0.0513598582945', 55, 0, '1.519413861849747925316114762776072854986408058656090736');
  t('-0.47053741453574802106194', 57, 3, '2.06069605707371986078585229034829183417808469379926116665');
  t('-0.808290075589992330895181051160074826850861462', 37, 6, '2.512038465217457018717674485489475545');
  t('0.264', 47, 0, '1.3036293340668398294182059461387160012504644841');
  t('0.318321562733552055745994261888', 46, 2, '1.246837902629252714754183903853658996606280493');
  t('-0.7144260143438044083550607906843292', 36, 1, '2.36659977119955665488513292493900708');
  t('0.52207258958068207', 48, 1, '1.02151713142137520132630986203315247977307767646');
  t('-0.52846', 56, 2, '2.127581877818602343608464692588797335181826758121656533');
  t('-0.77042362', 3, 5, '2.45');
  t('0.888058866863', 41, 5, '0.47769086641702688570735986783004822739602');
  t('0.61', 3, 4, '0.915');
  t('0.00134527223413953711322592774674317', 70, 2, '1.569451054154987358470767990867942591022235784726998525970968293719521');
  t('0.30972', 6, 5, '1.2559');
  t('0.17031504', 28, 1, '1.399646955406458103981480746');
  t('-0.002950946518912', 20, 3, '1.5737472775966744309');
  t('0.778661667594228939922725240149031436', 68, 1, '0.67826633266484973186767371753328618612283001219279116957149814679474');
  t('-0.1267633036936784698573608505706039575', 73, 1, '1.697901600986480068248608172620606620126315170225235965843518633339815384');
  t('-0.2624934890966', 46, 1, '1.836401728845610789406085539024830996102617622');
  t('-0.315334467691854303189053816314480843708', 37, 1, '1.891605409668230447830162984731250645');
  t('0.542445001220153', 31, 0, '0.9974515434959153005513581487683');
  t('-0.52729798873038805548827852', 34, 6, '2.126213710313848857619978925378265');
  t('0.523460046648967763118115', 44, 4, '1.0198895696481273457016749244165476323645976');
  t('-0.2', 30, 4, '1.77215424758522741068644724386');
  t('-0.40040763712932062696772310749', 45, 0, '1.98275798462481025732566356713143501277642995');
  t('0.77112', 16, 4, '0.6901979458415838');
  t('0.60907444272122434170209804', 6, 0, '0.915904');
  t('-0.49700115359', 23, 0, '2.0909357804748627690874');
  t('0.173341594', 11, 6, '1.3965747063');
  t('0.701550222218832032974', 23, 1, '0.79322576883716962563875');
  t('0.97742084960693534545482703', 42, 1, '0.21290671863396340029344575266193118961659');
  t('0.28341520704468202358001111532661548775335354128165408498195685010203204407339454964', 33, 0, '1.28344285516330838072685555525306');
  t('0.837711815968035609', 68, 1, '0.57771661848546532049738308839796797930209707983823912469564373413401');
  t('-0.021', 57, 2, '1.59179787060128462410937058563698098796834367863978741824');
  t('-0.940083359', 1, 6, '3');

  t('-0.74500571461207884237077', 44, 4, '2.4113397347401420478032656537224828938630945');
  t('-0.273370399', 59, 3, '1.8476914878826149462128694514986204151636789860397267318107');
  t('-0.998530855124571097454050742041068407778875285692847505184755236251664978780833132086835', 160, 5, '3.087380021343445207063597723447589225243315966330486565870147753913770229719702466149787763563881186420696559433719687805860337690771104894006466113176500291181');
  t('-0.969203993566514887267928904076363252172', 11, 0, '2.8927739117');
  t('-0.594935953115484459834050449808165218294506', 26, 4, '2.2079822903543834570661034');
  t('-0.303363441644917', 124, 0, '1.879016789955838580781193296741381352064753120600060749762404225091206584746211664086759630681869120894242081834775660855607');
  t('-0.25497', 160, 1, '1.828613004452711776803409844947989706748509423853951137667423610937748608132595176087330752161802685517468729762122554870617678756091622275488559002979034320657');
  t('0.5313521989908', 83, 5, '1.0106003866753127992381185934110106069727238545556783963467840580345474003274786731');
  t('0.571615329133539575166769409182152812078571', 39, 5, '0.962323157444591782340864631585422389484');
  t('0.308736875290380848061', 71, 0, '1.2569315819837357496139460796844660294711115191142531909519821919127715');
  t('-0.600494622752337363648678605808331945915799369330861579079', 111, 5, '2.21491585748513291847034470233136414422001555198960356342260724132258776396368999583800216133866436243414522453');
  t('0.640564864799', 136, 0, '0.8755626937213258164687162609370738455269367604525385089616093647673064650363022228775376728326400630999479754026542103713105898000608485');
  t('0.0625', 21, 2, '1.50825556499840522844');
  t('0.254119201305002041308584149183230251166007296757', 25, 6, '1.313859426831512910592291');
  t('0.305473958878289941980240702955496416309106350814154153028603799835986193157650064464117948597449533334365590072574028033502957278931764828146832485', 79, 2, '1.260360186061142547924369665075996057444067811977697913301630102312706292933717');
  t('0.2751628311269842542432112551152090750907', 88, 3, '1.292037259329894735524281742443307396104626425179750845600170909593809357628306113192597');
  t('-0.759737646784374846578693276219778319738938594082032892534', 60, 0, '2.43370586892176967977484496155100115990495649232337587431598');
  t('-0.5935256093849329632970921096892335802572192', 149, 0, '2.2062287733789378049362618601962143685038222061499871253642432612620633335192180786504819031630794514775070914508763943843880175087017179559691641877');
  t('0.186268549244814320360437', 160, 2, '1.383433476336729922531195985998145697019147836124229291951483382807237184136587252813638450259579903097767787311265161816241227801859497021213873791628246362008');
  t('0.424970410427476727965', 110, 0, '1.1318671296107427043377288313797810787945611421220084948240531416219934806500058408110492877708901760896565096');
  t('-0.54801697', 15, 3, '2.15078799794379');
  t('0.296220990759424275253164856164638327199552048824', 24, 2, '1.27006269660765514875131');
  t('0.2831595410221361607802', 22, 3, '1.283709441893810365672');
  t('0.380368780310292752933', 78, 5, '1.18060131041366539312553100127677636737531515076314619509238454861084762659682');
  t('0.31340747665', 43, 5, '1.252017151276346115739503723034520209878567');
  t('-0.0274912', 114, 0, '1.59829099079251135163856432707927201931954929078275944348989444768909631838739179896293864808452773527567687564812');
  t('-0.724238289937326670922613036700413603', 87, 2, '2.38072543089389942123787156491521060290682598964101121908856486703586204041471687997466');
  t('0.72817943572865', 72, 4, '0.755134397198269497645291728662780084724244757703956053379942705980932943');
  t('0.159314498534385484436396373516522470452444733821967250009026359307430946322427694109296168866302290593865330089622806954832356373998', 150, 2, '1.41080008284864341472891839347735746276964010519686181554889094729024886046587535386686689466959469389253754037002429463231602114920602298486346069072');
  t('-0.98763035059220634929326902447509667484813', 153, 0, '2.98414275531774628310529408837645252646380556603010043564723450626758712246883497327868036649836943514230879546901087281330149378597008027545992380694973');
  t('0.121695039326', 61, 5, '1.448798890335260690740992681806763734590683875137187183076346');
  t('-0.819144495664383150257182552172823299849381', 32, 1, '2.5307142548900689918952680308521');
  t('-0.1984822714822705688714749520148290876570485254682596565950435360526985', 51, 4, '1.77060546660271090130648202296894323030568365456471');
  t('0.2104', 9, 5, '1.35881223');
  t('-0.7176741292', 84, 5, '2.37125292220905748701842038243015919721893683594685877641875110346563802067516550568');
  t('-0.991154', 41, 0, '3.0084831287201148791202830107078454718405');
  t('0.33950736550284648647337696777060532089581717510848448379945167458623923870334718378773', 107, 5, '1.2244032218620593728880028130347363452677440040905678245836918947025379617457455703982288905613389105922498');
  t('0.95892955777523879571445784025475358379', 18, 3, '0.287592394367756097');
  t('0.2', 6, 6, '1.36944');
  t('-0.75738649974702787373775526977960759188936238184245264729677678636788629837500066421873', 97, 0, '2.430097595945076490918420552451293909896532995663373144359055890556348211283777047075828840407628');
  t('0.96', 100, 2, '0.2837941092083278456257032342051061660155635174569281447562600587268832535198623218883837232684930363');
  t('-0.079091562014880104224687574744505287', 114, 1, '1.64997058101469873025222809972736074807905440661275716164988863009045179553293355321265657886361849170390712654644');
  t('0.866035955242659449391366149705127070147', 101, 0, '0.52357767229617184155093135419032171967642357370418618112452655300059963490131782635797047626259714705');
  t('-0.5831', 87, 5, '2.19333566789282847919628841844223510128635918665443434678963129143857838751167596262165');
  t('0.03198168807431579', 95, 6, '1.5388091842466703023217028582926553058250086562093337871092591504698367145403083144826946606544');
  t('0.237152116452735443', 1, 4, '1');
  t('-0.252035', 87, 1, '1.82557889303026528986081561473117130426494739376645996546263059112350258043649623290234');
  t('0.92067649744097043192499857', 12, 3, '0.400986211138');
  t('0.7966721', 111, 4, '0.649027277941610002406943361401840667419363611999506355180646482450203750692974466839173235320010746234653518208');
  t('-0.1344545842344403', 72, 2, '1.70565935502332265994887623815437522273348932153760502094528496615528602');
  t('-0.230577573087792998430323655033', 92, 3, '1.8034675353410381992822628799645639198750087725728868100720969706418224489356791551279340985');
  t('-0.73071478309803907782748428479731797238', 50, 5, '2.3901647122798606064350685056778949094908994530399');
  t('-0.55356739529528850775615917747188525437583444693501116051578838401906', 22, 1, '2.157438089938618781136');
  t('-0.78879778003968027699896379170101318503584267401833559347493590490320136681', 79, 1, '2.479646928541474391160197481386668587759542759060582529971547801154982656272904');
  t('0.49240978', 156, 5, '1.05594003011190024134686462301008403852509311501974964831390428832621978981101695244375153152503517653237492920156989770438194978119373390765497926087752547');
  t('-0.5149686861351071841805287114918579', 21, 0, '2.11176744561946149204');
  t('0.5786671400596005567410329870488957662035179716', 90, 5, '0.953702865857541655763314277538260197470603577283939333962556907515409717868162938406938605');
  t('0.54043435103748299', 49, 5, '0.9998430702599774871063041273985799466189665219237');
  t('0.803667941044632544916155836793', 45, 4, '0.637362715332678496439877787972469940730233932');
  t('-0.3276548651861843377348757679419577608208242046182932369605385296013443296275626702790169989268459654191795641611', 21, 0, '1.90461667407363768597');
  t('0.43177974259109353198116663442780977764778659487396656584419223', 102, 0, '1.12433132671947380949525829564893686015887130497759790348813346605477359067877216442702209368547357543');
  t('0.2299', 78, 5, '1.33882139747605490088216904615713243536655145924065751370808651241545311233943');
  t('-0.449167106962', 160, 1, '2.036629223617219209143960928973869894777758629207319222840208524973412431452781936121200328006119321482901508105979657403899843465588017622316408701204519150872');
  t('-0.0914716000349082895796275569273750935496889194700689778600919528736417', 45, 1, '1.66239596747701726311622627785952724370674901');
  t('0.720992635511896394873282602286049064250227031502466998416191563337805853568539655366211897508718212556', 92, 4, '0.765562580466423584537369624048709466625359747106377596679983267290012312401942182582344447');
  t('0.059152410840096218080423272224375865', 92, 4, '1.5116093657356910196245928346767412738475286996124956692935014130002387376978935764354950183');
  t('0.1644159366508', 140, 4, '1.405630466215101837597069929073374653383610647761583460590172463920616854520610146182957630433964276288688247974794581150309371743251582474');
  t('-0.840602523380349961322019948305823387344144789359702', 83, 3, '2.5691909708949548583916235356053786596430665700395381878518065247381953297908452124');
  t('-0.43124805501811319764556332173594058436018653889203382264613249875154136280073', 22, 2, '2.016671942234676674718');
  t('-0.11951541897328786662304239165546739', 154, 3, '1.690598115419409133759300641607048045337261572010636106629530075883625158565650704211784427251934915548425641941745161710050206991294284883050444310641196');
  t('-0.9572275011938', 50, 3, '2.8480592154389515890234415123483375360352458797806');
  t('-0.448035559288703883872533078165916376994300284798978979139318270876503921141775067902', 60, 5, '2.03536313060824418858858116615139400167898952917003509291282');
  t('0.04889972137864273', 125, 4, '1.521877096388230907478537518979862355114403720752436516463286853306653871259137676545320902793610407574554171969640034772433');
  t('0.504022', 131, 0, '1.0425470857523073529669656592865680596907528404722655123861864288380537843956412479501841500397641405901171523866418316208619596518');
  t('0.6278057527810758737261613839071', 48, 1, '0.89206535946614211946820503964803546263605229253');
  t('0.73616474016943104986336813613048890080158882089477605766064645020406414708428526961274052674433217', 26, 1, '0.74341030695621125391633157');
  t('0.6160135035838929884963155091266353098922877296340082387012133331056630384795495219625320359676513518609893532589331199458719424', 1, 5, '0.9');
  t('-0.060112286716019952197066194246617079641451272702707517010399664502299901152720176251059631374', 27, 3, '1.63094487500018037003595741');
  t('-0.979798385268993348268190580648141300657263210706487329512281388604', 67, 0, '2.940247173957211229073331991566024364698686667396874686236909016139');
  t('-0.661621598975443283291286795947432091996163', 68, 0, '2.2937756293701963903554479837234565841121610495560161113970677793765');
  t('-0.381957507172600177593742878928868890505667500121818818823654866479', 152, 2, '1.9627098004686142379405205789858680784775437896414925418021878281224296981204546457249280875353611336078777482050711953604950283516694808215786669908294');
  t('-0.1461', 73, 5, '1.717421139459972039223418269368011136726068522643476906878057407011346714');
  t('-0.0739544028841431025', 117, 5, '1.64481830869992186545493815311712812652487775164253726511322231430769265047416498240633337882090593842061347759286712');
  t('-0.447811612731740115903364', 83, 2, '2.0351126512316121201591139760290119133194829627419793448710702923205807932696973027');
  t('0.8896519443202153', 19, 5, '0.4742139355830590341');
  t('0.0143951057472458845622163499397556758', 34, 4, '1.556400723844549533752809952361696');
  t('0.40685832552', 133, 4, '1.151784104348191440371545859066406734030002954774199380426814420181889313375065696573068527079460053682318608729396554845374911686711');
  t('-0.44234', 61, 1, '2.029002465906458514560520791214937725768600676294060514461325');
  t('-0.27311272386979559886696274699', 147, 1, '1.8474236191265275191421412861715355641917280545368634656936546954118173694452322945153588872884527865046967413964095593484135967836850485844102724');
  t('-0.6536220618384623160583653101718337985753111239252605279712312508474956640656440696608', 127, 3, '2.28315682053997575884078958784329270527132836324917401020990384561406192483136081434665562260004372194441766422759133931899155');
  t('0.280664645365458563627447192079659707', 137, 4, '1.2863098086920056876517328991201911711126595619092080210784742925206990034491033299477497416817169074166579326651084392317237468569424434');
  t('0.135031606632336203851052308598608290642072494531517485548778009391023605786384696360046604390491662969333546610478125851559497018208185140719', 7, 6, '1.435351');
  t('-0.91312998334725114341', 11, 5, '2.7216933197');
  t('0.5108137113587456', 147, 2, '1.03466528677807172643403629603435967325429301512961694818034399144618065587021174698982032367885121478010574425117717959408072140227163807607016002');
  t('-0.161104', 67, 3, '1.732605489811316116320881172247963953528749039350724721438380344509');
  t('-0.2018964432338658983364730072931', 117, 3, '1.77409018057680247183951421153645663963857836471318655457044976919129749315015167997143754918055669911247710975345398');
  t('-0.5235758456925839965052', 74, 2, '2.1218389959756991086820206291979231469778294143499018870406333297034161575');
  t('0.767326', 27, 3, '0.696135576619553683501483467');
  t('-0.770160021982382575', 115, 3, '2.449888317335091696446361468908483327153938316802225943842958551992634999969307753982276394366924269857279428536424');
  t('-0.8', 49, 5, '2.49809154479650885165983415456218024615565880826');
  t('0.09575772001754856497162607028', 109, 3, '1.474891657220093717369457649377702711569899035826724746119760508824424943835194656281618306011728167963199183');
  t('0.6014333037838', 96, 0, '0.925502381963847870315863097711110793143050093231048091854459206150649523780830676011449078014287');
  t('-0.81086327578934629643373061563891411322443919008089601972867040471669005259959135303031', 2, 0, '2.6');
  t('-0.8979207664239745250510882151788419021875073450977947429632125491326102558477328433', 19, 0, '2.685818996888976823');
  t('-0.115312893238553374595145659632383543602501456974242485315013343131037024109061476870649012599252175827186451104428394136175', 88, 3, '1.686366315206685297739054615739424058883900402087314173320598143818070418664058481225494');
  t('-0.6606777950396020221244349198822216350190434852187988575125', 92, 3, '2.2925176498970702126613448318462300339314977794221853243958597351706123425056891469697461844');
  t('-0.87388', 114, 2, '2.63392349576842298394109239097405132297562465136878379474438907119022310777653832967478826456420534765172132532384');
  t('0.006684365986905605', 14, 3, '1.5641119110299');
  t('0.7825684737', 66, 5, '0.6720155060008838006636723945252566941764197408181969289516645268');
  t('-0.713068797064084727223388122438655279171355935534485701258397711058309190834522137860790849914771887413114422277910550612208804', 89, 4, '2.3646620042733311442205233508700499891538391534549055012734414250381451832995643032725658');
  t('-0.66481971026295404377351319084273028012', 90, 6, '2.29804876838881540991879481366011931847124332742218736620270999908384410329318354042151955');
  t('0.11889078072958761893179392173377867565897725485813028984713345567521500161', 131, 4, '1.4516236621471918282346786152240802639585317866902416068256837896085335822180007818317717669942735894548890910328244092194982275935');
  t('0.898745373844', 126, 2, '0.45389662312733916172584281756651263506427911911032926844024357515241417252401060554838499801965747500993837660281074367501405');
  t('-0.71999713578703107', 115, 5, '2.374594518474489276650288380060021896206854604279350724471452600714976268696566268033201244504065283673311257268114');
  t('0.05476181', 92, 4, '1.5160071093305605541679218157112714944033928629426191122772159156824146110100572475942620361');
  t('-0.2131390022833902540930655808518576124702354109286', 54, 4, '1.78558299393916816515653738365200727616344007410134346');
  t('-0.413633700736544703856257934751006717720479699077841132691605440363011308994', 69, 5, '1.99723792070470430945360524298382948224549650366223782822672632765227');
  t('0.67306387026192230399822207982313562628029111874277480296', 64, 1, '0.8324526153760856251585432848751794622974289590062442028198520065');
  t('0.904216280170708359982831202900039023001015149926962916333764719184745877', 1, 4, '0.4');
  t('0.43125172383642430996781402073609971209769522911513496468', 154, 0, '1.124916644977324678956379402218251503251479687154110046664502141470228259210330873292408995097607991664591059812351811622154490409710828825593150901733124');
  t('0.229967814517', 64, 0, '1.338751715928841725837546358249176235006960378477752112211168397');
  t('0.719', 106, 1, '0.7684339088689119674557688064676175120341113234173883516866340937679242543316069796328778627319271122733227');
  t('0.046994093476232470642073506535764900177', 148, 1, '1.523784918795565263319880380980297061863133417930703389774776074842204280299506554502802316443280650031121829765755183614979972424797937937978750055');
  t('-0.0470959703263', 11, 3, '1.6179097245');
  t('0.8905465064453331158489489644567216545435308688995472167019624316329618798292650452', 18, 4, '0.472251168819759681');
  t('-0.5522645947720219959779846477612467475579496232530074274409246', 22, 2, '2.155874548200469547336');
  t('0.2065704842043886', 156, 6, '1.36272778719557083310369987579707451036578014066320797846193934762629922656600957718500732130949286304729593764115629594333817721895349988689234339314715666');
  t('0.4346232826374749253060577', 89, 6, '1.1211763825109721676949756102555179575836573779667600913398717978393552154047548466233883');
  t('0.712', 35, 3, '0.77845394015561802673043749084781691');
  t('-0.72867365444923334376595', 100, 4, '2.387179613159754456900062775008894809908743025186288969800229525615508468681610791130361877970210559');
  t('0.91081446', 116, 5, '0.42554360189360406285448289505111878326499798355507643407378770372500297397589059534347330367247373919639922140436053');
  t('-0.659026819202040245132173157411458764818977557269327151313930646896992902353226724248346279798785489256276942458873205528597989013428380237', 59, 6, '2.2903204350815404324481489993267346829006032384869979526097');
  t('-0.0927', 8, 5, '1.6636296');
  t('-0.6382820272462251468928235900841619909575470238688226787630659782984627014834858552223465589303234442117457', 180, 6, '2.26306081638175282619222006578215238602736032247585910711452019452401355329399282976743060562833506495679738787513347099788589739984766429547405695151623417320772379259288897767884');
  t('0.73872188141197', 70, 5, '0.7396242334764833618091498609992599112485163846112326069853346600262214');
  t('0.1188488654746663107287428889283662344452917996930825633889968501252763508928759598', 231, 5, '1.45166587670980530337094484275967846408411600372081669193814831965162619195285054558095680805374737565871966251889865704524481198054766721793919016178908579194115200187194839105092431724279755005113851505446105744753937842032414703');
  t('-0.767', 207, 6, '2.44494885513240006745987736113732706212268703540492693149634150316662272477318188435315373323792864448360575512080963251098462961156915714200907099826564060337658153623026206886418426101891487394147409078777');
  t('0.923393188393151829389539019031943757876967824530708810551626752051065322', 33, 4, '0.393968016786584027796052105173914');
  t('0.710088294117', 293, 2, '0.78117272766081844487780394779256392648583494462736385733473101269183187309961455195068901531342257125543120665943427994220091682721958252431954027607686956299882426573115010159591013890402928603481300561999945329473443459224791102210326179212284734538436672963768058093593002210007670564952297');
  t('0.332904710781211308', 252, 3, '1.23141400369551057739953646004969942424521182960160354625713231806995093516946260127118268100720383958248331843534949936561085831027660813846785191471810291160025938514867977905911276149618351028487386293964937567662815131780708734663279081853846034308');
  t('0.77704944635044481194808529', 263, 5, '0.68083175778078794026645287666199242122858619692713311524539685218809596599387081696598622768651184114160931174567127575293800322636261401601021964462210194554178322407266734038588470118034705732045763006655751930719958875567971625092842072816714589183376269228333');
  t('0.9344089150224766246070010703517785782215749436301847008722194897305907749679845507930869755816174716832577495292223508507742540435811', 268, 4, '0.3642002993462258543860986997231019836812617153856475277351847239592828408372033220950360711847940705411234548266151923368245480786952709302946934636392141268462657896997602875421619868039245712393661543499322441920950804551472118411042211072512026898932743189916695158');
  t('-0.3302368139030543600182354657269961881272815400141353485691893606312', 72, 5, '1.90735078020562052815880791567293760985949401549600862681834150143963168');
  t('-0.901425680927926676249627035936397434868909909394827', 250, 4, '2.693847703306722528032170317352055995758628458478554475084362448564107635967539909171303632191496415436043303462193766766418308594294837889654876895816136069932230156329053391943825011974077171138371996135289056527509118494796489336229640945466482633');
  t('-0.8029119494155364793530794563267292038649857491625505272246364857703812238858844060703742700934874292868676729295491155493816177000407948288301824150772212886860010045008214981724195806592025', 44, 0, '2.5029606182814545492316884326024915671275362');
  t('-0.9674161', 183, 0, '2.88561450768824852411809268486192187132280036744482598621648186004411428655783858168189594594443785992306891285793547912655284771064876977578210218009144517358027996579964615585400427');
  t('-0.6618212077055', 163, 3, '2.294041863156667849970120337953407337263696509965927535183568301849552488301836148203338883681376846510540769570728408232325547370654544505384596938304181770032881');
  t('0.8128', 303, 1, '0.621853689831827629043711307708582662736216506146860073743573314291244730941889106600125949643970975175814580792238657357831612486987794611114237477837408590321795204996561888730437081326738983645953934519966716525779618036750625245975482093471605676839061459354116348909967846537955686570323188819958238');
  t('0.05260534420866396814944600565616719411629116458', 112, 0, '1.518166689665715268051380131681363016949821661029175335107020375834113449809575329955166153107550240905047468601');
  t('0.407023806900686817542809701958977309980584313560413100364959314927', 140, 2, '1.1516029443709710433020886608615546632772007211804268163591290860699079363585318602409725674887578779270965727778930447298409453588356674486');
  t('0.794554214400613507121550855174975', 224, 2, '0.65252327457618440688569599533636448138671479266189816369296254251702808998705761639316444465304148427727850101639696651873329882266567145764836377309039659453218601651128407018031658456436514779165101511786186223602728135295');
  t('0.6469218435', 14, 0, '0.86725546507622');
  t('-0.093678585', 134, 6, '1.6646124712251458856513384824597882929291192383218096573160175992600092347044156382955041369648056296416915753759318180565211022503548');
  t('0.3924812820677700716850844069389291089661896615133315855608374582780076404720512884810882209382233401500945489161173579244101095', 185, 3, '1.1674685323428983973993578047599640101188639421128396574195795300745060731441460198041573395148746688719234363995369243238145479056458641907401055228913291246596162403548942001270094302');
  t('0.59561', 60, 0, '0.932771499280400988722491079992739984169798458218471414398034');
  t('0.44040840461420326110587738674216', 285, 0, '1.11474280801393135466613963918168814176144824526594807463640842411113450130453255652977792907234004189247115148309003191820137817621426669743496167421966763234011079615104140417925000709175909517750339302939592304500256622852401339782063272180685161276407891994150463834423340995826012');
  t('0.6705235162207143876366305207552053691428810075312401384356771297826220581040025360805827040585992', 10, 2, '0.8358821105');
  t('-0.1', 122, 1, '1.6709637479564564155768448710924447606672606719171824518784961511903108767939670509679552770305629889467341341767377392918');
  t('0.227666607755', 253, 4, '1.341115639615689547243809021052302587470178529515075367976671807994849941857698125465933583135327014519341890282264810297325203993320600883978825275539680234833321985583831500270425232823811998285196438296916592322992487063114003861965299409933455056574');
  t('-0.014757609905429833122705981234645537', 267, 4, '1.58555447242221911700723428170394218376319503073672078976815978011049493730508982504182508928199311797957036040652702166028563253355386454011770597258516123157107253614288122725874231856250073479690695497657233593944937264002768575643232111935276216990638764996506602');
  t('-0.880175240296030356339193293913398473910258140686', 139, 0, '2.647027600822527550072155350442025447737939627426107081864190259414251012912723512815900570439492258671758273051995363820600842296089000542');
  t('0.133090532285494822008319320003585643077519722544488343829688762797803380444712006784559769', 244, 5, '1.437309721839051756442075425743428699450176650881680236212373057041468648166042542826009517804322994677003695317933655118964093952885579130034716317224690895362071928471934343960645711219126384565587225041838830423249525501220478383134568422279');
  t('0.65193193321070831302331543913927364924418973254554503630138777974270086436816397224076300272714430321423847109164564221968743797337323853027888235296795141030627167618004011883119511946522053443143675828468975086002727943476460431860911862', 207, 1, '0.860666879820060042252465353739704456844038823215338037965794549943693411647110222211816573897267349748079031088028212328083703756817551638038267445371957872455794037689400957799506253817597585320801196809924');
  t('0.212554723953471812305587858170083298095004263849182239671448975407', 220, 0, '1.356607640377456334041662780898718621018958226378420242336942891418767095600704367254657910690886351046813734009406709917754680791598131360275135793003875280005855768378579497830087623396539029314475095906418333491048209');
  t('-0.665046972018957759', 57, 4, '2.29835304062831707480557783537948257583515212002040463799');
  t('-0.92093', 249, 0, '2.74125640354283006641388781824769352205818197790150492297528330123812984818122105216558102132552635296196125244485851418947076917679454929481056002954459017969537272074297922037642118434922586161474330961133530824021830773067327442755004456553197988');
  t('0.68535542610405071175951929148624112349539388420752340055', 318, 4, '0.815704657242983365331208816689921078801599179729138107987309059416930689267797152716305457058979730702096596664048735786477940882804938668125621302215427380491469898925728241748106327245320507622597063705531360224033027836436782131944471933245345990314170479087933219140639340677234052370185004701728379077102176228338');
  t('0.49845940188189411015074906405598653383249068001558853843170102', 66, 5, '1.04897556900769504250242067804383445574519066554283354581343165217');
  t('0.508660119767', 105, 1, '1.03716850289261782862767223551696256061299795292578369421271375839146451087522611291701651289412409445951');
  t('-0.779224320115242323348742764154152561457981416268941467942241080658', 44, 4, '2.4642235579639323466017112487755142365915651');
  t('-0.7152102897395072756554115944925209764167157484496233767652107453410998989641502236410781', 14, 4, '2.3677212697308');
  t('-0.55495911847829', 74, 6, '2.1591101484529818278937734992102582170441518797193469117169721011998535785');
  t('-0.893683514503696242', 262, 5, '2.676284888744369248739299296749444378847556868444386933854611880655454738851072007698009611171959278797486673769425052387457573762892570689457704524442120272906957453775380582109082848677422533929681108005986869237003265219197078650309048716185488246889500968028');
  t('-0.76132', 130, 3, '2.436142870384473292044323020218002697728275879765254184958207414100089081918836500456467752501769779584656697039650742278140337523');
  t('0.2274630890480566480660484655658912854', 311, 6, '1.3413246419319014240275610872514478480239730182972226945539338672740565817234461350532754367412396369643367993747569129948268582529299981963552054934101680332478953515279904970252842379640185265005026889494546183376332868790332543515695470116496548670029130853120175455025233795105096203497117664862879562798213');
  t('0.392570363812', 112, 2, '1.167371677091476681744850563993741737388213299847958498014284043769771516062917915401524979681440260162238843253');
  t('-0.351134691054373041436125523322865968330312991741716867057940847379648', 147, 4, '1.92957901152746893103387344015334626952050434447494932318326591596348574284495930386533065956448949134386934703289813223958246973805763044973104341');
  t('-0.71072087851', 35, 5, '2.3613187470437525841149443413634537');
  t('0.91', 318, 4, '0.427512264944869586970008347692942211349754186322044387545030981138660976114883678116737830166081841143582428029372529009811147175923525574931181121337483224153571872690723088340322509320864255173828109651042703649300506727238626490244701942096579039531780514988359524071512872978185520408878727673751769441693298629057');
  t('-0.566110783293866', 16, 4, '2.172576457551446');
  t('0.3', 155, 6, '1.2661036727794991112593187304122222751440246679807765230944943474074352106310713398754174554396953852593390866258556063987502368813428722376754958736080904');
  t('-0.3352147614', 107, 4, '1.9126294978568461937353869487026835122524383568057098889045743967321450572432384470136805460976302677484216');
  t('0.032178285606642150945178090324141959881903547', 109, 1, '1.538612485474105365377470624143198333917548847842318602480599015405764125116924005862020882132045598286911099');
  t('-0.5677714497218306546809356014106986295638353', 314, 3, '2.1745924215395240284687492627475815801464724845240865659663691911458716554484196949579716513768226957252088627197990640193702092256316407104589114099741433078816084818628016877376694969554942256292695237987158858400036030642283489406482736918628965902014493726078853101352100610769335168043675263350577485989672116');
  t('0.64092385529718940931392171633338719180367557322561407343548127204', 122, 3, '0.87509510857289456376464307749132753859118498085989644000640805516750689909474597994366764960202404453750749882950986359528');
  t('0.41825457900719504562951767362035916463017722979110686662078236973092550313691005025122184963190518040112154879366780803206948312056058216897966567149655980705464', 17, 0, '1.1392734305586714');
  t('-0.0496510841709263312020124673801193301328', 230, 0, '1.6204678338551738094110631028104389232458396604783803626472176696414709732664269280577706165235902186357118652403052127761563476617405021072016717141290850707025057317062889725396580194061640656622149620389137027381912259763540621');
  t('-0.88626013068047376794338298364226349', 117, 1, '2.66000385760667640490595506284994809117134632133385754272057335926944341085456346913855235272292795414560303456636251');
  t('-0.47297806342', 292, 2, '2.063464087296454183786198345452555730491745896026439874472146853522017432667866178192116543512468378799143177509191912606736952722129115433838531576349244605853328349773823772072258571400024127139415877563239088587696109552684037576415659484825947853993939851072530815338822784952934228012156');
  t('-0.35', 287, 6, '1.9283674304404069059461601839603940099453260246770406737388850047842873158665757722585803570234278962139658655261027688616137799378799946514682191698095073630991955131598594270940758439903750935437496600601721893079726078455357999997823561735873059814127513391306403374385185590312228605');
  t('0.324341159910898123540095048716961469945698527748665339870387531540472575752266', 147, 5, '1.24048117429124846439578545373999630426355045230685510964055886798371999067558590498300440420285009575721223083067446642458590694734030010659094097');
  t('0.6208', 274, 2, '0.9010335868350647250640668447424903117641845857464504080890214720617070834481303950000043220353142596436129112691272296411807268848557546306700859828653983938656999369765211926226949749585573862817338993130600245265746978004143183998193549345813225551178480455808521960770796');
  t('0.814036557254769352332051', 69, 0, '0.619727846529946752480424411491032281228574630563955228633703251334406');
  t('-0.56287168256179', 84, 3, '2.16865235719271966873624200961947350538696194021496618149589356616743255619405374226');
  t('0.2922289535307753', 319, 3, '1.274239624294988113135680297268601711414222286192159978827952154848505182747141031657978637476129121351035807782388308110491560119599348956516200040305850269942760980948611053322193371050640209631629830650410608213850398713622323345439626860188954154685210783271199254078512885082097682334842628412795692919069633462773');
  t('0.4041079941099973454724047491', 3, 3, '1.15');
   t('-0.132369929486107644952706585954821224213916538128943735419611998781657528807689527000313500355130302792133872310963479100151085686', 167, 5, '1.7035558962709346112659744601021796705948318281875682672884014142187285638786901561954644450777723687233829468069733360743418675267244846572609838284953006844492825316');
  t('0.826143026143165947418530674810690364264479695496677609092020939378734709308843780167963626063175021080647101113236372467624613855926438999989023854978102344600260661512274686867679926422591991008', 320, 0, '0.59856855067896697666314293809733853525770781843627066169441358685286459683321903624161582895514646578375583421331537720655285411270447822642759241678126324750413193577365277023505904105719969270288604406183299695809199042575486726606181649363165843374947421434949397333399125124687989979132035862231875454406777492484201');
  t('-0.89681002594581245485900478190386364785298741043229142325472442031730653885089321873525837599041444062792347767222253362158917387755978588764100341765541275632027211459955807765614489896287958946555833707024107035389241955211924284537757867712396930653657716299737302157', 27, 1, '2.68330194746761005509988882');
  t('0.669946243473', 136, 0, '0.8366599498849809517437499988442199241358644191324008672073862790613823489108136471836550727337842190256821787493293353126115085529794223');
  t('0.29', 183, 2, '1.27656948904591413987398597594696897741159560899220860620644628387340967180708163820294386727162911156271240538673487718970208244756734583354878358238990988623945517750173456442760053');
  t('0.7385669422419576364', 119, 4, '0.73985408106406417974210390222534301450431768661988965920808480784506447740642449442237027619088202382404137178166265038');
  t('0.801587460441496046356485833430888928728354490901128749012667252251113887097737428044338099212676718589188177902450992361597268360799252991890337891601641469', 187, 6, '0.6408506550202004394026187757169137104499857065072304404695397317623558226127400373909162902529838681545175003350694278245867374547235635364651888143933966626027658874904485783030024157416');
  t('-0.74479550088469198425324', 224, 2, '2.4110246546053988488988408923419562183631961183535245757956595129472755503412743926970575768016799547951093838663110992393475299746362166311934042658566117573313876464160911691162341201369237322519655500846062820565606204909');
  t('-0.312458', 319, 4, '1.888575816690415930897863309331725979175727779384558802433686021217404971624969681341996700860809837652362124902097836208029184382045270837090564008001214693920210733782845067360282097004533217148180164128327150312977702949850975330582001158237003300825774708456120404130531099096457462480813518869121809528904260844406');
  t('-0.61639', 221, 4, '2.234946287898429631762937377329599153075633865840350295508563673146118502348311380409842809106237191618031144081678897258315801728590457573353740881361766478356847901824067744325162738844710926221537607502416384257386494');
  t('-0.61418940266925687389773678248018043331329961099128447572814759394857589486450377', 267, 0, '2.23215471571424527579765023581666026183529710201580295330570398618242073041810631497893724386387388879927529625316222325466841139510558953822141786494046953221556271623691251432265529999023868539693262165787517099498612599388063071254099711208037802364155106835377888');
  t('0.87161333687619183133911947665122788315770698593229677931462835671472802085635', 184, 6, '0.5123123537814753061341315923333946955209786206236265274529716653865860077010475250728707670487149265977994825232145230031194805513782638530142357468946721751710066962694878749794710909');
  t('-0.54492614437367078707836463072883616277139652176955501527744', 259, 2, '2.147097356682361990789573337716565515277448627804116404415332674469355820399379001751308754721278308084361700487881948959953671933557554155494006054860817767545798417293793144639215144894252021164760416378589470814344767585296407960189081268738439509307303019');
  t('-0.36827139907977142540600480861706753815165492907195239700879384009244581232831726375508059967898495850369984792950287331227105485689039055388012741957872383277720259230683233018189443186317301851832485625693365', 39, 2, '1.94794538747255048880860438372027566055');
  t('-0.310788960947458997385701581170061772370856278116485941733948080339445467514014594', 88, 2, '1.886819313443551334393267875766376955090085962205287363063498508603998482155232336251061');
  t('-0.6835784623393568105409864645', 85, 0, '2.323450604884502055975789421591130055613269582595529949371094506889203198872410901683');
  t('0.06303', 312, 1, '1.50772451794449895001896495665834645314865622268904335176608647112227029743356320933276191310895796826131700228358374833121561592213609047385829265104826621981230917395633535606472801114928528070994555710804213607092343037038453308642080807073993177321196610750642598963326519559684302931003280253455854492204352');
  t('0.14159754097308047869876797058007264698706651268303919655410203089475779265237281439683597537168040229221538955730691785275603244179178689951775360943231267040034810415770734364100418753277739938815991845226741142322137986682491162412984578388465023522118107685281157333765764302761451605345', 97, 6, '1.428721296468117260131447719720120643606935242558780263592325885438857357592285346271786768052748');
  t('0.983917740445305717582383639617968771764688514342620130177', 55, 5, '0.1795859231375598185134751941162039220772037511346722299');
  t('0.7462', 285, 0, '0.72846074738336186314512555153160539133242615393707445289901011812090296188728003776057340146894560054492669387284857011928727497351428642240635519496614181873485442803347764060215185209828488045163519633049971351266944625788622648036160055937189063317867353807668938674608089843640791');
  t('-0.63749036152486630898846609673853134621500136003116148836827386144728211331717654238362157539948576547769124995113771383113684978310713010733296683395874574529618130248789', 319, 3, '2.262032853349759419918810907175156571405272498714925554314338174135289616528339831906633591023746460061766802912484892869936613103256557390410894536409782986272488579105382186907968862032051875703332974065975816937156110304827912286747358048774351206951955183273104313549191193175673565829813777239444645060801523176667');
  t('-0.1141640343354315506556', 222, 1, '1.68520981842495050014147615975290158004109836337259187899336659348167046906214885549764347867588666249176275094806885892849781527105675161716777061370410863873999947455303198268020735011287502347527478952210680516344569612');
  t('0.5713795014721887461409', 248, 0, '0.96261054052090653212760877361525181084824095846114312040413793508787828711552912421361287019229283556885900055754028149595849659123000470439918004592998497271147101773137937907677227508600324945668581571552069920220441685103990779743035650718632769');
  t('0.5491133720273159649194824398117994872752823770525898898819015041671032178104895841440753727765', 77, 5, '0.98949333884286849008807576455779377967416280087815217664373094177941943884053');
  t('-0.9876904840211732250219417223595731532614339786372', 262, 3, '2.984526723253686403150537692104940666485166931745810210839133121154517397411645230584614445801511828969383930135063760693941761422389258010813892908333773910886617137395269538154993005587184430708251353764401476343946200186994099277241414589857752442824968378283');
  t('0.11682931883635741045903553898433234', 18, 3, '1.45369959321867178');
  t('0.63042933689029129894608253565803239760460329863128285190253972', 163, 6, '0.8886901459775789183682921972337580564350001748316808184510177611323289617204199351338740313146949311822120862201104740352821636246484482711229682670044232753263609');
  t('0.055575723515231106292771871615830403377041525831563911941565703401932780379023147401043552303406738571431099020062224745327447214221902483097732886347861247921004849881147855677233787949058431280721497688249722565580530982', 195, 6, '1.5151919543473259206688692942472887716013493745964634193306099467285192605087398047595166751936410577438285656145795372551570700737166046114809637441351166175733025260538265125671387421155772442');
  t('-0.67081376663963892286350154076279356563598903', 123, 4, '2.30610184432817058958468471212978417010364203579941061734075532058158918487957012149012316120396828430047057303502683065048');
  t('-0.6197190977426961', 120, 0, '2.23918106174383411174766245654407117198225627426434114941545005956876053014246202782550433076636756757647149243774330378');
  t('0.554628263532835327211555422', 79, 5, '0.9828801730931808037431529962501619412035167051557435246013536615234714429546733');
  t('-0.6073479814995807', 112, 0, '2.223514399898826079680274470297228910209613217147979929582411320895148824204403513968642735395435991584931544758');
  t('0.42679237203546629185516043966661351024724843359242687551905432458591776036', 183, 6, '1.12985342005461814907383712049897636264869323670817157190786962687478218751090413001820865328915882157517951645217565760274165682104407613470892093992239897075701034240926231182365144');
  t('0.7952372172676414174131713786434740692126405212887205840294730181390513199113507546229304014416456997266056201078377373483356251722576889846254682845964201', 216, 4, '0.651397592654873580352434828214057351738081427543986284689410954536856994138804034606403481651414294095532600553527233012987540285042096024644116067523256891312472273766658438481141107125649244701326007562141002038488');
  t('0.36915243012482195395438480369914644684836788745515660849', 158, 1, '1.1926994558353250041870431947540847400670232144751164265745772322264361020111236426890092297554374858184262972921107713958534764683144090242596626752092546927');
  t('-0.0720938927831676742856206151027539199732879632516921283', 304, 1, '1.642952817786686948683315383725901379806443257102725457208689982317729573072036049991983638431825701757948685311911608435627169719963055756527088269561621088918034346141416460523000298152074697779726807838134079963409899300774069992263214024703457046580319821464299130154749942095168507764115971382958892');
  t('-0.9611784169813900148373575165761377445', 5, 3, '2.862');
  t('-0.752204', 290, 0, '2.4221968655648808282939541988169255418567230769362207317812862899335601605320229931653475124012608156274039087174395584011068527783819007800776467687260118135652702154541238614809018877520820269252198155650487671861250263973523098719973357247322207357932195398673822549970272121690126503978');
  t('-0.892', 282, 5, '2.67254679532470759629979138284737589812438365090806948160348760517043959726357642342387715205321666298768750727073323271869629513482899459250693279289097687528111672001626167771411185315972525797563103433510303127335971545795241572726390302882813687240313906716146853715673772186565');
  t('0.0194921274212323871771974373448472', 243, 5, '1.55130296484624988166566681772233143934873698294538848609787950995402575054752744246282793271185753315837617870428978354015220029797298181253062922302144934032918933541702492327957297718961037130711142564132166720657134679164123617133275472923');
  t('-0.04462059883716291018479516912', 272, 1, '1.6154317454997373154321183620932351929193913381196803523158021315924591916241378154717161993762172689567252634331165643892900730384789517526690129350521052601439652417525743100119602534857673171212133062160602622981009843127837437916452951298506016085595430840464646690742');
  t('0.3711973677704709358828676984922672505522568703368870008818216630246896', 309, 6, '1.19049814073163239832878058434521236689058207699871836509925861169431783812433096191540941983413537188233101135120340130240412759396522859753550681519981686550945243311268935717573252853540511635218537367075653864087894672738076297395070844234167514038021871454183804351183541226375090246976681895044470480721');
  t('0.9775875709', 298, 2, '0.2121162539357906417928657971621930651029300750651970541067770042502738516145767538620746196531796426206501114523151248214506200917068186136172382457542153878985621929156752261130734536918116868365004019523896334956087999323991107085567008728869918014274010820352452754370956557681811223143842731048');
  t('0.752434946326829409086623615631163306368641526396283709565028', 23, 2, '0.71904523114474343306493');
  t('0.99165003788387843245445647311313221560765051771358078533', 235, 6, '0.1293182769096382894026279210494087006198103635579328484628022464736521524968382441621257387073904309785860947382994159630081513474815048849755287125093988786024403266760703042225488266176244504618832740955920965682457824521594605287848');
  t('-0.77188', 320, 5, '2.4525892459727082170155051480682822575174052734525359103781774926886313582575827171911161892272357283452234219363024030408021294796200286451418304461985421319344289714840808792098210837612916331137749164463725496853322339629262703074946235242165490996003476701411809101563503801998676541867924149926776720078537565300128');
  t('0.8', 46, 5, '0.6435011087932843868028092287173226380415105911');
  t('-0.61815613117244051', 276, 6, '2.23719113633919874775435047420561691373974860455669202144317982325117805147416652811252764365723425297335543123518432603335997146588321873841485252110660119851393336205515626980377449546048932802841906723052460398657643410911610675007406896703543669861518121603189995378722942');
  t('-0.33643301', 59, 3, '1.9139228587757703197708140317847003896833314566646423404753');
  t('-0.69155478574641753001164026010589358105401549263773127394888911585259606123602', 132, 2, '2.33443564475284995704834857317210713999410316463348547913521093067050444856479246726014598655923810619577037792286983955790139849253');
  t('0.483499109114031625546347445285492629564860978018815796041445725623402437217970904566424964465644023592852826953877791436191840784721807187722251489449186553406332607980703796084903948734587138079950532833463137593891470805082529455528401742407245273107', 57, 0, '1.06614860077659800418307759080630658113283713836288525756');
  t('-0.988304191282080650953802621', 83, 3, '2.9885000100721732869699054378956254043820550812677438678976996689347689911714373758');
  t('-0.8804302880564177900810117157080474426202357177031513372735693327741439152202812638991207123', 256, 6, '2.647565208696149929451849105861047087145060274026807895560052204114265578356552789877764753665507162268053062061372800187626268970860668862340649148766673878305201917312647545477234901090088195516505439148904626876405366261384867999746245383324795961910684');
  t('0.42428032756570609862714848506721882329999054474326535853286', 180, 2, '1.13262934123485525754578618576872205349992592340322819122159726606473783030143359647669512297887579729955558322548091681893040420357398542453141122638953020675719819960277346368265');
  t('-0.87318117', 300, 4, '2.63248784505978229810212545554199470270741978807337413697303411378814057722542001505167719269527598618428437606200441585881939991278814228255343291130608330682589254932446737151871702502051354818566978075200413633590284250102801369535791009702624169689710926456425351981417797343490217837426827523693');
  t('0.96889471', 92, 2, '0.25007158021436624794295153555382985318245242967011242899770086982678963442358037144655804477');
  t('0.53216570798594932806587532135216', 129, 0, '1.00963980910583087839185652832587623794456891336855034618993516577165927675014495654249287231937320099711676555111950756786757744');
  t('-0.23712039778801183346243928238731697651456485920903533540882746017103', 314, 0, '1.8101969618023819731939959317484638854484246342492762694000108320209486314022486329865542980787051107012872292008241291295246234532537105462444023532727278135454852590199911089531394603998407522495677819779835759456565197095016259510717678677982416978353359344430097817021972723875854504125043448450461659456010344');
  t('0.060312058960001006620729476004837145265085470875758549911566521877222631766673172', 239, 1, '1.5104476432198999871836000685572952922608257333998098204455171531757541963014824612851677814769158136692776817254075293790293074344376791688577594298132948170973180097992385228973042788643185280481929062300919049521900258014626953232177415');
  t('-0.6092217264', 298, 3, '2.225875117696767611798434160842362208705179294486716468847048390499475515617808925689327516321797702120209023594786108981694192208281057189770532263065168519340373233361799994992421135641496398387221491275842879078323129111751254133356701280589961193536939217056893714413159871621402184462662909479');
  t('-0.8417541936749089651704696216', 149, 3, '2.5713207083662755169543018953542102403269001777416467988567909257029089778187807384053545361354329110128556112979090137399683464572932024275703291812');
  t('-0.5871491050733172484161708781930905121749636124540215233046677776', 87, 4, '2.19832876070812716511230158211618329354535920964613744602062246787263030759008081521551');
  t('-0.277085743814551299013979575277428980903866161057731677175001378157448277129948259', 267, 6, '1.85155609054366023894305664277402055671646457369622532691169979979236491580847908362855772271035220542814056613024656797342473866388172838373205956416622350841390735877479320143626913144462913196802994570340752235406237826319149596443932238414382180415263763761583741');
  t('0.843765307415754624620893987805', 93, 1, '0.56653581055128743262884354069486315172159146109161090591955302455595691492222052244432289179');
  t('0.99227053001504270707153079654558', 271, 5, '0.1244142114981200916755875252263227200822082352213824752041820617987391411786837215459425757477808148970167446400969726695598367945330544180429788248837472195067871595209280340452585143772532409997477171983908355797967048729038970277883954572434175003011182064116479061784');
  t('0.8916190290031362370660457184995432248124460390015213375481019673409564154191249153329003227717266154126518545400451128', 166, 0, '0.4698879489033527110099584795383708408135922237461366438738377386586957015058903691654089703633649095558514053574879043965387260343269284353962592958620127238556191528');
  t('0.053', 292, 6, '1.517771482544358388242817093052857085306026025381738900487504616010309353836731453760893662121532297422577745513902819652753794495226559510725715267932273346070946662132803589780075591959296218712174180957337622341958566544208335137145863565062078255980236396142568927715312874643034114715603');
  t('0.398796971155411047390810642159207635220398152038513972073846138332312984648049948499514107', 268, 0, '1.160591717422262385064884232125924156313523468328523151403606303340022652673125292059165184582888180400608042102783455151236262385626752477121635321200596269332248486983740560231852946019718172259983235670357591665194971488935163824613291603392885425492686616376482795');
  t('-0.6557865', 194, 5, '2.2860202723094013533806445018264828293623128815820404122598815812540264519992972576890573970023926790207885059004361134545991829387761743015599358412241217875289662490342062341471799120269585512');
  t('-0.6812043690008459604413941888598292520741891519', 125, 3, '2.3202028081451919410413719757522179849649386000074945672305247857877010408286226699795867212434956111836742523363280469117115');
  t('-0.9234752', 110, 1, '2.7478383440460332112966515441918214447413819586755899194425547667826353831096714151900237190186169488334882775');
  t('0.285587081446806', 117, 5, '1.28117736018107567939628956225702475862966862151034667491699756631348792163014435902650756015380766264732028097025524');
  t('0.13819504238824579343', 50, 2, '1.4321575887704496221908186825707853385894826968968');
  t('-0.87088432912375114572763546302668725975693196', 305, 0, '2.6277950783829523655376501555612165658978703527269592241549573760619180066557759743935095729039244585109591115342954615025625502912414261323239685934485409870957514187672089242294766814885932365265993794899793412194891940057651102588359432775299523228135446808402159857946697659146517765582551370632468776');
  t('0.08823194083430274508726439434669253642392152158773663374909397164', 160, 6, '1.482449503939088896690597964423680503507425766873722635967873639816786043531410813509390246940709897785350045255724481571102070115396790364245538570280736524387');
  t('-0.4782350986149213223137075215227283', 209, 0, '2.069440329491666823368829738330133890917048270254692515552666794440743064212644756784461766290185491309936280116773443413771855462729472715257786786592510529817401749835772340808303006119114840372074816699568');
  t('-0.2904291356767990672663969769818813256736389145509262938123890442512869616388398097073972998', 220, 0, '1.865471600177256160841755343573079021480900579809941981435575198730816828223164397465182652600858480436382194535277523895290318359241525994579691849237416813186256582053721221858748911101879760730733644400625342817959603');
  t('-0.97', 116, 3, '2.8960271360745012304805194387355191452231610922687838587442287877772463030269677185690125636193327601684590363875111');
  t('0.64406641838727362832048634692006', 285, 6, '0.870994088184606218032856018230384348672398234965897958708138388678442642625049163249686273971233817835515549148344148268350143207052115551177156040327348972401335588215953696887536582040009378864053812838839767842444818895936100772429085359222574841874108401619657798149436333075430981');
  t('-0.255497879378386206529349560080073437056905', 72, 4, '1.8291589664675264680392682574143193990176444937797416276953057483639527');
  t('0.13736053075325015589431757537003544287024030864690661953290082856326766722949797355755839528830859467258891', 28, 3, '1.433000135662117306310376376');
  t('0.98', 158, 6, '0.20033484232311959269104635890538663713735194445925908278204771007280534730172510330787572871900890991132018184019317193656613714611693604055581634894163193067');
  t('0.285240699184324875469699323998456346535460266242954848425596184046483391444787686704954176945347768730989028617730321686864722621185397651677284056837487505492834524081566587967538357989373661144847881697423362', 159, 6, '1.28153877575936981514828884705656932194745590215359116881777970452418012738053160747644045072827400589404204122956916037521899051936034859376026053003385567941');
  t('0.870885920899394843427595453559619421', 62, 3, '0.51379433651106699777184143963408910975793416371794737910603043');
  t('0.22188789676081649237243800127', 253, 2, '1.347046120402577112535530917655143767892732910457439488486932441045302606637138097804650010451632153661994733536016427392831818754294662744543007759025992402965982617699020774651969755506626758290159115577988294806339034942230395292869389659871867239555');
  t('-0.20325165840739489878', 261, 1, '1.77547408850854089743198994679778700328968580104357495970002519071688653345045996210264749955429047077887716613197444286232868888314681933726192087753660062552179051596607259764994400604543771017200901564058205784756171450307745638796023879678104097658443152865');
  t('0.857414843516717240627', 278, 2, '0.54057124559153480250756402419679382562791635772938182739452725254706797441291141273149804905164659865734797480206355089220227651658135807741234396019513091627199800759787749579227670181272959419244872701919679455667810149411092491944694932281136030173068028369249503650823396519');
  t('-0.423524346905325485896185', 200, 6, '2.0081286274715512634849484937805659607728178462144990461598778928561649948317204157683509413265813598264596367547787485358622333336596704743401483897162382632056180971822839953638432758891580460517347');
  t('0.413005758679023316787848706252173623675061017446440007199455', 223, 5, '1.145044335076719558065541584128477329597355586178076311778094502014552803180480645530413043828985265166646826445662244803902880964228755136226705052251066453744827767134227184786929306022462501527822933967432962426330174114');
  t('0.60303396912878463481820757880149243536964122123', 74, 0, '0.92349733850886719511782404713538203887217672251996140824604328139845013166');
  t('-0.5009004854786', 269, 2, '2.0954352059408460514318026547309433198738255688061450644617174160314436547867283717629140442256930156388608876640976758377708167203988724854611214814544001386962797047563887209619201816436375743858810756575589094720903844577003117436991158536314585137130782865903593605');
  t('0.051982', 192, 2, '1.51879088794395444868710618321273480388836835436859563148267673127351041936037021104920053999562569315683939991260086992737535681210803545257257762676298776611312728382326725537299116519307078');
  t('0.6346406587004958214299660742336408318928652761581435881815894816', 193, 2, '0.8832528773049009261667990998627157166711351563781864065099463634933306183056548641126151808787129383294481781530192258364476994810649388254730407553512514399805136221571869647138857340680299531');
  t('0.5808863207143779486419360991243495310519417125497680874674241928465718557439232384069462701463652467773787097469591729677973812273202622932378878206677139017689899138902', 114, 3, '0.950979192071296118882561680089797212373025625430682323609489650779266948836074124065928224284024624698950727879061');
  t('0.6', 251, 5, '0.92729521800161223242851246292242880405707410857224052762186617744039572833148341060120056796977578511305970450238167502701163636325002231094306113988821124143867253232976020306500551197585161103370777833495647457307758783602503439896802791167637023019');
  t('0.329008830627035518820451', 176, 3, '1.2355425479656791188459013451665743465397529721125321299610420962095734449665049666456976063909031459823081837975455689839295482599636313257647464048053432262047441910829923808');
  t('0.31503731586271512953987', 175, 1, '1.250300355040444140384875969127128388865582776679385514007352971948442243497048855209710989127061157111853695806290441906793238123959427914022156720058162558731327402523044166');
  t('-0.07853007897317622293045558522251526660194271081717322978', 173, 6, '1.6494073460738196727474653405568328128478576667816496188558018754785734688662650493515246411034101302768235838373499639808407336300758786703980995090099910486541663777946303');
  */
});
