/* $Id: ID2_Reply_Data.hpp 534721 2017-05-01 18:13:51Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Reply_Data.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: ID2_Reply_Data_.hpp


#ifndef OBJECTS_ID2_ID2_REPLY_DATA_HPP
#define OBJECTS_ID2_ID2_REPLY_DATA_HPP


#include <corelib/reader_writer.hpp>

// generated includes
#include <objects/id2/ID2_Reply_Data_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2_Reply_Data : public CID2_Reply_Data_Base
{
    typedef CID2_Reply_Data_Base Tparent;
public:
    // constructor
    CID2_Reply_Data(void);
    // destructor
    ~CID2_Reply_Data(void);

private:
    // Prohibit copy constructor and assignment operator
    CID2_Reply_Data(const CID2_Reply_Data& value);
    CID2_Reply_Data& operator=(const CID2_Reply_Data& value);

};


class  NCBI_ID2_EXPORT COctetStringSequenceWriter : public IWriter
{
public:
    typedef vector<char> TOctetString;
    typedef CID2_Reply_Data::TData TOctetStringSequence;

    COctetStringSequenceWriter(TOctetStringSequence& out);
    virtual ERW_Result Write(const void* buffer,
                             size_t      count,
                             size_t*     written);
    virtual ERW_Result Flush(void);

private:
    TOctetStringSequence& m_Output;
};


/////////////////// CID2_Reply_Data inline methods

// constructor
inline
CID2_Reply_Data::CID2_Reply_Data(void)
{
}


/////////////////// end of CID2_Reply_Data inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REPLY_DATA_HPP
/* Original file checksum: lines: 86, chars: 2487, CRC32: bc64c4ad */
