/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.beans.*;
import java.io.File;
import java.net.MalformedURLException;
import org.netbeans.modules.xml.catalog.impl.sun.Catalog;
import static org.netbeans.modules.xml.catalog.impl.sun.res.Bundle.*;

/**
 * Catalog customizer. It allows to customize catalog location and
 * preferences.
 *
 * @author  Petr Kuzel
 * @version
 */
public class CatalogCustomizer extends javax.swing.JPanel implements Customizer {

    /** Serial Version UID */
    private static final long serialVersionUID =-1437233290256708364L;

    Catalog model = null;

    /** Creates new customizer XCatalogCustomizer */
    public CatalogCustomizer() {
        initComponents ();
        
        // A11Y
        this.getAccessibleContext().setAccessibleDescription(ACSD_CatalogCustomizer());
        
        locationLabel.setDisplayedMnemonic(CatalogCustomizer_locationLabel_mneString().charAt(0));
        locationTextField.getAccessibleContext().setAccessibleDescription(ACSD_locationTextField());

        preferCheckBox.setMnemonic(MNE_preference().charAt(0));
        preferCheckBox.getAccessibleContext().setAccessibleDescription(ACSD_preference());
        
        selectButton.setMnemonic(MNE_file().charAt(0));
        selectButton.getAccessibleContext().setAccessibleDescription(ACSD_file());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        locationLabel = new javax.swing.JLabel();
        locationTextField = new javax.swing.JTextField();
        selectButton = new javax.swing.JButton();
        preferCheckBox = new javax.swing.JCheckBox();
        descTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        locationLabel.setLabelFor(locationTextField);
        locationLabel.setText(CatalogCustomizer_locationLabel_text());
        add(locationLabel, new java.awt.GridBagConstraints());

        locationTextField.setColumns(40);
        locationTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                locationTextFieldActionPerformed(evt);
            }
        });
        locationTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                locationTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(locationTextField, gridBagConstraints);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/res/Bundle"); // NOI18N
        selectButton.setText(bundle.getString("PROP_choose_file")); // NOI18N
        selectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(selectButton, gridBagConstraints);

        preferCheckBox.setText(bundle.getString("LBL_preference")); // NOI18N
        preferCheckBox.setToolTipText(HINT_pp());
        preferCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                preferCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(preferCheckBox, gridBagConstraints);

        descTextArea.setEditable(false);
        descTextArea.setColumns(40);
        descTextArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        descTextArea.setForeground(new java.awt.Color(102, 102, 153));
        descTextArea.setLineWrap(true);
        descTextArea.setRows(4);
        descTextArea.setText(DESC_catalog_fmts());
        descTextArea.setWrapStyleWord(true);
        descTextArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(descTextArea, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void selectButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selectButtonActionPerformed
        File f = org.netbeans.modules.xml.catalog.lib.Util.selectCatalogFile("txt xml cat catalog"); // NOI18N
        if (f == null) return;
        try {
            String location = f.toURL().toExternalForm();
            locationTextField.setText(location);
            model.setLocation(location);
        } catch (MalformedURLException ex) {
            // ignore
        }
    }//GEN-LAST:event_selectButtonActionPerformed

    private void preferCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_preferCheckBoxStateChanged
        if (model != null) model.setPreferPublic(preferCheckBox.isSelected());
    }//GEN-LAST:event_preferCheckBoxStateChanged

    //!!! find out whether action performed is not enough
    
    private void locationTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_locationTextFieldFocusLost
        //if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("FocusLost-setting location: " + locationTextField.getText()); // NOI18N
        model.setLocation(locationTextField.getText());
    }//GEN-LAST:event_locationTextFieldFocusLost

    private void locationTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_locationTextFieldActionPerformed
        //if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("ActionPerformed-setting location: " + locationTextField.getText()); // NOI18N
        model.setLocation(locationTextField.getText());
    }//GEN-LAST:event_locationTextFieldActionPerformed

    /**
     * Set model for this customizer.
     */
    public void setObject(java.lang.Object peer) {
        if ((peer instanceof Catalog) == false) {
            throw new IllegalArgumentException("Catalog instance expected (" + peer.getClass() + ").");  // NOI18N
        }
        
        model = (Catalog) peer;        
        locationTextField.setText(model.getLocation());
        preferCheckBox.setSelected(model.isPreferPublic());
    }    

    public void addPropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    public void removePropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JTextField locationTextField;
    private javax.swing.JCheckBox preferCheckBox;
    private javax.swing.JButton selectButton;
    // End of variables declaration//GEN-END:variables

}
