package org.jboss.cache.commands.write;

import static org.easymock.EasyMock.expect;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * tester class for {@link RemoveKeyCommand}.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups = "unit")
public class RemoveKeyCommandTest extends AbstractVersionedDataCommandTest
{
   RemoveKeyCommand command;
   private String key;

   public AbstractVersionedDataCommand moreSetUp()
   {
      key = "key";
      command = new RemoveKeyCommand(globalTransaction, fqn, key);
      return command;
   }

   public void testNonexistentNode()
   {
      expect(container.peek(fqn, false, false)).andReturn(null);
      control.replay();
      assert null == command.perform(ctx);
      control.verify();
   }

   public void testRemoveNonexistentPair()
   {
      Map expected = new HashMap();
      expected.put("newKey", "newValue");
      nodes.adfgNode.putAll(expected);
      expect(container.peek(fqn, false, false)).andReturn(nodes.adfgNode);
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, ctx);
      expected = new HashMap();
      expected.put(key, null);
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, ctx);
      control.replay();
      assert null == command.perform(ctx);
      assert nodes.adfgNode.getData().size() == 1;
      assert "newValue".equals(nodes.adfgNode.getData().get("newKey"));
      control.verify();

      control.reset();
      expect(container.peek(fqn, false, true)).andReturn(nodes.adfgNode);
      control.replay();
      command.rollback();
      assert nodes.adfgNode.getData().size() == 1;
      assert "newValue".equals(nodes.adfgNode.getData().get("newKey"));
      control.verify();
   }

   public void testRemoveExistentPair()
   {
      Map expected = new HashMap();
      expected.put(key, "newValue");
      nodes.adfgNode.putAll(expected);
      expect(container.peek(fqn, false, false)).andReturn(nodes.adfgNode);
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, ctx);
      expect(notifier.shouldNotifyOnNodeModified()).andReturn(true);
      notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, ctx);
      control.replay();
      assert "newValue" == command.perform(ctx);
      assert nodes.adfgNode.getData().get(key) == null;
      control.verify();

      control.reset();
      expect(container.peek(fqn, false, true)).andReturn(nodes.adfgNode);
      control.replay();
      command.rollback();
      assert nodes.adfgNode.getData().size() == 1;
      assert "newValue".equals(nodes.adfgNode.getData().get(key));
      control.verify();
   }

   /**
    * On an no-op scenario the user will try to remove a key on an unexisting node.
    * When rollback is being called, the node might not exist in the cache and we should know how to handle that.
    */
   public void testRollbackOnNoOp()
   {
      expect(container.peek(fqn, false, true)).andReturn(null);
      control.replay();
      try
      {
         command.rollback();
      }
      catch (Exception ex)
      {
         assert false : "No exception should be thrown here.";
      }
   }
}
