/***************************************************************************
                           cfile.h  -  description
                             -------------------
    begin                : Wed Apr 3 2003
    copyright            : (C) 2003-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFILE_H
#define CFILE_H

/**
  *@author Mathias Küster
  *
  * Handles file reading and writing, with a write buffer.
  *
  * The Close() function used to not return any value and
  * the return value from close() was not checked. Nothing
  * much actually checks if Close() returns true or not,
  * even though write errors may not be reported until
  * the file is closed, says the man page.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

#define IO_RAW			0x0001
#define IO_READONLY		0x0002
#define IO_WRITEONLY		0x0004
#define IO_READWRITE		0x0008
#define IO_APPEND		0x0010
#define IO_TRUNCATE		0x0020
#define IO_CREAT		0x0040

#define MO_IRWXU 0x01C0    /* RWX mask for owner */
#define MO_IRUSR 0x0100    /* R for owner */
#define MO_IWUSR 0x0080    /* W for owner */
#define MO_IXUSR 0x0040    /* X for owner */

#define MO_IRWXG 0x0038    /* RWX mask for group */
#define MO_IRGRP 0x0020    /* R for group */
#define MO_IWGRP 0x0010    /* W for group */
#define MO_IXGRP 0x0008    /* X for group */

#define MO_IRWXO 0x0007    /* RWX mask for other */
#define MO_IROTH 0x0004    /* R for other */
#define MO_IWOTH 0x0002    /* W for other */
#define MO_IXOTH 0x0001    /* X for other */

class CByteArray;

class CFile {

public:
	/** */
	CFile();
	/** */
	~CFile();

	/** */
	bool Open( CString filename, int mode, int acc = 0 );
	/**
	 * Creates and opens a temp file, name based on supplied filename.
	 * If successful, filename will be set to the temp file name.
	 * The new name will have a dot and some numbers/letters added.
	 */
	bool OpenTemp( CString & filename );
	/** */
	bool IsOpen() { return (m_nFD!=-1); };
	/** */
	bool Close();
	/** */
	long Flush();
	/** */
	static bool Rename( const CString & absfrom, const CString & absto );
	/** */
	static bool Remove( const CString & absfile );
	/** */
	static bool UnLink( const CString & absfile );
	/**
	 * Copies the contents of absfrom to absto.
	 * Since dclib only needs to copy files it created
	 * there's no copying of ownership / permissions.
	 * Since dclib only copies files it has just finished writing,
	 * and utimes() only sets last access and modification times
	 * not creation time, there's no setting of timestamps either.
	 */
	static bool Copy( const CString & absfrom, const CString & absto );
	/** */
	long Write( const char * buf, long count );
	/** */
	long Read( char * buf, long count );
	/** */
	bool Seek( int64_t offset, int how );
	/** */
	int GetBufferPos() { return m_nBufferPos; };

private:
	/** */
	int m_nFD;
	/** */
	int m_nMode;
	/** */
	CByteArray * m_pBuffer;
	/** */
	int m_nBufferPos;
};

#endif
