---
date: 2015-12-16T09:24:56-07:00
title: "hugo server"
slug: hugo_server
url: /commands/hugo_server/
---
## hugo server

A high performance webserver

### Synopsis


Hugo provides its own webserver which builds and serves the site.
While hugo server is high performance, it is a webserver with limited options.
Many run it in production, but the standard behavior is for people to use it
in development and use a more full featured server such as Nginx or Caddy.

'hugo server' will avoid writing the rendered and served content to disk,
preferring to store it in memory.

By default hugo will also watch your files for any changes you make and
automatically rebuild the site. It will then live reload any open browser pages
and push the latest content to them. As most Hugo sites are built in a fraction
of a second, you will be able to save and see your changes nearly instantly.

```
hugo server
```

### Options

```
      --appendPort[=true]: append port to baseurl
  -b, --baseURL="": hostname (and path) to the root, e.g. http://spf13.com/
      --bind="127.0.0.1": interface to which the server will bind
  -D, --buildDrafts[=false]: include content marked as draft
  -F, --buildFuture[=false]: include content with publishdate in the future
      --cacheDir="": filesystem path to cache directory. Defaults: $TMPDIR/hugo_cache/
      --canonifyURLs[=false]: if true, all relative URLs will be canonicalized using baseURL
      --config="": config file (default is path/config.yaml|json|toml)
  -d, --destination="": filesystem path to write files to
      --disableLiveReload[=false]: watch without enabling live browser reload on rebuild
      --disableRSS[=false]: Do not build RSS files
      --disableSitemap[=false]: Do not build Sitemap file
      --editor="": edit new content with this editor, if provided
      --ignoreCache[=false]: Ignores the cache directory for reading but still writes to it
      --meminterval=100: interval to poll memory usage (requires --memstats)
      --memstats="": log memory usage to this file
      --noTimes[=false]: Don't sync modification time of files
      --pluralizeListTitles[=true]: Pluralize titles in lists using inflect
  -p, --port=1313: port on which the server will listen
      --preserveTaxonomyNames[=false]: Preserve taxonomy names as written ("Gérard Depardieu" vs "gerard-depardieu")
      --renderToDisk[=false]: render to Destination path (default is render to memory & serve from there)
  -s, --source="": filesystem path to read files relative from
      --stepAnalysis[=false]: display memory and timing of different steps of the program
  -t, --theme="": theme to use (located in /themes/THEMENAME/)
      --uglyURLs[=false]: if true, use /filename.html instead of /filename/
  -w, --watch[=true]: watch filesystem for changes and recreate as needed
```

### Options inherited from parent commands

```
      --log[=false]: Enable Logging
      --logFile="": Log File path (if set, logging enabled automatically)
  -v, --verbose[=false]: verbose output
      --verboseLog[=false]: verbose logging
```

### SEE ALSO
* [hugo](/commands/hugo/)	 - hugo builds your site

###### Auto generated by spf13/cobra on 16-Dec-2015
