/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.BlockQuote;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Para;

public class BlockquoteEditor extends Editor {

    @Override
	public EditorInstruction edit(EditorInstruction values) throws EditorException {

	setValues(super.edit(values));
	DocBookTagFactory dbfactory = values.getTagFactory();

	BlockQuote blockquote = dbfactory.createBlockQuote();

	DocBookElement parent = getParent();

	parent.appendChild(blockquote);
	blockquote.setParentNode(parent);

	Para para = dbfactory.createPara();

	blockquote.appendChild(para);
	para.setParentNode(blockquote);

	setCurrent(para);
	traverse(true);

	return finalizeValues();
    }
}
