/****************************************************************************
 *    lib/c/Arguments.h - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef ARGUMENTS_H
#define ARGUMENTS_H

#include <string>
#include <set>
#include "Variable.h"
#include "Constant.h"
#include "Pool.h"
#include "Interval.h"
#include "Function.h"
#include "Printer.h"

namespace C {

class Arguments
{
public:
	Arguments(Variable* variable);
	Arguments(Constant* constant);
	Arguments(Pool* pool);
	Arguments(Interval* interval);
	Arguments(Function* function);
	
	virtual ~Arguments ( );

	string print(Printer* p = NULL);

	/**
	 * @return vector<Variable*>
	 */
	set<Variable*>* getVariables();

	void addVariable(Variable* var);
	void addConstant(Constant* con);
	void addPool(Pool* pool);
	void addInterval(Interval* interval);
	void addFunction(Function* function);
	void setMin(int);
	void setMax(int);
	int getMin();
	int getMax();

	vector<Term*>* getArgs();
	
private:
	vector<Term*> args_;
	int min_;
	int max_;

};
}; // end of package namespace

#endif // ARGUMENTS_H
