# print notification about required overlays when building Gentoo packages
# USAGE: information_required_gentoo_overlays $overlays
information_required_gentoo_overlays() {
	local overlays_file
	overlays_file=$(dependency_gentoo_overlays_file)

	local message
	case "${LANG%_*}" in
		('fr')
			message='Vous pourriez avoir besoin des overlays suivants pour installer ces paquets :'
		;;
		('en'|*)
			message='You may need the following overlays to install these packages:'
		;;
	esac
	print_message 'info' '\n%s\n' \
		"$message"
	print_message 'info' '\t%s\n' \
		"$(cat "$overlays_file")"
}

# add comment to packages installation instructions on Gentoo
# USAGE: information_installation_instructions_gentoo_comment
information_installation_instructions_gentoo_comment() {
	local message
	case "${LANG%_*}" in
		('fr')
			message='ou mettez les paquets dans un PKGDIR (dans un dossier nommé games-playit) et emergez-les'
		;;
		('en'|*)
			message='or put the packages in a PKGDIR (in a folder named games-playit) and emerge them'
		;;
	esac
	print_message 'info' "$message"
}

# inform the need of a local overlay on gentoo for ebuilds
# USAGE: info_local_overlay_gentoo
info_local_overlay_gentoo() {
	local message
	case "${LANG%_*}" in
		('fr')
			message='\nUn overlay local est nécessaire pour utiliser les ebuilds générés par ./play.it\n'
			message="$message"'Dans la suite OVERLAY_PATH correspond au chemin de votre overlay local\n'
		;;
		('en'|*)
			message='\nA local overlay is needed to use the ebuilds generated by ./play.it\n'
			message="$message"'In what comes next, OVERLAY_PATH is the path to your local overlay\n'
		;;
	esac
	print_message 'info' "$message"
}

# inform the need to move the packages to a distfile on egentoo
# USAGE: info_package_to_distfiles
info_package_to_distfiles() {
	local message
	case "${LANG%_*}" in
		('fr')
			message='Déplacez les paquets créés dans votre disfile\n'
			message="$message"'puis exécutez les instructions suivantes :\n'
			;;
		('en'|*)
			message='Move the generated packages into your distfile\n'
			message="$message"'then run the following commands:\n'
			;;
	esac
	print_message 'info' "$message"
}

# Error - An unknown architecture string is used
# USAGE: error_unknown_gentoo_architecture_string $arch_string $caller
error_unknown_gentoo_architecture_string() {
	local arch_string caller
	arch_string="$1"
	caller="$2"

	local message
	case "${LANG%_*}" in
		('fr')
			message='Lʼarchitecture « %s », utilisée dans %s, est inconnue sous Gentoo.\n'
			;;
		('en'|*)
			message='“%s” architecture, used in %s, is unknown on Gentoo.\n'
			;;
	esac
	print_message 'error' "$message" \
		"$arch_string" \
		"$caller"
}

