#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Jazz Jackrabbit 2
###

script_version=20231016.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='jazz-jackrabbit-2'
GAME_NAME='Jazz Jackrabbit 2'

GAME_ID_CHRISTMAS="${GAME_ID}-the-christmas-chronicles"
GAME_NAME_CHRISTMAS="$GAME_NAME - The Christmas Chronicles"

# Game archives

## Jazz Jackrabbit 2 (including The Secret Files)

ARCHIVE_BASE_JJ2PLUS_0_NAME='setup_jazz_jackrabbit_2_1.24_jj2_(5.9)_(46861).exe'
ARCHIVE_BASE_JJ2PLUS_0_MD5='94f8477d51e35b4cdc6b3d999b502580'
ARCHIVE_BASE_JJ2PLUS_0_TYPE='innosetup'
ARCHIVE_BASE_JJ2PLUS_0_SIZE='78000'
ARCHIVE_BASE_JJ2PLUS_0_VERSION='1.24-gog46861'
ARCHIVE_BASE_JJ2PLUS_0_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

ARCHIVE_BASE_0_NAME='setup_jazz_jackrabbit_2_1.24hf_(16886).exe'
ARCHIVE_BASE_0_MD5='48a48258ed60b24068cbbb2f110b049b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='67000'
ARCHIVE_BASE_0_VERSION='1.24-gog16886'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

## Jazz Jackrabbit 2 - The Christmas Chronicles

ARCHIVE_BASE_CHRISTMAS_0_NAME='setup_jazz_jackrabbit_2_cc_1.2x_(16742).exe'
ARCHIVE_BASE_CHRISTMAS_0_MD5='3289263ea6bad8bc35f02176e22109f2'
ARCHIVE_BASE_CHRISTMAS_0_TYPE='innosetup'
ARCHIVE_BASE_CHRISTMAS_0_SIZE='70000'
ARCHIVE_BASE_CHRISTMAS_0_VERSION='1.2x-gog16742'
ARCHIVE_BASE_CHRISTMAS_0_URL='https://www.gog.com/game/jazz_jackrabbit_2_collection'

## Jazz² Resurrection (native engine)

ARCHIVE_OPTIONAL_JAZZ2NATIVE_0_NAME='Jazz2_1.0.0_Linux.zip'
ARCHIVE_OPTIONAL_JAZZ2NATIVE_0_MD5='868ce9ac55ee3a085eed5503d7647a67'
ARCHIVE_OPTIONAL_JAZZ2NATIVE_0_SIZE='8000'
ARCHIVE_OPTIONAL_JAZZ2NATIVE_0_URL='http://deat.tk/jazz2/'

# Archives content

## Jazz Jackrabbit 2

CONTENT_PATH_DEFAULT='app'
CONTENT_PATH_DEFAULT_JJ2PLUS='.'
CONTENT_GAME_BIN_WINE_FILES='
jcs.ini-plus
plus.ini-default
*.dll
*.exe
*.ini'
CONTENT_GAME_DATA_FILES='
html
jcshelp
tiles
userlevels
*.asc
*.it
*.j2?
*.j2as
*.mo3
*.mod
*.mut
*.pal
*.s3m
*.wav'
CONTENT_DOC_DATA_FILES='
*.doc
*.html
*.pdf
*.txt'

## Jazz² Resurrection

CONTENT_GAME_BIN_NATIVE_PATH='64-bit'
CONTENT_GAME_BIN_NATIVE_FILES='
Content
jazz2
jazz2_clang
jazz2_sdl2'


USER_PERSISTENT_FILES='
SAVEGAME.*
*.cfg
*.CFG
*.ini'

## WINE only - Work around a crash on level launch
WINE_WINETRICKS_VERBS='winxp'

APP_WINE_EXE='jazz2.exe'

APP_NATIVE_EXE='jazz2'
APP_NATIVE_PRERUN='# Jazz² Resurrection engine expects the original game data to be found in "Source".
# A hard copy is done, because the engine is confused by symbolic links.
if [ ! -e "Source" ]; then
	mkdir "Source"
	cp --recursive "$PATH_GAME"/* "Source"
fi
'

PACKAGES_LIST='PKG_BIN_WINE PKG_DATA'
PACKAGES_LIST_NATIVE='PKG_BIN_WINE PKG_BIN_NATIVE PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_CHRISTMAS="${GAME_ID_CHRISTMAS}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="${GAME_ID}-bin"
PKG_BIN_ID_CHRISTMAS="${GAME_ID_CHRISTMAS}-bin"

PKG_BIN_WINE_ID="${PKG_BIN_ID}-wine"
PKG_BIN_WINE_ID_CHRISTMAS="${PKG_BIN_ID_CHRISTMAS}-wine"
PKG_BIN_WINE_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_WINE_PROVIDES_CHRISTMAS="
$PKG_BIN_ID_CHRISTMAS"
PKG_BIN_WINE_ARCH='32'
PKG_BIN_WINE_DEPS="$PKG_DATA_ID"
PKG_BIN_WINE_DEPS_CHRISTMAS="$PKG_DATA_ID_CHRISTMAS"

PKG_BIN_NATIVE_ID="${PKG_BIN_ID}-native"
PKG_BIN_NATIVE_ID_CHRISTMAS="${PKG_BIN_ID_CHRISTMAS}-native"
PKG_BIN_NATIVE_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_NATIVE_PROVIDES_CHRISTMAS="
$PKG_BIN_ID_CHRISTMAS"
PKG_BIN_NATIVE_ARCH='64'
PKG_BIN_NATIVE_DEPS="$PKG_DATA_ID"
PKG_BIN_NATIVE_DEPS_CHRISTMAS="$PKG_DATA_ID_CHRISTMAS"
PKG_BIN_NATIVE_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libGLEW.so.2.2
libglfw.so.3
libGL.so.1
libGLX.so.0
libICE.so.6
libm.so.6
libopenal.so.1
libOpenGL.so.0
libopenmpt.so.0
libSDL2-2.0.so.0
libSM.so.6
libstdc++.so.6
libX11.so.6
libXext.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of required extra archives

archive_initialize_optional \
	'ARCHIVE_JAZZ2NATIVE' \
	'ARCHIVE_OPTIONAL_JAZZ2NATIVE_0'
if archive_is_available 'ARCHIVE_JAZZ2NATIVE'; then
	export PACKAGES_LIST="$PACKAGES_LIST_NATIVE"
fi

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Delete unwanted files
	rm --force --recursive \
		'__support' \
		'commonappdata' \
		'tmp'
)
if archive_is_available 'ARCHIVE_JAZZ2NATIVE'; then
	archive_extraction 'ARCHIVE_JAZZ2NATIVE'
fi

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion 'APP_WINE'
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN_WINE'
launchers_write 'APP_WINE'
if archive_is_available 'ARCHIVE_JAZZ2NATIVE'; then
	set_current_package 'PKG_BIN_NATIVE'
	launchers_write 'APP_NATIVE'
fi

# Build packages

packages_generation
printf '\n'
printf 'WINE:'
print_instructions 'PKG_DATA' 'PKG_BIN_WINE'
if archive_is_available 'ARCHIVE_JAZZ2NATIVE'; then
	printf 'Jazz² Resurrection:'
	print_instructions 'PKG_DATA' 'PKG_BIN_NATIVE'
fi

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
