#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grim Dawn expansions:
# - Ashes of Malmouth
# - Forgotten Gods
###

script_version=20231211.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='grim-dawn'
GAME_NAME='Grim Dawn'

EXPANSION_ID_ASHES='ashes-of-malmouth'
EXPANSION_NAME_ASHES='Ashes of Malmouth'

EXPANSION_ID_GODS='forgotten-gods'
EXPANSION_NAME_GODS='Forgotten Gods'

# Archives

## Ashes of Malmouth

ARCHIVE_BASE_ASHES_3_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.3_hotfix_3_(69499).exe'
ARCHIVE_BASE_ASHES_3_MD5='921796d60998467c4c753d80f99a6584'
ARCHIVE_BASE_ASHES_3_TYPE='innosetup'
ARCHIVE_BASE_ASHES_3_PART1_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.3_hotfix_3_(69499)-1.bin'
ARCHIVE_BASE_ASHES_3_PART1_MD5='618cfba9ba745a2d3fd6e5b9ae744cb2'
ARCHIVE_BASE_ASHES_3_SIZE='2510332'
ARCHIVE_BASE_ASHES_3_VERSION='1.2.0.3-gog69499'
ARCHIVE_BASE_ASHES_3_URL='https://www.gog.com/game/grim_dawn_ashes_of_malmouth'

ARCHIVE_BASE_ASHES_2_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.2_hotfix_2_(69134).exe'
ARCHIVE_BASE_ASHES_2_MD5='49194993f6649141ac9f118d61eb8f90'
ARCHIVE_BASE_ASHES_2_TYPE='innosetup'
ARCHIVE_BASE_ASHES_2_PART1_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.2_hotfix_2_(69134)-1.bin'
ARCHIVE_BASE_ASHES_2_PART1_MD5='798f63fd270edfdac9938fd77d73752c'
ARCHIVE_BASE_ASHES_2_SIZE='2509140'
ARCHIVE_BASE_ASHES_2_VERSION='1.2.0.2-gog69134'

ARCHIVE_BASE_ASHES_1_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.1_hotfix_1_(69098).exe'
ARCHIVE_BASE_ASHES_1_MD5='f8935c6d6ca9c354a9336d51efd823f9'
ARCHIVE_BASE_ASHES_1_TYPE='innosetup'
ARCHIVE_BASE_ASHES_1_PART1_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.2.0.1_hotfix_1_(69098)-1.bin'
ARCHIVE_BASE_ASHES_1_PART1_MD5='c2e7bd56299023afa261d43fb89a43f7'
ARCHIVE_BASE_ASHES_1_SIZE='2507692'
ARCHIVE_BASE_ASHES_1_VERSION='1.2.0.1-gog69098'

ARCHIVE_BASE_ASHES_0_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.1.9.8_(65199).exe'
ARCHIVE_BASE_ASHES_0_MD5='0754f567005ecc7d758d905992e5d7f7'
ARCHIVE_BASE_ASHES_0_TYPE='innosetup'
ARCHIVE_BASE_ASHES_0_PART1_NAME='setup_grim_dawn_-_ashes_of_malmouth_1.1.9.8_(65199)-1.bin'
ARCHIVE_BASE_ASHES_0_PART1_MD5='49bc0c617d4ab9415298994ba4a085b8'
ARCHIVE_BASE_ASHES_0_SIZE='2506744'
ARCHIVE_BASE_ASHES_0_VERSION='1.1.9.8-gog65199'

## Forgotten Gods

ARCHIVE_BASE_GODS_3_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.3_hotfix_3_(69499).exe'
ARCHIVE_BASE_GODS_3_MD5='75b0ed8db6996ae3b5fb4df2177b8507'
ARCHIVE_BASE_GODS_3_TYPE='innosetup'
ARCHIVE_BASE_GODS_3_PART1_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.3_hotfix_3_(69499)-1.bin'
ARCHIVE_BASE_GODS_3_PART1_MD5='a0c5c5a18b150c8349d247c593fb71d5'
ARCHIVE_BASE_GODS_3_SIZE='3220424'
ARCHIVE_BASE_GODS_3_VERSION='1.2.0.3-gog69499'
ARCHIVE_BASE_GODS_3_URL='https://www.gog.com/game/grim_dawn_forgotten_gods'

ARCHIVE_BASE_GODS_2_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.2_hotfix_2_(69134).exe'
ARCHIVE_BASE_GODS_2_MD5='3506b7cfcbb6b475b8c182024932d332'
ARCHIVE_BASE_GODS_2_TYPE='innosetup'
ARCHIVE_BASE_GODS_2_PART1_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.2_hotfix_2_(69134)-1.bin'
ARCHIVE_BASE_GODS_2_PART1_MD5='40b9f598aa048680c9f7dc4651b99d71'
ARCHIVE_BASE_GODS_2_SIZE='3220892'
ARCHIVE_BASE_GODS_2_VERSION='1.2.0.2-gog691341'

ARCHIVE_BASE_GODS_1_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.1_hotfix_1_(69098).exe'
ARCHIVE_BASE_GODS_1_MD5='f0809d0007e3e3634b24dcdbf2bf25fd'
ARCHIVE_BASE_GODS_1_TYPE='innosetup'
ARCHIVE_BASE_GODS_1_PART1_NAME='setup_grim_dawn_-_forgotten_gods_1.2.0.1_hotfix_1_(69098)-1.bin'
ARCHIVE_BASE_GODS_1_PART1_MD5='82c069ab14fcec774fb075706fa3cce1'
ARCHIVE_BASE_GODS_1_SIZE='3218872'
ARCHIVE_BASE_GODS_1_VERSION='1.2.0.1-gog69098'

ARCHIVE_BASE_GODS_0_NAME='setup_grim_dawn_-_forgotten_gods_1.1.9.8_(65199).exe'
ARCHIVE_BASE_GODS_0_MD5='6615eb32a355092c4d0173457f701e31'
ARCHIVE_BASE_GODS_0_TYPE='innosetup'
ARCHIVE_BASE_GODS_0_PART1_NAME='setup_grim_dawn_-_forgotten_gods_1.1.9.8_(65199)-1.bin'
ARCHIVE_BASE_GODS_0_PART1_MD5='55ac480dee30aa6cfa6a8b466f521406'
ARCHIVE_BASE_GODS_0_SIZE='3220672'
ARCHIVE_BASE_GODS_0_VERSION='1.1.9.8-gog65199'


CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
gdx?
survivalmode?'

PKG_MAIN_DEPS="$GAME_ID"
PKG_MAIN_DEPS_GODS="${PKG_MAIN_DEPS:-} ${GAME_ID}-${EXPANSION_ID_ASHES}"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
