/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    public ResourcePropertySource(String name, Resource resource) throws IOException {
        super(name, ResourcePropertySource.loadPropertiesForResource(resource));
    }

    public ResourcePropertySource(Resource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource), resource);
    }

    public ResourcePropertySource(String name, String location, ClassLoader classLoader) throws IOException {
        this(name, ResourcePropertySource.getResourceForLocation(location, classLoader));
    }

    public ResourcePropertySource(String name, String location) throws IOException {
        this(name, location, ClassUtils.getDefaultClassLoader());
    }

    public ResourcePropertySource(String location, ClassLoader classLoader) throws IOException {
        this(ResourcePropertySource.getResourceForLocation(location, classLoader));
    }

    public ResourcePropertySource(String location) throws IOException {
        this(ResourcePropertySource.getResourceForLocation(location, ClassUtils.getDefaultClassLoader()));
    }

    private static Resource getResourceForLocation(String location, ClassLoader classLoader) {
        return new PathMatchingResourcePatternResolver(classLoader).getResource(location);
    }

    private static Properties loadPropertiesForResource(Resource resource) throws IOException {
        Properties props = new Properties();
        InputStream is = resource.getInputStream();
        props.load(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private static String getNameForResource(Resource resource) {
        String name = resource.getDescription();
        if (!StringUtils.hasText(name)) {
            name = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
        }
        return name;
    }
}

