/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.aiff.ExtDouble;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;

public class ADump
extends Dump {
    private static final int[] sigByte = new int[]{70, 79, 82, 77};
    private static final boolean ENDIAN = true;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: java ADump file");
            System.exit(-1);
        }
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            ADump aDump = new ADump();
            long l = 0L;
            for (int i = 0; i < 4; ++i) {
                int n2 = dataInputStream.readUnsignedByte();
                if (n2 == sigByte[i]) continue;
                System.out.println("No AIFF FORM header");
                System.exit(-2);
            }
            l += 4L;
            long l2 = ModuleBase.readUnsignedInt(dataInputStream, true);
            StringBuffer stringBuffer = new StringBuffer(4);
            for (n = 0; n < 4; ++n) {
                int n3 = ModuleBase.readUnsignedByte(dataInputStream);
                stringBuffer.append((char)n3);
            }
            System.out.println("00000000: FORM " + l2 + ": " + stringBuffer);
            n = 0;
            if (stringBuffer.toString().equals("AIFC")) {
                n = 1;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            while (!bl) {
                try {
                    long l3;
                    int n4;
                    stringBuffer2.setLength(0);
                    for (int i = 0; i < 4; ++i) {
                        int n5 = ModuleBase.readUnsignedByte(dataInputStream);
                        stringBuffer2.append((char)n5);
                    }
                    String string = stringBuffer2.toString();
                    l2 = ModuleBase.readUnsignedInt(dataInputStream, true);
                    System.out.print(ADump.leading(l, 8) + l + ": " + string + " " + l2);
                    long l4 = 0L;
                    if (string.equals("AESD")) {
                        int n6;
                        int[] nArray = new int[24];
                        for (n6 = 0; n6 < 24; ++n6) {
                            nArray[n6] = ModuleBase.readUnsignedByte(dataInputStream);
                        }
                        System.out.print(": " + nArray[0]);
                        for (n6 = 1; n6 < 24; ++n6) {
                            System.out.print("," + nArray[n6]);
                        }
                        l4 = 24L;
                    } else if (string.equals("ANNO") || string.equals("AUTH") || string.equals("(c) ") || string.equals("NAME")) {
                        stringBuffer2.setLength(0);
                        int n7 = 0;
                        while ((long)n7 < l2) {
                            int n8 = ModuleBase.readUnsignedByte(dataInputStream);
                            stringBuffer2.append((char)n8);
                            ++n7;
                        }
                        System.out.print(": \"" + stringBuffer2.toString() + "\"");
                        l4 = l2;
                    } else if (string.equals("APPL")) {
                        stringBuffer2.setLength(0);
                        for (int i = 0; i < 4; ++i) {
                            int n9 = ModuleBase.readUnsignedByte(dataInputStream);
                            stringBuffer2.append((char)n9);
                        }
                        System.out.print(": " + stringBuffer2.toString());
                        l4 = 4L;
                    } else if (string.equals("COMM")) {
                        int n10 = ModuleBase.readSignedShort(dataInputStream, true);
                        long l5 = ModuleBase.readUnsignedInt(dataInputStream, true);
                        n4 = ModuleBase.readSignedShort(dataInputStream, true);
                        byte[] byArray = new byte[10];
                        for (int i = 0; i < 10; ++i) {
                            byArray[i] = (byte)ModuleBase.readSignedByte(dataInputStream);
                        }
                        ExtDouble extDouble = new ExtDouble(byArray);
                        double d = extDouble.toDouble();
                        System.out.print(": " + n10 + " " + l5 + " " + n4 + " " + d);
                        l4 = 18L;
                        if (n != 0) {
                            int n11;
                            int n12;
                            stringBuffer2.setLength(0);
                            for (n12 = 0; n12 < 4; ++n12) {
                                n11 = ModuleBase.readUnsignedByte(dataInputStream, null);
                                stringBuffer2.append((char)n11);
                            }
                            System.out.print(" " + stringBuffer2.toString());
                            n12 = ModuleBase.readUnsignedByte(dataInputStream, null);
                            l4 = 23L;
                            stringBuffer2.setLength(0);
                            for (n11 = 0; n11 < n12; ++n11) {
                                int n13 = ModuleBase.readUnsignedByte(dataInputStream, null);
                                stringBuffer2.append((char)n13);
                                ++l4;
                            }
                            System.out.print(" \"" + stringBuffer2.toString() + "\"");
                        }
                    } else if (string.equals("COMT")) {
                        int n14 = ModuleBase.readUnsignedShort(dataInputStream, true, null);
                        System.out.print(": " + n14);
                        l4 = 2L;
                    } else if (string.equals("FVER")) {
                        l3 = ModuleBase.readUnsignedInt(dataInputStream, true, null);
                        System.out.print(": " + l3);
                        l4 = 4L;
                    } else if (string.equals("INST")) {
                        int n15 = ModuleBase.readSignedByte(dataInputStream);
                        int n16 = ModuleBase.readSignedByte(dataInputStream);
                        int n17 = ModuleBase.readSignedByte(dataInputStream);
                        n4 = ModuleBase.readSignedByte(dataInputStream);
                        int n18 = ModuleBase.readSignedByte(dataInputStream);
                        int n19 = ModuleBase.readSignedByte(dataInputStream);
                        int n20 = ModuleBase.readSignedShort(dataInputStream, true);
                        System.out.print(": " + n15 + " " + n16 + " " + n17 + "," + n4 + " " + n18 + "," + n19 + " " + n20);
                        l4 = 8L;
                    } else if (string.equals("MARK")) {
                        int n21 = ModuleBase.readUnsignedShort(dataInputStream, true);
                        System.out.print(": " + n21);
                        l4 = 2L;
                    } else if (string.equals("SSND")) {
                        l3 = ModuleBase.readUnsignedInt(dataInputStream, true);
                        long l6 = ModuleBase.readUnsignedInt(dataInputStream, true);
                        System.out.print(": " + l3 + " " + l6);
                        l4 = 8L;
                    }
                    System.out.println();
                    l3 = l2;
                    if ((l3 & 1L) != 0L) {
                        ++l3;
                    }
                    dataInputStream.skipBytes((int)(l3 -= l4));
                    l += l2 + 8L;
                }
                catch (EOFException eOFException) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

