/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.dependencyanalyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DependencyAnalyzerOutputLoader {
    private final Properties dependencyAnalyzerResults = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyAnalyzerOutputLoader(String dependencyAnalyzerOutputFileName) {
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(new File(dependencyAnalyzerOutputFileName));
            this.dependencyAnalyzerResults.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error loading dependency analyzer output file %s. Error was: %s", dependencyAnalyzerOutputFileName, e.getMessage()));
        }
    }

    public boolean classHasDependencies(String className) {
        String classResult = this.dependencyAnalyzerResults.getProperty(className);
        if (classResult == null) {
            throw new IllegalArgumentException(String.format("Class %s not present in the dependency analyzer results.", className));
        }
        return Boolean.parseBoolean(classResult);
    }

    public List<Boolean> classesHaveDependencies(List<String> classNames) {
        ArrayList<Boolean> classResults = new ArrayList<Boolean>(classNames.size());
        for (String className : classNames) {
            classResults.add(this.classHasDependencies(className));
        }
        return classResults;
    }
}

