/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryWriter;

public class DataEntryRewriter
extends DataEntryCopier {
    private final ClassPool classPool;
    private final Charset charset;

    public DataEntryRewriter(ClassPool classPool, Charset charset, DataEntryWriter dataEntryWriter) {
        super(dataEntryWriter);
        this.classPool = classPool;
        this.charset = charset;
    }

    @Override
    protected void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charset));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset));
        this.copyData(bufferedReader, bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    protected void copyData(Reader reader, Writer writer) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) >= 0) {
            char c = (char)n;
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') {
                stringBuffer.append(c);
                continue;
            }
            this.writeUpdatedWord(writer, stringBuffer.toString());
            stringBuffer.setLength(0);
            writer.write(c);
        }
        this.writeUpdatedWord(writer, stringBuffer.toString());
    }

    private void writeUpdatedWord(Writer writer, String string) throws IOException {
        if (string.length() > 0) {
            String string2;
            String string3 = string;
            boolean bl = string.indexOf(46) >= 0;
            String string4 = bl ? string.replace('.', '/') : string;
            Clazz clazz = this.classPool.getClass(string4);
            if (clazz != null && !string4.equals(string2 = clazz.getName())) {
                string3 = bl ? string2.replace('/', '.') : string2;
            }
            writer.write(string3);
        }
    }
}

