/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.refseq;

import java.util.ArrayList;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.refseq.RefSeqFeature;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class RefSeqCodec
extends AsciiFeatureCodec<RefSeqFeature>
implements ReferenceDependentFeatureCodec {
    private GenomeLocParser genomeLocParser;
    private boolean zero_coding_length_user_warned = false;

    public RefSeqCodec() {
        super(RefSeqFeature.class);
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    public Feature decodeLoc(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        String[] fields = line.split("\t");
        if (fields.length < 3) {
            throw new TribbleException("RefSeq (decodeLoc) : Unable to parse line -> " + line + ", we expected at least 3 columns, we saw " + fields.length);
        }
        String contig_name = fields[2];
        try {
            return new RefSeqFeature(this.genomeLocParser.createGenomeLoc(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        }
        catch (UserException.MalformedGenomeLoc e) {
            Utils.warnUser("RefSeq file is potentially incorrect, as some transcripts or exons have a negative length (" + fields[2] + ")");
            return null;
        }
        catch (NumberFormatException e) {
            throw new UserException.MalformedFile("Could not parse location from line: " + line);
        }
    }

    public RefSeqFeature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        String[] fields = line.split("\t");
        if (fields.length < 16) {
            throw new TribbleException("RefSeq (decode) : Unable to parse line -> " + line + ", we expected at least 16 columns, we saw " + fields.length);
        }
        String contig_name = fields[2];
        RefSeqFeature feature = new RefSeqFeature(this.genomeLocParser.createGenomeLoc(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        feature.setTranscript_id(fields[1]);
        if (fields[3].length() == 1 && fields[3].charAt(0) == '+') {
            feature.setStrand(1);
        } else if (fields[3].length() == 1 && fields[3].charAt(0) == '-') {
            feature.setStrand(-1);
        } else {
            throw new UserException.MalformedFile("Expected strand symbol (+/-), found: " + fields[3] + " for line=" + line);
        }
        int coding_start = Integer.parseInt(fields[6]) + 1;
        int coding_stop = Integer.parseInt(fields[7]);
        if (coding_start > coding_stop) {
            if (!this.zero_coding_length_user_warned) {
                Utils.warnUser("RefSeq file contains transcripts with zero coding length. Such transcripts will be ignored (this warning is printed only once)");
                this.zero_coding_length_user_warned = true;
            }
            return null;
        }
        feature.setTranscript_interval(this.genomeLocParser.createGenomeLoc(contig_name, Integer.parseInt(fields[4]) + 1, Integer.parseInt(fields[5])));
        feature.setTranscript_coding_interval(this.genomeLocParser.createGenomeLoc(contig_name, coding_start, coding_stop));
        feature.setGene_name(fields[12]);
        String[] exon_starts = fields[9].split(",");
        String[] exon_stops = fields[10].split(",");
        String[] eframes = fields[15].split(",");
        if (exon_starts.length != exon_stops.length) {
            throw new UserException.MalformedFile("Data format error: numbers of exon start and stop positions differ for line=" + line);
        }
        if (exon_starts.length != eframes.length) {
            throw new UserException.MalformedFile("Data format error: numbers of exons and exon frameshifts differ for line=" + line);
        }
        ArrayList<GenomeLoc> exons = new ArrayList<GenomeLoc>(exon_starts.length);
        ArrayList<Integer> exon_frames = new ArrayList<Integer>(eframes.length);
        for (int i = 0; i < exon_starts.length; ++i) {
            exons.add(this.genomeLocParser.createGenomeLoc(contig_name, Integer.parseInt(exon_starts[i]) + 1, Integer.parseInt(exon_stops[i])));
            exon_frames.add(Integer.decode(eframes[i]));
        }
        feature.setExons(exons);
        feature.setExon_frames(exon_frames);
        return feature;
    }
}

