/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.ComponentPattern;
import org.apache.jena.iri.impl.Parser;
import org.apache.jena.iri.impl.Specification;

public class SchemeSpecification
extends Specification
implements ViolationCodes,
IRIComponents {
    boolean usesDNS = false;
    int port = -4;
    private List<String> dUris = new ArrayList<String>();
    private List<String> dDefnText = new ArrayList<String>();
    private List<String> dDefnHtml = new ArrayList<String>();
    private ComponentPattern[] pattern = new ComponentPattern[Parser.fields.length];
    private String[] reserved = new String[Parser.fields.length - 1];

    public SchemeSpecification(String name, String rfc, String uri, String title, String section, String[] bad, String[] good) {
        super(name, "scheme", rfc, uri, title, section, bad, good);
        this.violations[4] = this.violations[4] | 0x2800000000000000L;
        this.violations[2] = this.violations[2] | 0x1000000000000000L;
    }

    @Override
    public boolean applies(String scheme) {
        return this.name().equalsIgnoreCase(scheme);
    }

    @Override
    public void addDefinition(String uri, String defn, String defnHtml) {
        this.dUris.add(uri);
        this.dDefnText.add(defn);
        this.dDefnHtml.add(defnHtml);
    }

    @Override
    public void setDNS(boolean b) {
        this.usesDNS = b;
    }

    @Override
    public void port(int i) {
        this.port = i;
    }

    @Override
    public void setPattern(int component, String string) {
        ComponentPattern p;
        this.pattern[Parser.invFields[component]] = p = new ComponentPattern(string);
    }

    @Override
    public void setReserved(int component, String subDelims) {
        if (component == 31) {
            this.setReserved(11, subDelims);
            this.setReserved(13, subDelims);
        } else {
            this.reserved[Parser.invFields[component]] = subDelims;
        }
    }

    public void analyse(Parser parser, int range) {
        ComponentPattern patt = this.pattern[Parser.invFields[range]];
        if (patt != null) {
            patt.analyse(parser, range);
        }
    }
}

