//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 6>, 252> igamma_small_data = { {
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.165048164480104120332981665342231281101703643798828125e-13), SC_(31.15790848492937617968754572910879626038987427321665501824062445965678033809696860327421033588997389), SC_(0.5142555520027874508595595722328287870710653491133268223717400674935981376413784737279829921742056631e-10), SC_(605883754914.8750136902267543620760601500284208480879474455026885251060577270869941538181411625849707), SC_(0.9999999999485744447997212549140440427767171212928934650886673177628259932506401862358621522444918976) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.825240808847993445596102901617996394634246826171875e-12), SC_(27.24588549611682625963801859326817650865189920983978484217386169027034380426371292313397641222047523), SC_(0.4496883316923336685099678252541612612557662391990416220973173325702496188138998642060577791819560088e-10), SC_(605883754918.7870366790393042821255872858690405998259225088795587011728204964734306876513968427252046), SC_(0.9999999999550311668307666331490032174745838738744233760800958377902682667429750381186100131967398492) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.1485433412558301302652807862614281475543975830078125e-11), SC_(26.65809886043765184861833815671322602877461879268583897860494287446522932950747972178867249013415618), SC_(0.4399870213191659715445515622143744278264487110204265430288897607131180016977120873571283497579633446e-10), SC_(605883754919.3748233147184786931452677224239910797032029260335045647417393122785451624076300440705085), SC_(0.9999999999560012978680834028455448437785625572173551288979573456971110239286881998302287908816411206) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(26.55273831558914007164077488340563437622573207289701433865490306535179619489488183113436762977413663), SC_(0.4382480648941352919111303365625055162099824756683096022952805756000873913572998244587797811350613329e-10), SC_(605883754919.4801838595669904701228309957315827322520896458223292046917791213919782970202279347248134), SC_(0.9999999999561751935105864708088869663437494483790017524331690397704719424399912608642700171714774703) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.1815529822833672479731603743857704102993011474609375e-11), SC_(26.45742811190195049533727267568504724879726922010500532361189289376431739839451074960681764629918148), SC_(0.4366749875024881266012524590033039215380435741991291470061983416947539967123967894565937878826126117e-10), SC_(605883754919.5754940632541800464263332034521698596805524986143382197347892929794570935205990162523633), SC_(0.9999999999563325012497511873398747540996696078461956425800870852993801658305246003287603206716974201) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(0.33009632353919737823844116064719855785369873046875e-11), SC_(25.85959113506148614558473903473463000631861077966174981641096804406377885881031868583310284349737406), SC_(0.4268077980959374477897019960137392551284102019659605405168797702263707908186064406194329606569899375e-10), SC_(605883754920.1733310400946443961788668444025871021592109390575937269357141426799956331047910800260781), SC_(0.9999999999573192201904062552210298003986260744871589798034039459483120229773629209181393555554219737) }}, 
      {{ SC_(0.165048161769598689119220580323599278926849365234375e-11), SC_(100), SC_(0.3683597761710089903097254101781941823648659605630519043409070893481216676279802460792521302677220332e-45), SC_(0.6079710392694377664924030954068840443869972626811800754595244480141084992747696378316144427416336236e-57), SC_(605883754946.0329221751561305417636058791372171084778217183509837671756731964340490869383638804970089), SC_(0.9999999999999999999999999999999999999999999999999999999993920289607305622335075969045931159556130027) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.206542072399111542591043644279125146567821502685546875e-13), SC_(30.93364168989949088662225783062562821275952768601909775986922127020315858008889124877888658573404498), SC_(0.6389098545336816619892930503520603759746754856217578076876091016189435240618029150566633773613501762e-10), SC_(484162851275.7955760243922734768637389008721827255248363671120740129064287230363410221766509320371893), SC_(0.9999999999361090145466318338010706949647939624025324514378242192312390898381056475938197081115165694) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.103271037554808486902402364648878574371337890625e-11), SC_(27.02161867158789878931620977320803696878717217632829425949582007780935030750254752153846820592898784), SC_(0.5581101193257189977881105127089252324891172434544119082354068522575555605654075175919360728270166827e-10), SC_(484162851279.7075990427038655741697869582897739694971918768028775132798299154301492947629946592776076), SC_(0.9999999999441889880674281002211889487291074767510882756545588091764593147742444439434592478580586656) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.185887871935463966366341992397792637348175048828125e-11), SC_(26.43383198338951447575879438498253053353949275687755657420480627486005125327251472959382229622556174), SC_(0.5459698510954741536654673991582696808426815259889022512892158090257346409981992469903104624210780402e-10), SC_(484162851280.2953857309022498877272023465152804047448712962536151985708437183794483489930274512222535), SC_(0.999999999945403014890452584633453260084173031915731847401109774871078419097426535900180074918231649) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(26.32847149106800163239094870586891526845820120393763229343432134045290266659697616892501543756547086), SC_(0.5437937136236059464756234080125646641077276944217179074523941203826804633593467352842472989896410538e-10), SC_(484162851280.4007462232237627310950480256288956698261628491935394793413286527865969356685660118910604), SC_(0.9999999999456206286376394053524376591987435335892272305578282092547605879617319536640653260888398335) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.227196278283769981243267466197721660137176513671875e-11), SC_(26.23316133035754938556791779149687928744103895259996107320150619846356673193156719633839660209741738), SC_(0.5418251577863868103129995208921398586460271143353281036151920862215441160993128135190632372203888294e-10), SC_(484162851280.4960563839342149779180789400009316508433251005312106995741437947759328703339749844776792), SC_(0.9999999999458174842213613189687000479107860141353972885664671896384807913778455883900687182653599296) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(0.4130841502192339476096094585955142974853515625e-11), SC_(25.63532431054814484821636003256695231324162132983547239417046128926165869713281292469158572207801148), SC_(0.5294773079214937290303064802551754036436189663559802177554527074961441840149493021783730734829548128e-10), SC_(484162851281.0938934037436195152696366989308586250427427232956993786051887039778409051327292561244901), SC_(0.9999999999470522692078506270969693519744824596356381033644019782244547292503855815985050693994395465) }}, 
      {{ SC_(0.20654207510961697380480472929775714874267578125e-11), SC_(100), SC_(0.3683597761717143751552636437264047570124229557729804467214558990981423263608011608473991574457783741e-45), SC_(0.7608179255751063148390974562103337563986691710549682719520828630510110088500246233042380098159938087e-57), SC_(484162851306.7292177142917643634859967314978109382843640527628119966039356180842359626956245681566386), SC_(0.9999999999999999999999999999999999999999999999999999999992391820744248936851609025437896662436013308) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.693323098043506502730082274865708313882350921630859375e-13), SC_(29.72264969834645019434398391335764181503761657632206675371880634359092033544076863168741139909711396), SC_(0.206073993293117147372414902249210966803119325754493450865229927096149608694728859685200779850164835e-9), SC_(144232900121.1921430521268665012736046760265611169427879527355317858388116749258141965866398426913323), SC_(0.9999999997939260067068828526275850977507890331968806742455065491347700729038503913052711399307582724) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.34666154495599510454439950990490615367889404296875e-11), SC_(25.81062670541879230446808925169387675802578353778167356850954822607902657677034794738407159230904849), SC_(0.1789510346003750462291870271302182045706001584982927847421887098868836775584657333644555074456521954e-9), SC_(144232900125.1041660450545243911494993376903261739546209912759249710480697924377079552570605269946721), SC_(0.9999999998210489653996249537708129728697817954293998415017072152578112901131163224415342662517363926) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.62399078959440856806395458988845348358154296875e-11), SC_(25.2228400267255531152618952281379932924411003086900105211922184450178012365594286472819270244402403), SC_(0.1748757738375517094192041844150274466299904575196806663645205533642878644093005573820531742584469496e-9), SC_(144232900125.6919527237477635803556933612462096395393042203675880183653995734989332954679798270968166), SC_(0.9999999998251242261624482905807958155849725533700095424803193336354794466357121355906994422341737114) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(25.11747952498746142361430978769868892247381913853328273208683820438926506797390005227064273526406535), SC_(0.1741452851513514725594924878654616781351273183021538570238001845190604483585022624330711346611073093e-9), SC_(144232900125.7973132254858552720032788016855140095065853905243158074707798141274694640535084221081009), SC_(0.9999999998258547148486485274405075121345383218648726816978461429761998154809395516414977371831620222) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.762655390229571850113643449731171131134033203125e-11), SC_(25.0221693565736957916669074328284162882489616607965901908363256370029803994953262974955021243250512), SC_(0.173484477746702186443587051705780058873940943597213522737037471163070412731277762961794229093460155e-9), SC_(144232900125.8926233938996209039506811565557866437314428682610083487212923815137541325320821768832415), SC_(0.9999999998265155222532978135564129482942199411260590564027864772629625288369295872687222366544446007) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(0.1386646179823980418177598039619624614715576171875e-10), SC_(24.42433234455626606652839207807430844427730364925975696592664901632954072382133322942821025011393797), SC_(0.1693395357023288385073728566291731739740606678779075780232085702485998742830572554333144562303028157e-9), SC_(144232900126.4904604059170506290891965113098944877031008797978415736309690021871938082060752449505334), SC_(0.9999999998306604642976711614926271433708268260259393321220924219767914297514001257169427441829599575) }}, 
      {{ SC_(0.6933230899119902090887990198098123073577880859375e-11), SC_(100), SC_(0.3683597761799895153698730317431021061042018369548001861605671269716523992047277326892588602148934185e-45), SC_(0.2553923382214215324259769271798839593251938655786213829878574777436759121294679586832258717739493913e-56), SC_(144232900150.914792750473316695617588589384202931980404528689238763377628503146861501522530642738347), SC_(0.9999999999999999999999999999999999999999999999999999999974460766177857846757402307282011604067480613) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.1335144560014878134523996777716092765331268310546875e-12), SC_(29.06735096752258056536729325061718779507401036453523687090019139448425341843714626101878460014693126), SC_(0.3880911362773696280056967206382892877595887264967036046564614404793100056365061158173422079796396869e-9), SC_(74898260328.90196362049089872824818260580093489311271918958613340011303560956530877930271362425243055), SC_(0.9999999996119088637226303719943032793617107122404112735032963953435385595206899943634938837970499892) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.6675722474813738926968653686344623565673828125e-11), SC_(25.15532801227009481634854499485265368220513892065216833299624544453507393957181578125784549362418071), SC_(0.3358599771482345384131641676265650413741820004409137933250390439848599040126047403716522597790232213e-9), SC_(74898260332.81398657574338447726693086156546900598159063346920193801698155951448825816804410401336966), SC_(0.9999999996641400228517654615868358323734349586258179995590862066749609560151400959873952592431883364) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.12016300281192382470862867194227874279022216796875e-10), SC_(24.56754136200937290895309015643013692734899956077677422972131844692787149062503339568078156875330453), SC_(0.3280121760450920899039398349140014268680649487989970733413326617285218105317582118133799690911870165e-9), SC_(74898260333.40177322600410638466238569998798576083772999334459604129190855712169070711482648959043358), SC_(0.9999999996719878239549079100960601650859985731319350512010029266586673382714781894682417878015279996) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(24.46218083195176010649364880366207427410534536757083785426245216990214243684390452554861676210010203), SC_(0.3266054607281534602931256455991079205489544580937849675334684529926510308105892248315380939599068615e-9), SC_(74898260333.50713375606171918712182705275604841408138418655053241675077483414741976089595535972259839), SC_(0.9999999996733945392718465397068743544008920794510455419062150324665315470073489691894107747833819512) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.146865887507008352486082003451883792877197265625e-10), SC_(24.36687069942703621636474649884830858586360466981647453600019531910473642024678190766643820074464995), SC_(0.3253329327405981029506500408194777649632511116495356043137860479733163371392142797229444467383356232e-9), SC_(74898260333.60244388858644307725072935756981410232312488430489573501303168494482577749307797760477695), SC_(0.999999999674667067259401897049349959180522235036748888350464395686213952026683662860785719891986523) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(0.267028898992549557078746147453784942626953125e-10), SC_(23.76903365163368637714726357106366774067839544251260729637154239753687551861168627655362242529563612), SC_(0.3173509443080758666399794602743594938889364162005174867456317123127003777846638219901410439648592437e-9), SC_(74898260334.20028093637979291646821228535445494750833411160876297464168460651268667912817360871759272), SC_(0.9999999996826490556919241333600205397256405061110635837994825132543682876872996222153361776248584503) }}, 
      {{ SC_(0.1335144494962747785393730737268924713134765625e-10), SC_(100), SC_(0.3683597761909002985725154019522360034186479878704276119409642960482091227291688533040722883793123849e-45), SC_(0.4918135273507806264975899117308317251680883012601122164361829316280219055323411283684053482677186779e-56), SC_(74898260357.96931458801347929361547585641812268818672955375301049482232670547704679643061756772917213), SC_(0.999999999999999999999999999999999999999999999999999999995081864726492193735024100882691682748319117) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.163998168886160533563867147677228786051273345947265625e-12), SC_(28.86170546048550903250791364354103174711941404864916093092211628926819150433026199321887056484982165), SC_(0.4733266956017863549356785857349564001556987523623975875099289832122935994033637594200382623146680339e-9), SC_(60976289136.04755502069917679752872010453068861352193805048851530605928360922572999879710208038628732), SC_(0.9999999995266733043982136450643214142650435998443012476376024124900710167877064005966362401936201746) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.8199908634043406863156633335165679454803466796875e-11), SC_(24.94968243368988607111279754392317756380227270251133614160416796123146030362622611392135558822201802), SC_(0.4091702328131829335658100117857600486348378315159431029057398228899356970648604050012328736288061661e-9), SC_(60976289139.9595780474947997589238362041485427968390793966263400953772319372624611995011379596838023), SC_(0.9999999995908297671868170664341899882142399513651621684840568970942601771100643029351395946129763398) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.147598357147504799513626494444906711578369140625e-10), SC_(24.36189575728456295003132599921358413686026766230814153211787426629972226773292289925946223440568955), SC_(0.3995306387274283086974308494460402604093332809792523127454217860117734923592787164330424168375165454e-9), SC_(60976289140.54736472390012288000530774885813622378108443682953470486352563219419923539444117434569565), SC_(0.9999999996004693612725716913025691505539597395906667190207476872545782139882265076407212831812495514) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(24.25653525342437768437658896325365651337860545156693453226968518332587217946888910687140766162073795), SC_(0.3978027457168313583469989604217433831468153842115388681555701205453351568796200287599732708870424631e-9), SC_(60976289140.65272522776030814566004478481806384726274664757074170471171471516804932365847496673375022), SC_(0.9999999996021972542831686416530010395782566168531846157884611318444298794546648431203799708543335312) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.18039798821423147501263883896172046661376953125e-10), SC_(24.16122508327652617519590199369744375455719285280943888605192992266988552275227025898634199908794285), SC_(0.3962396763426015344461764850760900065502450679538123401043299184582485648669591657876624688537040695e-9), SC_(60976289140.74803539790815965484073175437427660608415924632823735092946997582403598037509381461881589), SC_(0.999999999603760323657398465553823514923909993449754932046187659895670081541751435133040833826657752) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(0.327996345361736274526265333406627178192138671875e-10), SC_(23.56338807315918986464012703190798660164528420519711882806071454392864939259008026372492229560609768), SC_(0.3864352586204850403684059827048015121160790089543124664914957341357702119371734421550813514771496104e-9), SC_(60976289141.34587240802549596539650671616373375899606789394055740892068535456527211053728380988023559), SC_(0.9999999996135647413795149596315940172951984878839209910456875335085042658642297880628265574593230393) }}, 
      {{ SC_(0.1639981726808681372631326667033135890960693359375e-10), SC_(100), SC_(0.3683597761960824456973440458971288797268387514608391776033349781792370202528015534132545784138354776e-45), SC_(0.604103301858629274831499974509457097887751372447864471729689966861315882847250252661528747298098097e-56), SC_(60976289164.90926048118468583003663374807172036064135209876931646078531745279657745775371022166012385), SC_(0.9999999999999999999999999999999999999999999999999999999939589669814137072516850002549054290211224863) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.573015918568786641884571508853696286678314208984375e-12), SC_(27.6106472098755373678615892957552188514392208308914370574671979807337950954199264753856743145463171), SC_(0.1582134097247930761916926996566173725184435209521595402428776353387575980092254391589228116683289136e-8), SC_(17451521469.77907015894501840505217305875316969497911380106683817749809146341898826620777197321561114), SC_(0.9999999984178659027520692380830730034338262748155647904784045975712236466124240199077456080148841959) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.28650797012641504579733009450137615203857421875e-10), SC_(23.69862417251378038952616559964959814674605472568467557908323168060288798167427651813769915675210729), SC_(0.1357968941336058470934858983350904062268525035853043297384472091732464433008740851052453939768886969e-8), SC_(17451521473.6910931963067753833875967548587903996722799062735996558820577635498953799534219304635863), SC_(0.999999998642031058663941529065141016649095937731474964146956702615527908267535566991259148553582807) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.51571434622754708243519417010247707366943359375e-10), SC_(23.11083750844232066541856517547638235383999162398345525748390753321873059549928332132438508557815942), SC_(0.1324287828536846267698242639611554089942976407747771190023041814922702096049274020442481045996545458e-8), SC_(17451521474.27887986037823510749519717903200619257834300797481997748138191093405276612841512727690037), SC_(0.9999999986757121714631537323017573603884459100570235922522288099769581850772979039507259791638448496) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(23.00547699293291896306076158113169930688197033801512141590130210336739204595275152660573883159863242), SC_(0.1318250503050632310467450763954205952944767000377994361106999773822397935549399220964208254390314e-8), SC_(17451521474.38424037588763680985300077337668923953636429394315381906398734078539131567494692199554662), SC_(0.999999998681749496949367689532549236045794047055232999622005638893000226177602064450600778642169471) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.63031753427811310075412620790302753448486328125e-10), SC_(22.91016681326285911036482433387052840486554444935997510626386091855902542360680226771757896854966052), SC_(0.131278907782852111998502208711041568433039798572145878940423672650587434270536833762803149353282314e-8), SC_(17451521474.47955055555769666254893802063786014155279018259830012870142852559375793802089618088370649), SC_(0.9999999986872109221714788800149779128895843156696020142785412105957632734941256572946316619783931176) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(0.1146031880505660183189320378005504608154296875e-9), SC_(22.31232981335317761005464626276302124640839375679570163414658599113571272797681619866501215525057952), SC_(0.1278532064765270331994687322853490603421051572461068122465332422383363707192556887865982096498100553e-8), SC_(17451521475.0773875554673781628591160917453673000099408751625736008187034530170706336508822499362733), SC_(0.9999999987214679352347296680053126771465093965789484275389318775346675776166362928074431117407366075) }}, 
      {{ SC_(0.5730159402528300915946601890027523040771484375e-10), SC_(100), SC_(0.3683597762656143147412501990407375886204955849371483318579496462042737326648157786420372764098334912e-45), SC_(0.2110760235551445314127435252766919837846905764866388122369133762360673813723384183492506286200476097e-55), SC_(17451521497.38971736882055577291376235450838854641833463158991545869967512941153316273678033616204007), SC_(0.9999999999999999999999999999999999999999999999999999999788923976444855468587256474723308016215309424) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.111373128601488513567119298386387526988983154296875e-11), SC_(26.94608951197243134264035228299247915597093305955796311160699789459126371976157505899213677920236715), SC_(0.3001070409577089374471433333168337852827278186934568015384061941034070683970493772030484549124621713e-8), SC_(8978826136.539249151558690958757920155035752518348236486400575053128754985659304498206510791901974558), SC_(0.9999999969989295904229106255285666668316621471727218130654319846159380589659293160295062275614104797) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.55686566469148601754568517208099365234375e-10), SC_(23.03406647879892918456558105575371863530305442269150174427313454029552311246381074717418197886141832), SC_(0.256537614821776708824059139549998779356958231710371237032476212530912880637154932898525580680102855e-8), SC_(8978826140.451272184732193116832691382274513039016115123267036420462618339955045105504275103719929359), SC_(0.9999999974346238517822329117594086045000122064304176828962876296752378746908711936284506706103796113) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.100235819644467483158223330974578857421875e-9), SC_(22.44627981546780063160345897923689021141531165996069633283338363222849323115786681745128136554007249), SC_(0.2499912506019022749286681756424641219890798049130802945055014051352240986468246367658776210980053346e-8), SC_(8978826141.039058848063321669794813458791341462903857885997841831902369248022074986810219033442829972), SC_(0.9999999975000874939809772507133182435753587801092019508691970549449859486477590135317536319374212056) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.11137313293829720350913703441619873046875e-9), SC_(22.34091930009065878629576607605680580436877648663609077185455946183181441544231989449089475001167062), SC_(0.2488178175332722466925933740793066027557435701541721453448621185264537582128112706950444385398308279e-8), SC_(8978826141.144419363440463515102506361971425869950393059322447392881193418418753802525765956403216588), SC_(0.9999999975118218246672775330740662592069339724425642984582785465513788147354624178718872926458537691) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.122510446232126923860050737857818603515625e-9), SC_(22.24560912054024123074565891630486743833987547514585902039186337009010714935512360613339125060171874), SC_(0.2477563182034598438094638076524734763804195471685307986068331938451454169665770157070003654374647795e-8), SC_(8978826141.239729542990881070652613521723364235979294070812679144343889510160461068612962244760720087), SC_(0.9999999975224368179654015619053619234752652361958045283146920139316680615485458303342298425263856288) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(0.2227462658765944070182740688323974609375e-9), SC_(21.64777212138456539709954300290877830494692393926642861465677572074653039209947495921652032925777053), SC_(0.2410980202447920305932252703615156913733213749270754409716280508079090497684447685131824708511669405e-8), SC_(8978826141.837566542146556904298729435119453369372245606692109550078977159504037825868610891677591008), SC_(0.9999999975890197975520796940677472963848430862667862507292455902837194919209095023155523144651361825) }}, 
      {{ SC_(0.11137313293829720350913703441619873046875e-9), SC_(100), SC_(0.3683597763575344087226111398438938272509906635605890873692809855359236412596468330566588977515855312e-45), SC_(0.4102538234402647767186847892287525864482147683686713825107594110488699493470720178477194808618775589e-55), SC_(8978826163.485338663531122301398272438028231674319169545590178388378218471527957078201274301714155051), SC_(0.9999999999999999999999999999999999999999999999999999999589746176559735223281315210771247413551785232) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.1421470688552084471467651383136399090290069580078125e-11), SC_(26.70211336646544908568240934740043958323639463745235945376703935302866237608631974783048288968757413), SC_(0.3795627228655345499045214618788383433085518008940228005127553183005835414783613474277186904928698803e-8), SC_(7034967254.82543787961887250933704225938674433524740319124325542058211886668755137856799005981116172), SC_(0.9999999962043727713446545009547853812116165669144819910597719948724468169941645852163865253078665254) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.71073535945487265053088776767253875732421875e-10), SC_(22.79009035383229651088936044328462880259311619388223140223713350762876228767939634136594532363547752), SC_(0.3239544612193807687729140248051409422455042244368366945302869240880534466665426655075594886171421569e-8), SC_(7034967258.737460892252025084130091163502555115890681634813383472112024712087451466974913466275699286), SC_(0.9999999967604553878061923122708597519485905775449577556316330546971307591194655333345733445142324547) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.1279323591507619539697770960628986358642578125e-9), SC_(22.20230373430588518574599517163009252297492442144115684527666225796714704831903638172648260276164122), SC_(0.3155992465324578590322413700410647275858761790240137605372526685389607372650696292286102238187052205e-8), SC_(7034967259.325247511778436409273456435157091395508873407254458029072495961749066706335273425915162007), SC_(0.999999996844007534675421409677586299589352724141238209759862394627473314610392627349303707304442389) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.14214707189097453010617755353450775146484375e-9), SC_(22.09694317561163084788256496036530953147092347410452097344643885306928594283321908310393706604685225), SC_(0.3141015770412164346813985170246651814652255069022700252246142790736798295834518551840832933978997408e-8), SC_(7034967259.430608070472690747136886646421874387012874354591093900902719366646927811821090724537707544), SC_(0.9999999968589842295878356531860148297533481853477449309772997477538572092632017041654814477498402666) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.1563617846311871062425780110061168670654296875e-9), SC_(22.00163296062632740578891355475648697965306819368909767715932731224145604717237971042081472014338911), SC_(0.3127467702429592568034533791768014054286353115690853318814380713131703123472920670767278141117677138e-8), SC_(7034967259.52591828545799418923053805203069693883072963500651719718983090747475770748193009722082989), SC_(0.9999999968725322975704074319654662082319859457136468843091466811856192868682968765270793288235113682) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(0.2842941437819490602123551070690155029296875e-9), SC_(21.40379599739374373170217506790634548509305249060068813622155560444561248971012412754083900239701767), SC_(0.3042486928630915968194348013502314618692864026682572961369916654475821954744566036682222707414007156e-8), SC_(7034967260.123755248690577863317276538880838433390745338094926738127602615270601264944185680100805608), SC_(0.9999999969575130713690840318056519864976853813071359733174270386300833455241780452554339629092963528) }}, 
      {{ SC_(0.14214707189097453010617755353450775146484375e-9), SC_(100), SC_(0.3683597764098492386336152539104254151921797155538759249293362379340307895860280821652955424982969586e-45), SC_(0.5236126362337035988875078331237656531466590134182069202925202356413518519426323906077032829275023807e-55), SC_(7034967281.527551246084321595019451606787183918483797828327255097939308981082598500804278846513718819), SC_(0.9999999999999999999999999999999999999999999999999999999476387363766296401112492166876234346853340987) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.3800632551731464303657048731110990047454833984375e-11), SC_(25.71863780614397288010147521631315344171623755848822764992072153765456518475074886687422245642758907), SC_(0.9774709294596037940916676527820114124746134691931423205846689548871880716474893103846780972798987393e-8), SC_(2631140914.74519355244884312710983403304386510582491051924104929466536754431055551933332874616599262), SC_(0.9999999902252907054039620590833234721798858752538653080685767941533104511281192835251068956867848609) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.1900316293212966911596595309674739837646484375e-9), SC_(21.80661482796232558126385760559778653885688101888695584253422767102912585622853214064975119524812173), SC_(0.8287893093297442617394600080481358743788505091844266098099379969589135302470974626994509955407754548e-8), SC_(2631140918.657216530630490425947451643759232008684267058842321102051861410935994847855545472390463881), SC_(0.9999999917121069067025573826053999195186412562114949081557339019006200304108646975290253725518200384) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.34205693832944916721316985785961151123046875e-9), SC_(21.2188281519184091074197349089638501692947807572844549039905336200431000395335389236811368570794375), SC_(0.8064496973764485044921577079125390935718035401464332127026971226261749475158712656444796387312508743e-8), SC_(2631140919.245003206674406899791574340393168378246367320444822040595555461922020664550538689359078219), SC_(0.9999999919355030262355149550784229208746090642819645985356678729730287737382505248412873431034514386) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.380063258642593382319319061934947967529296875e-9), SC_(21.11346765339790192582476806127896153063255462874174973171428786920445101329085630010938751413829286), SC_(0.8024453319355788231071856129480638656939376132861242781342055390942782000359263652635592251266388019e-8), SC_(2631140919.350363705194914081386541188078057016908593448987527212871801212760669690793221312930827562), SC_(0.9999999919755466806442117689281438705193613430606238671387572186579446090572179996407363469129993452) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.418069578955737597425468266010284423828125e-9), SC_(21.01815748769354753681541483317942613666797384579945147563505042437069525425951965979572590147559531), SC_(0.7988229427188479013538313237093901854500203182219240131819647654827907272005447879997228211158577692e-8), SC_(2631140919.445673870899268470395894416177592410873174231929825468951038657594425449824557953244489175), SC_(0.9999999920117705728115209864616867629060981454997968177807598681803523451720927279945521195516743636) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(0.76012651728518676463863812386989593505859375e-9), SC_(20.42032047884090736154803370761882936092356585970991996993591888602022484329289757651983529816877165), SC_(0.7761013545416957369345649204508277521115402268643724891878670606753809701791569445124111913554009282e-8), SC_(2631140920.043510879751908645663275541738189186617582218019356974650170195944895860791180036520379778), SC_(0.9999999922389864545830426306543507954917224788845977313562751081213293932461902982084305544267412856) }}, 
      {{ SC_(0.380063258642593382319319061934947967529296875e-9), SC_(100), SC_(0.3683597768143000588501045612366266587026324139543635389694328925328044330110662978123616511521290451e-45), SC_(0.1400000171596142853099853759042719201591767991391272459690176841978253808328348886856967958303393352e-54), SC_(2631140940.4638313585928160072113092493570185475411480773609171677717890231150161428700390225483129), SC_(0.9999999999999999999999999999999999999999999999999999998599999828403857146900146240957280798408232009) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.6091627202664540163823403418064117431640625e-11), SC_(25.24689000992704732787135724866261800970811047823684316497350536840230928933317343744190229076667277), SC_(0.1537946420212282290388870648090621015361541890092574171072313575177103301876506923092618393186023679e-7), SC_(1641597476.338518053413636274259836985269533883400419746654418949287301096265401001071611212702220699), SC_(0.9999999846205357978771770961112935190937898463845810990742582892768642482289669812349307685591137124) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.30458136013322700819117017090320587158203125e-9), SC_(21.3348670616764575694084620346450007447466560409056884083295587423721196027401461035733919807191439), SC_(0.1299640566038377327023800043707913228319508430302493810014011606711116895510053575891216993291925631e-7), SC_(1641597480.250541001664226032722732199287151148361874183985573705931247722295590687664638546570731009), SC_(0.9999999870035943396162267297619995629208677168049156969750618998598839328888310448994642405935860174) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.54824644823980861474410630762577056884765625e-9), SC_(20.74708040475856333272056970156465261678339942423265416913327089251443532761708244171523215357783191), SC_(0.1263834794139344425118232321183354522083053328091741784506671242578844229824808801717866523696617757e-7), SC_(1641597480.838327658582120269410624532367499276325130800658607945127535572153274962787702208428890836), SC_(0.9999999873616520586065557488176767881664547791694667190825821549332875742115577017519119823301646011) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.6091627202664540163823403418064117431640625e-9), SC_(20.64171989052690173164125914922577325555846255495170730858843701991262424300992897560083460560989909), SC_(0.1257416624391284537089974684973411094534338190854010147454289269632881992524698950579098446179922177e-7), SC_(1641597480.943688172813781870489935084706378637550067669939554805672369444755086047394855674543288384), SC_(0.9999999874258337560871546291002531502658890546566180914598985254571073036711800747530104937183963693) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.67007899229309941802057437598705291748046875e-9), SC_(20.54640971201268516165538039975180650613799708589369843474345136577620599951087683234445613253354479), SC_(0.125161068362796291184557743972318612158944968768911412842186021481421920766907364029319759229230024e-7), SC_(1641597481.038998351327998440475813834180345386970533138997563679517355098891504290893907817799666858), SC_(0.9999999874838931637203708815442256027681387841055031231088587157813978518578079233092635965779033421) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(0.1218325440532908032764680683612823486328125e-8), SC_(19.94857271938925318892629116896502172280225286269393318404939530994624847021543151944491594933174886), SC_(0.1215192682744917095180907842201967631726418753982474528205547736066322224640476863215267020074856382e-7), SC_(1641597481.636835343951430413204903064967130170306277362197328930211411154721461820189353130699207041), SC_(0.9999999878480731725508290481909215779803236827358124601752547179445226393367777535952313673603355112) }}, 
      {{ SC_(0.6091627202664540163823403418064117431640625e-9), SC_(100), SC_(0.3683597772037626949569747697482535611970023191945352353852558467830678560993595818027632381112498452e-45), SC_(0.224391043997089009006504796203547864580900840098025131345108130163352143724096374336291528176609545e-54), SC_(1641597501.585408063340683602131194233932151893108530224522902337057043769710735520670624030835493708), SC_(0.9999999999999999999999999999999999999999999999999999997756089560029109909934952037964521354190991599) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.1022164124175883870293546351604163646697998046875e-10), SC_(24.72929796168890307773053947770197995742396358732380012416282100875772478941865703735421562814163124), SC_(0.2527740137900208072419854593989979018870051288632542079134894518498984221938923689132829272969019949e-7), SC_(978316440.2785138474851210288009664937862366753513412595356375465751281415103498675729580690720758623), SC_(0.9999999747225986209979192758014540601002098112994871136745792086510548150101577806107631080717582274) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.5110820655573888871003873646259307861328125e-9), SC_(20.81727504334552751593922417967989654614866927899547854531496033112624345288005347883731107762520171), SC_(0.212786718694132400110619554444385167959227259906753424768221953049311736322141481157530899012218798e-7), SC_(978316444.1905367658284965905922817918083200866266355678639591254229888191418312041115616275889804128), SC_(0.9999999787213281305867599889380445555614832040772740093246575231778046950688263677858518836812897266) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.919947729105530243032262660562992095947265625e-9), SC_(20.22948837946149081510940283102401715574362207151558976721095182417003224262558175686865084967739547), SC_(0.2067785742448887368851715908089275811839899812745751344337437720349125190938734268899724092740108311e-7), SC_(978316444.7783234297125332914221031404641994770316827753438479035269973260980424143660333495576406408), SC_(0.999999979322142575511126311482840919107241881601001872542486556625622796508748090612657310442296629) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.1022164131114777774200774729251861572265625e-8), SC_(20.12412787820932792787004758754943218994412838742785769353702257560445887047194497166136852635520988), SC_(0.2057016169920909769212256552832601257804726029795106314647013450918863636019822220851706070951506741e-7), SC_(978316444.8836839309646961786614583839387844428311764594315799772009265746636157865196701347649229641), SC_(0.9999999794298383007909023078774344716739874219527397020489368535298654908113636398017777909234014033) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.1124380588635176536627113819122314453125e-8), SC_(20.02881766102301393831207531728882281429973282998729105722538170112309033733724834693034977083898903), SC_(0.204727390138150080177445996456666728315290298815939180255768096508032052219381722620656885512093383e-7), SC_(978316444.9789941481510101682194306541993938184755720168721466135125674491449843196543667594959417196), SC_(0.9999999795272609861849919822554003543333271684709701184060819744231903491967947780618277373756099251) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(0.204432826222955554840154945850372314453125e-8), SC_(19.43098071309310856739850006938387356508620516746723173564368303966669585412142301124841461724966083), SC_(0.1986165152902537844517703143761223797636884600083407953619183269710795671567659392502869176952039793e-7), SC_(978316445.5768310960809155391330059021043430676890996793922059350942661106013788028701920951778768732), SC_(0.9999999801383484709746215548229685623877620236311539991659204638081673028920432843234060744178528284) }}, 
      {{ SC_(0.1022164131114777774200774729251861572265625e-8), SC_(100), SC_(0.368359777905853469344081578473447669941351384460280853428932926883636508105262794753424256125050729e-45), SC_(0.3765241525429219209910825009890207595821295804071954576284646002830176921376604633493543610222973032e-54), SC_(978316465.007811809174024106531505971488216632775304846491077892832095680923993078526566180451757333), SC_(0.9999999999999999999999999999999999999999999999999999996234758474570780790089174990109792404178704196) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.2881922998854147266456493525765836238861083984375e-10), SC_(23.69276173287444713600362539532735897074401039338002364459951233632390084933308389649146365396311848), SC_(0.6828071324950950523363279903511969227148981012853760479406773886973120694747625118050536296546829893e-7), SC_(346990518.8092916442712551078592277123048325251606036468328712719807157479670526021253962414418257934), SC_(0.9999999317192867504904947663672009648803077285101898714623952059322611302687930525237488185242755283) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.144096146126315716173849068582057952880859375e-8), SC_(19.78073900691445016095885639389753583417329796709626635762393586357077977251532141015520193165795698), SC_(0.5700656526336706765629520015182516359846483872666794203819670490539025121689011616105759423044434712e-7), SC_(346990522.7213143702312520829039967137346556617313160731166285589562922207201736789431587277780875157), SC_(0.9999999429934347366329323437047998481748364015351612733320579618032950946097487831098838380688316345) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.259373056366030141361989080905914306640625e-8), SC_(19.19295240283519277001248098401216667945156155882223441569781060870989377430967855446669293260451802), SC_(0.5531260957269927644107691820793416661314585991395812482915927983214683347999464998067057683658614732e-7), SC_(346990523.3091009743105094738503721236200248164530524813906605008824174755810596771488015834665965148), SC_(0.9999999446873904273007235589230817920658333868541400860418751708407201678531665200053500184703914593) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.28819229225263143234769813716411590576171875e-8), SC_(19.08759186777013603816792587749223489455280334218748173096139370012582277962819162273541650773187906), SC_(0.550089686310605479374765797849467387524892977968085364683140072885555277963830423179634902496072806e-7), SC_(346990523.4144615093755662056949272301399566013518106980254131856188343841651306718302885151978729396), SC_(0.9999999449910313689394520625234202150532612475107022031914635316859927114444722036169576811800847717) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.3170115281392327233334071934223175048828125e-8), SC_(18.99228167262945621502648058021899664954575156309545732994364898814631108103455965848611522527445993), SC_(0.5473429199447724449365598406622974379563743180761029215331144943244495512522245779895163601792014344e-7), SC_(346990523.5097717045162460288363725274131948463588624771174375866365790961446423704239204794471742221), SC_(0.9999999452657080055227555063440159337702562043625681923897078466885505675550448747775422001942970733) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(0.5763845845052628646953962743282318115234375e-8), SC_(18.39444472868215481925071667663763768425283982135035921869937076240377447660477049785366490448039564), SC_(0.5301137199891637530589417121122432352185484755011395918818709838756987883697419864604246167509751675e-7), SC_(346990524.1076086484635474246121364309945538116517742188625356978808573218871789748537096400796245429), SC_(0.9999999469886280010836246941058287887756764781451524498860408118129016124301211630258013531182625026) }}, 
      {{ SC_(0.28819229225263143234769813716411590576171875e-8), SC_(100), SC_(0.3683597810673910878259453261772515633910704553160155236681772136493967971708576626919997117688756639e-45), SC_(0.1061584498560825341452551983689185819173187227077225650262751236783018804856022567589731517239725586e-53), SC_(346990542.5020533771457022438628531076321914959046140398445351355128369964650081252842074518800947888), SC_(0.9999999999999999999999999999999999999999999999999999989384155014391746585474480163108141808268127729) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.47627769783620266252910369075834751129150390625e-10), SC_(23.19038812059928706191522283690527385656309360115541794293373312151507378827895094855876257121879682), SC_(0.1104506437454029732773617676876454573576667359402730267024881849761444919487044475307980205841895399e-6), SC_(209961524.6486165380590072031267839293878743974072625991569323662721967549685473587581377213470662443), SC_(0.9999998895493562545970267226382323123545426423332640597269732975118150238555080512955524678683459398) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.238138841979207427357323467731475830078125e-8), SC_(19.27836555303852664717482651321926247182418302115228361998419920630183910868506757364234977717289466), SC_(0.9181855321347166845654648049560415056080198046558664624253121699011682798723257077569007180350152305e-7), SC_(209961528.5606391056197676178671802530738857821461731791600666892217306701817820383520210962634790384), SC_(0.9999999081814467865283315434535195043958494391980195344133537574687830098831720127674292231362492534) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.428649915562573369243182241916656494140625e-8), SC_(18.69057894480439921146292761698368931301869064556029920307753752008313567583325198990769357802891858), SC_(0.8901905676146021099392395487493978523199372342624156094924211669240791528864596453711967113373659302e-7), SC_(209961529.1484257138538950535790791493094589409516655547520511061283923564004854712038366799981352375), SC_(0.9999999109809432385397890060760451250602147680062765737584390507578833075920847113540354617306833051) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.47627768395841485471464693546295166015625e-8), SC_(18.58521843926516063616159117385745026961037444537118571666682847295485604865340615389551277900606232), SC_(0.8851724818449150137839659430028178647541159466498367093865133518897261306127836051466836650821406931e-7), SC_(209961529.2537862193931336288804155924356979843599817549411645925391014035287650983836825160103160365), SC_(0.9999999114827518155084986216034056997182135245884053350163290613486648110273869387216394841862959044) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.523905452354256340186111629009246826171875e-8), SC_(18.48990826861409754915914054745333969856149250183160368187697338734474029092506594451708752846133756), SC_(0.8806330710988985343637930814217292584929923611643492845725318071702064179698045205498127683421126027e-7), SC_(209961529.3490963900441967158828662188398085554088636984807466273289564891388808561120227253887412871), SC_(0.9999999119366928901101465636206918578270741507007638835650715427468192829793582030195479438772826146) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(0.9525553679168297094292938709259033203125e-8), SC_(17.89207132558489254872898191821300829504848015417588185120468252595323909749380952581872497962796603), SC_(0.8521594315595473893570887456010527755175426628801151643709441342537892612282540380918156624991023537e-7), SC_(209961529.9469333330734017163130248480801399589218760461364684580012473505303820495432791440871038359), SC_(0.9999999147840568440452610642911254398947224482457337119884835629055865746210738771745961897014375183) }}, 
      {{ SC_(0.47627768395841485471464693546295166015625e-8), SC_(100), SC_(0.3683597842647898539638319646575348876461744866014745590506707335656926352325103438525782815849877969e-45), SC_(0.1754415453953704746110331976528379492219515551934825926073073006650744888653580533475753852837452549e-53), SC_(209961547.8390046586582942650420067662931482539703561999439905249411400225197891823813562800938596156), SC_(0.9999999999999999999999999999999999999999999999999999982455845460462952538896680234716205077804844481) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.8854135480351743581195478327572345733642578125e-10), SC_(22.57033335902441974267993744902233404760258140104854321621061470853074508808052628280158164776222873), SC_(0.1998407841543141012248490727052655357431167147700169043625632815223933493745191773694679750144185685e-6), SC_(112941554.6684546040980603096308264738863542135073524582948704259914857828870349999674177527113406245), SC_(0.9999998001592158456858987751509272947344642568832852299830956374367184776066506254808226284282727799) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.442706760139799371245317161083221435546875e-8), SC_(18.6583111233059802174057509736510213335259196911232853352922340829115561700075570811943199831974457), SC_(0.1652032101858949796302289955659783448274610131859022277392967256843795115700613344316475613920488389e-6), SC_(112941558.5804768398164998349050129492576669275840141682201283069098664085062239180403869543186022891), SC_(0.9999998347967898141050203697710044340216551725389868140977722607032743156204884299386655665460463279) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.796872168251638868241570889949798583984375e-8), SC_(18.0705245605242648102377992831995972097341588803833027513799335193795868602291484760468416630743721), SC_(0.1599988684620408736481999579580135345328362406716867645680406556468973459111645286790976591132531006e-6), SC_(112941559.1682634025982152420729646397090910513757749789601108908221669720381932278187955594660806092), SC_(0.9999998400011315379591263518000420419864654671637593283132354319593443531026540888354713191406273324) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.88541352027959874249063432216644287109375e-8), SC_(17.96516406309874169586027073544801751692494361289095971992798011086267991084164702767842073224648442), SC_(0.1590659923680337611740761466732621951074525099314948573726344274806655009183601948304105735107350149e-6), SC_(112941559.27362390002373835645049318746067074418499024645245392227412038055510017720629700783450154), SC_(0.999999840934007631966238825923853326737804892547490068505142627365572519334499081639805167835721578) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.973954872307558616739697754383087158203125e-8), SC_(17.86985389978732891421375296552633629159861817518313999673519481069116467676882685685258650242248151), SC_(0.1582221032915610444173915208486543787458430568115829248643843717701438660747299147452653328600508464e-6), SC_(112941559.3689340633351511380970109573823519695113156841602736454669056807266154112791171786603357698), SC_(0.9999998417778967084389555826084791513456212541569431884170751356156282298561339252700852529882069275) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(0.17708270405591974849812686443328857421875e-7), SC_(17.27201700306457480169007292747088068426541706139981969244913752412474379026769377057212755710992149), SC_(0.152928774551704942314303679930836765822366796968046157545881586041172919661263558073523024045365045e-6), SC_(112941559.9667709600579052506206909954378075768445167979435939497529629672930362977802502649407947152), SC_(0.9999998470712254482950576856963200691632341776332030319538424541184139588270803387364419247759584121) }}, 
      {{ SC_(0.88541352027959874249063432216644287109375e-8), SC_(100), SC_(0.3683597912199841112095417550101783502819370608688387755489825879659256088289529750480251391576150657e-45), SC_(0.3261507411404175804375974373269334288186158482865090659836236265501496777030439782340057986262186784e-53), SC_(112941577.2387879631224800523107639229086882611099338589750538509821163802082383330387352768241321059), SC_(0.9999999999999999999999999999999999999999999999999999967384925885958241956240256267306657118138415171) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.23050329700513572106501669622957706451416015625e-9), SC_(21.61353463267935449352048389341309488642778138447582971204795317556836678756247536371135745036186673), SC_(0.4981991047054799163092965657908029954911828896480061528870779913970164723377903285957423316894210177e-6), SC_(43383305.31046017371427919608210692543663676807964178467812499051588124043120872686622345022899824395), SC_(0.999999501800895294520083690703434209197004508817110351993847112922008602983527662209671399583124858) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.115251648225012104376219213008880615234375e-7), SC_(17.70151346558980219074553873559802545062953610440442392274875326936887722479450448611110773259772437), SC_(0.4080257260260808603668407358210353739699202098264519660278529383367635766312111119708629863286580163e-6), SC_(43383309.22248134080383149885705208325170620387788706474953077981508114663069828963419432782924796172), SC_(0.9999995919742739739191396331592641789646260300797901735480339721470616632364233687888880252365992234) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.2074529703577354666776955127716064453125e-7), SC_(17.11372703645314648023233574191699349392156986053582762334085501327543868406684188522246783970598128), SC_(0.3944770548933568744202378879845935305785660886680773995523830392370690108533996110412933013807743745e-6), SC_(43383309.81026776994048720937025507693273816058585330861812707922297940272413683036185692871788785461), SC_(0.9999996055229451066431255797621120154064694214339113319226004476169607629309891466003889549225980929) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.23050329645002420875243842601776123046875e-7), SC_(17.00836658306192736527943254555798064290466310600614818592383354255417300588036696814436354636963132), SC_(0.3920484616788299015946145032998463764986093846826987933117874627651585929723682604959056859914410468e-6), SC_(43383309.91562822333170632432315827329175101160276006314780651664000087344540250854833184579599214794), SC_(0.9999996079515383211700984053854967001536235013906153173012066882125372348414070276317395003310627004) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.253553622542312950827181339263916015625e-7), SC_(16.9130564581039310496954238697527131665325887870067307826985495683889321255845920433317560168872345), SC_(0.3898515318508115388604206648010335220059794932861661087930643810285091034522888416710893418749840686e-6), SC_(43383310.01093834828970263990716694909701848797483438214722391986528484761064338884410677060859967743), SC_(0.9999996101484681491884611395793351989664779940205067138338912069356189714908965477111583251662672292) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(0.4610065929000484175048768520355224609375e-7), SC_(16.31521970098461681782418424242540259470780067227015303761725169309472242873380410724275262478747214), SC_(0.3760711973419645980949823165656473046482927073589198601872549332887107518773674786869797262683016502e-6), SC_(43383310.60877510540901687177840657642432905979962249688380166494658272290485308569489470669760306953), SC_(0.9999996239288026580354019050176834343526953517072926410801398127450667112892481226325213093941855633) }}, 
      {{ SC_(0.23050329645002420875243842601776123046875e-7), SC_(100), SC_(0.3683598153531167924132257395642715834888369073597665999403953429895858402238700449439230691342550711e-45), SC_(0.8490815284831955188977848628330511140350836114650287916474006276648459764910645244927747543859253126e-53), SC_(43383326.92399480639363368960259081884973165450742316878559488721071762358634977486479967178327234673), SC_(0.9999999999999999999999999999999999999999999999999999915091847151680448110221513716694888596491638853) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.593924909253473742865025997161865234375e-9), SC_(20.66703921191792709768295714831476745107828089229145366896325821357014019311457006331215176651168259), SC_(0.1227466980927991544984574286397941972519965288725356960941458114892383148304630279215771587304737682e-5), SC_(16837124.06519073299227488937851746531753021666590378542294984406922191547756008534632370110203567575), SC_(0.9999987725330190720084550154257136020580274800347112746430390585418851076168516953697207732690739523) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.2969624546267368714325129985809326171875e-7), SC_(16.75502071711546687877552816312899511421900051247249059838831263479099924633381620801923527753146366), SC_(0.9951224500103467742981873190183609851784990903160019575948043540834172877160003690539156838774895778e-6), SC_(16837127.97720922779473510828594645050330255352518416524191291464416749425670103212707755639495216473), SC_(0.9999990048775499896532257018126809816390148215009096839980424051956459165827122839996309371196311067) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.5345324183281263685785233974456787109375e-7), SC_(16.16723467078082807983390949109229897523429303925060117597873173640665366231398001836241367218011656), SC_(0.9602123713905740946575873907953276442736031477079535087166644150898196354801366643025255847268699409e-6), SC_(16837128.56499527412937390722756512253999869250989163846380233705374839264104661614691374605177377008), SC_(0.9999990397876286094259053424126092046723557263968522920464912833355849101803645198633356888094296657) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.593924909253473742865025997161865234375e-7), SC_(16.0618742655130566376615398513143221457641905990919775418902869158682613921792873781312284950599302), SC_(0.9539547542622917210518837837076878650520297551922445808660128001980926996675087224598890817236834732e-6), SC_(16837128.6703556793971453493999347623179755219799940786224259711421932131794388862816063862829589472), SC_(0.9999990460452457377082789481162162923121349479702448077554191339871998019073003324912775314996536636) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.6533174001788211171515285968780517578125e-7), SC_(15.96656418556725877411773825764856491499216232874447797425629890501029062664823835764675885358191078), SC_(0.9482940510099550163867520298229688291761802379970900581812748772612166500471186405495792892165888367e-6), SC_(16837128.76566575934294321294373635598373275275202234896992553877618122403740965181265540676742858868), SC_(0.9999990517059489900449836132479701770311708238197620029099418187251227387833499528813594418580427217) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(0.118784981850694748573005199432373046875e-6), SC_(15.36872781507158936238774950132072563313067515901113068784207978569757247703295934697364970511496732), SC_(0.9127870585831879647328972334655501767736868198217547260893471431003681346809412699098680198385937853e-6), SC_(16837129.36350212983861262467372511231157203461350951870327282519040034335012780142793441744053773715), SC_(0.9999990872129414168120352671027665344498232263131801782452739106528568996318653190587300818741359511) }}, 
      {{ SC_(0.593924909253473742865025997161865234375e-7), SC_(100), SC_(0.368359877133779627789829551660082000613875450854323935272781868541342659113566885072004686000538901e-45), SC_(0.2187781140995117606201452236455813018212902951985671539811835384949649582989793027274879052399928624e-52), SC_(16837144.73222994491020198706147461363229766774418467734604363589870050125787072680095630895061953683), SC_(0.9999999999999999999999999999999999999999999999999999781221885900488239379854776354418698178709704801) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.116676501793477882529259659349918365478515625e-8), SC_(19.99179062922895135279135641886320891001581815937183643556509236650684411373876662714850250165891516), SC_(0.2332572378933380896614852404043955731764578465775493974926690084565287424804883371298924493977218701e-5), SC_(8570685.384721901300483028821204717822157533079822661474976225929986450750353145762058562609147949176), SC_(0.9999976674276210666191033851475959560442682354215342245060250733099154347125751951166286805909513369) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.5833825156287275603972375392913818359375e-7), SC_(16.0797761652926913291348182928175289155012625988611007066795778694965500481440904574753561437645726), SC_(0.1876132180363857639789676233333532906846598828609086431214348342210527724267593406047436181114213655e-5), SC_(8570689.29673636523674305247774284386783752759437822198571195481550094776064721135673473228229430707), SC_(0.9999981238678196361423602103237666664670931534011713909135687856516577894722757324065939359977568908) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.1050088513920854893513023853302001953125e-6), SC_(15.49199068278999056649859842334433759637560196333218447549803510123386873556476009557038640123831097), SC_(0.1807551421058621310807213821771561126961165858814107707981132554842734011637703760338376719425404298e-5), SC_(8570689.884521847739443815113962713341028846720038857514628185997043716023328523936065094187264049597), SC_(0.9999981924485789413786891927861782284388730388341411858922920188674451572659883622962396456459774245) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.1166765031257455120794475078582763671875e-6), SC_(15.3866303621595121903055194214640004819643700201239951503589815755084802176013688518707845330302695), SC_(0.1795258346451342009067250034158853144786430547677529568118461283673972754030713169757889866521204212e-5), SC_(8570689.989882168369922191307041715221365961131270800722817511136097241748717041899456337886865917805), SC_(0.9999982047416535486579909327499658411468552135694523224704318815387163260272459692868302262383651242) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.1283441548594055348075926303863525390625e-6), SC_(15.29132035994571657638039300287563535180084117803963253552413504942013521352660403189447452392334253), SC_(0.1784137907931195630664561454318510163315338031686619212723404195189619449748018216498706604663238592e-5), SC_(8570690.085192170583717805232168133809731091294799642807180125970943767837062045974221157863175926912), SC_(0.999998215862092068804369335438545681489836684661968313380787276595804810380550251981783485517094816) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(0.233353006251491024158895015716552734375e-6), SC_(14.6934845613070024760494225435742907723124682224201517272497450593684039976083820917023846937113556), SC_(0.171438451280492692951103596089400926290752279997685233733607411600878884237477302606935736342097826e-5), SC_(8570690.683027969222431905563138593111075670783172598426660934245333757888793261892443098055265757124), SC_(0.9999982856154871950730704889640391059907370924772000231476626639258839912111576252269739154651618625) }}, 
      {{ SC_(0.1166765031257455120794475078582763671875e-6), SC_(100), SC_(0.3683599745150272892400101851084383480541082747012424563695810823445735085141349784587435139634448406e-45), SC_(0.4297895661242704953447061916098768107011138017136912219248455921577410514737583061430570539091243596e-52), SC_(8570705.376512530529434381612561136685366443095640820478452686980051528017187074392460420341614021638), SC_(0.9999999999999999999999999999999999999999999999999999570210433875729504655293808390123189298886198286) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.237996733432055407320149242877960205078125e-8), SC_(19.27891673014500384712975954133906727908916527670596021251361724382202588449078822005139406210651264), SC_(0.4588320041682795593560853371393206798770048257652114149928167287258758275442354159184341750549756364e-5), SC_(4201718.29714702201837632903347815093723979460295951469666887255317157666500550243664833189975821244), SC_(0.999995411679958317204406439146628606793201229951742347885850071832712741241724557645840775727840859) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.118998372045098221860826015472412109375e-6), SC_(15.36691046244503019303216484318429298749214642591994684691039336237661370327741195067531752721925024), SC_(0.3657275159207103939695479393292554275178977950013236054952077816443786958781500453981083921610508537e-5), SC_(4201722.209153289718349983131072849092014086199978365482682238156395458110417683650024601275834747327), SC_(0.9999963427248407928960603045206067074457248210220499867639450479221835562130412184995459869785992116) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.2141970725233477423898875713348388671875e-6), SC_(14.77912606880405554320844579784391642177532601345234307603372558058988212196241643263517065797786068), SC_(0.351738436807596921667056270205114676221693090312843767336644235194061285388943755508505919901508354e-5), SC_(4201722.796937683359324632954791894432390651916798777950286009033063239897149264965020119315981616569), SC_(0.9999964826156319240307833294372979488532377830690968715623266335576480593871461105624448842042705906) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.23799674409019644372165203094482421875e-6), SC_(14.67376597396105649453036812443393894917032230518286562033759901077193801319022210687524045783721146), SC_(0.3492309005101563306261817049418309990117558274322812638483854942787654081882300992770309551270324434e-5), SC_(4201722.902297778202323681632869567842368124521802486219763464729189809715093373737214445075911816709), SC_(0.9999965076909948984366937381829505816900098824417256771873615161450572123459181176990071991691878782) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.261796429867899860255420207977294921875e-6), SC_(14.57845611939566069440237955049938520426980148453585722510870212146447641337367902080343147878809691), SC_(0.3469625566919142729058458937777665456140511546453599670387706066336210824338287507795926701398807221e-5), SC_(4201722.997607632767719481760858141776921869422323306866771859958086699022554973553757531147720795758), SC_(0.9999965303744330808572709415410622223345438594884535464003296122939336637891756617124921737467728518) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(0.4759934881803928874433040618896484375e-6), SC_(13.98062149012918366428511114800871268266807678547036949113325558045006169779368583987639389614502636), SC_(0.3327342852103207684752363058948584309242224498454602151301549811709032038532266697414493119576702341e-5), SC_(4201723.595442262034196511878126544267594391024048005932259593933533240036969689133750712074758378401), SC_(0.9999966726571478967923152476369410514156907577755015453978486984501882909679614677333025564018378888) }}, 
      {{ SC_(0.23799674409019644372165203094482421875e-6), SC_(100), SC_(0.3683601807561903453487227917946548385573708423867483923712851961583870164304112447598463530755600432e-45), SC_(0.876685357159490739543651112558346477678429021168165332787394475993615415533427560190914746185518374e-52), SC_(4201737.576063752163380176163237692276307073692124791034268904310598475138308595132817784902903804044), SC_(0.9999999999999999999999999999999999999999999999999999123314642840509260456348887441653522321570978832) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.4684659327125473282649181783199310302734375e-8), SC_(18.60167128432713126049714022480406049280333523742253441670062191512753054890362577998854409315927306), SC_(0.8714251809823585100435744204889726642363504946616200983606323205190597998352053381235925565434475928e-5), SC_(2134607.719702335830924452634528139632079027539349189946222122988726342566669414211039830503031253245), SC_(0.9999912857481901764148995642557951102733576364950533837990163936767948094020016479466186885703684354) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.2342329707971657626330852508544921875e-6), SC_(14.68968005301031976643331035840593236260593963861875850251422903256292992153558859166979463970637483), SC_(0.6881616658581063689027483359750385205817311632040590464481660589786955565901260462148502140670390048e-5), SC_(2134611.631693567147735946698358006030207157736744788749998037175119225131270041579077018821780706698), SC_(0.9999931183833414189363109725166402496147941826883679594095355183394102130444340987395377917268011473) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.4216193474348983727395534515380859375e-6), SC_(14.10189769843010546942720544113574262212174033914815624894996026913136790937284038362109117220840236), SC_(0.6606260569932264669724311527857042192425033889106042448471224318271263526523299301090977515234908494e-5), SC_(2134612.219475921727950243704462923300396898220944088220600290739387988562832053741825226870484174196), SC_(0.9999933937394300677353302756884721429578075749661108939575515287756817287364734767006988516153338386) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.468465941594331525266170501708984375e-6), SC_(13.99653795154726872064911358532555715075250091376154209367453177360967827288291670991444029822683104), SC_(0.6556903103556117701756044692650324280448295052811354149178811463849060684472815052010971899919429068e-5), SC_(2134612.324835668610786992482554779110582369590183513607214446014816484084521690231748900577135048177), SC_(0.9999934430968964438822982439553073496757195517049471886458508211885361509393155271849479320446785637) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.5153125357537646777927875518798828125e-6), SC_(13.90122846717327900573443124534289408072046032132905084924993091192893336556677221712553463128503422), SC_(0.6512253844142573792983300047299138761413093258190021203127553426086026396006741487672698566897127579e-5), SC_(2134612.420145152984776707397237119093245439622224106039705690439417345765266597547893393366040715119), SC_(0.9999934877461558574262070166999527008612385869067418099787968724465739139736039932585122707013214624) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(0.93693188318866305053234100341796875e-6), SC_(13.30339585924124739759212031089212333847672402485460266025103522751038192551102394791302682656440127), SC_(0.6232189552820929425724063540209542716098976591597168826685547888867254482172533948040105618796411538e-5), SC_(2134613.01797776091680831553954805354401618186596040251415387943831303018381803760364166257854851984), SC_(0.9999937678104471790705742759364597904572839010234084028311733144521111327455178274660519056985963154) }}, 
      {{ SC_(0.468465941594331525266170501708984375e-6), SC_(100), SC_(0.3683605725479766827321071158248024610889871068121879014042431546717690351697299841424421003359745422e-45), SC_(0.1725644291273138168367812516546848163348272913613526632863050085876922548670669754108825141004909997e-51), SC_(2134626.32137362015805571313166836443613952034268442700039596714137157496209284728988147497905013814), SC_(0.9999999999999999999999999999999999999999999999999998274355708726861831632187483453151836651727086386) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.93827008385005683521740138530731201171875e-8), SC_(17.90702316214094572298659865912103321153538476862255045041710203807962909160247665121229985025903671), SC_(0.1680163335056838077398797008411230046919538979550375838318300926071514855201858944311370322393218397e-4), SC_(1065772.709193038698101423512783256447871465508899001686943348418032826098774871502989957411806859754), SC_(0.9999831983666494316192260120299158876995308046102044962416168169907392848514479814105567410513836118) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.46913504547774209640920162200927734375e-6), SC_(13.99506127642124776837836720764985109178153219137764302176667988451990936472253249223036783388726104), SC_(0.1313115452836965224479618717278241114458994619815289665069740362966873246648867053544221848734683184e-4), SC_(1065776.621154924417799378121014707919053585262751578931850777068454979658494598382934116393738876125), SC_(0.9999868688454716303477552038128272175888554100538018471033493025963703312675335113294644440469083498) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.8444430932286195456981658935546875e-6), SC_(13.40728284792705405921175202864328757097913666333569562548985300639212003935826065277746216166174085), SC_(0.1257965931012412025349983859851347622688710042404386876405001481125409386466765200867553617943513245e-4), SC_(1065777.208933352911993087287629886925617106065147106973798173345281857786283923747205955846644548351), SC_(0.9999874203406898758797465001614014865237731128995759561312359499851887459061353323479912154637617612) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.9382700909554841928184032440185546875e-6), SC_(13.30192381681008314644771732812408682463580041914793229749678135625390915881071603376782206792029161), SC_(0.1248080402887664648327282693160891934565219594910834019494607138418106440419781733009870372044594217e-4), SC_(1065777.314292384028964000051664587444817852408483351161561501338353507924494804294750574856284642092), SC_(0.9999875191959711233535167271730683910806543478040508916598050539286158189355958021826697931448859998) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.1032097088682348839938640594482421875e-5), SC_(13.20661497875025012762779384532818383022623122387119083035384233620286037680268403521088485551131337), SC_(0.1239137854829003644420967188331993911497101698402351477679546617792491648844782042025557437882226045e-4), SC_(1065777.409601222088797018871588070240720846818052546438302968481292527975543586302782573413221854501), SC_(0.9999876086214517099635557903281166800608850289830159764852232045338220750835115521795796370419387344) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(0.1876540181910968385636806488037109375e-5), SC_(12.60878637553901204491902216024675411864495322083008785555374949312567040765393745883052572611561811), SC_(0.118304535465916112568189714154308952719629521613669050921313209741268280054132615368513967803378903e-4), SC_(1065778.007429825300035101580359755322150558399330549479405943281385371052733555451529149793580983897), SC_(0.9999881695464534083887431810285845691047280370478386330949078686790258731719945867384630460350367092) }}, 
      {{ SC_(0.9382700909554841928184032440185546875e-6), SC_(100), SC_(0.3683613712043972721284785441217690804271283553619040637700600414034391372851181449249753788454375212e-45), SC_(0.3456226444478972278783411373889022170828597871391079061470766426801423900748326644627836244326757172e-51), SC_(1065790.616216200839047146499381915568904677044283769941132427630737592049925418983706677931353491878), SC_(0.9999999999999999999999999999999999999999999999999996543773555521027721216588626110977829171402128609) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.1103985791672812410979531705379486083984375e-7), SC_(17.74435380867648812152933496485960258404476786406173463953011634554605933719259272711311375475803299), SC_(0.1958952753772566953498242883159414020023812695689979643011485485202188001854078620475897206530583608e-4), SC_(905790.4112795657874958983724894534951910792262926339613787307428128021213559866886812984349221420605), SC_(0.9999804104724622743304650175711684058597997618730431002035698851451479781199814592137950717386502682) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.5519929118236177600920200347900390625e-6), SC_(13.83240199524921665059220420848373304216701327641200330777099497738421402784766936501759673719510145), SC_(0.1527078544084987963856313110639561426635842499559565987476075848865420373992403312304836431670772084e-4), SC_(905794.3232313792147673693096202098710606211040472216111100625019341702832012960336046605304391596234), SC_(0.9999847292145591501203614368688936043857336415750044043401252392415113457962600759668768194225029971) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.993587264019879512488842010498046875e-6), SC_(13.24462490886106316287393487913916575705158663286235766831821349079415376982683222572107578879425981), SC_(0.1462188745651106776872810691146921473336713937031466336213028634135934579146848015983909268434307111e-4), SC_(905794.9110084656029208570278895392156279062194738651607557019547156568732615540544417998269601080242), SC_(0.999985378112543488932231271893088530785266632860629685336637869713658640654208531519840034264879967) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.1103985823647235520184040069580078125e-5), SC_(13.13926612806443380620890159824536270285898684727354039095364824370320538431486862617907709057838313), SC_(0.145055727819948523433548946373342543596620467207830016065730221064242728352586933273187223902751026e-4), SC_(905795.0163672463995502136929228201094309604120736507495729793192809039642099395664053993689588062401), SC_(0.9999854944272180051476566451053626657456403379532792169983934269778935757271647413066725556337275229) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.1214384383274591527879238128662109375e-5), SC_(13.04395751562867977601479924206537396455788261221552968013029646722097996898267084500789797820621899), SC_(0.14400353357944612109112828053740748994152953755309814198593266309410669228861155727365886727089781e-4), SC_(905795.1116758588353042438870251762894196987131778858075836901426326804464353548986031805401379186123), SC_(0.9999855996466420553878908871719462592510058470462446901858014067336905893307711388442725093726922333) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(0.220797164729447104036808013916015625e-5), SC_(12.44613028245889195314526377802303814639723486374610861628184568447768515751160901944018948547937381), SC_(0.1374036014696301636864284398259471275765181121693288907510605139360489228526085950515688702605826166e-4), SC_(905795.7095030920050920667565606403317555168738256342770047539910834631897301663696650061078464113391), SC_(0.9999862596398530369836313571560174052872423481887830671109248939486063951077147391404947240383896284) }}, 
      {{ SC_(0.1103985823647235520184040069580078125e-5), SC_(100), SC_(0.3683616529178052381665881389699748020204071322833363349847998142740388515100968673648824635925300167e-45), SC_(0.4066663019392149181472916823511259317809127307013032060113010114362889372649124804879664896024455817e-51), SC_(905808.1556333744639840199018244183547936632710604976547517173551239095008271849113069998294100316003), SC_(0.9999999999999999999999999999999999999999999999999995933336980607850818527083176488740682190872692987) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.32917764514195368974469602108001708984375e-7), SC_(16.65155242578472125077865818017999223921392810199846477971403538583319099062102780473636257392323267), SC_(0.5481329253963683268485517924942329825131898981531211012970208366056272337630903039856717034480939281e-4), SC_(303770.1062626347931374589587424136375844975939417950799330311101763610026855930167267593351775462019), SC_(0.9999451867074603631673151448207505767017486810101846878898702979163394372766236909696009596915935406) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.1645888232815195806324481964111328125e-5), SC_(12.73972770521527538267822317137670519799596610146753097060923980135013513590328680257040948135671992), SC_(0.4193641552003057301013006606266192945920011495663818867412051935690589833761577054967821955490894716e-4), SC_(303774.0180873553625833270591774224408715388119037956108668402149719454857414477344677615011306387684), SC_(0.9999580635844799694269898699339373380705407998850433618113258794806430941016623842294499591904285528) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.2962598728117882274091243743896484375e-5), SC_(12.15196758548750614810816925548754529398909569781173658751755855407673854395668028093021932645444306), SC_(0.4000163691429033836867481155186122291085579015247606273990437494519571006295620896429093158084368877e-4), SC_(303774.6058474750903525616292313383300314428187741992666612233066531927591380396810742831413207936707), SC_(0.9999599983630857096616313251884481387770891442098475239372600956250548042899370437910353630884853472) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.329177646563039161264896392822265625e-5), SC_(12.04661176479999811140634155307317082012928547668049387292417363273546037783917473474959920690240891), SC_(0.3965482844427912545484725619799632230432394450139294606522796058003039464067230273188509518679162789e-4), SC_(303774.7112032957778605983310590407444059166785844203979039379000381141004162057985798293219409132227), SC_(0.9999603451715557208745451527438020036776956760554986070539347720394199696053593276972677719022316198) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.3620954203142900951206684112548828125e-5), SC_(11.9513058346871546854430268054271323428043892394229824368371646704537864389908357145944831129426804), SC_(0.3934110203040145469851919253885289281354550622190107396674969903577664000002359749940237063215353518e-4), SC_(303774.8065092258907040242943737883904443940034806576554153739870470763820901446469188494770570071825), SC_(0.999960658897969598545301480807461147107186454493778098926033250300964223359999976402500257320128883) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(0.65835529312607832252979278564453125e-5), SC_(11.35349588872610896328418097803638672688730240356916402932870797027235794435578328336447095263168748), SC_(0.3737324158032554751677632184579216486690362817196885886244001238843540197986299939621207201338024427e-4), SC_(303775.4043191718517497464532196157811900099205674935092337814955037765635186392819712807070691674934), SC_(0.9999626267584196744524832236781542078351330963718280311411375599876115645980201370006034645128381626) }}, 
      {{ SC_(0.329177646563039161264896392822265625e-5), SC_(100), SC_(0.3683653721380312284826205368768214510441742859217687717386032933073829224777109467178511976182069205e-45), SC_(0.1212578766722560187765291681130619215149216547262060090468652488064353079918211357186902778217330973e-50), SC_(303786.757815060577858709737400593817576736807869896710032438686180518353256046760935721038779841092), SC_(0.9999999999999999999999999999999999999999999999999987874212332774398122347083188693807848507834527379) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.7517214584140674560330808162689208984375e-7), SC_(15.82526561764454728342966821589472139664724150322851707676102004489341962719271297708142489926523583), SC_(0.0001189624359255592237862815558880713087990446036924919297451377464603066416287689968160968864018086199), SC_(133011.5921247526357962961140535215356573850063967656547310417930455804934915615774106294070251964132), SC_(0.9998810375640744407762137184441119286912009553963075080702548622535396933583712310031828764352585812) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.375860736312461085617542266845703125e-5), SC_(11.9136711174867736236214905117854233020595342925902006208819680622720875863414628970824432555409585), SC_(0.8955801256011749182136346603310548654557058568185329217337255660386032244654301322159384759126826361e-4), SC_(133015.5037192527935699559222312256449554795941039762930474976720975631148236024286607094060068401375), SC_(0.9999104419874398825081786365339668945134544294143181467078266274433961396775534569867776319153204317) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.676549325362429954111576080322265625e-5), SC_(11.32594135190024678452441579889894896267064982164585841915236898476381380835673532183052606838012168), SC_(0.8513990254102399929452014271628757155054279541445707063427329024562379040764318665190921799104905263e-4), SC_(133016.0914490183800967950193059385314298189829884472373896994016966406230973804133882846579240272983), SC_(0.9999148600974589760007054798572837124284494572045855429293657267097543762095923568133473544750377556) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.75172147262492217123508453369140625e-5), SC_(11.22059097367312206653073895077567275460869589512040588102691631953165068957338656005947321526215693), SC_(0.8434795769015184423687469972049239605474093484775830456888644703398218908125781163514294606243344774e-4), SC_(133016.1967993966072215130129827866547060270449423737628422375271493058552604991967370464289768804163), SC_(0.9999156520423098481557631253002795076039452590651522416954311135529660178109187421883641275459281001) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.8268936653621494770050048828125e-5), SC_(11.12528990912070334842028256458211381512474226028542360283812420089076532037672003083652011247126413), SC_(0.8363155601580559427806131456374522701121867743686672003991362072258855893888535698270710264009848662e-4), SC_(133016.2921004611596402311234391728482649665288960085978245157159414244961458683934035756519299832072), SC_(0.9999163684439841944057219386854362547729887813225631332799600863792774114410611146430165695397630062) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(0.15034429452498443424701690673828125e-4), SC_(10.52751097678404353575292919405146988083574764759484244648238001487790069471777084676930229500190864), SC_(0.7913790392465455293988206610151183656909612886096098062466517289377091782971893578988250363352489437e-4), SC_(133016.8898793934963000437907925433789089008178906212884056720716856105090104940523527597191478006765), SC_(0.9999208620960753454470601179338984881634309038711390390193753348271062290821702810642094327174263602) }}, 
      {{ SC_(0.75172147262492217123508453369140625e-5), SC_(100), SC_(0.3683725554432829067612872243280108437998671942257655208036546827649132063228372793002427800872935906e-45), SC_(0.2769147613850834797683717278051538844876953879427870920239713852456644247557063040183715178499272632e-50), SC_(133027.4173903702803435795437217374303787816536382685148755631107827186256239644421139047490234929653), SC_(0.9999999999999999999999999999999999999999999999999972308523861491652023162827219484611551230461205721) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.1511466649617432267405092716217041015625e-6), SC_(15.12595076570930142415113875823363357295605035404639531204957676229163912554536395484786860379819604), SC_(0.0002286257018554836489431356554919182120306485455045215738223802134748684840969261143987440219174334289), SC_(66145.19916994425442492863121700354068887259624407405386839220202470859982980324427270767267845419994), SC_(0.9997713742981445163510568643445080817879693514544954784261776197865251315159030738855992827268867316) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.7557333447039127349853515625e-5), SC_(11.21474801747600544021891302933899204062674738345908426984713635013076848581541156507122243455520528), SC_(0.0001695086594120361608152520397283450067867848238131865217585243873315804028629930368548995307101041943), SC_(66149.11037269248772091256344273243533040492554704464117943440446512076070044297422509744932462344293), SC_(0.9998304913405879638391847479602716549932132151761868134782414756126684195971370069631436347615004895) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.136032003865693695843219757080078125e-4), SC_(10.62706953540145438211228219929587974373693257875211389636116678866837862820728731874228854130261406), SC_(0.0001606260174207471569365081380850234657541134789236385230635168619547026843142926801564681867741869564), SC_(66149.69805117456227197067007356247844270181536184934814980789043468222309030058234934377825851669552), SC_(0.9998393739825792528430634918619149765342458865210763614769364831380452973156857073198421423664634813) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.1511466689407825469970703125e-4), SC_(10.5217283030920710420271751774083507318685513631792218831470559162612814792956241968239372187464839), SC_(0.0001590338058934127984009976816073822319810839586199611584692214864905119201246855033780257665105196706), SC_(66149.80339240687165531075518058436597171368374306492104182110454555463018744949401246569660983925165), SC_(0.999840966194106587201599002318392617768018916041380038841530778513509488079875314496620598456498655) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.1662613431108184158802032470703125e-4), SC_(10.4264355109876301271981031203342846202336117292494299224581597787559235184819699396893186880311142), SC_(0.0001575934745176135022714455486103985583399812228677151058973982278479718134100796868413757261550940711), SC_(66149.89868519897609622558425264144003782531868269885083378179344169213554541030766672283122836996702), SC_(0.9998424065254823864977285544513896014416600187771322848941026017721520281865899203131572608626738619) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(0.302293337881565093994140625e-4), SC_(9.828708884099554001424941916212075487084962799859414028893879643820622081209781792423102714162883496), SC_(0.0001485589568395712643505830120438173096913648105126899546376260896365457651254865681004600329652559501), SC_(66150.49641182586417235135741384556224695846733162824084967535772182707084684757985487009744434383525), SC_(0.9998514410431604287356494169879561826903086351894873100453623739103634542348745134318982541208041678) }}, 
      {{ SC_(0.1511466689407825469970703125e-4), SC_(100), SC_(0.3683854715725894513002309725740864196602549074944340531013479342165808771852496626643756869511507703e-45), SC_(0.5568072268394504557778690982775295316749883343441024523739867296038356236511365515664473945650021877e-50), SC_(66160.32512070996372635278235576177432244555229442773187823267901201959123795621555081087378036313487), SC_(0.999999999999999999999999999999999999999999999999994431927731605495442221309017224704683250116656559) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.2986399749715928919613361358642578125e-6), SC_(14.44347128866797804254320337144696175530470055470521266198627254611752239956946388063299447899094848), SC_(0.0004313472190155501030896569938956659736892167348807185425401660569277545569606858499250007483497896845), SC_(33470.11525991597136927013076046767951907145561604238395713201888510331477346728061462396798203596631), SC_(0.9995686527809844498969103430061043340263107832651192814574598339430722454430393141500712755580780067) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.14931998521205969154834747314453125e-4), SC_(10.53298934494486248592836073751760320361934525816728821248100632046134537149957547738894248753739291), SC_(0.0003145625847871499789390051407327169757776588783212260872212135038949350196457449675293490951092101237), SC_(33474.02574185969448482674560310160887762314097133892188158152415132897095049535050302721203402741986), SC_(0.9996854374152128500210609948592672830242223411216787739127787864961050649803542550324679299115431488) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.26877596610574983060359954833984375e-4), SC_(9.945404515480021362587733815872595694113256781757636849823901616022240302898090931796315526851254516), SC_(0.0002970146507026173322852993450024201563994689836192835608369199098273473369769499899600983304965003603), SC_(33474.613326689159325950086230023253885132647059815331532944181256033410055563951987572804660988106), SC_(0.9997029853492973826677147006549975798436005310163807164391630800901726526630230500100373313408178958) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.2986399704241193830966949462890625e-4), SC_(9.840079901579465732843214072362487626956847745884392227313451134484924025450963336435141393066081442), SC_(0.000293869182525896149165406949428582823446559979619859120396893923972056280989654049182655440674856527), SC_(33474.71865130305988157983074976676399319980346885120477756669170651494737184139911516816583512189117), SC_(0.9997061308174741038508345930505714171765534400203801408796031060760279437190103459508148012372887276) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.3285039565525949001312255859375e-4), SC_(9.744802255840961696791206203994083490265040240805261065790243250755463432092351928601661325593760024), SC_(0.000291023762148601055251356945642216014539145254847673643084466811642833657820854639749072840275506773), SC_(33474.8139289487983856158827576351323973364952763562839087282149143986768324347577265759993151893635), SC_(0.9997089762378513989447486430543577839854608547451523263569155331883571663421791453602484082681593473) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(0.597279940848238766193389892578125e-4), SC_(9.14717104176328918518961076380731786405668690683150842878046749324077715909386465877327730353577352), SC_(0.0002731757976920549034977900895360045226613726748221935551188427826715608884761823170710237722713509186), SC_(33475.41156016287605812748435307531916296270362969025766136522469015619151870775621384582769921142148), SC_(0.9997268242023079450965022099104639954773386273251778064448811572173284391115238176829266105768538286) }}, 
      {{ SC_(0.2986399704241193830966949462890625e-4), SC_(100), SC_(0.3684105476210905758660119691693999231568920244230418745036699745074355905854317943022531500070237571e-45), SC_(0.1100240115387169835703968243867209607905004251861690953489409564307109814718315728157810594225260069e-49), SC_(33484.55873120463934731267396383912648082676031659672075924638406707356628389768067886893955635255911), SC_(0.9999999999999999999999999999999999999999999999999889975988461283016429603175613279039209499574813831) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.33870293236759607680141925811767578125e-6), SC_(14.31720238942907049297552494111382877647727570530129503408811089120835009311148255115581913663095916), SC_(0.0004849373071819764439701163901376387814417526401793160768534459803094529343896336966479239358629863374), SC_(29509.5040779898725862526272859494252292177926958652030180931500803005024829557905223829882923048893), SC_(0.9995150626928180235560298836098623612185582473598206839231465540196905470656103663033478895290088931) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.16935146049945615231990814208984375e-4), SC_(10.40691047854504248780606847036856254172159909999597537950418333192964361032354135839895755229081297), SC_(0.0003524919887474451509240612142476498836350009212484998307975031418234945001919280813074483076400324668), SC_(29513.41436990075661425779674242017049545254837247050833774773400785978118943857846357574515388922944), SC_(0.9996475080112525548490759387857523501163649990787515001692024968581765054998080719186895023361162419) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.30483262889902107417583465576171875e-4), SC_(9.819350184405234666635908417595308903154195123453563710580835876305653436752112255346451803972055836), SC_(0.0003325907609029898056613328653353558971533877245842967793706896707317906825596839290645004840538710585), SC_(29514.0019301948964220789669024729437490911157764470507494166573553154051796121498926787976596375482), SC_(0.999667409239097010194338667134664644102846612275415703220629310329268209317440316070932621032152602) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.3387029209989123046398162841796875e-4), SC_(9.714029967474893226070718648782901035048990936316174905801715892138690043484122559928930089465784884), SC_(0.0003290234646532887453117501035674050108594728887612117842860584809682600005118779722019427987801738806), SC_(29514.10725041182676351953209224175615695922098063418813822143647529957214300541788237421518135205447), SC_(0.9996709765353467112546882498964325949891405271112387882157139415190317399994881220277952093463229449) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.372573194908909499645233154296875e-4), SC_(9.618756290295504150679291840361072001457180360929476189681268594037377479585276382430598240905077075), SC_(0.0003257964542919062479775493594577207301243195502275949405490351641413709943370842931416737603794881568), SC_(29514.20252408900615259492351905017798599281279120957483693755692259767345556931672855171351320061518), SC_(0.9996742035457080937520224506405422792698756804497724050594509648358586290056629157068555060919169543) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(0.677405841997824609279632568359375e-4), SC_(9.021150118209977769369661913822350154574260160023683583849934104601272230099275600136580608292265416), SC_(0.0003055549629751071391692953118256452034225544854788440252479570264531927129183256159501686668145844057), SC_(29514.80013026109167897623314897671670783969571141048062954338825708710956081880272933400753083322799), SC_(0.9996944450370248928608307046881743547965774455145211559747520429735468072870816743840471849794429146) }}, 
      {{ SC_(0.3387029209989123046398162841796875e-4), SC_(100), SC_(0.368417359211589380644106182585882547154830603056568035135712185383458566122516657946904622592495098e-45), SC_(0.124786475203475492981880680444985672669319255539329124753005329473208429357103015626168704610698808e-49), SC_(29523.82128037930165674560281089053905799426997157013589576802660181106672686631612264048223851894846), SC_(0.9999999999999999999999999999999999999999999999999875213524796524507018119319555014327330680744460671) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.906601371752913109958171844482421875e-6), SC_(13.32766625254245825110649470500001943129292117610630938841581724589065103928788701940278452816203213), SC_(0.001208351238059217259682792854592180267930773389213798316633481769874991765667218417384814170782114559), SC_(11016.30166068767111816609109076631108341203038434939064808364291555174994086760604419736580896472206), SC_(0.998791648761940782740317207145407819732069226610786201683366518230125008234332781582604748065861277) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.453300672234036028385162353515625e-4), SC_(9.419926257182776517022895926409484352067829189600873716110165092219807998664911913725115098307086108), SC_(0.0008540564671719577089585424446736757990193663926394433506865722637349548673930129799998593821387184286), SC_(11020.20940068303079990017468954490161849125547633589608375594856770542078390822901930304347839457701), SC_(0.9991459435328280422910414575553263242009806336073605566493134277362650451326069870199927455104781301) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.815941239125095307826995849609375e-4), SC_(8.832692869115279858229943059767604487510279012419295119801389142561491382155749445189733923350106773), SC_(0.000800815023542192128687382174437403663078484345305910836692662587034014381145275804728327151169429313), SC_(11020.79663407109829655896764241154349835581302651307766235225734365507910052473818177157885956953398), SC_(0.9991991849764578078713126178255625963369215156546940891633073374129659856188547241952647349748299213) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.90660134446807205677032470703125e-4), SC_(8.727430826049971906348212554025347192715588891977251607850418423784049953050936933323672658446767512), SC_(0.0007912714532239945688448285892749091191211780369711198821360165381978358013539514443857278350234928369), SC_(11020.90189611416360451084937291728575565060771663351970586420831437385654195384299428344492083443732), SC_(0.9992087285467760054311551714107250908808788219630288801178639834618021641986460485556074162504164785) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.997261449811048805713653564453125e-4), SC_(8.632209720288806697979836349491137657538473859774062129721005259634448970817472923373720684036830969), SC_(0.0007826382432639295748024473933954531764891438153904447067216215761099225531362101851471566352482218512), SC_(11020.99711721992476971921774912181996518578483166572289534233772753800614293607645829339487280884726), SC_(0.9992173617567360704251975526066045468235108561846095552932783784238900774468637898148460615915283244) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(0.00018132026889361441135406494140625), SC_(8.034937165367621012403385050194062914400399481659795480629196054541348460406924268202873464639812311), SC_(0.0007284865997937062514333984230539655298090748100685469632626687619990184772409167844457303700120984405), SC_(11021.59438977484595540479420042111703992892290604383716199142953674309924344648700694856572002824428), SC_(0.9992715134002062937485666015769460344701909251899314530367373312380009815227590832155479529068724824) }}, 
      {{ SC_(0.90660134446807205677032470703125e-4), SC_(100), SC_(0.3685139280905710436994721242036189908822907308095409123448069561078678593239959083447966543087282335e-45), SC_(0.3341127042143331894995128098294766903840699864702825478136458410941040661121629222661952842590318733e-49), SC_(11029.62932694021357641719758547131110284332330552512844354396816175394111978269031232060857042237101), SC_(0.9999999999999999999999999999999999999999999999999665887295785666810500487190170523309615930013529717) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.2194953367506968788802623748779296875e-5), SC_(12.43373987899514817371075587132139485443214506207730602735670368997807545425512088305871519481722047), SC_(0.002729493664652995832349973328782885209015536934301774568321583311181753719149821467517250745511891109), SC_(4542.894612779359930696763756270298424153176154602170450605577474902282671287382887284187290135821235), SC_(0.9972705063353470041676500266712171147909844630656982254316784166888182462808501785324591507349176598) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.0001097476706490851938724517822265625), SC_(8.531320852619722141112899767045819093822995930695154031584126041215816155166875882487581518266900471), SC_(0.00187282237242922242378936855346676486844176077719594651316988802092256347855798929174324245822495782), SC_(4546.797031805735356729361612374573999913785303733552602601350052551044930586471132284758423812371555), SC_(0.998127177627570777576210631446533235131558239222804053486830111979077436521442010708240519736292165) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.0001975457998923957347869873046875), SC_(7.944759112436981693486452640261713310657748797857120514031225127700054003781309987895570449794531095), SC_(0.001744058495322440353745047952617773419218224692332730491234823572087297567363166250006584150337481453), SC_(4547.383593545918097176988059501358105696950550866390636118902953464560692737856698179350434880843925), SC_(0.9982559415046775596462549520473822265807817753076672695087651764279127024326368337499782844126231665) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.000219495341298170387744903564453125), SC_(7.839616321276975902690699813828798749419833668845508703463955919591030288317432278320268341823878493), SC_(0.001720977219282558933691469891573016359544150224165216183165218677630320163402413373007606413366651385), SC_(4547.488736337078102967783812327791020258188465995402247929470222672669716453320575888925736988814577), SC_(0.9982790227807174410663085301084269836404558497758347838168347813223696798365975866269774604691539586) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.00024144488270394504070281982421875), SC_(7.744503095161658141207857479767427181352103715589482798242989620972513814982014578857089943239937461), SC_(0.001700097664889995224860509709892924338099619180293268160105700171023341477236813804597436662920417724), SC_(4547.583849563193420729266654661852391826256195948658273834691188971288232926655993588388915387398518), SC_(0.998299902335110004775139490290107075661900380819706731839894299828976658522763186195387809621468277) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(0.00043899068259634077548980712890625), SC_(7.147916071385270836669332782699214935846752855366642332240367629021824482837854870367056003245966888), SC_(0.001569133006013487071839746656438447527691736574363137207479174522486544497757184099723703382882066507), SC_(4548.180436586969808033805179358920604071761546808881114300693810963238922258800153296878949327392489), SC_(0.9984308669939865129281602533435615524723082634256368627925208254775134555022428159002626681795663891) }}, 
      {{ SC_(0.000219495341298170387744903564453125), SC_(100), SC_(0.3687331011208829821235783702258587502637929563563458587356807166821056692427493581034758630251865637e-45), SC_(0.8094544949887119231192206599397651337303846082675520365698260713955607488778882482795863326932048023e-49), SC_(4555.328352658355078870474512141619819007608299663879023531813295610137168371412149456123292495415492), SC_(0.9999999999999999999999999999999999999999999999999190545505011288076880779340060234866269615391732448) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.43952159103355370461940765380859375e-5), SC_(11.7248404258160979769354582817952119388035751716360183491651552750743821551293817289372921816962114), SC_(0.005154627299251649735193641851543111286976235039314309717428885320547473321900656370966328331276270019), SC_(2262.899442792160429951010682745048571928617649846264704721195708938592244649554947990471151914901656), SC_(0.9948453727007483502648063581484568887130237649606856902825711146794525266780993436289890516351131804) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.000219760797335766255855560302734375), SC_(7.83083657612641887271360281559479397366267210746489478262532286731624501032259214089515922234449198), SC_(0.003442694529334712229699997236857947438566120263891184624805396362635773775239773564740607533332788745), SC_(2266.793446641850109055232538211248989893758552910435828287735541346350381794361737578513284874253376), SC_(0.996557305470665287770300002763142052561433879736108815375194603637364226224760226435229494340362304) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.0003955694264732301235198974609375), SC_(7.24532144716768982617832697253334219987931811907787823632604929273811234782563327766420074440951253), SC_(0.00318528273026151148152807884201841539015831359711160256942639415483064351635047204129743087811329525), SC_(2267.378961770808838101767814054310441667541906898822844834034814920928514456858696441744243352188355), SC_(0.9968147172697384885184719211579815846098416864028883974305736058451693564836495279586748846296169227) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.00043952159467153251171112060546875), SC_(7.140364480706150532727401915940526168301501877910360741000222814565954726488324514304129622211857059), SC_(0.003139140179495697248617573209358930430661494575899544993040362766436604135787018629165800864694473958), SC_(2267.483918737270377395218739110903257699119723139990362329360641399100672078196005205104314474386011), SC_(0.9968608598205043027513824267906410695693385054241004550069596372335633958642129813708069114497136447) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.00048347376286983489990234375), SC_(7.045419346954026093163136237173731985918760701870650921965535433932498334500966644424283355604192257), SC_(0.003097399161230560809233726951657173100662248650045340000316910346695702614441065249963897375001857947), SC_(2267.578863871022501834783004789670051881502464316030072148395328779734128470183363074984160740993676), SC_(0.9969026008387694391907662730483428268993377513499546599996830896533042973855589347500091738947417394) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(0.0008790431893430650234222412109375), SC_(6.449900943085110510007025494460553938971912992686386102438225189983220556127979375884854255747233149), SC_(0.002835589591948016030270074882629709463093839412199856857492205860509787683463753223614068822390953578), SC_(2268.174382274891417417939115532383229928449312025214336967922639023683406248556350343523589840850635), SC_(0.9971644104080519839697299251173702905369061605878001431425077941394902123165362467763612539003760559) }}, 
      {{ SC_(0.00043952159467153251171112060546875), SC_(100), SC_(0.3691077087993230098541586684799498253960030358212388385477602063116389413924752477757872434642021124e-45), SC_(0.1622719459748032306091668523258917509933575031508427758365556526257272383098869157534227205746190056e-48), SC_(2274.624283217976527927946141026843783867421225017531615361561541203812468136204379913573925606138419), SC_(0.9999999999999999999999999999999999999999999999998377280540251967693908331476741082490066424968491572) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.6333151759463362395763397216796875e-5), SC_(11.34787479276627224580337785406716408637962399339194101942392509498124552134738596941813889524189291), SC_(0.007189406708716155036412741210682079270084489676201376425675990314746938093155481859795382443915378031), SC_(1567.068154864945736082743209084143469696500226900908223039910275026461205789315128688234147685462369), SC_(0.9928105932912838449635872587893179207299155103237986235743240096852530619068445181401423236020871227) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.0003166575916111469268798828125), SC_(7.46089020000764916854497751483875323689070673926667523004343500772904424536063023825665047822216213), SC_(0.004726821104082162211221019391397195168330253616352950214361929952096861402799079871019712108594353278), SC_(1570.9551394577043591600016094233718805459891441550334888292907651137134070653018844193956361024821), SC_(0.9952731788959178377887789806086028048316697463836470497856380700479031385972009201289391871117416547) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.0005699836765415966510772705078125), SC_(6.876238555953408718416594537798340473268048068243365549088675013223047395061285527034096028063455391), SC_(0.004356417083172018959221261794953155882713682295744458780583951852807903015349109501873436912557839796), SC_(1571.539791101758599610129992400412293309611802826056798510245525108219403915601229130618190552640806), SC_(0.9956435829168279810407787382050468441172863177042555412194160481471920969846508904980886500292422297) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.000633315183222293853759765625), SC_(6.771434840437260588331514267600610227543507825827826035725496428238340010820087908340515022118788088), SC_(0.004290019052775130897611439445652375220154925215169162214634538171707307054215692115889625397046700523), SC_(1571.644594817274747740215072670610023555336343068472338023608703693204111299842426749311771558585474), SC_(0.9957099809472248691023885605543476247798450747848308377853654618282926929457843078840730329705876445) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.0006966466899029910564422607421875), SC_(6.676628330764053718403410068010161982564575265578611073379627007746838969385121207523321517555412416), SC_(0.004229954717459323080685991209588121205189081545404163038362373791787135439566525790025670496067884073), SC_(1571.739401326947954610143176870200471800315275628721552985954573113695612341277393450128965063148849), SC_(0.9957700452825406769193140087904118787948109184545958369616376262082128645604334742099375047892026149) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(0.00126663036644458770751953125), SC_(6.081991793575300930669877059912523255467802980275504680256341769545559907751915715125394582719715743), SC_(0.003853224802141811439696054746351860608527516211098292685669914318068132022118945358853821902319624959), SC_(1572.334037864136707397876709878298110527412047914024659379077858351896891402910598942526891997984546), SC_(0.996146775197858188560303945253648139391472483788901707314330085681931867977881054641112595545479944) }}, 
      {{ SC_(0.000633315183222293853759765625), SC_(100), SC_(0.3694379690261862441325547580779226268301879715648517819995454465782418074378402817780801082967918397e-45), SC_(0.2340561436811439703203842074408197989072039571083394976470309063569495885679226428931556445308685332e-48), SC_(1578.416029657712008328546586938210633782879850893930726090308013877309896552584592044406716408821022), SC_(0.9999999999999999999999999999999999999999999999997659438563188560296796157925591802010927960428916605) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.111512335934094153344631195068359375e-4), SC_(10.75565287760055913740896765612346180311358345238570566038074692418172394911119161095101631036767488), SC_(0.01200159039933653983583114137969082611740910486766791959127703282711250142887973666639872027637829415), SC_(885.4299791695606740915428863435242067141380032869117726428486785830959728412220222106788217929350633), SC_(0.9879984096006634601641688586203091738825908951323320804087229671728874985711202633334970564592023341) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.0005575616960413753986358642578125), SC_(6.885167272326057966535769528825983541933992512736792077330130169067106186004022887959255171444342864), SC_(0.007682746772672796158096373764491740122177572401804292342758055981690000793802753543348292402431921404), SC_(889.3004647748351752624160844708216849753175942265606862258992953382105906043291909336705829318583953), SC_(0.9923172532273272038419036262355082598778224275981957076572419440183099992061972464565847222834198242) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.001003611017949879169464111328125), SC_(6.30252206344623165988876425803389624898732275590340990562159593227980675830276598586422406560337573), SC_(0.007032607796946431298475925944642590950715313399609344319157521664390535346690051356774370432862863186), SC_(889.8831099837150015690630897416137722682642639833940683976078295749978900320304478357656140376993624), SC_(0.9929673922030535687015240740553574090492846866003906556808424783356094646533099486431642498837873551) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.001115123392082750797271728515625), SC_(6.198074030154650235800040800844929293448468193045593098727956654474399692192252388629721688277597352), SC_(0.006916060477332535827357501075793973568818642279447521929382182165878590242224495036138432073930557823), SC_(889.9875580170065829931518131988027392238031185462518852045014688528032970981409614330001164150251408), SC_(0.993083939522667464172642498924206026431181357720552478070617817834121409757775504963801193137470936) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.001226635766215622425079345703125), SC_(6.10358926752454803303914287923957841459461280215270747928413969329151971770320704193589046351143213), SC_(0.006810630576147588021140262758498336091892334032398841343355219693328993172419541903195723506762135893), SC_(890.082042779636685195912711120408090102656973937144770823945285813986177072630006779693947639791306), SC_(0.9931893694238524119788597372415016639081076659676011586566447803066710068275804580967448107427423296) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(0.00223024678416550159454345703125), SC_(5.511002392559784093447480079969735304976321758213552021607928542239835444892393114944382553871657622), SC_(0.006149398289248371799951508353724551195819571305616213669422026554687463700662545335191097528796241802), SC_(890.6746296546014491355043739196779332122752649810839262816214969650378613454408207066854555494310805), SC_(0.9938506017107516282000484916462754488041804286943837863305779734453125362993374546647551380002973232) }}, 
      {{ SC_(0.001115123392082750797271728515625), SC_(100), SC_(0.3702603407772645384456820318760441217718875049034628199922739228789532164646234722215423167851765606e-45), SC_(0.4131513913378381515046787628785713975260428930204907684112778279965472625312124850546678692814116117e-48), SC_(896.1856320471612332289518539996476685172515867389272179624521609688320147584571697075857117915787288), SC_(0.9999999999999999999999999999999999999999999999995868486086621618484953212371214286024739571069795092) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.19624678316176868975162506103515625e-4), SC_(10.14900337572979834752856828435222968276857358458714259561564982034712198149362402081020553741206422), SC_(0.01993960339030124946382735375426398898016732760536631077824983188773118787016291491977308720148649153), SC_(498.838220546002689994967652630969995367921390863210470202269511362753642603088983457060814250816841), SC_(0.980060396609698750536172646245736011019832672394633689221750168112268812129837085080053110668504355) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.000981233897618949413299560546875), SC_(6.305521200834886415416308899675210215771248321994179673970836310627256136803935764077555320110596483), SC_(0.01238836832141093816026665145857334532773760114600233715357901408496679192890752816999172230181319178), SC_(502.6817027208976019270799120156470148349187161258034331239143248724735084477786717137934644681183087), SC_(0.9876116316785890618397333485414266546722623988539976628464209859150332080710924718298997986627453569) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.001766221015714108943939208984375), SC_(5.726110295062204477106095949553648066139026407441921607813130915916652757384186149128304038958709409), SC_(0.01125000790971270941434582089991592017532662129224464813640856532380797238503895270719870060927437707), SC_(503.2611136266702838653901249657685769845509380403556911900720302671841118271984213287427157492701958), SC_(0.9887499920902872905856541791000840798246733787077553518635914346761920276149610472927026679132196737) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.00196246779523789882659912109375), SC_(5.622235238195502609729557776235833053907662308569455149216171573860273454724603801088353898636734914), SC_(0.01104592605463912342911567873591583653599892781918782710272429010531004179081995306973316838325624233), SC_(503.3649886835369857327666631390863919967823021392281576486689896092404911298580036767826658895921703), SC_(0.9889540739453608765708843212640841634640010721808121728972757098946899582091800469301699655800162906) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.00215871445834636688232421875), SC_(5.528268826085020416140321670222386364107340204532141274836755795867025003823450858816714198544287396), SC_(0.01086131157377558900448272017872066564975710285331866197337535645094791015296927056530787659789095208), SC_(503.4589550956474679263558992450998386865826242432654715230484053872337395807591566190543055896846178), SC_(0.9891386884262244109955172798212793343502428971466813380266246435490520898470307294345968544007118276) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(0.0039249355904757976531982421875), SC_(4.938987082914699838457983226719965217476612853363045113042016127451297846013281495884499568865883318), SC_(0.009703558067449986097531968416312103910922126732481402762324146425017417699686163534289754729460729665), SC_(504.0482368388177885040382376886022598332133515944345676848431450556494667385693259819865202193630219), SC_(0.9902964419325500139024680315836878960890778732675185972376758535749825823003138364656249915899590869) }}, 
      {{ SC_(0.00196246779523789882659912109375), SC_(100), SC_(0.371711069233994618089251980379787404703200868503681252205878708328579900643829653098280882608666812e-45), SC_(0.7302954804444227624038715794279959610192586730525009887130851252337543775699440571494118134245598624e-48), SC_(508.9872239217324883424962209153222250506899644474259017286511665650115126042028200775715570287875006), SC_(0.999999999999999999999999999999999999999999999999269704519555577237596128420572004038980741326947499) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.5553754817810840904712677001953125e-4), SC_(8.964916995922265562670509435276988555999266212543889148630586594457109756662300790199875201890414176), SC_(0.04994755397027048426834023531853787482994000264191186425566638484033048318774106778174252966339825561), SC_(170.521690121181316177902329265915998355956795018230725850859227674038580240062721109869774095721396), SC_(0.9500524460297295157316597646814621251700599973580881357443336151596695168122589322178155624007872869) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.0027768774889409542083740234375), SC_(5.222169637141671636404804427422403643545438726610446085568828215923685407329063311433402344362745274), SC_(0.02909503790293689426695312636806957821114009596057981217975996295813570004816536813932743724112559258), SC_(174.2644374799619101041680342737705832684106225041641689139209860525720045893959585886362469532490649), SC_(0.9709049620970631057330468736319304217888599040394201878202400370418642999518346318604135760837493635) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.004998379386961460113525390625), SC_(4.654508257117303320411512555062309276826075249498977524731665069947789435192356659973016340215335662), SC_(0.02593234298579466195965215749908092357421845490729802493578101747721091498484013447327969090018933084), SC_(174.8320988599862784201613261461306776351299859812756374747581491985479005615326652400966329573964745), SC_(0.9740676570142053380403478425009190764257815450927019750642189825227890850151598655264890660379528003) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.005553754977881908416748046875), SC_(4.552711102485910264547873147973210224670389064059533400410882648423784089166455372965055776226103584), SC_(0.02536518560137223040331237053691364143746751771600885263808132832279168674495735497543463321073851608), SC_(174.9338960146176714760249655532197766872856721667150815990789316200719059075585665271045935213857066), SC_(0.9746348143986277695966876294630863585625324822839911473619186716772083132550426450243390989132964284) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.006109130568802356719970703125), SC_(4.460624247688622547953655889386147254858073264917443243978430055334332005853002076023509767191650769), SC_(0.02485212863140451070724595723004764521959822842170598463337027497439070096530401467959144797904202474), SC_(175.0259828694149591926191828118068396570979879658571717555113842131613579908720198240461395304201594), SC_(0.9751478713685954892927540427699523547804017715782940153666297250256092990346959853201867847542934446) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(0.01110750995576381683349609375), SC_(3.883357360216657997244393968550088480113409837493760013294217647121382192929527127834473880298138601), SC_(0.02163591714496566646516776444203604062813292121063084740422116343165497104858943114627344800197163485), SC_(175.6032497568869237433284447326428984318426513932808549861955966213743078037954947722351754173136716), SC_(0.9783640828550343335348322355579639593718670787893691525957788365683450289514105688535329977996498619) }}, 
      {{ SC_(0.005553754977881908416748046875), SC_(100), SC_(0.3779230356323651469251400251436801657115323311828038629573248866991682540425440079590315860323569243e-45), SC_(0.2105577913040578184612113756477261211410811213425891696964581142045415939710425561995401419156912192e-47), SC_(179.4866071171035817405728387011929869119560612303966919638574491215705499715813417359332742369180329), SC_(0.9999999999999999999999999999999999999999999999978944220869594218153878862435227387885891887865741083) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.869112918735481798648834228515625e-4), SC_(8.412150535244441203168046070317310253724567623691078331486778211100219408535590313077554856570699598), SC_(0.0734742369214086089210153054947260329971557695201341707775521940117156621771297470370953689874816908), SC_(106.0790083759050634625337598716446870920526426681515083014260468453871574230843464967785306090985135), SC_(0.9265257630785913910789846945052739670028442304798658292224478059882843378228702529622462611547659734) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.0043455646373331546783447265625), SC_(4.747483533337902183946818699971831287857052577276252258033190690531537548113688962993636655174478423), SC_(0.04146594006461382313537482617248709417766142416202542486142474476114080262861893941422971907404955593), SC_(109.7436753778116024817549872419901660579201577145663343748796343659558392835062478468624488104947346), SC_(0.9585340599353861768646251738275129058223385758379745751385752552388591973713810605853961293779614401) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.00782201625406742095947265625), SC_(4.188714405951040634652072336322477039569342050275559543021997361729942472593051923062465693734697627), SC_(0.03658548350621272832275084129392436578573561492653168803027125335941528070349701044338510087997499593), SC_(110.3024445051984640310497336056395203062078682415670270898908276947574343590268848867936197719345154), SC_(0.9634145164937872716772491587060756342142643850734683119697287466405847192965029895562840836832982795) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.008691129274666309356689453125), SC_(4.08848737420065935929134320387738037551705209754263277179328266373220927403385787131830593805064886), SC_(0.03571007065596669193904108016015709813865155263375873910595316749759359782915444208415216634230658664), SC_(110.4026715369488453064104627380846169702601581942999538611195423927551675575860789385377795276185642), SC_(0.9642899293440333080609589198398429018613484473662412608940468325024064021708455579155247914668146388) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.00956024229526519775390625), SC_(3.99782079814824918307908619479527349158197798771392975095659098640536858272574657135383729506757053), SC_(0.03491816168312825922906539505187828450927190406957704260083957374549678225908496848420561100299384268), SC_(110.4933381130012554826227197471667238541952323041286568819562340700820082488941902385022481706016425), SC_(0.9650818383168717407709346049481217154907280959304229573991604262545032177409150315154783785776319255) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(0.01738225854933261871337890625), SC_(3.429652593561693644638834896451401252091493865356407433916434404687048079702486661999920641307007191), SC_(0.02995561077535484202820021234487128647994519436125259940646933255344394936860990914312183685175046186), SC_(111.0615063175878110210629710455105960936857164264861791989963906518003287519174501478561648243622059), SC_(0.9700443892246451579717997876551287135200548056387474005935306674465560506313900908566062177985487162) }}, 
      {{ SC_(0.008691129274666309356689453125), SC_(100), SC_(0.3834347555474465586395291403125251405405389593008695231904802071464782586691835903731927721307539629e-45), SC_(0.3349033752422838748916689259240733539203045003131547237515235304204672805448804838430882271615821179e-47), SC_(114.4911589111495046657018059419619973457772102914591518773653784978478476913074116703328547030652432), SC_(0.9999999999999999999999999999999999999999999999966509662475771612510833107407592664607969549968684528) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.00029933368205092847347259521484375), SC_(6.65558792122502145790203122705781927392537710568382982650902879917995730340091807239175568813213068), SC_(0.2025490756976798423479118675089777352736957583605687315155725757125233270513154513279880668403039601), SC_(26.20354954113990720677295171562168818585244384318224849305166810303853836693243368037159645376977416), SC_(0.7974509243023201576520881324910222647263042416394312684844274242874766729486845486700376252368081425) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.01496668346226215362548828125), SC_(3.412781457563949627493849132800205293732370924443084983071137019169168281694119440771156646106558311), SC_(0.1038609568334763548457972777288529241469923900253962807775257423932593724995787612069914513230733471), SC_(29.44635600480097903718113380987930216604545002442299333648955988304932738863923231199219549579534653), SC_(0.8961390431665236451542027222711470758530076099746037192224742576067406275004212387919853803026229454) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.02694003097712993621826171875), SC_(2.900428060083442521700414212209539293181960970813005023783465175158447954051342500859962243168594771), SC_(0.08826853910591643763067442789157912471708232570630547469480133709625147782109251555169415725060617567), SC_(29.95870940228148614297456873046996816659585997805307329577723172706004771628200925190338989873331007), SC_(0.9117314608940835623693255721084208752829176742936945253051986629037485221789074844474329514837168865) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.0299333669245243072509765625), SC_(2.80837448661732195170761906499999493821123607368254428592631444869917451230049026839722143354330746), SC_(0.08546707867283131075432095045307988463257577828543753893332063453617336634663328499785869123628549113), SC_(30.05076297574760671296736387767951252156658487518353403363438245351932115803286148436613070835859738), SC_(0.9145329213271686892456790495469201153674242217145624610666793654638266336533667150012954175041413206) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.0329267047345638275146484375), SC_(2.725101221535109535021413719100843696433626664532974402284107300109171958371467977939595309468299124), SC_(0.08293282879553038976697110966809591185042939605421337827594738688004093044577294705637033103753406651), SC_(30.13403624082981912965356922357866376334419428433310391727658960210932371196188377482375683243360572), SC_(0.9170671712044696102330288903319040881495706039457866217240526131199590695542270529428082023784467733) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(0.059866733849048614501953125), SC_(2.204476228650003963881192397589198776933448409172425381454446680594408859247730852369919972696722456), SC_(0.06708868214130365722661165568506456062512493800386324405219217526484257111958289695748025178580326486), SC_(30.65466123371492470079379054509030868284437253969365293810625022162408681108562090039343216920518239), SC_(0.9329113178586963427733883443149354393748750619961367559478078247351574288804171030418509848600074949) }}, 
      {{ SC_(0.0299333669245243072509765625), SC_(100), SC_(0.4229279999195938340595688371433305871889682449285871973650802503052523480463068726888829167170666972e-45), SC_(0.1287094040140258076521551344643561104581741100997942473491238945795244936062181105143232448905621274e-46), SC_(32.85913746236492866467498294267950745977782094844315031964110306815892683319002116589180337092808888), SC_(0.9999999999999999999999999999999999999999999999871290595985974192347844865535643889541825889900205753) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.00051242602057754993438720703125), SC_(5.750398977913244900274962421353297368031325639433868586950794911944578215691256892664192413362591034), SC_(0.3028722400658670309060582521260906731221817754690304799285207885428553696560930593067285904368322388), SC_(13.23582100930869053226053270179389011404206015970023183245494980462996606312399917775634092248377199), SC_(0.6971277599341329690939417478739093268778182245309695200714792114571446303439069406900635548967258876) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.025621302425861358642578125), SC_(2.832141251899738927184198830918552560705390731127443324742929027769956627452021708549562866974237375), SC_(0.1491682522274481432092518761039267269452211637367753155145843941704919377471471128043007783037985871), SC_(16.15407873532219650535129629222863492136799506800665709466281568880458765136323436187097046887212565), SC_(0.85083174777255185679074812389607327305477883626322468448541560582950806225285288719409849230013501) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.0461183451116085052490234375), SC_(2.354535041475650840188296544626824459348071689176520405240621833882890783690260790374595349243249817), SC_(0.1240128389463671496190159389825520574179898719077050768343103933526658807883438828524452225211835791), SC_(16.63168494574628459234719857852036302272531410995758001416512288269165349512499528004593798660311321), SC_(0.8759871610536328503809840610174479425820101280922949231656896066473341192116561171462170724905049019) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.05124260485172271728515625), SC_(2.268581955935316913153430290814781029572894726877321715668417204937011887527880456166238463358814554), SC_(0.119485708975357549703407111440249731302572941365773848592259365032731048905891169977364697529085816), SC_(16.71763803128661851938206483233240645250049107225677870373732751163753239128737561425429487248754847), SC_(0.8805142910246424502965928885597502686974270586342261514077406349672689510941088300213449330467672867) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.0563668645918369293212890625), SC_(2.190826928493114755175474738392958609573869639135473828240129903375769251681938201165488344589073467), SC_(0.1153903689079543131568507907786239460633868239209515305709967719710419887432512190607714956691512904), SC_(16.79539305872882067736002038475422887249951615999862659116561481319877502713331786925504499125728956), SC_(0.8846096310920456868431492092213760539366131760790484694290032280289580112567487809379809556858218957) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(0.1024852097034454345703125), SC_(1.705832980948029655675174791358196762256920326164848611959849532446454449849713723349992966594024533), SC_(0.08984584514959194964111225566819986886942747214355191893796722859826575799935451129133496979377311521), SC_(17.2803870062739057768603203317889907198164654729692518074458951841280898289655423470705403692523385), SC_(0.9101541548504080503588877443318001311305725278564480810620327714017342420006454887076845744989248092) }}, 
      {{ SC_(0.05124260485172271728515625), SC_(100), SC_(0.4666332762470370840214357140870669083484141793110941527015291021554978221892371620740912810024635374e-45), SC_(0.2457747126921997105292850810706506718048727997191850109419737442424277356633748861407006331354595514e-46), SC_(18.98621998722193543253549512314718748207338579866746714315870763255310856472818916227141762310922602), SC_(0.9999999999999999999999999999999999999999999999754225287307800289470714918929349328195127200280814989) }}
   } };


