/* ANSI-C code produced by gperf version 2.7.1 (19981006 egcs) */
/* Command-line: gperf -L ANSI-C -I -t -H b5Hash -N inBig5 -C -E -o -n -c -D b5percent.txt  */
/****************************************************
 400 Most frequently used BIG5 chars in GB code space.
 The percentage is taken over all BIG5 code space.
****************************************************/
#include <string.h>
#include "zhstatis.h"

/* maximum key range = 986, duplicates = 4 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
b5Hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986, 986, 986, 986, 986, 986, 986, 986, 986, 986,
      986,  81,   0, 166,   0,  55,  35,   5, 396,  21,
      116,  80, 265,  19, 986, 311,  28,  25, 345, 105,
      215,  95,  10, 415,  30, 468,  40, 110, 330,  80,
      155, 480, 180, 333,  21, 498, 188, 190,  89, 453,
      200, 228, 380,  13, 436, 475,  11, 278, 273, 430,
      280, 340, 120, 236, 183, 296, 488, 500, 456, 356,
      246, 120,  64, 491,  78, 285, 163, 461, 418, 288,
        4, 510, 326, 438, 383, 478,  76, 135, 330, 260,
      495,  45,  33,   1,  73, 501, 380, 433, 348, 505,
      425, 363,  23, 206, 195, 986
    };
  return asso_values[(unsigned char)str[len - 1]] + asso_values[(unsigned char)str[0]];
}

#ifdef __GNUC__
__inline
#endif
const struct charHz *
inBig5 (register const char *str, register unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 400,
      MIN_WORD_LENGTH = 2,
      MAX_WORD_LENGTH = 2,
      MIN_HASH_VALUE = 0,
      MAX_HASH_VALUE = 985
    };

  static const struct charHz wordlist[] =
    {
      {"",	0.769287},
      {"",	0.306841},
      {"",	0.019016},
      {"",	0.088828},
      {"",	0.065464},
      {"",	0.031305},
      {"",	0.112574},
      {"",	0.028211},
      {"",	0.046708},
      {"",	0.015041},
      {"",	0.071498},
      {"",	0.025611},
      {"",	0.035635},
      {"",	0.016753},
      {"§",	0.018038},
      {"",	0.160736},
      {"",	0.090439},
      {"",	0.058479},
      {"",	0.037804},
      {"",	0.015738},
      {"",	0.014759},
      {"",	0.229607},
      {"",	0.034256},
      {"",	0.166304},
      {"",	0.093519},
      {"",	0.018394},
      {"",	0.045773},
      {"",	0.147260},
      {"",	0.017462},
      {"",	0.055894},
      {"",	0.015586},
      {"",	0.018907},
      {"",	0.019326},
      {"",	0.015277},
      {"",	0.039054},
      {"",	0.049332},
      {"",	0.057086},
      {"",	0.043716},
      {"",	0.423518},
      {"",	0.038273},
      {"",	0.016983},
      {"",	0.065455},
      {"",	0.043318},
      {"",	0.137466},
      {"",	0.404486},
      {"",	0.027452},
      {"",	0.031913},
      {"",	0.022180},
      {"",	0.108684},
      {"",	0.064182},
      {"",	0.066723},
      {"",	0.023091},
      {"",	0.113864},
      {"",	0.021874},
      {"",	0.015441},
      {"",	0.037946},
      {"",	0.028469},
      {"",	0.014519},
      {"",	0.069696},
      {"",	0.093334},
      {"",	0.128990},
      {"",	0.070255},
      {"",	0.083516},
      {"",	0.072818},
      {"",	0.016109},
      {"½",	0.018793},
      {"",	0.135395},
      {"",	0.098976},
      {"",	0.022989},
      {"",	0.185013},
      {"",	0.067999},
      {"",	0.041783},
      {"",	0.169524},
      {"",	0.098767},
      {"",	0.035493},
      {"",	0.031729},
      {"",	0.117938},
      {"",	0.019888},
      {"",	0.079914},
      {"",	0.041485},
      {"",	0.018574},
      {"",	0.016470},
      {"",	0.068123},
      {"",	0.014632},
      {"",	0.019986},
      {"",	0.061454},
      {"",	0.060330},
      {"",	0.016134},
      {"",	1.331823},
      {"",	0.311471},
      {"",	0.014513},
      {"",	0.033989},
      {"",	0.103263},
      {"",	0.127011},
      {"",	0.029026},
      {"",	0.015288},
      {"",	0.025526},
      {"",	0.137685},
      {"",	0.205378},
      {"",	1.647294},
      {"",	0.114942},
      {"",	0.049163},
      {"",	0.023332},
      {"",	0.029635},
      {"",	0.022240},
      {"¾",	0.030851},
      {"",	0.141643},
      {"",	0.120274},
      {"",	0.028860},
      {"",	0.102537},
      {"",	0.092950},
      {"",	0.051303},
      {"",	0.371579},
      {"",	0.014627},
      {"",	0.046636},
      {"",	0.049927},
      {"",	0.063111},
      {"",	0.019307},
      {"",	0.019892},
      {"",	0.082802},
      {"",	0.037599},
      {"",	0.069500},
      {"",	0.046553},
      {"",	0.022982},
      {"",	0.039860},
      {"ı",	0.125828},
      {"",	0.027650},
      {"",	0.014572},
      {"",	0.035152},
      {"",	0.028902},
      {"",	0.030283},
      {"",	0.018765},
      {"",	0.037953},
      {"",	0.015175},
      {"",	0.052447},
      {"",	0.016471},
      {"",	0.018525},
      {"",	0.016991},
      {"",	0.016309},
      {"",	0.023295},
      {"",	0.210737},
      {"ť",	0.109895},
      {"",	0.019304},
      {"",	0.016478},
      {"",	0.120442},
      {"",	0.029056},
      {"",	0.017140},
      {"",	0.205663},
      {"",	0.021996},
      {"",	0.026937},
      {"",	0.100132},
      {"",	0.076828},
      {"",	0.074701},
      {"",	0.070771},
      {"",	0.033967},
      {"",	0.135818},
      {"",	0.286923},
      {"",	0.021442},
      {"",	0.066187},
      {"",	0.154665},
      {"",	0.066513},
      {"",	0.019366},
      {"",	0.092406},
      {"ĵ",	0.019427},
      {"",	0.143276},
      {"ԣ",	0.019852},
      {"",	0.378802},
      {"",	0.029765},
      {"",	0.060734},
      {"ĳ",	0.060089},
      {"",	0.047633},
      {"",	0.017041},
      {"",	0.142548},
      {"",	0.041400},
      {"",	0.036977},
      {"",	0.030253},
      {"",	0.014722},
      {"Ū",	0.041732},
      {"",	0.023904},
      {"",	0.024133},
      {"",	0.034493},
      {"",	0.031733},
      {"",	0.017932},
      {"",	0.036924},
      {"",	0.086345},
      {"",	0.036020},
      {"",	0.014800},
      {"",	0.015329},
      {"",	0.039660},
      {"",	0.021045},
      {"",	0.029324},
      {"",	0.180739},
      {"",	0.020917},
      {"",	0.021087},
      {"",	0.016450},
      {"",	0.034270},
      {"",	0.023452},
      {"",	0.135500},
      {"",	0.022743},
      {"",	0.175203},
      {"",	0.029011},
      {"",	0.025235},
      {"",	0.020801},
      {"",	0.335331},
      {"",	0.159704},
      {"",	0.043805},
      {"",	0.082474},
      {"",	0.041141},
      {"",	0.070902},
      {"",	0.019910},
      {"²",	0.029031},
      {"",	0.016313},
      {"",	0.018368},
      {"",	0.125698},
      {"",	0.034810},
      {"",	0.267319},
      {"",	0.112807},
      {"",	0.018520},
      {"",	0.030641},
      {"",	0.348555},
      {"",	0.036569},
      {"",	0.056596},
      {"",	0.016607},
      {"",	0.122909},
      {"",	0.054052},
      {"",	0.268859},
      {"",	0.094117},
      {"",	0.024633},
      {"",	0.096599},
      {"",	0.065257},
      {"",	0.021939},
      {"",	0.019991},
      {"",	0.014644},
      {"",	0.030914},
      {"",	0.062679},
      {"",	0.015188},
      {"",	0.021828},
      {"",	0.649007},
      {"",	0.037749},
      {"",	0.072864},
      {"",	0.053675},
      {"",	0.093825},
      {"",	0.034648},
      {"",	0.018468},
      {"",	0.097010},
      {"",	0.031320},
      {"",	0.034071},
      {"",	0.017071},
      {"",	0.331414},
      {"",	0.236619},
      {"",	0.017806},
      {"",	0.033741},
      {"",	0.071342},
      {"",	0.158870},
      {"",	0.075241},
      {"",	0.082499},
      {"",	0.050505},
      {"",	0.037712},
      {"",	0.033770},
      {"",	0.026064},
      {"",	0.122616},
      {"",	0.072859},
      {"",	0.036769},
      {"",	0.023777},
      {"",	0.018066},
      {"",	0.024433},
      {"",	0.105024},
      {"",	1.503535},
      {"",	0.059178},
      {"",	0.115500},
      {"",	0.106853},
      {"",	0.072786},
      {"",	0.028320},
      {"",	0.024624},
      {"",	0.080762},
      {"",	0.124968},
      {"",	0.103272},
      {"",	0.036130},
      {"",	0.084656},
      {"",	0.023113},
      {"",	0.054908},
      {"",	0.095309},
      {"",	0.057877},
      {"",	0.015462},
      {"",	0.259234},
      {"",	0.030173},
      {"",	0.028259},
      {"",	0.025462},
      {"",	0.081804},
      {"",	0.019704},
      {"",	0.037346},
      {"",	0.172006},
      {"",	0.062596},
      {"",	0.042139},
      {"",	0.030141},
      {"",	0.017032},
      {"",	0.033712},
      {"",	0.097897},
      {"",	0.019585},
      {"",	0.036788},
      {"",	0.040640},
      {"",	0.021701},
      {"",	0.015084},
      {"ñ",	0.019035},
      {"",	0.046922},
      {"",	0.033282},
      {"",	0.142554},
      {"",	0.350021},
      {"",	0.020720},
      {"",	0.117753},
      {"",	0.155168},
      {"",	0.027903},
      {"",	0.034138},
      {"",	0.195193},
      {"",	0.091897},
      {"",	0.025892},
      {"",	0.092087},
      {"",	0.098278},
      {"",	0.206358},
      {"",	0.035629},
      {"",	0.037969},
      {"",	0.059885},
      {"",	0.017369},
      {"",	0.041338},
      {"",	0.042914},
      {"",	0.110517},
      {"",	0.024560},
      {"",	0.023162},
      {"",	0.023874},
      {"",	0.020609},
      {"",	0.227495},
      {"",	0.141367},
      {"",	0.015495},
      {"",	0.022215},
      {"",	0.056262},
      {"",	0.151584},
      {"",	0.061118},
      {"",	0.272770},
      {"",	0.085263},
      {"",	0.016105},
      {"",	0.053881},
      {"",	0.021204},
      {"",	0.093396},
      {"",	0.469347},
      {"",	0.020237},
      {"",	0.034130},
      {"",	0.059852},
      {"",	0.043658},
      {"",	0.017357},
      {"",	0.045179},
      {"",	0.023371},
      {"",	0.110726},
      {"",	0.020201},
      {"",	0.024993},
      {"",	0.029663},
      {"",	0.032246},
      {"",	0.015996},
      {"",	0.026776},
      {"",	0.027477},
      {"",	0.039371},
      {"",	0.016772},
      {"",	0.014455},
      {"",	0.024243},
      {"",	0.048220},
      {"",	0.027036},
      {"",	0.019130},
      {"",	0.022422},
      {"",	0.045496},
      {"",	0.054332},
      {"",	0.042048},
      {"",	0.030469},
      {"",	0.042275},
      {"",	0.016165},
      {"",	0.291129},
      {"",	0.094920},
      {"",	0.043175},
      {"",	0.025828},
      {"",	0.016134},
      {"",	0.034991},
      {"",	0.020823},
      {"",	0.035779},
      {"",	0.018547},
      {"",	0.023479},
      {"",	0.045329},
      {"",	0.297640},
      {"",	0.028177},
      {"",	0.085551},
      {"",	0.153848},
      {"",	0.037319},
      {"",	0.129670},
      {"",	0.049393},
      {"",	0.042645},
      {"",	0.030758},
      {"",	0.041439},
      {"",	0.042696},
      {"ù",	0.028028},
      {"",	0.019105},
      {"",	0.052699},
      {"",	0.014792},
      {"",	0.098239}
    };

  static const short lookup[] =
    {
         0,   -1,   -1,   -1,   -1, -408,    3, -399,
        -2,   -1, -413,    6, -396,   -2,   -1,    7,
         8,   -1,    9,   10,   11,   -1,   -1,   12,
        -1,   13,   14,   -1,   15,   16,   17,   18,
        -1,   19,   20,   -1,   21,   -1,   22,   23,
        24,   -1,   25,   26,   -1,   27,   28,   -1,
        29,   30,   31,   32,   -1,   33,   34,   35,
        36,   -1,   37,   38,   39,   40,   -1,   41,
        42,   43,   44,   -1,   45,   46,   47,   -1,
        -1,   48,   49,   50,   51,   -1,   -1,   -1,
        52,   53,   -1,   54,   55,   56,   57,   -1,
        -1,   58,   59,   60,   -1,   -1,   61,   62,
        -1,   -1,   -1,   63,   64,   65,   -1,   66,
        67,   68,   69,   -1,   -1,   70,   71,   72,
        -1,   73,   74,   75,   76,   -1,   77,   -1,
        78,   79,   -1,   -1,   -1,   80,   81,   -1,
        82,   -1,   83,   -1,   -1,   84,   -1,   85,
        86,   -1,   87,   -1,   88,   -1,   -1,   89,
        90,   91,   -1,   -1,   -1,   -1,   92,   -1,
        -1,   -1,   -1,   93,   94,   -1,   95,   -1,
        96,   -1,   -1,   97,   -1,   98,   99,   -1,
       100,   -1,  101,  102,   -1,  103,   -1,  104,
       105,   -1,   -1,   -1,  106,   -1,   -1,  107,
        -1,  108,  109,   -1,  110,   -1,  111,  112,
        -1,  113,  114,   -1,  115,   -1,  116,   -1,
       117,  118,   -1,  119,   -1,  120,  121,   -1,
       122,   -1,  123,  124,   -1,  125,   -1,  126,
       127,   -1,   -1,   -1,  128,  129,   -1,  130,
        -1,  131,  132,   -1,  133,   -1,  134,  135,
        -1,   -1,   -1,  136,  137,   -1,  138,   -1,
       139,  140,   -1,   -1,   -1,  141,  142,   -1,
       143,   -1,  144,   -1,   -1,  145,   -1,  146,
       147,   -1,  148,   -1,  149,  150,   -1,  151,
        -1,  152,  153,   -1,  154,   -1,  155,  156,
        -1,  157,   -1,  158,  159,   -1,  160,   -1,
       161,  162,   -1,  163,   -1,  164,  165,   -1,
       166,   -1,  167,  168,   -1,  169,   -1,  170,
       171,   -1,  172,   -1,  173,  174,   -1,  175,
        -1,  176,  177,   -1,  178,  179, -737,  182,
        -1,  183,   -1,  184,  185,   -1,  186,   -1,
       187,  188,   -1,  189,   -1,  190,  191,   -1,
       192,   -1,  193,  194,   -1,  195,   -1,  196,
      -220,   -2,   -1,   -1,  197,  198,   -1,  199,
        -1,  200,  201,   -1,   -1,   -1,  202,   -1,
        -1,  203,  204,  205,  206,   -1,   -1,   -1,
       207,  208,   -1,  209,   -1,   -1,  210,   -1,
       211,  212,  213,   -1,   -1,  214,   -1,  215,
       216,   -1,  217,   -1,  218,  219,   -1,  220,
        -1,  221,  222,   -1,  223,   -1,  224,  225,
        -1,  226,   -1,  227,  228,   -1,   -1,   -1,
       229,  230,   -1,  231,   -1,  232,  233,   -1,
       234,   -1,  235,  236,   -1,  237,   -1,  238,
       239,   -1,  240,  241,  242,  243,   -1,  244,
        -1,  245,  246,   -1,  247,   -1,  248,  249,
        -1,  250,   -1,  251,  252,   -1,  253,   -1,
       254,  255,   -1,  256,   -1,  257,   -1,   -1,
       258,   -1,  259,  260,   -1,  261,  262,  263,
       264,   -1,  265,   -1,  266,  267,   -1,  268,
        -1,  269,  270,   -1,  271,   -1,  272,  273,
        -1,  274,   -1,  275,   -1,   -1,  276,  277,
       278,  279,   -1,  280,   -1,  281,   -1,   -1,
       282,   -1,  283,  284,   -1,  285,   -1,  286,
       287,   -1,  288,   -1,  289,  290,   -1,  291,
        -1,  292,  293,   -1,  294,   -1,  295,  296,
        -1,  297,   -1,  298,  299,   -1,  300,   -1,
       301,  302,   -1,  303,   -1,  304,  305,   -1,
       306,   -1,  307,  308,   -1,  309,   -1,  310,
        -1,   -1,  311,   -1,  312,  313,   -1,  314,
        -1,  315,  316,   -1,  317,   -1,  318,   -1,
        -1,  319,   -1,  320,  321,   -1,  322,   -1,
       323,  324,   -1,  325,   -1,  326,  327,   -1,
        -1,   -1,  328,  329,   -1, -975,  -70,   -2,
        -1,   -1,  332,   -1,  333,  334,   -1,  335,
        -1,  336,   -1,   -1,  337,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  338,   -1,   -1,   -1,
       339,   -1,   -1,  340,   -1,  341,  342,   -1,
       343,   -1,  344,  345,   -1,   -1,   -1,  346,
       347,   -1,  348,   -1,   -1,   -1,   -1,  349,
        -1,   -1,  350,   -1,  351,   -1,  352,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       353,  354,   -1,   -1,   -1,   -1,   -1,   -1,
       355,   -1,  356,  357,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  358,   -1,
        -1,   -1,   -1,  359,   -1,   -1,  360,   -1,
       361,   -1,   -1,   -1,   -1,  362,  363,   -1,
       364,  365,  366,   -1,   -1,  367,   -1,  368,
        -1,   -1,   -1,   -1,  369,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,
        -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
       373,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,
        -1,   -1,  375,   -1,  376,   -1,   -1,  377,
        -1,   -1,   -1,  378,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       379,   -1,  380,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  381,   -1,
        -1,   -1,   -1,  382,   -1,  383,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  384,   -1,   -1,  385,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,
        -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  389,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  390,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  391,   -1,  392,   -1,
        -1,   -1,   -1,   -1,  393,   -1,   -1,   -1,
       394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,
        -1,  396,   -1,  397,   -1,   -1,   -1,   -1,
        -1,   -1,  398,   -1,   -1,   -1,   -1,   -1,
        -1,  399
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = b5Hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist[index].name;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                return &wordlist[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct charHz *wordptr = &wordlist[TOTAL_KEYWORDS + lookup[offset]];
              register const struct charHz *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}
