/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xwatch.h"

/* global data section */
#undef EXTERN
#define EXTERN
#include "data.inc"

/* main function */ 
void main(int argc, char *argv[])
{
    int
	i;
    static int
	border,				/* flag: use border? */ 
	xpos, ypos,			/* startup screen coords */ 
	height,				/* initial height */ 
	printversion;			/* flag: print version/copyright? */
    static char
	*copyrightmsg [] =              /* our copyright msg */
	{
	    "XWatch V" VER "\n",
            "Copyright (C) 1995, 1996 Karel Kubat <karel@icce.rug.nl>.\n",
            "See /usr/doc/xwatch/README.debian\n",
        },
	titlebuffer [128],              /* window title */
	gagbuffer [1024],               /* things to gag */
	colorstring [1024],             /* messages to color */
        ignorestring [1024],            /* files to be ignored */
	geometry [80],                  /* geometry string */
        fgstring [80], bgstring [80];   /* foreground/background strings */

#include "flres.h"     
#include "settings.h"     

    /* count total cmdline length.. X barfs on too long cmdlines (!) */
#ifdef MAXCMDLINE
    register int
	totlength = 0;
    
    for (i = 0; i < argc; i++)
	totlength += strlen (argv [i]) + 1;
    if (totlength > MAXCMDLINE)
	error ("too many strings on the commandline");
#endif

    /* parse in options */
    fl_initialize (&argc, argv, "XWatch", 
                   cmdopt, sizeof (cmdopt) / sizeof (FL_CMD_OPT));
    fl_get_app_resources (res, sizeof (res) / sizeof (FL_resource));

    /* check the settings */
    for (i = 0; i < sizeof (setting) / sizeof (Setting); i++)
	checksetting (*setting [i].var, setting [i].min,
		      setting [i].max, setting [i].desc);

    /* show usage if no args */
    if (argc < 2)
	usage ();
        
    /* parse gag strings and color strings */
    parsegag (gagbuffer);
    parsecolorstring (colorstring);
    parsegeometry (geometry, &xpos, &ypos, &width, &height);
    parsecolors (fgstring, bgstring);
    argc = parseignore(ignorestring, argc, argv);

    /* now create and initialize the forms */
    create_the_forms ();

    /* fontsize is now 1..4, remap to 8/10/12/14 */
    fontsize <<= 1;
    fontsize += 6;
    fl_set_browser_fontsize (watch_browser, fontsize);
    fl_set_browser_fontstyle (watch_browser, fontstyle);
    fl_set_object_color (watch_browser, backgr, foregr);
    fl_set_object_lcol (watch_browser, foregr);

    /* show browser form */
    fl_set_form_geometry (browser_form, xpos, ypos, width, height);
    fl_set_form_position (browser_form, xpos, ypos);
    fl_show_form (browser_form, FL_PLACE_GEOMETRY,
		      border ? FL_FULLBORDER : FL_NOBORDER,
                      *titlebuffer ? titlebuffer : "XWatch");

    /* add our own message */
    if (printversion)
	for (i = 0; i < sizeof (copyrightmsg) / sizeof (char *); i++)
	    warning (copyrightmsg [i]);

    /* add all files */
    for (i = 1; i < argc; i++)
	addfile (argv [i]);

    /* forms action loop , interrupted each `interval' secs */ 
    signal (SIGALRM, alarmhandler);
    alarm (interval);

    /* here goes..  */ 
    fl_do_forms();

    /* never reached, exit is from `quit' button */ 
}
