.\" @(#)xpanex.man
.\"
.\" Copyright 1996 - 2024  David A. Bagley
.\"
.\" All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XPANEX 6 "15 Aug 2024" "V8.8.4"
.SH NAME
xpanex \- Panex X widget
.SH SYNOPSIS
.B /usr/games/xpanex
[\-geometry [{width}][x{height}][{+\-}{xoff}[{+\-}{yoff}]]]
[\-display [{host}]:[{vs}]] [\-[no]mono] [\-[no]{reverse|rv}]
[\-{foreground|fg} {color}] [\-{background|bg} {color}]
[\-pyramid{0|1} {color}] [\-tile {color}] [\-frame {color}]
[\-[no]stippleFrame] [\-delay msecs] [\-[no]sound]
[\-moveSound {filename}] [\-{font|fn} {fontname}]
[\-tiles {int}] [\-{mode {int}|hanoi|algorithme|panex}]
[\-userName {string}] [\-scoreFile {filename}] [\-scores]
[\-version]
.SH DESCRIPTION
Panex \- A grooved sliding tile puzzle created by Toshio
Akanuma and manufactured by the Tricks Co., Ltd of Tokyo,
Japan (a Magic Company) in the 1980's.  Mathematicians at
Bell Laboratories calculated the number of moves to be 27,564
to 31,537.  It came in two varieties: one with a magenta and
a orange pyramid of order 10 on silver tiles; in the gold
version pieces of each color look alike (i.e. no pyramid is
drawn on them), this is a little harder.  The goal in this
puzzle is to simply exchange the 2 piles.  Pieces with
smaller trapazoids cannot go down as far as pieces with
bigger trapazoids.
.LP
The original Tower of Hanoi puzzle is the invention of
Edouard Lucas and was sold as a toy in France in 1883.  The
legend of 64 disks in the great temple of Benares of the god
Brahma is also his invention.  The goal in this puzzle is to
move the pile from the left side to the right most column.
Unlike panex, a large trapazoid cannot go on top of a smaller
one, but pieces always fall to the bottom.
.LP
The original Algorithme 6 is 2 stacks of 3 wooden spheres on
2 of 3 posts.  The spheres come in 3 different sizes.  The goal
goal is to swap the spheres using the posts without putting a
bigger sphere on a smaller one and without exceeding the
size of the post.  It was created and produced by Patrick
Farvacque around 1997.  The puzzle presented here has a
simpler solution because the tiles are all the same height
(i.e. a 39 move solution as opposed to 66).
.SH FEATURES
Press "\fBmouse\-left\fP" button to move a tile in the top tile of a column.
Release "\fBmouse\-left\fP" button on another column to move the tile to
that column.  It will not move if blocked.
.LP
Click "\fBmouse\-right\fP" button, or press "\fBC\fP" or "\fBc\fP" keys, to
clear the puzzle.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to read (get) a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to auto\-solve.  Unfortunately, its only
implemented from the starting position.
.LP
Press "\fBM\fP" or "\fBm\fP" keys to switch between Hanoi (one pyramid
column), Algorithme, and Panex, (each has two pyramid
columns) modes (they each have different rules).
.br
In Hanoi, one cannot place larger trapezoid on a smaller trapezoid.
Here the goal is to move the pile from the left peg to the
rightmost peg.
.br
Algorithme is similar, here we must exchange
tiles and we are limited by the size of the stack.  A move
from stack 1 to stack 3 and vice\-versa when stack 2 is full.
.br
In Panex, a tile cannot go lower that its initial starting
point.  Here again, the goal is to exchange the 2 piles.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of tiles.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of tiles.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of tiles.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of tiles.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL\-C\fP" keys to kill program.
.LP
Unlike other puzzles in the collection there is no way to move pieces
without drag and drop.
.LP
The title is in the following format (non\-motif version):
.RS
x{hanoi | algorithme | panex}: <Number of rows> @ (<Number of
moves>/{<Record number of moves> <user name>|"NEVER noaccess"}) \- <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the panex window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the panex window on a color screen
as if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the panex window in reverse video
(resource name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the panex window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the panex window (resource name
"\fIbackground\fP").
.TP 8
.B \-pyramid0 \fIcolor\fP
This option specifies the color of the first pyramid (resource name
"\fIpyramidColor0\fP").
.TP 8
.B \-pyramid1 \fIcolor\fP
This option specifies the color of the second pyramid, if it exists
(resource name "\fIpyramidColor1\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the panex window
(resource name "\fItileColor\fP").
.TP 8
.B \-frame \fIcolor\fP
This option specifies the color of the frame (resource name
"\fIframeColor\fP").
.TP 8
.B \-[no]stippleFrame
This option allows you to toggle the frame stippling (resource name
"\fIstippleFrame\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a tile or
a group of tiles one space (1\-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding tile should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound for the sliding of
the tiles (resource name "\fImoveSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-tiles \fIint\fP
This option specifies the number of tiles in a column (resource name
"\fItiles\fP").
.TP 8
.B \-mode \fIint\fP
This option specifies the hanoi (0), algorithme (1), or panex (2) mode
(resource name "\fImode\fP").
.TP 8
.B \-hanoi
This option specifies the hanoi mode (resource name "\fImode\fP").
.TP 8
.B \-algorithme
This option specifies the algorithme mode (resource name "\fImode\fP").
.TP 8
.B \-panex
This option specifies the panex mode (resource name "\fImode\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xpanex you have.
.SH RECORDS
You must clear the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto\-solve.
.SH SAVE FORMAT
Here is the format for the xpanex configuration, starting position, and
the movement of its pieces.
.sp
.RS
mode: 0\-2 <0 hanoi, 1 algorithme, 2 panex>
.br
tiles: 1\-10 <number of tiles in a column>
.br
moves: 0\-MAXINT <total number of moves>
.sp
startingPosition: <array pairs of column and position of each tile>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <from_column> <to_column>
.RE
from_column is the top tile of the column
.br
to_column is where that tile is moved to.
.SH REFERENCES
Mark Manasse & Danny Sleator of AT&T Bell Laboratories
and Victor K. Wei of Bell Communications Research,
Some Results on the Panex Puzzle, Murray Hill, NJ, 1985
20 pp. (unpublished).
.sp
Vladimir Dubrovsky, Nesting Puzzles Part 1: Moving oriental
towers, Quantum/Toy Store, January/February 1996 pp 55\-57, 50\-51.
.sp
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics
Series), Oxford University Press 1986, pp 144, 145.
.sp
Jerry Slocum & Jack Botermans, Puzzles Old & New (How to Make
and Solve Them), University of Washington Press, Seattle, 1987,
p 135.
.sp
Dick Hess, Analysis of the Algorithme 6 Puzzle and its
Generalisations, Cubism For Fun, July 2008 76 pp 8\-13.
.sp
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6),
xmball(6), xpyraminx(6), xoct(6), xrubik(6), xskewb(6), xdino(6),
xbevel(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1996\-2024, David A. Bagley
.LP
Main algorithm taken from AT&T paper above.
.sp
Thanks to Nick Baxter <nickb AT baxterweb.com> for debugging level n > 4
and vTrick.
.sp
Though most code by Rene Jansen <rene.j.jansen@bigfoot.com> is now
removed, much inspiration was gained by his efforts implementing
an algorithm from Quantum January/February 1996 by Vladimir
Dubrovsky.
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd AT verizon.net\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttps://www.sillycycle.com/puzzles.html\fP
.br
\fIhttp://www.ibiblio.org/pub/Linux/games/strategy/\fP
