
/**
 * Custom fullscreen triangle with placeholders varyings.
 **/

#pragma BLENDER_REQUIRE(common_view_lib.glsl)
#pragma BLENDER_REQUIRE(eevee_nodetree_lib.glsl)
#pragma BLENDER_REQUIRE(eevee_surf_lib.glsl)

void main()
{
  /* Fullscreen triangle. */
  int v = gl_VertexID % 3;
  float x = float((v & 1) << 2) - 1.0;
  float y = float((v & 2) << 1) - 1.0;
  gl_Position = vec4(x, y, 1.0, 1.0);

  /* Pass view position to keep accuracy. */
  interp.P = project_point(ProjectionMatrixInverse, gl_Position.xyz);
  interp.N = vec3(1);
}
