/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "spettro.h"
#include "version.h"

#include "a_file.h"

#if USE_EFL || USE_EFL_SDL
# include <Efl_Config.h>	/* in eina includes */
#if 0
#if ECORE_TIMER || EVAS_VIDEO || ECORE_MAIN
/* Any one of these three will get EFL_VERSION_{MAJOR,MINOR} defined */
# include <Ecore.h>
#  include <Ecore_Evas.h>
# endif
# if EVAS_VIDEO
#  include <Evas.h>
# endif
# if EMOTION_AUDIO
#  include <Emotion.h>
# endif
#endif
#endif
#if USE_SDL || USE_EFL_SDL
# include <SDL_version.h>
#endif
#if HAVE_LIBMPG123
# include <mpg123.h>
# if HAVE_LIBMAGIC
#  include <magic.h>
# endif
#endif
#if HAVE_LIBSOX
# include <sox.h>
#endif
#if HAVE_LIBAV
# include <libavformat/version.h>
# include <libavcodec/version.h>
# include <libavutil/version.h>
#endif
#if HAVE_LIBPNG
# include <png.h>
#endif
#if HAVE_LIBFFTW3F
#include <fftw3.h>
#endif
#if HAVE_LIBCACA
#include <caca.h>
#endif

/* version.c - Print version of spettro */
void
print_version()
{
    printf("Spettro version %s built with", VERSION);
#if USE_EFL || USE_EFL_SDL
    printf(" libefl-%d.%d.%d", EFL_VERSION_MAJOR,
				      EFL_VERSION_MINOR,
				      EFL_VERSION_MICRO);
#endif
#if USE_EFL_SDL
    printf(",");
#endif
#if USE_SDL || USE_EFL_SDL
    printf(" libSDL2-%d.%d.%d", SDL_MAJOR_VERSION,
			    SDL_MINOR_VERSION,
			    SDL_PATCHLEVEL);
#endif
#if HAVE_LIBFFTW3F
    printf(", %s", fftwf_version);
#endif
#if HAVE_LIBMPG123
    printf(", libmpg123 API v%d", MPG123_API_VERSION);
# if HAVE_LIBMAGIC
    printf(", libmagic-%d.%d", magic_version() / 100, magic_version() % 100);
# endif
#endif
#if HAVE_LIBSNDFILE
    /* To find out the libsndfile version you have to call
     * sf_command(sndfile, SFC_GET_LIB_VERSION, void *data, int datasize)
     * but we don't have an open sndfile.
     */
    printf(", %s", sf_version_string());
#endif
#if HAVE_LIBSOX
    printf(", libsox-%d.%d.%d", SOX_LIB_VERSION_CODE>>16,
    				SOX_LIB_VERSION_CODE>>8 & 0xff,
    				SOX_LIB_VERSION_CODE & 0xff);
#endif
#if HAVE_LIBAV
    printf(", libavformat-%d.%d.%d", LIBAVFORMAT_VERSION_MAJOR,
				     LIBAVFORMAT_VERSION_MINOR,
				     LIBAVFORMAT_VERSION_MICRO);
    printf(", libavcodec-%d.%d.%d", LIBAVCODEC_VERSION_MAJOR,
				    LIBAVCODEC_VERSION_MINOR,
				    LIBAVCODEC_VERSION_MICRO);
    printf(", libavutil-%d.%d.%d", LIBAVUTIL_VERSION_MAJOR,
				   LIBAVUTIL_VERSION_MINOR,
				   LIBAVUTIL_VERSION_MICRO);
#endif
#if HAVE_LIBPNG
    printf(", libpng-%s", PNG_LIBPNG_VER_STRING);
#endif
#if HAVE_LIBCACA
    printf(", libcaca");
# ifdef CACA_API_VERSION_1
    printf(" API v1");
# endif
#endif
    printf("\n");
}

