//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: D2D1Svg.h
//---------------------------------------------------------------------------
#ifdef _MSC_VER
#pragma once
#endif // #ifdef _MSC_VER

#ifndef _D2D1_SVG_
#define _D2D1_SVG_

#ifndef _D2D1_2_H_
#include <d2d1_2.h>
#endif // #ifndef _D2D1_2_H_

/*#include <winapifamily.h>*/

/*#pragma region Application Family*/
/*#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)*/

typedef interface ID2D1SvgDocument ID2D1SvgDocument;
typedef interface ID2D1SvgElement ID2D1SvgElement;

/// <summary>
/// Specifies the paint type for an SVG fill or stroke.
/// </summary>
typedef enum D2D1_SVG_PAINT_TYPE
{

    /// <summary>
    /// The fill or stroke is not rendered.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_NONE = 0,

    /// <summary>
    /// A solid color is rendered.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_COLOR = 1,

    /// <summary>
    /// The current color is rendered.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_CURRENT_COLOR = 2,

    /// <summary>
    /// A paint server, defined by another element in the SVG document, is used.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_URI = 3,

    /// <summary>
    /// A paint server, defined by another element in the SVG document, is used. If the
    /// paint server reference is invalid, fall back to D2D1_SVG_PAINT_TYPE_NONE.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_URI_NONE = 4,

    /// <summary>
    /// A paint server, defined by another element in the SVG document, is used. If the
    /// paint server reference is invalid, fall back to D2D1_SVG_PAINT_TYPE_COLOR.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_URI_COLOR = 5,

    /// <summary>
    /// A paint server, defined by another element in the SVG document, is used. If the
    /// paint server reference is invalid, fall back to
    /// D2D1_SVG_PAINT_TYPE_CURRENT_COLOR.
    /// </summary>
    D2D1_SVG_PAINT_TYPE_URI_CURRENT_COLOR = 6,
    D2D1_SVG_PAINT_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_SVG_PAINT_TYPE;

/// <summary>
/// Specifies the units for an SVG length.
/// </summary>
typedef enum D2D1_SVG_LENGTH_UNITS
{

    /// <summary>
    /// The length is unitless.
    /// </summary>
    D2D1_SVG_LENGTH_UNITS_NUMBER = 0,

    /// <summary>
    /// The length is a percentage value.
    /// </summary>
    D2D1_SVG_LENGTH_UNITS_PERCENTAGE = 1,
    D2D1_SVG_LENGTH_UNITS_FORCE_DWORD = 0xffffffff

} D2D1_SVG_LENGTH_UNITS;

/// <summary>
/// Specifies a value for the SVG display property.
/// </summary>
typedef enum D2D1_SVG_DISPLAY
{

    /// <summary>
    /// The element uses the default display behavior.
    /// </summary>
    D2D1_SVG_DISPLAY_INLINE = 0,

    /// <summary>
    /// The element and all children are not rendered directly.
    /// </summary>
    D2D1_SVG_DISPLAY_NONE = 1,
    D2D1_SVG_DISPLAY_FORCE_DWORD = 0xffffffff

} D2D1_SVG_DISPLAY;

/// <summary>
/// Specifies a value for the SVG visibility property.
/// </summary>
typedef enum D2D1_SVG_VISIBILITY
{

    /// <summary>
    /// The element is visible.
    /// </summary>
    D2D1_SVG_VISIBILITY_VISIBLE = 0,

    /// <summary>
    /// The element is invisible.
    /// </summary>
    D2D1_SVG_VISIBILITY_HIDDEN = 1,
    D2D1_SVG_VISIBILITY_FORCE_DWORD = 0xffffffff

} D2D1_SVG_VISIBILITY;

/// <summary>
/// Specifies a value for the SVG overflow property.
/// </summary>
typedef enum D2D1_SVG_OVERFLOW
{

    /// <summary>
    /// The element is not clipped to its viewport.
    /// </summary>
    D2D1_SVG_OVERFLOW_VISIBLE = 0,

    /// <summary>
    /// The element is clipped to its viewport.
    /// </summary>
    D2D1_SVG_OVERFLOW_HIDDEN = 1,
    D2D1_SVG_OVERFLOW_FORCE_DWORD = 0xffffffff

} D2D1_SVG_OVERFLOW;

/// <summary>
/// Specifies a value for the SVG stroke-linecap property.
/// </summary>
typedef enum D2D1_SVG_LINE_CAP
{

    /// <summary>
    /// The property is set to SVG's 'butt' value.
    /// </summary>
    D2D1_SVG_LINE_CAP_BUTT = D2D1_CAP_STYLE_FLAT,

    /// <summary>
    /// The property is set to SVG's 'square' value.
    /// </summary>
    D2D1_SVG_LINE_CAP_SQUARE = D2D1_CAP_STYLE_SQUARE,

    /// <summary>
    /// The property is set to SVG's 'round' value.
    /// </summary>
    D2D1_SVG_LINE_CAP_ROUND = D2D1_CAP_STYLE_ROUND,
    D2D1_SVG_LINE_CAP_FORCE_DWORD = 0xffffffff

} D2D1_SVG_LINE_CAP;

/// <summary>
/// Specifies a value for the SVG stroke-linejoin property.
/// </summary>
typedef enum D2D1_SVG_LINE_JOIN
{

    /// <summary>
    /// The property is set to SVG's 'bevel' value.
    /// </summary>
    D2D1_SVG_LINE_JOIN_BEVEL = D2D1_LINE_JOIN_BEVEL,

    /// <summary>
    /// The property is set to SVG's 'miter' value. Note that this is equivalent to
    /// D2D1_LINE_JOIN_MITER_OR_BEVEL, not D2D1_LINE_JOIN_MITER.
    /// </summary>
    D2D1_SVG_LINE_JOIN_MITER = D2D1_LINE_JOIN_MITER_OR_BEVEL,

    /// <summary>
    /// \ The property is set to SVG's 'round' value.
    /// </summary>
    D2D1_SVG_LINE_JOIN_ROUND = D2D1_LINE_JOIN_ROUND,
    D2D1_SVG_LINE_JOIN_FORCE_DWORD = 0xffffffff

} D2D1_SVG_LINE_JOIN;

/// <summary>
/// The alignment portion of the SVG preserveAspectRatio attribute.
/// </summary>
typedef enum D2D1_SVG_ASPECT_ALIGN
{

    /// <summary>
    /// The alignment is set to SVG's 'none' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_NONE = 0,

    /// <summary>
    /// The alignment is set to SVG's 'xMinYMin' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MIN = 1,

    /// <summary>
    /// The alignment is set to SVG's 'xMidYMin' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MIN = 2,

    /// <summary>
    /// The alignment is set to SVG's 'xMaxYMin' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MIN = 3,

    /// <summary>
    /// The alignment is set to SVG's 'xMinYMid' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MID = 4,

    /// <summary>
    /// The alignment is set to SVG's 'xMidYMid' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MID = 5,

    /// <summary>
    /// The alignment is set to SVG's 'xMaxYMid' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MID = 6,

    /// <summary>
    /// The alignment is set to SVG's 'xMinYMax' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MAX = 7,

    /// <summary>
    /// The alignment is set to SVG's 'xMidYMax' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MAX = 8,

    /// <summary>
    /// The alignment is set to SVG's 'xMaxYMax' value.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MAX = 9,
    D2D1_SVG_ASPECT_ALIGN_FORCE_DWORD = 0xffffffff

} D2D1_SVG_ASPECT_ALIGN;

/// <summary>
/// The meetOrSlice portion of the SVG preserveAspectRatio attribute.
/// </summary>
typedef enum D2D1_SVG_ASPECT_SCALING
{

    /// <summary>
    /// Scale the viewBox up as much as possible such that the entire viewBox is visible
    /// within the viewport.
    /// </summary>
    D2D1_SVG_ASPECT_SCALING_MEET = 0,

    /// <summary>
    /// Scale the viewBox down as much as possible such that the entire viewport is
    /// covered by the viewBox.
    /// </summary>
    D2D1_SVG_ASPECT_SCALING_SLICE = 1,
    D2D1_SVG_ASPECT_SCALING_FORCE_DWORD = 0xffffffff

} D2D1_SVG_ASPECT_SCALING;

/// <summary>
/// Represents a path commmand. Each command may reference floats from the segment
/// data. Commands ending in _ABSOLUTE interpret data as absolute coordinate.
/// Commands ending in _RELATIVE interpret data as being relative to the previous
/// point.
/// </summary>
typedef enum D2D1_SVG_PATH_COMMAND
{

    /// <summary>
    /// Closes the current subpath. Uses no segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_CLOSE_PATH = 0,

    /// <summary>
    /// Starts a new subpath at the coordinate (x y). Uses 2 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_MOVE_ABSOLUTE = 1,

    /// <summary>
    /// Starts a new subpath at the coordinate (x y). Uses 2 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_MOVE_RELATIVE = 2,

    /// <summary>
    /// Draws a line to the coordinate (x y). Uses 2 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_LINE_ABSOLUTE = 3,

    /// <summary>
    /// Draws a line to the coordinate (x y). Uses 2 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_LINE_RELATIVE = 4,

    /// <summary>
    /// Draws a cubic Bezier curve (x1 y1 x2 y2 x y). The curve ends at (x, y) and is
    /// defined by the two control points (x1, y1) and (x2, y2). Uses 6 floats of
    /// segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_CUBIC_ABSOLUTE = 5,

    /// <summary>
    /// Draws a cubic Bezier curve (x1 y1 x2 y2 x y). The curve ends at (x, y) and is
    /// defined by the two control points (x1, y1) and (x2, y2). Uses 6 floats of
    /// segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_CUBIC_RELATIVE = 6,

    /// <summary>
    /// Draws a quadratic Bezier curve (x1 y1 x y). The curve ends at (x, y) and is
    /// defined by the control point (x1 y1). Uses 4 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_QUADRADIC_ABSOLUTE = 7,

    /// <summary>
    /// Draws a quadratic Bezier curve (x1 y1 x y). The curve ends at (x, y) and is
    /// defined by the control point (x1 y1). Uses 4 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_QUADRADIC_RELATIVE = 8,

    /// <summary>
    /// Draws an elliptical arc (rx ry x-axis-rotation large-arc-flag sweep-flag x y).
    /// The curve ends at (x, y) and is defined by the arc parameters. The two flags are
    /// considered set if their values are non-zero. Uses 7 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_ARC_ABSOLUTE = 9,

    /// <summary>
    /// Draws an elliptical arc (rx ry x-axis-rotation large-arc-flag sweep-flag x y).
    /// The curve ends at (x, y) and is defined by the arc parameters. The two flags are
    /// considered set if their values are non-zero. Uses 7 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_ARC_RELATIVE = 10,

    /// <summary>
    /// Draws a horizontal line to the coordinate (x). Uses 1 float of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_HORIZONTAL_ABSOLUTE = 11,

    /// <summary>
    /// Draws a horizontal line to the coordinate (x). Uses 1 float of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_HORIZONTAL_RELATIVE = 12,

    /// <summary>
    /// Draws a vertical line to the coordinate (y). Uses 1 float of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_VERTICAL_ABSOLUTE = 13,

    /// <summary>
    /// Draws a vertical line to the coordinate (y). Uses 1 float of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_VERTICAL_RELATIVE = 14,

    /// <summary>
    /// Draws a smooth cubic Bezier curve (x2 y2 x y). The curve ends at (x, y) and is
    /// defined by the control point (x2, y2). Uses 4 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_ABSOLUTE = 15,

    /// <summary>
    /// Draws a smooth cubic Bezier curve (x2 y2 x y). The curve ends at (x, y) and is
    /// defined by the control point (x2, y2). Uses 4 floats of segment data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_RELATIVE = 16,

    /// <summary>
    /// Draws a smooth quadratic Bezier curve ending at (x, y). Uses 2 floats of segment
    /// data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_ABSOLUTE = 17,

    /// <summary>
    /// Draws a smooth quadratic Bezier curve ending at (x, y). Uses 2 floats of segment
    /// data.
    /// </summary>
    D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_RELATIVE = 18,
    D2D1_SVG_PATH_COMMAND_FORCE_DWORD = 0xffffffff

} D2D1_SVG_PATH_COMMAND;

/// <summary>
/// Defines the coordinate system used for SVG gradient or clipPath elements.
/// </summary>
typedef enum D2D1_SVG_UNIT_TYPE
{

    /// <summary>
    /// The property is set to SVG's 'userSpaceOnUse' value.
    /// </summary>
    D2D1_SVG_UNIT_TYPE_USER_SPACE_ON_USE = 0,

    /// <summary>
    /// The property is set to SVG's 'objectBoundingBox' value.
    /// </summary>
    D2D1_SVG_UNIT_TYPE_OBJECT_BOUNDING_BOX = 1,
    D2D1_SVG_UNIT_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_SVG_UNIT_TYPE;

/// <summary>
/// Defines the type of SVG string attribute to set or get.
/// </summary>
typedef enum D2D1_SVG_ATTRIBUTE_STRING_TYPE
{

    /// <summary>
    /// The attribute is a string in the same form as it would appear in the SVG XML.
    ///
    /// Note that when getting values of this type, the value returned may not exactly
    /// match the value that was set. Instead, the output value is a normalized version
    /// of the value. For example, an input color of 'red' may be output as '#FF0000'.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_STRING_TYPE_SVG = 0,

    /// <summary>
    /// The attribute is an element ID.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_STRING_TYPE_ID = 1,
    D2D1_SVG_ATTRIBUTE_STRING_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_SVG_ATTRIBUTE_STRING_TYPE;

/// <summary>
/// Defines the type of SVG POD attribute to set or get.
/// </summary>
typedef enum D2D1_SVG_ATTRIBUTE_POD_TYPE
{

    /// <summary>
    /// The attribute is a FLOAT.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT = 0,

    /// <summary>
    /// The attribute is a D2D1_COLOR_F.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR = 1,

    /// <summary>
    /// The attribute is a D2D1_FILL_MODE.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE = 2,

    /// <summary>
    /// The attribute is a D2D1_SVG_DISPLAY.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY = 3,

    /// <summary>
    /// The attribute is a D2D1_SVG_OVERFLOW.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW = 4,

    /// <summary>
    /// The attribute is a D2D1_SVG_LINE_CAP.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP = 5,

    /// <summary>
    /// The attribute is a D2D1_SVG_LINE_JOIN.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN = 6,

    /// <summary>
    /// The attribute is a D2D1_SVG_VISIBILITY.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY = 7,

    /// <summary>
    /// The attribute is a D2D1_MATRIX_3X2_F.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX = 8,

    /// <summary>
    /// The attribute is a D2D1_SVG_UNIT_TYPE.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE = 9,

    /// <summary>
    /// The attribute is a D2D1_EXTEND_MODE.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE = 10,

    /// <summary>
    /// The attribute is a D2D1_SVG_PRESERVE_ASPECT_RATIO.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO = 11,

    /// <summary>
    /// The attribute is a D2D1_SVG_VIEWBOX.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_VIEWBOX = 12,

    /// <summary>
    /// The attribute is a D2D1_SVG_LENGTH.
    /// </summary>
    D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH = 13,
    D2D1_SVG_ATTRIBUTE_POD_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_SVG_ATTRIBUTE_POD_TYPE;

/// <summary>
/// Represents an SVG length.
/// </summary>
typedef struct D2D1_SVG_LENGTH
{
    FLOAT value;
    D2D1_SVG_LENGTH_UNITS units;

} D2D1_SVG_LENGTH;

/// <summary>
/// Represents all SVG preserveAspectRatio settings.
/// </summary>
typedef struct D2D1_SVG_PRESERVE_ASPECT_RATIO
{

    /// <summary>
    /// Sets the 'defer' portion of the preserveAspectRatio settings. This field only
    /// has an effect on an 'image' element that references another SVG document. As
    /// this is not currently supported, the field has no impact on rendering.
    /// </summary>
    BOOL defer;

    /// <summary>
    /// Sets the align portion of the preserveAspectRatio settings.
    /// </summary>
    D2D1_SVG_ASPECT_ALIGN align;

    /// <summary>
    /// Sets the meetOrSlice portion of the preserveAspectRatio settings.
    /// </summary>
    D2D1_SVG_ASPECT_SCALING meetOrSlice;

} D2D1_SVG_PRESERVE_ASPECT_RATIO;

/// <summary>
/// Represents an SVG viewBox.
/// </summary>
typedef struct D2D1_SVG_VIEWBOX
{
    FLOAT x;
    FLOAT y;
    FLOAT width;
    FLOAT height;

} D2D1_SVG_VIEWBOX;

EXTERN_C CONST IID IID_ID2D1SvgAttribute;
EXTERN_C CONST IID IID_ID2D1SvgPaint;
EXTERN_C CONST IID IID_ID2D1SvgStrokeDashArray;
EXTERN_C CONST IID IID_ID2D1SvgPointCollection;
EXTERN_C CONST IID IID_ID2D1SvgPathData;
EXTERN_C CONST IID IID_ID2D1SvgElement;
EXTERN_C CONST IID IID_ID2D1SvgDocument;

#ifndef D2D_USE_C_DEFINITIONS

#if NTDDI_VERSION >= NTDDI_WIN10_RS2

/// <summary>
/// Interface describing an SVG attribute.
/// </summary>
interface DX_DECLARE_INTERFACE("c9cdb0dd-f8c9-4e70-b7c2-301c80292c5e") ID2D1SvgAttribute  : public ID2D1Resource
{

    /// <summary>
    /// Returns the element on which this attribute is set. Returns null if the
    /// attribute is not set on any element.
    /// </summary>
    STDMETHOD_(void, GetElement)(
        _Outptr_result_maybenull_ ID2D1SvgElement **element
        ) PURE;

    /// <summary>
    /// Creates a clone of this attribute value. On creation, the cloned attribute is
    /// not set on any element.
    /// </summary>
    STDMETHOD(Clone)(
        _COM_Outptr_ ID2D1SvgAttribute **attribute
        ) PURE;
}; // interface ID2D1SvgAttribute

/// <summary>
/// Interface describing an SVG 'fill' or 'stroke' value.
/// </summary>
interface DX_DECLARE_INTERFACE("d59bab0a-68a2-455b-a5dc-9eb2854e2490") ID2D1SvgPaint  : public ID2D1SvgAttribute
{

    /// <summary>
    /// Sets the paint type.
    /// </summary>
    STDMETHOD(SetPaintType)(
        D2D1_SVG_PAINT_TYPE paintType
        ) PURE;

    /// <summary>
    /// Gets the paint type.
    /// </summary>
    STDMETHOD_(D2D1_SVG_PAINT_TYPE, GetPaintType)(
        ) PURE;

    /// <summary>
    /// Sets the paint color that is used if the paint type is
    /// D2D1_SVG_PAINT_TYPE_COLOR.
    /// </summary>
    STDMETHOD(SetColor)(
        _In_ CONST D2D1_COLOR_F *color
        ) PURE;

    /// <summary>
    /// Gets the paint color that is used if the paint type is
    /// D2D1_SVG_PAINT_TYPE_COLOR.
    /// </summary>
    STDMETHOD_(void, GetColor)(
        _Out_ D2D1_COLOR_F *color
        ) PURE;

    /// <summary>
    /// Sets the element id which acts as the paint server. This id is used if the paint
    /// type is D2D1_SVG_PAINT_TYPE_URI.
    /// </summary>
    STDMETHOD(SetId)(
        _In_ PCWSTR id
        ) PURE;

    /// <summary>
    /// Gets the element id which acts as the paint server. This id is used if the paint
    /// type is D2D1_SVG_PAINT_TYPE_URI.
    /// </summary>
    STDMETHOD(GetId)(
        _Out_writes_(idCount) PWSTR id,
        UINT32 idCount
        ) PURE;

    /// <summary>
    /// Gets the string length of the element id which acts as the paint server. This id
    /// is used if the paint type is D2D1_SVG_PAINT_TYPE_URI. The returned string length
    /// does not include room for the null terminator.
    /// </summary>
    STDMETHOD_(UINT32, GetIdLength)(
        ) PURE;

    /// <summary>
    /// Sets the paint color that is used if the paint type is
    /// D2D1_SVG_PAINT_TYPE_COLOR.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetColor(
        CONST D2D1_COLOR_F &color
        )
    {
        return SetColor(&color);
    }
}; // interface ID2D1SvgPaint

/// <summary>
/// Interface describing an SVG 'stroke-dasharray' value.
/// </summary>
interface DX_DECLARE_INTERFACE("f1c0ca52-92a3-4f00-b4ce-f35691efd9d9") ID2D1SvgStrokeDashArray  : public ID2D1SvgAttribute
{

    /// <summary>
    /// Removes dashes from the end of the array.
    /// </summary>
    /// <param name="dashesCount">Specifies how many dashes to remove.</param>
    STDMETHOD(RemoveDashesAtEnd)(
        UINT32 dashesCount
        ) PURE;

    /// <summary>
    /// Updates the array. Existing dashes not updated by this method are preserved. The
    /// array is resized larger if necessary to accomodate the new dashes.
    /// </summary>
    /// <param name="dashes">The dashes array.</param>
    /// <param name="dashesCount">The number of dashes to update.</param>
    /// <param name="startIndex">The index at which to begin updating dashes. Must be
    /// less than or equal to the size of the array.</param>
    STDMETHOD(UpdateDashes)(
        _In_reads_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Updates the array. Existing dashes not updated by this method are preserved. The
    /// array is resized larger if necessary to accomodate the new dashes.
    /// </summary>
    /// <param name="dashes">The dashes array.</param>
    /// <param name="dashesCount">The number of dashes to update.</param>
    /// <param name="startIndex">The index at which to begin updating dashes. Must be
    /// less than or equal to the size of the array.</param>
    STDMETHOD(UpdateDashes)(
        _In_reads_(dashesCount) CONST D2D1_SVG_LENGTH *dashes,
        UINT32 dashesCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets dashes from the array.
    /// </summary>
    /// <param name="dashes">Buffer to contain the dashes.</param>
    /// <param name="dashesCount">The element count of buffer.</param>
    /// <param name="startIndex">The index of the first dash to retrieve.</param>
    STDMETHOD(GetDashes)(
        _Out_writes_(dashesCount) FLOAT *dashes,
        UINT32 dashesCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets dashes from the array.
    /// </summary>
    /// <param name="dashes">Buffer to contain the dashes.</param>
    /// <param name="dashesCount">The element count of buffer.</param>
    /// <param name="startIndex">The index of the first dash to retrieve.</param>
    STDMETHOD(GetDashes)(
        _Out_writes_(dashesCount) D2D1_SVG_LENGTH *dashes,
        UINT32 dashesCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets the number of the dashes in the array.
    /// </summary>
    STDMETHOD_(UINT32, GetDashesCount)(
        ) PURE;
}; // interface ID2D1SvgStrokeDashArray

/// <summary>
/// Interface describing an SVG 'points' value in a 'polyline' or 'polygon' element.
/// </summary>
interface DX_DECLARE_INTERFACE("9dbe4c0d-3572-4dd9-9825-5530813bb712") ID2D1SvgPointCollection  : public ID2D1SvgAttribute
{

    /// <summary>
    /// Removes points from the end of the array.
    /// </summary>
    /// <param name="pointsCount">Specifies how many points to remove.</param>
    STDMETHOD(RemovePointsAtEnd)(
        UINT32 pointsCount
        ) PURE;

    /// <summary>
    /// Updates the points array. Existing points not updated by this method are
    /// preserved. The array is resized larger if necessary to accomodate the new
    /// points.
    /// </summary>
    /// <param name="points">The points array.</param>
    /// <param name="pointsCount">The number of points to update.</param>
    /// <param name="startIndex">The index at which to begin updating points. Must be
    /// less than or equal to the size of the array.</param>
    STDMETHOD(UpdatePoints)(
        _In_reads_(pointsCount) CONST D2D1_POINT_2F *points,
        UINT32 pointsCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets points from the points array.
    /// </summary>
    /// <param name="points">Buffer to contain the points.</param>
    /// <param name="pointsCount">The element count of the buffer.</param>
    /// <param name="startIndex">The index of the first point to retrieve.</param>
    STDMETHOD(GetPoints)(
        _Out_writes_(pointsCount) D2D1_POINT_2F *points,
        UINT32 pointsCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets the number of points in the array.
    /// </summary>
    STDMETHOD_(UINT32, GetPointsCount)(
        ) PURE;
}; // interface ID2D1SvgPointCollection

/// <summary>
/// Interface describing SVG path data. Path data can be set as the 'd' attribute on
/// a 'path' element.
///
/// The path data set is factored into two arrays. The segment data array stores all
/// numbers and the commands array stores the set of commands. Unlike the string
/// data set in the d attribute, each command in this representation uses a fixed
/// number of elements in the segment data array. Therefore, the path 'M 0,0 100,0
/// 0,100 Z' is represented as: 'M0,0 L100,0 L0,100 Z'. This is split into two
/// arrays, with the segment data containing '0,0 100,0 0,100', and the commands
/// containing 'M L L Z'.
/// </summary>
interface DX_DECLARE_INTERFACE("c095e4f4-bb98-43d6-9745-4d1b84ec9888") ID2D1SvgPathData  : public ID2D1SvgAttribute
{

    /// <summary>
    /// Removes data from the end of the segment data array.
    /// </summary>
    /// <param name="dataCount">Specifies how much data to remove.</param>
    STDMETHOD(RemoveSegmentDataAtEnd)(
        UINT32 dataCount
        ) PURE;

    /// <summary>
    /// Updates the segment data array. Existing segment data not updated by this method
    /// are preserved. The array is resized larger if necessary to accomodate the new
    /// segment data.
    /// </summary>
    /// <param name="data">The data array.</param>
    /// <param name="dataCount">The number of data to update.</param>
    /// <param name="startIndex">The index at which to begin updating segment data. Must
    /// be less than or equal to the size of the segment data array.</param>
    STDMETHOD(UpdateSegmentData)(
        _In_reads_(dataCount) CONST FLOAT *data,
        UINT32 dataCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets data from the segment data array.
    /// </summary>
    /// <param name="data">Buffer to contain the segment data array.</param>
    /// <param name="dataCount">The element count of the buffer.</param>
    /// <param name="startIndex">The index of the first segment data to retrieve.
    /// </param>
    STDMETHOD(GetSegmentData)(
        _Out_writes_(dataCount) FLOAT *data,
        UINT32 dataCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets the size of the segment data array.
    /// </summary>
    STDMETHOD_(UINT32, GetSegmentDataCount)(
        ) PURE;

    /// <summary>
    /// Removes commands from the end of the commands array.
    /// </summary>
    /// <param name="commandsCount">Specifies how many commands to remove.</param>
    STDMETHOD(RemoveCommandsAtEnd)(
        UINT32 commandsCount
        ) PURE;

    /// <summary>
    /// Updates the commands array. Existing commands not updated by this method are
    /// preserved. The array is resized larger if necessary to accomodate the new
    /// commands.
    /// </summary>
    /// <param name="commands">The commands array.</param>
    /// <param name="commandsCount">The number of commands to update.</param>
    /// <param name="startIndex">The index at which to begin updating commands. Must be
    /// less than or equal to the size of the commands array.</param>
    STDMETHOD(UpdateCommands)(
        _In_reads_(commandsCount) CONST D2D1_SVG_PATH_COMMAND *commands,
        UINT32 commandsCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets commands from the commands array.
    /// </summary>
    /// <param name="commands">Buffer to contain the commands</param>
    /// <param name="commandsCount">The element count of the buffer.</param>
    /// <param name="startIndex">The index of the first commands to retrieve.</param>
    STDMETHOD(GetCommands)(
        _Out_writes_(commandsCount) D2D1_SVG_PATH_COMMAND *commands,
        UINT32 commandsCount,
        UINT32 startIndex = 0
        ) PURE;

    /// <summary>
    /// Gets the size of the commands array.
    /// </summary>
    STDMETHOD_(UINT32, GetCommandsCount)(
        ) PURE;

    /// <summary>
    /// Creates a path geometry object representing the path data.
    /// </summary>
    STDMETHOD(CreatePathGeometry)(
        D2D1_FILL_MODE fillMode,
        _COM_Outptr_ ID2D1PathGeometry1 **pathGeometry
        ) PURE;
}; // interface ID2D1SvgPathData

/// <summary>
/// Interface for all SVG elements.
/// </summary>
interface DX_DECLARE_INTERFACE("ac7b67a6-183e-49c1-a823-0ebe40b0db29") ID2D1SvgElement  : public ID2D1Resource
{

    /// <summary>
    /// Gets the document that contains this element. Returns null if the element has
    /// been removed from the tree.
    /// </summary>
    STDMETHOD_(void, GetDocument)(
        _Outptr_result_maybenull_ ID2D1SvgDocument **document
        ) PURE;

    /// <summary>
    /// Gets the tag name.
    /// </summary>
    STDMETHOD(GetTagName)(
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount
        ) PURE;

    /// <summary>
    /// Gets the string length of the tag name. The returned string length does not
    /// include room for the null terminator.
    /// </summary>
    STDMETHOD_(UINT32, GetTagNameLength)(
        ) PURE;

    /// <summary>
    /// Returns TRUE if this element represents text content, e.g. the content of a
    /// 'title' or 'desc' element. Text content does not have a tag name.
    /// </summary>
    STDMETHOD_(BOOL, IsTextContent)(
        ) PURE;

    /// <summary>
    /// Gets the parent element.
    /// </summary>
    STDMETHOD_(void, GetParent)(
        _Outptr_result_maybenull_ ID2D1SvgElement **parent
        ) PURE;

    /// <summary>
    /// Returns whether this element has children.
    /// </summary>
    STDMETHOD_(BOOL, HasChildren)(
        ) PURE;

    /// <summary>
    /// Gets the first child of this element.
    /// </summary>
    STDMETHOD_(void, GetFirstChild)(
        _Outptr_result_maybenull_ ID2D1SvgElement **child
        ) PURE;

    /// <summary>
    /// Gets the last child of this element.
    /// </summary>
    STDMETHOD_(void, GetLastChild)(
        _Outptr_result_maybenull_ ID2D1SvgElement **child
        ) PURE;

    /// <summary>
    /// Gets the previous sibling of the referenceChild element.
    /// </summary>
    /// <param name="referenceChild">The referenceChild must be an immediate child of
    /// this element.</param>
    /// <param name="previousChild">The output previousChild element will be non-null if
    /// the referenceChild has a previous sibling. If the referenceChild is the first
    /// child, the output is null.</param>
    STDMETHOD(GetPreviousChild)(
        _In_ ID2D1SvgElement *referenceChild,
        _COM_Outptr_result_maybenull_ ID2D1SvgElement **previousChild
        ) PURE;

    /// <summary>
    /// Gets the next sibling of the referenceChild element.
    /// </summary>
    /// <param name="referenceChild">The referenceChild must be an immediate child of
    /// this element.</param>
    /// <param name="nextChild">The output nextChild element will be non-null if the
    /// referenceChild has a next sibling. If the referenceChild is the last child, the
    /// output is null.</param>
    STDMETHOD(GetNextChild)(
        _In_ ID2D1SvgElement *referenceChild,
        _COM_Outptr_result_maybenull_ ID2D1SvgElement **nextChild
        ) PURE;

    /// <summary>
    /// Inserts newChild as a child of this element, before the referenceChild element.
    /// If the newChild element already has a parent, it is removed from this parent as
    /// part of the insertion. Returns an error if this element cannot accept children
    /// of the type of newChild. Returns an error if the newChild is an ancestor of this
    /// element.
    /// </summary>
    /// <param name="newChild">The element to be inserted.</param>
    /// <param name="referenceChild">The element that the child should be inserted
    /// before. If referenceChild is null, the newChild is placed as the last child. If
    /// referenceChild is non-null, it must be an immediate child of this element.
    /// </param>
    STDMETHOD(InsertChildBefore)(
        _In_ ID2D1SvgElement *newChild,
        _In_opt_ ID2D1SvgElement *referenceChild = NULL
        ) PURE;

    /// <summary>
    /// Appends newChild to the list of children. If the newChild element already has a
    /// parent, it is removed from this parent as part of the append operation. Returns
    /// an error if this element cannot accept children of the type of newChild. Returns
    /// an error if the newChild is an ancestor of this element.
    /// </summary>
    /// <param name="newChild">The element to be appended.</param>
    STDMETHOD(AppendChild)(
        _In_ ID2D1SvgElement *newChild
        ) PURE;

    /// <summary>
    /// Replaces the oldChild element with the newChild. This operation removes the
    /// oldChild from the tree. If the newChild element already has a parent, it is
    /// removed from this parent as part of the replace operation. Returns an error if
    /// this element cannot accept children of the type of newChild. Returns an error if
    /// the newChild is an ancestor of this element.
    /// </summary>
    /// <param name="newChild">The element to be inserted.</param>
    /// <param name="oldChild">The child element to be replaced. The oldChild element
    /// must be an immediate child of this element.</param>
    STDMETHOD(ReplaceChild)(
        _In_ ID2D1SvgElement *newChild,
        _In_ ID2D1SvgElement *oldChild
        ) PURE;

    /// <summary>
    /// Removes the oldChild from the tree. Children of oldChild remain children of
    /// oldChild.
    /// </summary>
    /// <param name="oldChild">The child element to be removed. The oldChild element
    /// must be an immediate child of this element.</param>
    STDMETHOD(RemoveChild)(
        _In_ ID2D1SvgElement *oldChild
        ) PURE;

    /// <summary>
    /// Creates an element from a tag name. The element is appended to the list of
    /// children. Returns an error if this element cannot accept children of the
    /// specified type.
    /// </summary>
    /// <param name="tagName">The tag name of the new child. An empty string is
    /// interpreted to be a text content element.</param>
    /// <param name="newChild">The new child element.</param>
    STDMETHOD(CreateChild)(
        _In_ PCWSTR tagName,
        _COM_Outptr_ ID2D1SvgElement **newChild
        ) PURE;

    /// <summary>
    /// Returns true if the attribute is explicitly set on the element or if it is
    /// present within an inline style. Returns FALSE if the attribute is not a valid
    /// attribute on this element.
    /// </summary>
    /// <param name="name">The name of the attribute.</param>
    /// <param name="inherited">Outputs whether the attribute is set to the 'inherit'
    /// value.</param>
    STDMETHOD_(BOOL, IsAttributeSpecified)(
        _In_ PCWSTR name,
        _Out_opt_ BOOL *inherited = NULL
        ) PURE;

    /// <summary>
    /// Returns the number of specified attributes on this element. Attributes are only
    /// considered specified if they are explicitly set on the element or present within
    /// an inline style. Properties that receive their value through CSS inheritance are
    /// not considered specified. An attribute can become specified if it is set through
    /// a method call. It can become unspecified if it is removed via RemoveAttribute.
    /// </summary>
    STDMETHOD_(UINT32, GetSpecifiedAttributeCount)(
        ) PURE;

    /// <summary>
    /// Gets the name of the specified attribute at the given index.
    /// </summary>
    /// <param name="index">The specified index of the attribute.</param>
    /// <param name="name">Outputs the name of the attribute.</param>
    /// <param name="inherited">Outputs whether the attribute is set to the 'inherit'
    /// value.</param>
    STDMETHOD(GetSpecifiedAttributeName)(
        UINT32 index,
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount,
        _Out_opt_ BOOL *inherited = NULL
        ) PURE;

    /// <summary>
    /// Gets the string length of the name of the specified attribute at the given
    /// index. The output string length does not include room for the null terminator.
    /// </summary>
    /// <param name="index">The specified index of the attribute.</param>
    /// <param name="nameLength">Outputs the string length of the name of the specified
    /// attribute.</param>
    /// <param name="inherited">Outputs whether the attribute is set to the 'inherit'
    /// value.</param>
    STDMETHOD(GetSpecifiedAttributeNameLength)(
        UINT32 index,
        _Out_ UINT32 *nameLength,
        _Out_opt_ BOOL *inherited = NULL
        ) PURE;

    /// <summary>
    /// Removes the attribute from this element. Also removes this attribute from within
    /// an inline style if present. Returns an error if the attribute name is not valid
    /// on this element.
    /// </summary>
    STDMETHOD(RemoveAttribute)(
        _In_ PCWSTR name
        ) PURE;

    /// <summary>
    /// Sets the value of a text content element.
    /// </summary>
    STDMETHOD(SetTextValue)(
        _In_reads_(nameCount) CONST WCHAR *name,
        UINT32 nameCount
        ) PURE;

    /// <summary>
    /// Gets the value of a text content element.
    /// </summary>
    STDMETHOD(GetTextValue)(
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount
        ) PURE;

    /// <summary>
    /// Gets the length of the text content value. The returned string length does not
    /// include room for the null terminator.
    /// </summary>
    STDMETHOD_(UINT32, GetTextValueLength)(
        ) PURE;

    /// <summary>
    /// Sets an attribute of this element using a string. Returns an error if the
    /// attribute name is not valid on this element. Returns an error if the attribute
    /// cannot be expressed as the specified type.
    /// </summary>
    STDMETHOD(SetAttributeValue)(
        _In_ PCWSTR name,
        D2D1_SVG_ATTRIBUTE_STRING_TYPE type,
        _In_ PCWSTR value
        ) PURE;

    /// <summary>
    /// Gets an attribute of this element as a string. Returns an error if the attribute
    /// is not specified. Returns an error if the attribute name is not valid on this
    /// element. Returns an error if the attribute cannot be expressed as the specified
    /// string type.
    /// </summary>
    STDMETHOD(GetAttributeValue)(
        _In_ PCWSTR name,
        D2D1_SVG_ATTRIBUTE_STRING_TYPE type,
        _Out_writes_(valueCount) PWSTR value,
        UINT32 valueCount
        ) PURE;

    /// <summary>
    /// Gets the string length of an attribute of this element. The returned string
    /// length does not include room for the null terminator. Returns an error if the
    /// attribute is not specified. Returns an error if the attribute name is not valid
    /// on this element. Returns an error if the attribute cannot be expressed as the
    /// specified string type.
    /// </summary>
    STDMETHOD(GetAttributeValueLength)(
        _In_ PCWSTR name,
        D2D1_SVG_ATTRIBUTE_STRING_TYPE type,
        _Out_ UINT32 *valueLength
        ) PURE;

    /// <summary>
    /// Sets an attribute of this element using a POD type. Returns an error if the
    /// attribute name is not valid on this element. Returns an error if the attribute
    /// cannot be expressed as the specified type.
    /// </summary>
    STDMETHOD(SetAttributeValue)(
        _In_ PCWSTR name,
        D2D1_SVG_ATTRIBUTE_POD_TYPE type,
        _In_reads_bytes_(valueSizeInBytes) CONST void *value,
        UINT32 valueSizeInBytes
        ) PURE;

    /// <summary>
    /// Gets an attribute of this element as a POD type. Returns an error if the
    /// attribute is not specified. Returns an error if the attribute name is not valid
    /// on this element. Returns an error if the attribute cannot be expressed as the
    /// specified POD type.
    /// </summary>
    STDMETHOD(GetAttributeValue)(
        _In_ PCWSTR name,
        D2D1_SVG_ATTRIBUTE_POD_TYPE type,
        _Out_writes_bytes_(valueSizeInBytes) void *value,
        UINT32 valueSizeInBytes
        ) PURE;

    /// <summary>
    /// Sets an attribute of this element using an interface. Returns an error if the
    /// attribute name is not valid on this element. Returns an error if the attribute
    /// cannot be expressed as the specified interface type. Returns an error if the
    /// attribute object is already set on an element. A given attribute object may only
    /// be set on one element in one attribute location at a time.
    /// </summary>
    STDMETHOD(SetAttributeValue)(
        _In_ PCWSTR name,
        _In_ ID2D1SvgAttribute *value
        ) PURE;

    /// <summary>
    /// Gets an attribute of this element as an interface type. Returns an error if the
    /// attribute is not specified. Returns an error if the attribute name is not valid
    /// on this element. Returns an error if the attribute cannot be expressed as the
    /// specified interface type.
    /// </summary>
    /// <param name="riid">The interface ID of the attribute value.</param>
    STDMETHOD(GetAttributeValue)(
        _In_ PCWSTR name,
        _In_ REFIID riid,
        _COM_Outptr_result_maybenull_ void **value
        ) PURE;

    /// <summary>
    /// Sets an attribute of this element using a float.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        FLOAT value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a float.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ FLOAT *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a color.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        CONST D2D1_COLOR_F &value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a color.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_COLOR_F *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a fill mode. This method can be used to set
    /// the value of the 'fill-rule' or 'clip-rule' properties.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_FILL_MODE value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a fill mode. This method can be used to get
    /// the value of the 'fill-rule' or 'clip-rule' properties.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_FILL_MODE *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a display value. This method can be used to
    /// set the value of the 'display' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_DISPLAY value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a display value. This method can be used to
    /// get the value of the 'display' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_DISPLAY *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as an overflow value. This method can be used
    /// to set the value of the 'overflow' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_OVERFLOW value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as an overflow value. This method can be used
    /// to get the value of the 'overflow' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_OVERFLOW *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a line join value. This method can be used
    /// to set the value of the 'stroke-linejoin' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_LINE_JOIN value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a line join value. This method can be used
    /// to get the value of the 'stroke-linejoin' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_LINE_JOIN *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a line cap value. This method can be used
    /// to set the value of the 'stroke-linecap' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_LINE_CAP value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a line cap value. This method can be used
    /// to get the value of the 'stroke-linecap' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_LINE_CAP *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a visibility value. This method can be used
    /// to set the value of the 'visibility' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_VISIBILITY value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a visibility value. This method can be used
    /// to get the value of the 'visibility' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_VISIBILITY *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a matrix value. This method can be used to
    /// set the value of a 'transform' or 'gradientTransform' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        CONST D2D1_MATRIX_3X2_F &value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a matrix value. This method can be used to
    /// get the value of a 'transform' or 'gradientTransform' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_MATRIX_3X2_F *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a unit type value. This method can be used
    /// to set the value of a 'gradientUnits' or 'clipPathUnits' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_SVG_UNIT_TYPE value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a unit type value. This method can be used
    /// to get the value of a 'gradientUnits' or 'clipPathUnits' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_UNIT_TYPE *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as an extend mode value. This method can be
    /// used to set the value of a 'spreadMethod' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        D2D1_EXTEND_MODE value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a extend mode value. This method can be
    /// used to get the value of a 'spreadMethod' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_EXTEND_MODE *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a preserve aspect ratio value. This method
    /// can be used to set the value of a 'preserveAspectRatio' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        CONST D2D1_SVG_PRESERVE_ASPECT_RATIO &value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a preserve aspect ratio value. This method
    /// can be used to get the value of a 'preserveAspectRatio' attribute.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_PRESERVE_ASPECT_RATIO *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO, value, sizeof(*value));
    }

    /// <summary>
    /// Sets an attribute of this element as a length value.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetAttributeValue(
        _In_ PCWSTR name,
        CONST D2D1_SVG_LENGTH &value
        )
    {
        return SetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH, &value, sizeof(value));
    }

    /// <summary>
    /// Gets an attribute of this element as length value.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _Out_ D2D1_SVG_LENGTH *value
        )
    {
        return GetAttributeValue(name, D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH, value, sizeof(*value));
    }

    /// <summary>
    /// Gets an attribute of this element.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _COM_Outptr_result_maybenull_ ID2D1SvgAttribute **value
        )
    {
        return GetAttributeValue(name, IID_ID2D1SvgAttribute, reinterpret_cast<void **>(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a paint. This method can be used to get the
    /// value of the 'fill' or 'stroke' properties.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _COM_Outptr_result_maybenull_ ID2D1SvgPaint **value
        )
    {
        return GetAttributeValue(name, IID_ID2D1SvgPaint, reinterpret_cast<void **>(value));
    }

    /// <summary>
    /// Gets an attribute of this element as a stroke dash array. This method can be
    /// used to get the value of the 'stroke-dasharray' property.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _COM_Outptr_result_maybenull_ ID2D1SvgStrokeDashArray **value
        )
    {
        return GetAttributeValue(name, IID_ID2D1SvgStrokeDashArray, reinterpret_cast<void **>(value));
    }

    /// <summary>
    /// Gets an attribute of this element as points. This method can be used to get the
    /// value of the 'points' attribute on a 'polygon' or 'polyline' element.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _COM_Outptr_result_maybenull_ ID2D1SvgPointCollection **value
        )
    {
        return GetAttributeValue(name, IID_ID2D1SvgPointCollection, reinterpret_cast<void **>(value));
    }

    /// <summary>
    /// Gets an attribute of this element as path data. This method can be used to get
    /// the value of the 'd' attribute on a 'path' element.
    /// </summary>
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetAttributeValue(
        _In_ PCWSTR name,
        _COM_Outptr_result_maybenull_ ID2D1SvgPathData **value
        )
    {
        return GetAttributeValue(name, IID_ID2D1SvgPathData, reinterpret_cast<void **>(value));
    }
}; // interface ID2D1SvgElement

interface DX_DECLARE_INTERFACE("86b88e4d-afa4-4d7b-88e4-68a51c4a0aec") ID2D1SvgDocument  : public ID2D1Resource
{

    /// <summary>
    /// Sets the size of the initial viewport.
    /// </summary>
    STDMETHOD(SetViewportSize)(
        D2D1_SIZE_F viewportSize
        ) PURE;

    /// <summary>
    /// Returns the size of the initial viewport.
    /// </summary>
    STDMETHOD_(D2D1_SIZE_F, GetViewportSize)(
        ) CONST PURE;

    /// <summary>
    /// Sets the root element of the document. The root element must be an 'svg'
    /// element. If the element already exists within an svg tree, it is first removed.
    /// </summary>
    STDMETHOD(SetRoot)(
        _In_opt_ ID2D1SvgElement *root
        ) PURE;

    /// <summary>
    /// Gets the root element of the document.
    /// </summary>
    STDMETHOD_(void, GetRoot)(
        _Outptr_result_maybenull_ ID2D1SvgElement **root
        ) PURE;

    /// <summary>
    /// Gets the SVG element with the specified ID. If the element cannot be found, the
    /// returned element will be null.
    /// </summary>
    STDMETHOD(FindElementById)(
        _In_ PCWSTR id,
        _COM_Outptr_result_maybenull_ ID2D1SvgElement **svgElement
        ) PURE;

    /// <summary>
    /// Serializes an element and its subtree to XML. The output XML is encoded as
    /// UTF-8.
    /// </summary>
    /// <param name="outputXmlStream">An output stream to contain the SVG XML subtree.
    /// </param>
    /// <param name="subtree">The root of the subtree. If null, the entire document is
    /// serialized.</param>
    STDMETHOD(Serialize)(
        _In_ IStream *outputXmlStream,
        _In_opt_ ID2D1SvgElement *subtree = NULL
        ) PURE;

    /// <summary>
    /// Deserializes a subtree from the stream. The stream must have only one root
    /// element, but that root element need not be an 'svg' element. The output element
    /// is not inserted into this document tree.
    /// </summary>
    /// <param name="inputXmlStream">An input stream containing the SVG XML subtree.
    /// </param>
    /// <param name="subtree">The root of the subtree.</param>
    STDMETHOD(Deserialize)(
        _In_ IStream *inputXmlStream,
        _COM_Outptr_ ID2D1SvgElement **subtree
        ) PURE;

    /// <summary>
    /// Creates a paint object which can be used to set the 'fill' or 'stroke'
    /// properties.
    /// </summary>
    /// <param name="color">The color used if the paintType is
    /// D2D1_SVG_PAINT_TYPE_COLOR.</param>
    /// <param name="id">The element id which acts as the paint server. This id is used
    /// if the paint type is D2D1_SVG_PAINT_TYPE_URI.</param>
    STDMETHOD(CreatePaint)(
        D2D1_SVG_PAINT_TYPE paintType,
        _In_opt_ CONST D2D1_COLOR_F *color,
        _In_opt_ PCWSTR id,
        _COM_Outptr_ ID2D1SvgPaint **paint
        ) PURE;

    /// <summary>
    /// Creates a dash array object which can be used to set the 'stroke-dasharray'
    /// property.
    /// </summary>
    STDMETHOD(CreateStrokeDashArray)(
        _In_reads_opt_(dashesCount) CONST D2D1_SVG_LENGTH *dashes,
        UINT32 dashesCount,
        _COM_Outptr_ ID2D1SvgStrokeDashArray **strokeDashArray
        ) PURE;

    /// <summary>
    /// Creates a points object which can be used to set a 'points' attribute on a
    /// 'polygon' or 'polyline' element.
    /// </summary>
    STDMETHOD(CreatePointCollection)(
        _In_reads_opt_(pointsCount) CONST D2D1_POINT_2F *points,
        UINT32 pointsCount,
        _COM_Outptr_ ID2D1SvgPointCollection **pointCollection
        ) PURE;

    /// <summary>
    /// Creates a path data object which can be used to set a 'd' attribute on a 'path'
    /// element.
    /// </summary>
    STDMETHOD(CreatePathData)(
        _In_reads_opt_(segmentDataCount) CONST FLOAT *segmentData,
        UINT32 segmentDataCount,
        _In_reads_opt_(commandsCount) CONST D2D1_SVG_PATH_COMMAND *commands,
        UINT32 commandsCount,
        _COM_Outptr_ ID2D1SvgPathData **pathData
        ) PURE;

    /// <summary>
    /// Creates a paint object which can be used to set the 'fill' or 'stroke'
    /// properties.
    /// </summary>
    /// <param name="color">The color used if the paintType is
    /// D2D1_SVG_PAINT_TYPE_COLOR.</param>
    /// <param name="id">The element id which acts as the paint server. This id is used
    /// if the paint type is D2D1_SVG_PAINT_TYPE_URI.</param>
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreatePaint(
        D2D1_SVG_PAINT_TYPE paintType,
        CONST D2D1_COLOR_F &color,
        _In_opt_ PCWSTR id,
        _COM_Outptr_ ID2D1SvgPaint **paint
        )
    {
        return CreatePaint(paintType, &color, id, paint);
    }
}; // interface ID2D1SvgDocument

#endif

#endif

#ifdef D2D_USE_C_DEFINITIONS

#endif

/*#endif*/ /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
/*#pragma endregion*/
#endif // #ifndef _D2D1_SVG_
