# Contributing


## Issues

**Issues** are used to report bugs, problems, feature requests, ask questions or other kind of suggestions. An issue ***should include***:

- Good and meaningful title
- Detailed description

### Problems and Bugs

Problem and bug reports ***need also***:

- Expected and actual behaviour
- Used version, compiler and platform
- Minimal example or steps to reproduce


## Pull Requests

**Pull requests** are used to submit contributions to the project. A pull request ***should include***:

- Good and meaningful title
- Detailed description
- Descriptive commit messages

If the PR is related to an *Issue*, please reference it in the description or title.

### Code

The contributed code should match these criteria:

- Pass all Unit Tests and CI Builds
- Proper Test Cases
- Merge cleanly, without conflicts
- Follow the projects code style
- Does not introduce external dependencies
- 4 Spaces – no Tabs
- UTF-8 encoding



## Further readings

- [Github Guide: How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)

