# Toolchain intended for AJA internal CI builds
if (CMAKE_SYSTEM_NAME STREQUAL "Windows")
    if (AJA_USE_CLANG)
        set(CMAKE_C_COMPILER clang.exe)
        set(CMAKE_CXX_COMPILER clang++.exe)
    else()
        set(CMAKE_C_COMPILER cl.exe)
        set(CMAKE_CXX_COMPILER cl.exe)
    endif()
elseif (CMAKE_SYSTEM_NAME STREQUAL "Linux")
    if (AJA_USE_CLANG)
        set(CMAKE_C_COMPILER clang)
        set(CMAKE_CXX_COMPILER clang++)
    else()
        if(AJA_USE_GCC_NEW_ABI)
        # GCC >= 5 (supports C++11)
            set(CMAKE_CXX_STANDARD 11)
            if (NOT EXISTS /opt/aja/bin/g++)
                message(FATAL_ERROR "AJA:  GCC 5 not found in /opt/aja/bin")
                return()
            endif()
            message(STATUS "AJA:  Building with GCC 5 in /opt/aja/bin")
            set(CMAKE_C_COMPILER /opt/aja/bin/gcc)
            set(CMAKE_CXX_COMPILER /opt/aja/bin/g++)
        else()
            # GCC <= 4.8.5 (CentOS7 default compiler)
            set(CMAKE_CXX_STANDARD 98)
            set(CMAKE_C_COMPILER gcc)
            set(CMAKE_CXX_COMPILER g++)
        endif()
    endif()
elseif(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
    # no-op
endif()
