/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import net.sourceforge.napkinlaf.shapes.DrawnCubicLineGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnQuadLineGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDrawnGenerator {
    public abstract Shape generate(AffineTransform var1);

    public static Shape addLine(GeneralPath path, AffineTransform matrix, AbstractDrawnGenerator gen) {
        Shape shape;
        if (gen != null) {
            shape = gen.generate(matrix);
        } else {
            double[] coords = new double[]{0.0, 0.0, 100.0, 0.0};
            matrix.transform(coords, 0, coords, 0, coords.length / 2);
            shape = new Line2D.Double(coords[0], coords[1], coords[2], coords[3]);
        }
        path.append(shape, false);
        return shape;
    }

    public static Class<? extends AbstractDrawnGenerator> defaultLineType(double len) {
        return len < 10.0 ? DrawnQuadLineGenerator.class : DrawnCubicLineGenerator.class;
    }

    public static AbstractDrawnGenerator defaultLineGenerator(double len) {
        return AbstractDrawnGenerator.defaultLineType(len) == DrawnQuadLineGenerator.class ? new DrawnQuadLineGenerator() : new DrawnCubicLineGenerator();
    }
}

