/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.BitmapBounds;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureXml;
import deadbeef.SupTools.Substream;
import deadbeef.Tools.QuantizeFilter;
import deadbeef.Tools.ToolBox;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SupXml
implements Substream {
    private final ArrayList<SubPictureXml> subPictures;
    private Palette palette;
    private Bitmap bitmap;
    private int primaryColorIndex;
    private int numForcedFrames;
    private String pathName;
    private String title;
    private String language;
    private Core.Resolution resolution;
    private double fps;
    private double fpsXml;
    private int numToImport;
    static final String[] xmlStates = new String[]{"bdn", "description", "name", "language", "format", "events", "event", "graphic"};

    SupXml(String fn) throws CoreException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.pathName = ToolBox.addSeparator(ToolBox.getPathName(fn));
        this.title = ToolBox.stripExtension(ToolBox.getFileName(fn));
        this.language = "deu";
        this.resolution = Core.Resolution.HD_1080;
        this.fps = 23.976023976023978;
        this.fpsXml = SupXml.XmlFps(this.fps);
        this.subPictures = new ArrayList();
        try {
            SAXParser saxParser = factory.newSAXParser();
            XmlHandler handler = new XmlHandler();
            saxParser.parse(new File(fn), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(e.getMessage());
        }
        catch (SAXException e) {
            throw new CoreException(e.getMessage());
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage());
        }
        Core.print("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    static double XmlFps(double fps) {
        if (fps == 23.975) {
            return 24.0;
        }
        if (fps == 23.976023976023978) {
            return 24.0;
        }
        if (fps == 29.97002997002997) {
            return 30.0;
        }
        if (fps == 59.94005994005994) {
            return 60.0;
        }
        return fps;
    }

    @Override
    public void close() {
    }

    @Override
    public void decode(int index) throws CoreException {
        try {
            IndexColorModel icm;
            File f = new File(this.subPictures.get((int)index).fileName);
            if (!f.exists()) {
                throw new CoreException("file " + this.subPictures.get((int)index).fileName + " not found.");
            }
            BufferedImage img = ImageIO.read(f);
            int w = img.getWidth();
            int h = img.getHeight();
            this.palette = null;
            if (img.getType() == 13 && ((icm = (IndexColorModel)img.getColorModel()).getMapSize() < 255 || icm.hasAlpha() && icm.getAlpha(255) == 0)) {
                this.palette = new Palette(256);
                int i = 0;
                while (i < icm.getMapSize()) {
                    int alpha = icm.getRGB(i) >> 24 & 0xFF;
                    if (alpha >= Core.getAlphaCrop()) {
                        this.palette.setARGB(i, icm.getRGB(i));
                    } else {
                        this.palette.setARGB(i, 0);
                    }
                    ++i;
                }
                WritableRaster raster = img.getRaster();
                this.bitmap = new Bitmap(img.getWidth(), img.getHeight(), (byte[])raster.getDataElements(0, 0, img.getWidth(), img.getHeight(), null));
            }
            if (this.palette == null) {
                int[] pixels = new int[w * h];
                img.getRGB(0, 0, w, h, pixels, 0, w);
                QuantizeFilter qf = new QuantizeFilter();
                this.bitmap = new Bitmap(img.getWidth(), img.getHeight());
                int[] ct = qf.quantize(pixels, this.bitmap.getImg(), w, h, 255, false, false);
                int size = ct.length;
                if (size > 255) {
                    Core.printWarn("Quantizer failed.\n");
                    size = 255;
                }
                this.palette = new Palette(256);
                int i = 0;
                while (i < size) {
                    int alpha = ct[i] >> 24 & 0xFF;
                    if (alpha >= Core.getAlphaCrop()) {
                        this.palette.setARGB(i, ct[i]);
                    } else {
                        this.palette.setARGB(i, 0);
                    }
                    ++i;
                }
            }
            this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette, Core.getAlphaThr());
            BitmapBounds bounds = this.bitmap.getBounds(this.palette, Core.getAlphaCrop());
            if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
                w = bounds.xMax - bounds.xMin + 1;
                h = bounds.yMax - bounds.yMin + 1;
                if (w < 2) {
                    w = 2;
                }
                if (h < 2) {
                    h = 2;
                }
                this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, w, h);
                SubPictureXml pic = this.subPictures.get(index);
                pic.setImageWidth(w);
                pic.setImageHeight(h);
                pic.setOfsX(pic.originalX + bounds.xMin);
                pic.setOfsY(pic.originalY + bounds.yMin);
            }
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage());
        }
        catch (OutOfMemoryError e) {
            JOptionPane.showMessageDialog(Core.getMainFrame(), "Out of heap! Use -Xmx256m to increase heap!", "Error!", 2);
            throw new CoreException("Out of heap! Use -Xmx256m to increase heap!");
        }
    }

    static void writeXml(String fname, SubPicture[] pics) throws CoreException {
        double fps = Core.getFPSTrg();
        double fpsXml = SupXml.XmlFps(fps);
        BufferedWriter out = null;
        String name = ToolBox.stripExtension(ToolBox.getFileName(fname));
        try {
            try {
                out = new BufferedWriter(new FileWriter(fname));
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                out.newLine();
                out.write("<BDN Version=\"0.93\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"BD-03-006-0093b BDN File Format.xsd\">");
                out.newLine();
                out.write("  <Description>");
                out.newLine();
                out.write("    <Name Title=\"" + name + "\" Content=\"\"/>");
                out.newLine();
                out.write("    <Language Code=\"" + Core.getLanguages()[Core.getLanguageIdx()][2] + "\"/>");
                out.newLine();
                String res = Core.getResolutionNameXml(Core.getOutputResolution());
                out.write("    <Format VideoFormat=\"" + res + "\" FrameRate=\"" + ToolBox.formatDouble(fps) + "\" DropFrame=\"False\"/>");
                out.newLine();
                long t = pics[0].startTime;
                if (fps != fpsXml) {
                    t = (t * 2000L + 1001L) / 2002L;
                }
                String ts = ToolBox.ptsToTimeStrXml(t, fpsXml);
                t = pics[pics.length - 1].endTime;
                if (fps != fpsXml) {
                    t = (t * 2000L + 1001L) / 2002L;
                }
                String te = ToolBox.ptsToTimeStrXml(t, fpsXml);
                out.write("    <Events Type=\"Graphic\" FirstEventInTC=\"" + ts + "\" LastEventOutTC=\"" + te + "\" NumberofEvents=\"" + pics.length + "\"/>");
                out.newLine();
                out.write("  </Description>");
                out.newLine();
                out.write("  <Events>");
                out.newLine();
                int idx = 0;
                while (idx < pics.length) {
                    SubPicture p = pics[idx];
                    t = p.startTime;
                    if (fps != fpsXml) {
                        t = (t * 2000L + 1001L) / 2002L;
                    }
                    ts = ToolBox.ptsToTimeStrXml(t, fpsXml);
                    t = p.endTime;
                    if (fps != fpsXml) {
                        t = (t * 2000L + 1001L) / 2002L;
                    }
                    te = ToolBox.ptsToTimeStrXml(t, fpsXml);
                    String forced = p.isforced ? "True" : "False";
                    out.write("    <Event InTC=\"" + ts + "\" OutTC=\"" + te + "\" Forced=\"" + forced + "\">");
                    out.newLine();
                    String pname = SupXml.getPNGname(name, idx + 1);
                    out.write("      <Graphic Width=\"" + p.getImageWidth() + "\" Height=\"" + p.getImageHeight() + "\" X=\"" + p.getOfsX() + "\" Y=\"" + p.getOfsY() + "\">" + pname + "</Graphic>");
                    out.newLine();
                    out.write("    </Event>");
                    out.newLine();
                    ++idx;
                }
                out.write("  </Events>");
                out.newLine();
                out.write("</BDN>");
                out.newLine();
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette);
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette);
    }

    @Override
    public int getNumForcedFrames() {
        return this.numForcedFrames;
    }

    @Override
    public int getNumFrames() {
        return this.subPictures.size();
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public long getStartOffset(int index) {
        return 0L;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get((int)index).endTime;
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get((int)index).startTime;
    }

    @Override
    public boolean isForced(int index) {
        return this.subPictures.get((int)index).isforced;
    }

    static String getPNGname(String fn, int idx) {
        return String.valueOf(ToolBox.stripExtension(fn)) + "_" + ToolBox.zeroTrim(idx, 4) + ".png";
    }

    String getLanguage() {
        return this.language;
    }

    double getFps() {
        return this.fps;
    }

    class XmlHandler
    extends DefaultHandler {
        XmlState state;
        StringBuffer txt;
        boolean valid;
        SubPictureXml pic;

        XmlHandler() {
        }

        private XmlState findState(String s) {
            XmlState[] xmlStateArray = XmlState.values();
            int n = xmlStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlState x = xmlStateArray[n2];
                if (s.toLowerCase().equals(xmlStates[x.ordinal()])) {
                    return x;
                }
                ++n2;
            }
            return XmlState.UNKNOWN;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.state = this.findState(qName);
            if (this.state != XmlState.BDN && !this.valid) {
                Core.printErr("BDN tag missing");
            }
            this.txt = null;
            block0 : switch (this.state) {
                case UNKNOWN: {
                    Core.printErr("Unknown tag " + qName + "\n");
                    break;
                }
                case BDN: {
                    if (this.valid) {
                        Core.printErr("BDN must be used only once");
                        break;
                    }
                    this.valid = true;
                    break;
                }
                case NAME: {
                    String at = atts.getValue("Title");
                    if (at == null) break;
                    SupXml.this.title = at;
                    Core.print("Title: " + SupXml.this.title + "\n");
                    break;
                }
                case LANGUAGE: {
                    String at = atts.getValue("Code");
                    if (at == null) break;
                    SupXml.this.language = at;
                    Core.print("Language: " + SupXml.this.language + "\n");
                    break;
                }
                case FORMAT: {
                    String at = atts.getValue("FrameRate");
                    if (at != null) {
                        SupXml.this.fps = Core.getFPS(at);
                        SupXml.this.fpsXml = SupXml.XmlFps(SupXml.this.fps);
                        Core.print("fps: " + ToolBox.formatDouble(SupXml.this.fps) + "\n");
                    }
                    if ((at = atts.getValue("VideoFormat")) == null) break;
                    String res = at;
                    Core.Resolution[] resolutionArray = Core.Resolution.values();
                    int n = resolutionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Core.Resolution r = resolutionArray[n2];
                        if (res.length() == 4 && res.charAt(0) != '7') {
                            res = res.replace('p', 'i');
                        }
                        if (Core.getResolutionNameXml(r).equalsIgnoreCase(res)) {
                            SupXml.this.resolution = r;
                            Core.print("Language: " + Core.getResolutionNameXml(r) + "\n");
                            break block0;
                        }
                        ++n2;
                    }
                    break;
                }
                case EVENTS: {
                    int n;
                    String at = atts.getValue("NumberofEvents");
                    if (at == null || (n = ToolBox.getInt(at)) <= 0) break;
                    SupXml.this.numToImport = n;
                    Core.setProgressMax(SupXml.this.numToImport);
                    break;
                }
                case EVENT: {
                    this.pic = new SubPictureXml();
                    SupXml.this.subPictures.add(this.pic);
                    int num = SupXml.this.subPictures.size();
                    Core.printX("#" + num + "\n");
                    Core.setProgress(num);
                    String at = atts.getValue("InTC");
                    if (at != null) {
                        this.pic.startTime = ToolBox.timeStrXmlToPTS(at, SupXml.this.fpsXml);
                        if (this.pic.startTime == -1L) {
                            this.pic.startTime = 0L;
                            Core.printWarn("Invalid start time " + at + "\n");
                        }
                    }
                    if ((at = atts.getValue("OutTC")) != null) {
                        this.pic.endTime = ToolBox.timeStrXmlToPTS(at, SupXml.this.fpsXml);
                        if (this.pic.endTime == -1L) {
                            this.pic.endTime = 0L;
                            Core.printWarn("Invalid end time " + at + "\n");
                        }
                    }
                    if (SupXml.this.fps != SupXml.this.fpsXml) {
                        this.pic.startTime = (this.pic.startTime * 1001L + 500L) / 1000L;
                        this.pic.endTime = (this.pic.endTime * 1001L + 500L) / 1000L;
                    }
                    this.pic.isforced = (at = atts.getValue("Forced")) != null ? at.equalsIgnoreCase("true") : false;
                    if (this.pic.isforced) {
                        SupXml supXml = SupXml.this;
                        supXml.numForcedFrames = supXml.numForcedFrames + 1;
                    }
                    int[] dim = Core.getResolution(SupXml.this.resolution);
                    this.pic.width = dim[0];
                    this.pic.height = dim[1];
                    break;
                }
                case GRAPHIC: {
                    this.pic.setImageWidth(ToolBox.getInt(atts.getValue("Width")));
                    this.pic.setImageHeight(ToolBox.getInt(atts.getValue("Height")));
                    this.pic.setOfsX(ToolBox.getInt(atts.getValue("X")));
                    this.pic.setOfsY(ToolBox.getInt(atts.getValue("Y")));
                    this.pic.setOriginal();
                    this.txt = new StringBuffer();
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            XmlState endState = this.findState(qName);
            if (this.state == XmlState.GRAPHIC && endState == XmlState.GRAPHIC) {
                this.pic.fileName = String.valueOf(SupXml.this.pathName) + ToolBox.trim(this.txt.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.txt != null) {
                this.txt.append(ch, start, length);
            }
        }
    }

    static enum XmlState {
        BDN,
        DESCRIPT,
        NAME,
        LANGUAGE,
        FORMAT,
        EVENTS,
        EVENT,
        GRAPHIC,
        UNKNOWN;

    }
}

