/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.ImageObject;
import deadbeef.SupTools.ImageObjectFragment;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.PaletteInfo;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureBD;
import deadbeef.SupTools.Substream;
import deadbeef.SupTools.SupSegment;
import deadbeef.Tools.FileBuffer;
import deadbeef.Tools.FileBufferException;
import deadbeef.Tools.QuantizeFilter;
import deadbeef.Tools.ToolBox;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

class SupBD
implements Substream {
    private final ArrayList<SubPictureBD> subPictures;
    private Palette palette;
    private Bitmap bitmap;
    private final FileBuffer buffer;
    private int primaryColorIndex;
    private int numForcedFrames;
    private static byte[] packetHeader;
    private static byte[] headerPCSStart;
    private static byte[] headerPCSEnd;
    private static byte[] headerODSFirst;
    private static byte[] headerODSNext;
    private static byte[] headerWDS;

    static {
        byte[] byArray = new byte[13];
        byArray[0] = 80;
        byArray[1] = 71;
        packetHeader = byArray;
        byte[] byArray2 = new byte[19];
        byArray2[4] = 16;
        byArray2[7] = -128;
        byArray2[10] = 1;
        headerPCSStart = byArray2;
        byte[] byArray3 = new byte[11];
        byArray3[4] = 16;
        headerPCSEnd = byArray3;
        byte[] byArray4 = new byte[11];
        byArray4[3] = -64;
        headerODSFirst = byArray4;
        byte[] byArray5 = new byte[4];
        byArray5[3] = 64;
        headerODSNext = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = 1;
        headerWDS = byArray6;
    }

    SupBD(String fn) throws CoreException {
        int index = 0;
        try {
            this.buffer = new FileBuffer(fn);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        int bufsize = (int)this.buffer.getSize();
        SubPictureBD pic = null;
        SubPictureBD picLast = null;
        SubPictureBD picTmp = null;
        this.subPictures = new ArrayList();
        int odsCtr = 0;
        int pdsCtr = 0;
        int odsCtrOld = 0;
        int pdsCtrOld = 0;
        int compNum = -1;
        int compNumOld = -1;
        int compCount = 0;
        long ptsPCS = 0L;
        boolean paletteUpdate = false;
        CompositionState cs = CompositionState.INVALID;
        try {
            while (index < bufsize) {
                if (Core.isCancelled()) {
                    throw new CoreException("Cancelled by user!");
                }
                Core.setProgress(index);
                SupSegment segment = this.readSegment(index);
                String[] so = new String[1];
                switch (segment.type) {
                    case 20: {
                        String out = "PDS ofs:" + ToolBox.hex(index, 8) + ", size:" + ToolBox.hex(segment.size, 4);
                        if (compNum != compNumOld) {
                            if (pic != null) {
                                so[0] = null;
                                int ps = this.parsePDS(segment, pic, so);
                                if (ps >= 0) {
                                    Core.print(String.valueOf(out) + ", " + so[0] + "\n");
                                    if (ps <= 0) break;
                                    ++pdsCtr;
                                    break;
                                }
                                Core.print(String.valueOf(out) + "\n");
                                Core.printWarn(String.valueOf(so[0]) + "\n");
                                break;
                            }
                            Core.print(String.valueOf(out) + "\n");
                            Core.printWarn("missing PTS start -> ignored\n");
                            break;
                        }
                        Core.print(String.valueOf(out) + ", comp # unchanged -> ignored\n");
                        break;
                    }
                    case 21: {
                        String out = "ODS ofs:" + ToolBox.hex(index, 8) + ", size:" + ToolBox.hex(segment.size, 4);
                        if (compNum != compNumOld) {
                            if (!paletteUpdate) {
                                if (pic != null) {
                                    so[0] = null;
                                    if (this.parseODS(segment, pic, so)) {
                                        ++odsCtr;
                                    }
                                    if (so[0] != null) {
                                        out = String.valueOf(out) + ", " + so[0];
                                    }
                                    Core.print(String.valueOf(out) + ", img size: " + pic.getImageWidth() + "*" + pic.getImageHeight() + "\n");
                                    break;
                                }
                                Core.print(String.valueOf(out) + "\n");
                                Core.printWarn("missing PTS start -> ignored\n");
                                break;
                            }
                            Core.print(String.valueOf(out) + "\n");
                            Core.printWarn("palette update only -> ignored\n");
                            break;
                        }
                        Core.print(String.valueOf(out) + ", comp # unchanged -> ignored\n");
                        break;
                    }
                    case 22: {
                        String out;
                        compNum = this.getCompositionNumber(segment);
                        cs = this.getCompositionState(segment);
                        paletteUpdate = this.getPaletteUpdateFlag(segment);
                        ptsPCS = segment.timestamp;
                        compCount = segment.size >= 19 ? 1 : 0;
                        if (cs == CompositionState.INVALID) {
                            Core.printWarn("Illegal composition state at offset " + ToolBox.hex(index, 8) + "\n");
                            break;
                        }
                        if (cs == CompositionState.EPOCH_START) {
                            if (this.subPictures.size() > 0 && (odsCtr == 0 || pdsCtr == 0)) {
                                Core.printWarn("missing PDS/ODS: last epoch is discarded\n");
                                this.subPictures.remove(this.subPictures.size() - 1);
                                compNumOld = compNum - 1;
                                picLast = this.subPictures.size() > 0 ? this.subPictures.get(this.subPictures.size() - 1) : null;
                            } else {
                                picLast = pic;
                            }
                            pic = new SubPictureBD();
                            this.subPictures.add(pic);
                            pic.startTime = segment.timestamp;
                            Core.printX("#> " + this.subPictures.size() + " (" + ToolBox.ptsToTimeStr(pic.startTime) + ")\n");
                            so[0] = null;
                            this.parsePCS(segment, pic, so);
                            if (picLast != null && picLast.endTime == 0L) {
                                picLast.endTime = pic.startTime;
                            }
                            out = "PCS ofs:" + ToolBox.hex(index, 8) + ", START, size:" + ToolBox.hex(segment.size, 4) + ", comp#: " + compNum + ", forced: " + pic.isforced;
                            out = so[0] != null ? String.valueOf(out) + ", " + so[0] + "\n" : String.valueOf(out) + "\n";
                            out = String.valueOf(out) + "PTS start: " + ToolBox.ptsToTimeStr(pic.startTime);
                            out = String.valueOf(out) + ", screen size: " + pic.width + "*" + pic.height + "\n";
                            odsCtr = 0;
                            pdsCtr = 0;
                            odsCtrOld = 0;
                            pdsCtrOld = 0;
                            picTmp = null;
                            Core.print(out);
                            break;
                        }
                        if (pic == null) {
                            Core.printWarn("missing start of epoch at offset " + ToolBox.hex(index, 8) + "\n");
                            break;
                        }
                        out = "PCS ofs:" + ToolBox.hex(index, 8) + ", ";
                        switch (cs) {
                            case EPOCH_CONTINUE: {
                                out = String.valueOf(out) + "CONT, ";
                                break;
                            }
                            case ACQU_POINT: {
                                out = String.valueOf(out) + "ACQU, ";
                                break;
                            }
                            case NORMAL: {
                                out = String.valueOf(out) + "NORM, ";
                            }
                        }
                        out = String.valueOf(out) + " size: " + ToolBox.hex(segment.size, 4) + ", comp#: " + compNum + ", forced: " + pic.isforced;
                        if (compNum != compNumOld) {
                            so[0] = null;
                            picTmp = pic.deepCopy();
                            picTmp.endTime = ptsPCS;
                            this.parsePCS(segment, pic, so);
                        }
                        if (so[0] != null) {
                            out = String.valueOf(out) + ", " + so[0];
                        }
                        out = String.valueOf(out) + ", pal update: " + paletteUpdate + "\n";
                        out = String.valueOf(out) + "PTS: " + ToolBox.ptsToTimeStr(segment.timestamp) + "\n";
                        Core.print(out);
                        break;
                    }
                    case 23: {
                        String out = "WDS ofs:" + ToolBox.hex(index, 8) + ", size:" + ToolBox.hex(segment.size, 4);
                        if (pic != null) {
                            this.parseWDS(segment, pic);
                            Core.print(String.valueOf(out) + ", dim: " + pic.winWidth + "*" + pic.winHeight + "\n");
                            break;
                        }
                        Core.print(String.valueOf(out) + "\n");
                        Core.printWarn("Missing PTS start -> ignored\n");
                        break;
                    }
                    case 128: {
                        Core.print("END ofs:" + ToolBox.hex(index, 8) + "\n");
                        if (cs == CompositionState.EPOCH_START) {
                            if (compCount > 0 && odsCtr > odsCtrOld && compNum != compNumOld && SupBD.picMergable(picLast, pic)) {
                                this.subPictures.remove(this.subPictures.size() - 1);
                                pic = picLast;
                                picLast = this.subPictures.size() > 0 ? this.subPictures.get(this.subPictures.size() - 1) : null;
                                Core.printX("#< caption merged\n");
                            }
                        } else {
                            long startTime = 0L;
                            if (pic != null) {
                                startTime = pic.startTime;
                                pic.startTime = ptsPCS;
                            }
                            if (compCount > 0 && odsCtr > odsCtrOld && compNum != compNumOld && !SupBD.picMergable(picTmp, pic)) {
                                if (odsCtr - odsCtrOld > 1 || pdsCtr - pdsCtrOld > 1) {
                                    Core.printWarn("multiple PDS/ODS definitions: result may be erratic\n");
                                }
                                this.subPictures.set(this.subPictures.size() - 1, picTmp);
                                picLast = picTmp;
                                this.subPictures.add(pic);
                                Core.printX("#< " + this.subPictures.size() + " (" + ToolBox.ptsToTimeStr(pic.startTime) + ")\n");
                                odsCtrOld = odsCtr;
                            } else if (pic != null) {
                                pic.startTime = startTime;
                                pic.endTime = ptsPCS;
                                if (picTmp != null && picTmp.isforced) {
                                    pic.isforced = true;
                                }
                                if (pdsCtr > pdsCtrOld || paletteUpdate) {
                                    Core.printWarn("palette animation: result may be erratic\n");
                                }
                            } else {
                                Core.printWarn("end without at least one epoch start\n");
                            }
                        }
                        pdsCtrOld = pdsCtr;
                        compNumOld = compNum;
                        break;
                    }
                    default: {
                        Core.printWarn("<unknown> " + ToolBox.hex(segment.type, 2) + " ofs:" + ToolBox.hex(index, 8) + "\n");
                    }
                }
                index += 13;
                index += segment.size;
            }
        }
        catch (CoreException ex) {
            if (this.subPictures.size() == 0) {
                throw ex;
            }
            Core.printErr(String.valueOf(ex.getMessage()) + "\n");
            Core.print("Probably not all caption imported due to error.\n");
        }
        if (this.subPictures.size() > 0 && (odsCtr == 0 || pdsCtr == 0)) {
            Core.printWarn("missing PDS/ODS: last epoch is discarded\n");
            this.subPictures.remove(this.subPictures.size() - 1);
        }
        Core.setProgress(bufsize);
        this.numForcedFrames = 0;
        for (SubPictureBD p : this.subPictures) {
            if (!p.isforced) continue;
            ++this.numForcedFrames;
        }
        Core.printX("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    private static boolean picMergable(SubPictureBD a, SubPictureBD b) {
        boolean eq = false;
        if (a != null && b != null && (a.endTime == 0L || b.startTime - a.endTime < (long)Core.getMergePTSdiff())) {
            ImageObject ao = a.getImgObj();
            ImageObject bo = b.getImgObj();
            if (ao != null && bo != null && ao.bufferSize == bo.bufferSize && ao.width == bo.width && ao.height == bo.height) {
                eq = true;
            }
        }
        return eq;
    }

    private static int getFpsId(double fps) {
        if (fps == 24.0) {
            return 32;
        }
        if (fps == 25.0) {
            return 48;
        }
        if (fps == 29.97002997002997) {
            return 64;
        }
        if (fps == 50.0) {
            return 96;
        }
        if (fps == 59.94005994005994) {
            return 112;
        }
        return 16;
    }

    private static double getFpsFromID(int id) {
        switch (id) {
            case 32: {
                return 24.0;
            }
            case 48: {
                return 25.0;
            }
            case 64: {
                return 29.97002997002997;
            }
            case 96: {
                return 50.0;
            }
            case 112: {
                return 59.94005994005994;
            }
        }
        return 23.976023976023978;
    }

    private static byte[] encodeImage(Bitmap bm) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int y = 0;
        while (y < bm.getHeight()) {
            int ofs = y * bm.getWidth();
            int x = 0;
            while (x < bm.getWidth()) {
                byte color = bm.getImg()[ofs];
                int len = 1;
                while (x + len < bm.getWidth()) {
                    if (bm.getImg()[ofs + len] != color) break;
                    ++len;
                }
                if (len <= 2 && color != 0) {
                    bytes.add(color);
                    if (len == 2) {
                        bytes.add(color);
                    }
                } else {
                    if (len > 16383) {
                        len = 16383;
                    }
                    bytes.add((byte)0);
                    if (color == 0 && len < 64) {
                        bytes.add((byte)len);
                    } else if (color == 0) {
                        bytes.add((byte)(0x40 | len >> 8));
                        bytes.add((byte)len);
                    } else if (len < 64) {
                        bytes.add((byte)(0x80 | len));
                        bytes.add(color);
                    } else {
                        bytes.add((byte)(0xC0 | len >> 8));
                        bytes.add((byte)len);
                        bytes.add(color);
                    }
                }
                x += len;
                ofs += len;
            }
            if (x == bm.getWidth()) {
                bytes.add((byte)0);
                bytes.add((byte)0);
            }
            ++y;
        }
        int size = bytes.size();
        byte[] retval = new byte[size];
        Iterator it = bytes.iterator();
        int i = 0;
        while (i < size) {
            retval[i] = (Byte)it.next();
            ++i;
        }
        return retval;
    }

    static byte[] createSupFrame(SubPicture pic, Bitmap bm, Palette pal) {
        byte[] rleBuf;
        int size;
        if (pal.getSize() > 255 && pal.getAlpha(255) > 0) {
            QuantizeFilter qf = new QuantizeFilter();
            Bitmap bmQ = new Bitmap(bm.getWidth(), bm.getHeight());
            int[] ct = qf.quantize(bm.toARGB(pal), bmQ.getImg(), bm.getWidth(), bm.getHeight(), 255, false, false);
            size = ct.length;
            if (size > 255) {
                size = 255;
                Core.print("Palette had to be reduced from " + pal.getSize() + " to " + size + " entries.\n");
                Core.printWarn("Quantizer failed.\n");
            } else {
                Core.print("Palette had to be reduced from " + pal.getSize() + " to " + size + " entries.\n");
            }
            pal = new Palette(size);
            int i = 0;
            while (i < size) {
                pal.setARGB(i, ct[i]);
                ++i;
            }
            bm = bmQ;
        }
        int numAddPackets = (rleBuf = SupBD.encodeImage(bm)).length <= 65508 ? 0 : 1 + (rleBuf.length - 65508) / 65515;
        int palSize = bm.getHighestColorIndex(pal) + 1;
        size = packetHeader.length * (8 + numAddPackets);
        size += headerPCSStart.length + headerPCSEnd.length;
        size += 2 * headerWDS.length + headerODSFirst.length;
        size += numAddPackets * headerODSNext.length;
        size += 2 + palSize * 5;
        size += rleBuf.length;
        int yOfs = pic.getOfsY() - Core.getCropOfsY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.height - pic.getImageHeight() - 2 * Core.getCropOfsY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        int h = pic.height - 2 * Core.getCropOfsY();
        byte[] buf = new byte[size];
        int index = 0;
        int fpsId = SupBD.getFpsId(Core.getFPSTrg());
        int frameInitTime = (pic.width * pic.height * 9 + 3199) / 3200;
        int windowInitTime = (bm.getWidth() * bm.getHeight() * 9 + 3199) / 3200;
        int imageDecodeTime = (bm.getWidth() * bm.getHeight() * 9 + 1599) / 1600;
        SupBD.packetHeader[10] = 22;
        int dts = (int)pic.startTime - (frameInitTime + windowInitTime);
        ToolBox.setDWord(packetHeader, 2, (int)pic.startTime);
        ToolBox.setDWord(packetHeader, 6, dts);
        ToolBox.setWord(packetHeader, 11, headerPCSStart.length);
        int i = 0;
        while (i < packetHeader.length) {
            buf[index++] = packetHeader[i];
            ++i;
        }
        ToolBox.setWord(headerPCSStart, 0, pic.width);
        ToolBox.setWord(headerPCSStart, 2, h);
        ToolBox.setByte(headerPCSStart, 4, fpsId);
        ToolBox.setWord(headerPCSStart, 5, pic.compNum);
        SupBD.headerPCSStart[14] = pic.isforced ? 64 : 0;
        ToolBox.setWord(headerPCSStart, 15, pic.getOfsX());
        ToolBox.setWord(headerPCSStart, 17, yOfs);
        i = 0;
        while (i < headerPCSStart.length) {
            buf[index++] = headerPCSStart[i];
            ++i;
        }
        SupBD.packetHeader[10] = 23;
        int timeStamp = (int)pic.startTime - windowInitTime;
        ToolBox.setDWord(packetHeader, 2, timeStamp);
        ToolBox.setWord(packetHeader, 11, headerWDS.length);
        int i2 = 0;
        while (i2 < packetHeader.length) {
            buf[index++] = packetHeader[i2];
            ++i2;
        }
        ToolBox.setWord(headerWDS, 2, pic.getOfsX());
        ToolBox.setWord(headerWDS, 4, yOfs);
        ToolBox.setWord(headerWDS, 6, bm.getWidth());
        ToolBox.setWord(headerWDS, 8, bm.getHeight());
        i2 = 0;
        while (i2 < headerWDS.length) {
            buf[index++] = headerWDS[i2];
            ++i2;
        }
        SupBD.packetHeader[10] = 20;
        ToolBox.setDWord(packetHeader, 2, dts);
        ToolBox.setDWord(packetHeader, 6, 0);
        ToolBox.setWord(packetHeader, 11, 2 + palSize * 5);
        i2 = 0;
        while (i2 < packetHeader.length) {
            buf[index++] = packetHeader[i2];
            ++i2;
        }
        buf[index++] = 0;
        buf[index++] = 0;
        i2 = 0;
        while (i2 < palSize) {
            buf[index++] = (byte)i2;
            buf[index++] = pal.getY()[i2];
            buf[index++] = pal.getCr()[i2];
            buf[index++] = pal.getCb()[i2];
            buf[index++] = pal.getAlpha()[i2];
            ++i2;
        }
        int bufSize = rleBuf.length;
        int rleIndex = 0;
        if (bufSize > 65508) {
            bufSize = 65508;
        }
        SupBD.packetHeader[10] = 21;
        timeStamp = dts + imageDecodeTime;
        ToolBox.setDWord(packetHeader, 2, timeStamp);
        ToolBox.setDWord(packetHeader, 6, dts);
        ToolBox.setWord(packetHeader, 11, headerODSFirst.length + bufSize);
        int i3 = 0;
        while (i3 < packetHeader.length) {
            buf[index++] = packetHeader[i3];
            ++i3;
        }
        int marker = numAddPackets == 0 ? -1073741824 : Integer.MIN_VALUE;
        ToolBox.setDWord(headerODSFirst, 3, marker | rleBuf.length + 4);
        ToolBox.setWord(headerODSFirst, 7, bm.getWidth());
        ToolBox.setWord(headerODSFirst, 9, bm.getHeight());
        int i4 = 0;
        while (i4 < headerODSFirst.length) {
            buf[index++] = headerODSFirst[i4];
            ++i4;
        }
        i4 = 0;
        while (i4 < bufSize) {
            buf[index++] = rleBuf[rleIndex++];
            ++i4;
        }
        bufSize = rleBuf.length - bufSize;
        int p = 0;
        while (p < numAddPackets) {
            int psize = bufSize;
            if (psize > 65515) {
                psize = 65515;
            }
            SupBD.packetHeader[10] = 21;
            ToolBox.setWord(packetHeader, 11, headerODSNext.length + psize);
            int i5 = 0;
            while (i5 < packetHeader.length) {
                buf[index++] = packetHeader[i5];
                ++i5;
            }
            i5 = 0;
            while (i5 < headerODSNext.length) {
                buf[index++] = headerODSNext[i5];
                ++i5;
            }
            i5 = 0;
            while (i5 < psize) {
                buf[index++] = rleBuf[rleIndex++];
                ++i5;
            }
            bufSize -= psize;
            ++p;
        }
        SupBD.packetHeader[10] = -128;
        ToolBox.setDWord(packetHeader, 6, 0);
        ToolBox.setWord(packetHeader, 11, 0);
        i4 = 0;
        while (i4 < packetHeader.length) {
            buf[index++] = packetHeader[i4];
            ++i4;
        }
        SupBD.packetHeader[10] = 22;
        ToolBox.setDWord(packetHeader, 2, (int)pic.endTime);
        dts = (int)pic.startTime - 1;
        ToolBox.setDWord(packetHeader, 6, dts);
        ToolBox.setWord(packetHeader, 11, headerPCSEnd.length);
        i4 = 0;
        while (i4 < packetHeader.length) {
            buf[index++] = packetHeader[i4];
            ++i4;
        }
        ToolBox.setWord(headerPCSEnd, 0, pic.width);
        ToolBox.setWord(headerPCSEnd, 2, h);
        ToolBox.setByte(headerPCSEnd, 4, fpsId);
        ToolBox.setWord(headerPCSEnd, 5, pic.compNum + 1);
        i4 = 0;
        while (i4 < headerPCSEnd.length) {
            buf[index++] = headerPCSEnd[i4];
            ++i4;
        }
        SupBD.packetHeader[10] = 23;
        timeStamp = (int)pic.endTime - windowInitTime;
        ToolBox.setDWord(packetHeader, 2, timeStamp);
        ToolBox.setWord(packetHeader, 11, headerWDS.length);
        i4 = 0;
        while (i4 < packetHeader.length) {
            buf[index++] = packetHeader[i4];
            ++i4;
        }
        ToolBox.setWord(headerWDS, 2, pic.getOfsX());
        ToolBox.setWord(headerWDS, 4, yOfs);
        ToolBox.setWord(headerWDS, 6, bm.getWidth());
        ToolBox.setWord(headerWDS, 8, bm.getHeight());
        i4 = 0;
        while (i4 < headerWDS.length) {
            buf[index++] = headerWDS[i4];
            ++i4;
        }
        SupBD.packetHeader[10] = -128;
        ToolBox.setDWord(packetHeader, 2, dts);
        ToolBox.setDWord(packetHeader, 6, 0);
        ToolBox.setWord(packetHeader, 11, 0);
        i4 = 0;
        while (i4 < packetHeader.length) {
            buf[index++] = packetHeader[i4];
            ++i4;
        }
        return buf;
    }

    private SupSegment readSegment(int offset) throws CoreException {
        try {
            SupSegment segment = new SupSegment();
            if (this.buffer.getWord(offset) != 20551) {
                throw new CoreException("PG missing at index " + ToolBox.hex(offset, 8) + "\n");
            }
            segment.timestamp = this.buffer.getDWord(offset += 2);
            offset += 4;
            segment.type = this.buffer.getByte(offset += 4);
            segment.size = this.buffer.getWord(++offset);
            segment.offset = offset + 2;
            return segment;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private CompositionState getCompositionState(SupSegment segment) throws CoreException {
        try {
            int type = this.buffer.getByte(segment.offset + 7);
            switch (type) {
                case 0: {
                    return CompositionState.NORMAL;
                }
                case 64: {
                    return CompositionState.ACQU_POINT;
                }
                case 128: {
                    return CompositionState.EPOCH_START;
                }
                case 192: {
                    return CompositionState.EPOCH_CONTINUE;
                }
            }
            return CompositionState.INVALID;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private int getCompositionNumber(SupSegment segment) throws CoreException {
        try {
            return this.buffer.getWord(segment.offset + 5);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private boolean getPaletteUpdateFlag(SupSegment segment) throws CoreException {
        try {
            return this.buffer.getByte(segment.offset + 8) == 128;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private void parsePCS(SupSegment segment, SubPictureBD pic, String[] msg) throws CoreException {
        int index = segment.offset;
        try {
            if (segment.size >= 4) {
                pic.width = this.buffer.getWord(index);
                pic.height = this.buffer.getWord(index + 2);
                int type = this.buffer.getByte(index + 4);
                int num = this.buffer.getWord(index + 5);
                int palID = this.buffer.getByte(index + 9);
                int coNum = this.buffer.getByte(index + 10);
                if (coNum > 0) {
                    ImageObject imgObj;
                    int objID = this.buffer.getWord(index + 11);
                    msg[0] = "palID: " + palID + ", objID: " + objID;
                    if (pic.imageObjectList == null) {
                        pic.imageObjectList = new ArrayList();
                    }
                    if (objID >= pic.imageObjectList.size()) {
                        imgObj = new ImageObject();
                        pic.imageObjectList.add(imgObj);
                    } else {
                        imgObj = pic.getImgObj(objID);
                    }
                    imgObj.paletteID = palID;
                    pic.objectID = objID;
                    if (segment.size >= 19) {
                        pic.type = type;
                        int forcedCropped = this.buffer.getByte(index + 14);
                        pic.compNum = num;
                        pic.isforced = (forcedCropped & 0x40) == 64;
                        imgObj.xOfs = this.buffer.getWord(index + 15);
                        imgObj.yOfs = this.buffer.getWord(index + 17);
                    }
                }
            }
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private void parseWDS(SupSegment segment, SubPictureBD pic) throws CoreException {
        int index = segment.offset;
        try {
            if (segment.size >= 10) {
                pic.xWinOfs = this.buffer.getWord(index + 2);
                pic.yWinOfs = this.buffer.getWord(index + 4);
                pic.winWidth = this.buffer.getWord(index + 6);
                pic.winHeight = this.buffer.getWord(index + 8);
            }
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private Bitmap decodeImage(SubPictureBD pic, int transIdx) throws CoreException {
        int w = pic.getImageWidth();
        int h = pic.getImageHeight();
        ImageObjectFragment info = pic.getImgObj().fragmentList.get(0);
        long startOfs = info.imageBufferOfs;
        if (w > pic.width || h > pic.height) {
            throw new CoreException("Subpicture too large: " + w + "x" + h + " at offset " + ToolBox.hex(startOfs, 8));
        }
        Bitmap bm = new Bitmap(w, h, transIdx);
        int index = 0;
        int ofs = 0;
        int size = 0;
        int xpos = 0;
        try {
            byte[] buf = new byte[pic.getImgObj().bufferSize];
            index = 0;
            int p = 0;
            while (p < pic.getImgObj().fragmentList.size()) {
                info = pic.getImgObj().fragmentList.get(p);
                int i = 0;
                while (i < info.imagePacketSize) {
                    buf[index + i] = (byte)this.buffer.getByte(info.imageBufferOfs + (long)i);
                    ++i;
                }
                index += info.imagePacketSize;
                ++p;
            }
            index = 0;
            do {
                int b;
                if ((b = buf[index++] & 0xFF) == 0) {
                    int i;
                    if ((b = buf[index++] & 0xFF) == 0) {
                        ofs = ofs / w * w;
                        if (xpos < w) {
                            ofs += w;
                        }
                        xpos = 0;
                        continue;
                    }
                    if ((b & 0xC0) == 64) {
                        size = (b - 64 << 8) + (buf[index++] & 0xFF);
                        i = 0;
                        while (i < size) {
                            bm.getImg()[ofs++] = 0;
                            ++i;
                        }
                        xpos += size;
                        continue;
                    }
                    if ((b & 0xC0) == 128) {
                        size = b - 128;
                        b = buf[index++] & 0xFF;
                        i = 0;
                        while (i < size) {
                            bm.getImg()[ofs++] = (byte)b;
                            ++i;
                        }
                        xpos += size;
                        continue;
                    }
                    if ((b & 0xC0) != 0) {
                        size = (b - 192 << 8) + (buf[index++] & 0xFF);
                        b = buf[index++] & 0xFF;
                        i = 0;
                        while (i < size) {
                            bm.getImg()[ofs++] = (byte)b;
                            ++i;
                        }
                        xpos += size;
                        continue;
                    }
                    i = 0;
                    while (i < b) {
                        bm.getImg()[ofs++] = 0;
                        ++i;
                    }
                    xpos += b;
                    continue;
                }
                bm.getImg()[ofs++] = (byte)b;
                ++xpos;
            } while (index < buf.length);
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Core.printWarn("problems during RLE decoding of picture OBJ at offset " + ToolBox.hex(startOfs + (long)index, 8) + "\n");
            return bm;
        }
    }

    private boolean parseODS(SupSegment segment, SubPictureBD pic, String[] msg) throws CoreException {
        ImageObject imgObj;
        boolean last;
        boolean first;
        int objVer;
        int objID;
        int index;
        block7: {
            block8: {
                index = segment.offset;
                try {
                    objID = this.buffer.getWord(index);
                    objVer = this.buffer.getByte(index + 1);
                    int objSeq = this.buffer.getByte(index + 3);
                    first = (objSeq & 0x80) == 128;
                    boolean bl = last = (objSeq & 0x40) == 64;
                    if (pic.imageObjectList == null) {
                        pic.imageObjectList = new ArrayList();
                    }
                    if (objID >= pic.imageObjectList.size()) {
                        imgObj = new ImageObject();
                        pic.imageObjectList.add(imgObj);
                    } else {
                        imgObj = pic.getImgObj(objID);
                    }
                    if (imgObj.fragmentList != null && !first) break block7;
                    int width = this.buffer.getWord(index + 7);
                    int height = this.buffer.getWord(index + 9);
                    if (width > pic.width || height > pic.height) break block8;
                    imgObj.fragmentList = new ArrayList();
                    ImageObjectFragment info = new ImageObjectFragment();
                    info.imageBufferOfs = index + 11;
                    info.imagePacketSize = segment.size - (index + 11 - segment.offset);
                    imgObj.fragmentList.add(info);
                    imgObj.bufferSize = info.imagePacketSize;
                    imgObj.height = height;
                    imgObj.width = width;
                    msg[0] = "ID: " + objID + ", update: " + objVer + ", seq: " + (first ? "first" : "") + (first && last ? "/" : "") + (last ? "last" : "");
                    return true;
                }
                catch (FileBufferException ex) {
                    throw new CoreException(ex.getMessage());
                }
            }
            Core.printWarn("Invalid image size - ignored\n");
            return false;
        }
        ImageObjectFragment info = new ImageObjectFragment();
        info.imageBufferOfs = index + 4;
        info.imagePacketSize = segment.size - (index + 4 - segment.offset);
        imgObj.fragmentList.add(info);
        imgObj.bufferSize += info.imagePacketSize;
        msg[0] = "ID: " + objID + ", update: " + objVer + ", seq: " + (first ? "first" : "") + (first && last ? "/" : "") + (last ? "last" : "");
        return false;
    }

    private Palette decodePalette(SubPictureBD pic) throws CoreException {
        boolean fadeOut = false;
        int palIndex = 0;
        ArrayList<PaletteInfo> pl = pic.palettes.get(pic.getImgObj().paletteID);
        if (pl == null) {
            throw new CoreException("Palette ID out of bounds.");
        }
        Palette palette = new Palette(256, Core.usesBT601());
        try {
            int j = 0;
            while (j < pl.size()) {
                PaletteInfo p = pl.get(j);
                int index = p.paletteOfs;
                int i = 0;
                while (i < p.paletteSize) {
                    int cr;
                    int cb;
                    palIndex = this.buffer.getByte(index);
                    int y = this.buffer.getByte(++index);
                    if (Core.getSwapCrCb()) {
                        cb = this.buffer.getByte(++index);
                        cr = this.buffer.getByte(++index);
                    } else {
                        cr = this.buffer.getByte(++index);
                        cb = this.buffer.getByte(++index);
                    }
                    int alpha = this.buffer.getByte(++index);
                    int alphaOld = palette.getAlpha(palIndex);
                    if (alpha >= alphaOld) {
                        if (alpha < Core.getAlphaCrop()) {
                            y = 16;
                            cr = 128;
                            cb = 128;
                        }
                        palette.setAlpha(palIndex, alpha);
                    } else {
                        fadeOut = true;
                    }
                    palette.setYCbCr(palIndex, y, cb, cr);
                    ++index;
                    ++i;
                }
                ++j;
            }
            if (fadeOut) {
                Core.printWarn("fade out detected -> patched palette\n");
            }
            return palette;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private int parsePDS(SupSegment segment, SubPictureBD pic, String[] msg) throws CoreException {
        int paletteUpdate;
        int paletteID;
        int index;
        block6: {
            index = segment.offset;
            try {
                paletteID = this.buffer.getByte(index);
                paletteUpdate = this.buffer.getByte(index + 1);
                if (pic.palettes == null) {
                    pic.palettes = new ArrayList();
                    int i = 0;
                    while (i < 8) {
                        pic.palettes.add(new ArrayList());
                        ++i;
                    }
                }
                if (paletteID <= 7) break block6;
                msg[0] = "Illegal palette id at offset " + ToolBox.hex(index, 8);
                return -1;
            }
            catch (FileBufferException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        ArrayList<PaletteInfo> al = pic.palettes.get(paletteID);
        if (al == null) {
            al = new ArrayList();
        }
        PaletteInfo p = new PaletteInfo();
        p.paletteSize = (segment.size - 2) / 5;
        p.paletteOfs = index + 2;
        al.add(p);
        msg[0] = "ID: " + paletteID + ", update: " + paletteUpdate + ", " + p.paletteSize + " entries";
        return p.paletteSize;
    }

    private void decode(SubPictureBD pic) throws CoreException {
        this.palette = this.decodePalette(pic);
        this.bitmap = this.decodeImage(pic, this.palette.getTransparentIndex());
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette, Core.getAlphaThr());
    }

    @Override
    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette);
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette);
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public int getNumFrames() {
        return this.subPictures.size();
    }

    @Override
    public int getNumForcedFrames() {
        return this.numForcedFrames;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get((int)index).endTime;
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get((int)index).startTime;
    }

    @Override
    public boolean isForced(int index) {
        return this.subPictures.get((int)index).isforced;
    }

    @Override
    public long getStartOffset(int index) {
        SubPictureBD pic = this.subPictures.get(index);
        return pic.getImgObj().fragmentList.get((int)0).imageBufferOfs;
    }

    double getFps(int index) {
        return SupBD.getFpsFromID(this.subPictures.get((int)index).type);
    }

    private static enum CompositionState {
        NORMAL,
        ACQU_POINT,
        EPOCH_START,
        EPOCH_CONTINUE,
        INVALID;

    }
}

