/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.BitmapBounds;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.ImageObjectFragment;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureDVD;
import deadbeef.SupTools.Substream;
import deadbeef.SupTools.SubstreamDVD;
import deadbeef.Tools.FileBuffer;
import deadbeef.Tools.FileBufferException;
import deadbeef.Tools.ToolBox;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

class SubDVD
implements Substream,
SubstreamDVD {
    private static final byte[] packHeader;
    private static byte[] headerFirst;
    private static byte[] headerNext;
    private static byte[] controlHeader;
    private final ArrayList<SubPictureDVD> subPictures;
    private Palette srcPalette = new Palette(Core.getDefaultDVDPalette());
    private Palette palette;
    private Bitmap bitmap;
    private int screenWidth = 720;
    private int screenHeight = 576;
    private int ofsXglob = 0;
    private int ofsYglob = 0;
    private int delayGlob = 0;
    private int languageIdx = 0;
    private int streamID;
    private final FileBuffer buffer;
    private int primaryColorIndex;
    private int numForcedFrames;
    private static int[] lastAlpha;

    static {
        byte[] byArray = new byte[14];
        byArray[2] = 1;
        byArray[3] = -70;
        byArray[4] = 68;
        byArray[5] = 2;
        byArray[6] = -60;
        byArray[7] = -126;
        byArray[8] = 4;
        byArray[9] = -87;
        byArray[10] = 1;
        byArray[11] = -119;
        byArray[12] = -61;
        byArray[13] = -8;
        packHeader = byArray;
        byte[] byArray2 = new byte[19];
        byArray2[2] = 1;
        byArray2[3] = -67;
        byArray2[6] = -127;
        byArray2[7] = -128;
        byArray2[8] = 5;
        byArray2[14] = 32;
        headerFirst = byArray2;
        byte[] byArray3 = new byte[10];
        byArray3[2] = 1;
        byArray3[3] = -67;
        byArray3[6] = -127;
        byArray3[9] = 32;
        headerNext = byArray3;
        byte[] byArray4 = new byte[29];
        byArray4[3] = 1;
        byArray4[4] = 3;
        byArray4[5] = 50;
        byArray4[6] = 16;
        byArray4[7] = 4;
        byArray4[8] = -1;
        byArray4[9] = -1;
        byArray4[10] = 5;
        byArray4[17] = 6;
        byArray4[22] = -1;
        byArray4[27] = 2;
        byArray4[28] = -1;
        controlHeader = byArray4;
        int[] nArray = new int[4];
        nArray[1] = 15;
        nArray[2] = 15;
        nArray[3] = 15;
        lastAlpha = nArray;
    }

    SubDVD(String fnSub, String fnIdx) throws CoreException {
        this.subPictures = new ArrayList();
        this.readIdx(fnIdx);
        Core.setProgressMax(this.subPictures.size());
        try {
            this.buffer = new FileBuffer(fnSub);
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
        int i = 0;
        while (i < this.subPictures.size()) {
            Core.setProgress(i);
            Core.printX("# " + (i + 1) + "\n");
            Core.print("Ofs: " + ToolBox.hex(this.subPictures.get((int)i).offset, 8) + "\n");
            long nextOfs = i < this.subPictures.size() - 1 ? this.subPictures.get((int)(i + 1)).offset : this.buffer.getSize();
            this.readSubFrame(this.subPictures.get(i), nextOfs, this.buffer);
            ++i;
        }
        Core.printX("\nDetected " + this.numForcedFrames + " forced captions.\n");
    }

    static void decodeLine(byte[] src, int srcOfs, int srcLen, byte[] trg, int trgOfs, int width, int maxPixels) {
        int b;
        byte[] nibbles = new byte[srcLen * 2];
        int i = 0;
        while (i < srcLen) {
            b = src[srcOfs + i] & 0xFF;
            nibbles[2 * i] = (byte)(b >> 4);
            nibbles[2 * i + 1] = (byte)(b & 0xF);
            ++i;
        }
        int index = 0;
        int sumPixels = 0;
        int x = 0;
        while (index < nibbles.length && sumPixels < maxPixels) {
            int len;
            if ((b = nibbles[index++] & 0xFF) == 0) {
                if (((b = nibbles[index++] & 0xFF) & 0xC) != 0) {
                    len = b << 2;
                    b = nibbles[index++] & 0xFF;
                    len |= b >> 2;
                } else {
                    len = b << 6;
                    b = nibbles[index++] & 0xFF;
                    len |= b << 2;
                    if ((len |= (b = nibbles[index++] & 0xFF) >> 2) == 0) {
                        len = width - x;
                        if (len <= 0 || sumPixels >= maxPixels) {
                            len = 0;
                            sumPixels = (trgOfs += 2 * width) / width / 2 * width;
                            x = 0;
                        }
                        if ((index & 1) == 1) {
                            ++index;
                        }
                    }
                }
            } else {
                len = b >> 2;
                if (len == 0) {
                    len = b << 2;
                    b = nibbles[index++] & 0xFF;
                    len |= b >> 2;
                }
            }
            int col = b & 3;
            sumPixels += len;
            int i2 = 0;
            while (i2 < len) {
                trg[trgOfs + x] = (byte)col;
                if (++x >= width) {
                    trgOfs += 2 * width;
                    x = 0;
                    if ((index & 1) == 1) {
                        ++index;
                    }
                }
                ++i2;
            }
        }
    }

    static byte[] encodeLines(Bitmap bm, boolean even) {
        int ofs = 0;
        ArrayList<Byte> nibbles = new ArrayList<Byte>();
        int y = even ? 0 : 1;
        while (y < bm.getHeight()) {
            ofs = y * bm.getWidth();
            int x = 0;
            while (x < bm.getWidth()) {
                byte color = bm.getImg()[ofs];
                int len = 1;
                while (x + len < bm.getWidth()) {
                    if (bm.getImg()[ofs + len] != color) break;
                    ++len;
                }
                if (len < 4) {
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (len < 16) {
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (len < 64) {
                    nibbles.add((byte)0);
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                } else if (x + len == bm.getWidth()) {
                    nibbles.add((byte)0);
                    nibbles.add((byte)0);
                    nibbles.add((byte)0);
                    nibbles.add(color);
                } else {
                    if (len > 255) {
                        len = 255;
                    }
                    nibbles.add((byte)0);
                    nibbles.add((byte)(len >> 6));
                    nibbles.add((byte)(len >> 2));
                    nibbles.add((byte)(len << 2 | color & 3));
                }
                x += len;
                ofs += len;
            }
            if ((nibbles.size() & 1) == 1) {
                nibbles.add((byte)0);
            }
            y += 2;
        }
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        nibbles.add((byte)0);
        int size = nibbles.size() / 2;
        byte[] retval = new byte[size];
        Iterator it = nibbles.iterator();
        int i = 0;
        while (i < size) {
            int hi = (Byte)it.next() & 0xF;
            int lo = (Byte)it.next() & 0xF;
            retval[i] = (byte)(hi << 4 | lo);
            ++i;
        }
        return retval;
    }

    static byte[] createSubFrame(SubPictureDVD pic, Bitmap bm) {
        int controlHeaderLen;
        int forcedOfs;
        byte[] even = SubDVD.encodeLines(bm, true);
        byte[] odd = SubDVD.encodeLines(bm, false);
        if (pic.isforced) {
            forcedOfs = 0;
            SubDVD.controlHeader[2] = 1;
            SubDVD.controlHeader[3] = 0;
            controlHeaderLen = controlHeader.length;
        } else {
            forcedOfs = 1;
            SubDVD.controlHeader[2] = 0;
            SubDVD.controlHeader[3] = 1;
            controlHeaderLen = controlHeader.length - 1;
        }
        int ptm = (int)pic.startTime;
        SubDVD.headerFirst[9] = (byte)(ptm >> 29 & 0xE | 0x21);
        SubDVD.headerFirst[10] = (byte)(ptm >> 22);
        SubDVD.headerFirst[11] = (byte)(ptm >> 14 | 1);
        SubDVD.headerFirst[12] = (byte)(ptm >> 7);
        SubDVD.headerFirst[13] = (byte)(ptm * 2 + 1);
        SubDVD.controlHeader[5] = (byte)((pic.pal[3] & 0xF) << 4 | pic.pal[2] & 0xF);
        SubDVD.controlHeader[6] = (byte)((pic.pal[1] & 0xF) << 4 | pic.pal[0] & 0xF);
        SubDVD.controlHeader[8] = (byte)((pic.alpha[3] & 0xF) << 4 | pic.alpha[2] & 0xF);
        SubDVD.controlHeader[9] = (byte)((pic.alpha[1] & 0xF) << 4 | pic.alpha[0] & 0xF);
        SubDVD.controlHeader[11] = (byte)(pic.getOfsX() >> 4 & 0xFF);
        int tmp = pic.getOfsX() + bm.getWidth() - 1;
        SubDVD.controlHeader[12] = (byte)((pic.getOfsX() & 0xF) << 4 | tmp >> 8 & 0xF);
        SubDVD.controlHeader[13] = (byte)(tmp & 0xFF);
        int yOfs = pic.getOfsY() - Core.getCropOfsY();
        if (yOfs < 0) {
            yOfs = 0;
        } else {
            int yMax = pic.height - pic.getImageHeight() - 2 * Core.getCropOfsY();
            if (yOfs > yMax) {
                yOfs = yMax;
            }
        }
        SubDVD.controlHeader[14] = (byte)(yOfs >> 4 & 0xFF);
        tmp = yOfs + bm.getHeight() - 1;
        SubDVD.controlHeader[15] = (byte)((yOfs & 0xF) << 4 | tmp >> 8 & 0xF);
        SubDVD.controlHeader[16] = (byte)(tmp & 0xFF);
        SubDVD.controlHeader[18] = 0;
        SubDVD.controlHeader[19] = 4;
        tmp = even.length + controlHeader[19];
        SubDVD.controlHeader[20] = (byte)(tmp >> 8 & 0xFF);
        SubDVD.controlHeader[21] = (byte)(tmp & 0xFF);
        tmp = (int)((pic.endTime - pic.startTime) / 1024L);
        SubDVD.controlHeader[23] = (byte)(tmp >> 8 & 0xFF);
        SubDVD.controlHeader[24] = (byte)(tmp & 0xFF);
        tmp = even.length + odd.length + 22 + (pic.isforced ? 1 : 0) + 4;
        SubDVD.controlHeader[forcedOfs + 0] = (byte)(tmp >> 8 & 0xFF);
        SubDVD.controlHeader[forcedOfs + 1] = (byte)(tmp & 0xFF);
        SubDVD.controlHeader[25] = (byte)(tmp >> 8 & 0xFF);
        SubDVD.controlHeader[26] = (byte)(tmp & 0xFF);
        tmp = even.length + odd.length + 4 + controlHeaderLen;
        SubDVD.headerFirst[15] = (byte)(tmp >> 8);
        SubDVD.headerFirst[16] = (byte)tmp;
        tmp = even.length + odd.length + 2;
        SubDVD.headerFirst[17] = (byte)(tmp >> 8);
        SubDVD.headerFirst[18] = (byte)tmp;
        int sizeRLE = even.length + odd.length;
        int bufSize = packHeader.length + headerFirst.length + controlHeaderLen + sizeRLE;
        int numAdditionalPackets = 0;
        if (bufSize > 2048) {
            numAdditionalPackets = 1;
            int remainingRLEsize = sizeRLE - (2048 - packHeader.length - headerFirst.length);
            while (remainingRLEsize > 2048 - packHeader.length - headerNext.length - controlHeaderLen) {
                remainingRLEsize -= 2048 - packHeader.length - headerNext.length;
                bufSize += packHeader.length + headerNext.length;
                ++numAdditionalPackets;
            }
            tmp = 2048 - packHeader.length - 6;
        } else {
            tmp = bufSize - packHeader.length - 6;
        }
        byte[] buf = new byte[(1 + numAdditionalPackets) * 2048];
        int diff = buf.length - bufSize;
        int stuffingBytes = diff > 0 && diff < 6 ? diff : 0;
        int ofs = 0;
        int i = 0;
        while (i < packHeader.length) {
            buf[ofs++] = packHeader[i];
            ++i;
        }
        SubDVD.headerFirst[4] = (byte)((tmp += stuffingBytes) >> 8);
        SubDVD.headerFirst[5] = (byte)tmp;
        SubDVD.headerFirst[8] = (byte)(5 + stuffingBytes);
        i = 0;
        while (i < 14) {
            buf[ofs++] = headerFirst[i];
            ++i;
        }
        i = 0;
        while (i < stuffingBytes) {
            buf[ofs++] = -1;
            ++i;
        }
        i = 14;
        while (i < headerFirst.length) {
            buf[ofs++] = headerFirst[i];
            ++i;
        }
        tmp = sizeRLE;
        if (numAdditionalPackets > 0 && (tmp = 2048 - packHeader.length - stuffingBytes - headerFirst.length) > sizeRLE) {
            tmp = sizeRLE;
        }
        i = 0;
        while (i < tmp) {
            buf[ofs++] = i < even.length ? even[i] : odd[i - even.length];
            ++i;
        }
        int ofsRLE = tmp;
        int controlHeaderWritten = 0;
        if (numAdditionalPackets == 1 && ofs < 2048) {
            while (ofs < 2048) {
                buf[ofs] = controlHeader[forcedOfs + controlHeaderWritten++];
                ++ofs;
            }
        }
        int p = 0;
        while (p < numAdditionalPackets) {
            int rleSizeLeft;
            if (p == numAdditionalPackets - 1) {
                rleSizeLeft = sizeRLE - ofsRLE;
                tmp = headerNext.length + (controlHeaderLen - controlHeaderWritten) + (sizeRLE - ofsRLE) - 6;
            } else {
                tmp = 2048 - packHeader.length - 6;
                rleSizeLeft = 2048 - packHeader.length - headerNext.length;
                if (rleSizeLeft > sizeRLE - ofsRLE) {
                    rleSizeLeft = sizeRLE - ofsRLE;
                }
            }
            SubDVD.packHeader[13] = -8;
            int i2 = 0;
            while (i2 < packHeader.length) {
                buf[ofs++] = packHeader[i2];
                ++i2;
            }
            SubDVD.headerNext[4] = (byte)(tmp >> 8);
            SubDVD.headerNext[5] = (byte)tmp;
            i2 = 0;
            while (i2 < headerNext.length) {
                buf[ofs++] = headerNext[i2];
                ++i2;
            }
            i2 = ofsRLE;
            while (i2 < ofsRLE + rleSizeLeft) {
                buf[ofs++] = i2 < even.length ? even[i2] : odd[i2 - even.length];
                ++i2;
            }
            ofsRLE += rleSizeLeft;
            if (p != numAdditionalPackets - 1) {
                while (ofs < (p + 2) * 2048) {
                    buf[ofs] = controlHeader[forcedOfs + controlHeaderWritten++];
                    ++ofs;
                }
            }
            ++p;
        }
        int i3 = controlHeaderWritten;
        while (i3 < controlHeaderLen) {
            buf[ofs++] = controlHeader[forcedOfs + i3];
            ++i3;
        }
        diff = buf.length - ofs;
        if (diff >= 6) {
            buf[ofs++] = 0;
            buf[ofs++] = 0;
            buf[ofs++] = 1;
            buf[ofs++] = -66;
            buf[ofs++] = (byte)((diff -= 6) >> 8);
            buf[ofs++] = (byte)diff;
            while (ofs < buf.length) {
                buf[ofs] = -1;
                ++ofs;
            }
        }
        return buf;
    }

    void readIdx(String fname) throws CoreException {
        BufferedReader in = null;
        try {
            try {
                String s;
                in = new BufferedReader(new FileReader(fname));
                int langIdx = 0;
                boolean ignore = false;
                while ((s = in.readLine()) != null) {
                    int v;
                    if ((s = ToolBox.trim(s)).length() < 1 || s.charAt(0) == '#') continue;
                    int pos = s.indexOf(58);
                    if (pos == -1 || s.length() - pos <= 1) {
                        Core.printErr("Illegal key: " + s + "\n");
                        continue;
                    }
                    String key = ToolBox.trim(s.substring(0, pos));
                    String val = ToolBox.trim(s.substring(pos + 1));
                    if (key.equalsIgnoreCase("size")) {
                        pos = val.indexOf(120);
                        if (pos == -1 || val.length() - pos <= 1) {
                            throw new CoreException("Illegal size: " + val);
                        }
                        v = ToolBox.getInt(val.substring(0, pos));
                        if (v < 2) {
                            throw new CoreException("Illegal screen width: " + v);
                        }
                        this.screenWidth = v;
                        v = ToolBox.getInt(val.substring(pos + 1));
                        if (v < 2) {
                            throw new CoreException("Illegal screen height: " + v);
                        }
                        this.screenHeight = v;
                        continue;
                    }
                    if (key.equalsIgnoreCase("org")) {
                        pos = val.indexOf(44);
                        if (pos == -1 || val.length() - pos <= 1) {
                            throw new CoreException("Illegal origin: " + val);
                        }
                        v = ToolBox.getInt(val.substring(0, pos));
                        if (v < 0) {
                            throw new CoreException("Illegal x origin: " + v);
                        }
                        this.ofsXglob = v;
                        v = ToolBox.getInt(val.substring(pos + 1));
                        if (v < 0) {
                            throw new CoreException("Illegal y origin: " + v);
                        }
                        this.ofsYglob = v;
                        continue;
                    }
                    if (key.equalsIgnoreCase("scale") || key.equalsIgnoreCase("alpha") || key.equalsIgnoreCase("smooth") || key.equalsIgnoreCase("fadein/out") || key.equalsIgnoreCase("align")) continue;
                    if (key.equalsIgnoreCase("time offset")) {
                        v = ToolBox.getInt(val);
                        if (v < 0) {
                            v = (int)ToolBox.timeStrToPTS(val);
                        }
                        if (v < 0) {
                            throw new CoreException("Illegal time offset: " + v);
                        }
                        this.delayGlob = v * 90;
                        continue;
                    }
                    if (key.equalsIgnoreCase("align")) continue;
                    if (key.equalsIgnoreCase("palette")) {
                        String[] vals = val.split(",");
                        if (vals == null || vals.length < 1 || vals.length > 16) {
                            throw new CoreException("Illegal palette definition: " + val);
                        }
                        int i = 0;
                        while (i < vals.length) {
                            int color = -1;
                            try {
                                color = Integer.parseInt(ToolBox.trim(vals[i]), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (color == -1) {
                                throw new CoreException("Illegal palette entry: " + vals[i]);
                            }
                            this.srcPalette.setARGB(i, color);
                            ++i;
                        }
                        continue;
                    }
                    if (key.equalsIgnoreCase("custom colors")) continue;
                    if (key.equalsIgnoreCase("langidx")) {
                        v = ToolBox.getInt(val);
                        if (v < 0) {
                            throw new CoreException("Illegal language idx: " + v);
                        }
                        langIdx = v;
                        continue;
                    }
                    if (key.equalsIgnoreCase("id")) {
                        pos = val.indexOf(44);
                        String id = pos > 0 ? ToolBox.trim(val.substring(0, pos)) : val;
                        if (id.length() != 2) {
                            Core.printWarn("Illegal language id: " + id + "\n");
                            continue;
                        }
                        boolean found = false;
                        int i = 0;
                        while (i < Core.getLanguages().length) {
                            if (id.equalsIgnoreCase(Core.getLanguages()[i][1])) {
                                this.languageIdx = i;
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            Core.printWarn("Illegal language id: " + id + "\n");
                        }
                        if ((pos = val.indexOf(58)) == -1 || s.length() - pos <= 1) {
                            Core.printErr("Missing index key: " + val + "\n");
                            continue;
                        }
                        key = ToolBox.trim(val.substring(0, pos));
                        val = ToolBox.trim(val.substring(pos + 1));
                        if (key.equalsIgnoreCase("index")) {
                            Core.printErr("Missing index key: " + s + "\n");
                            continue;
                        }
                        v = ToolBox.getInt(val);
                        if (v < 0) {
                            throw new CoreException("Illegal language index: " + v);
                        }
                        if (v != langIdx) {
                            ignore = true;
                            Core.printWarn("Language id " + id + "(index:" + v + ") inactive -> ignored\n");
                            continue;
                        }
                        this.streamID = v;
                        ignore = false;
                        continue;
                    }
                    if (ignore || !key.equalsIgnoreCase("timestamp")) continue;
                    pos = val.indexOf(44);
                    if (pos == -1 || val.length() - pos <= 1) {
                        throw new CoreException("Illegal timestamp entry: " + val);
                    }
                    String vs = val.substring(0, pos);
                    long t = ToolBox.timeStrToPTS(vs);
                    if (t < 0L) {
                        throw new CoreException("Illegal timestamp: " + vs);
                    }
                    vs = val.substring(pos + 1).toLowerCase();
                    if ((pos = vs.indexOf("filepos:")) == -1 || vs.length() - pos <= 1) {
                        throw new CoreException("Missing filepos: " + val);
                    }
                    long l = Long.parseLong(ToolBox.trim(vs.substring(pos + 8)), 16);
                    if (l == -1L) {
                        throw new CoreException("Illegal filepos: " + vs.substring(pos + 8));
                    }
                    SubPictureDVD pic = new SubPictureDVD();
                    pic.offset = l;
                    pic.width = this.screenWidth;
                    pic.height = this.screenHeight;
                    pic.startTime = t + (long)this.delayGlob;
                    this.subPictures.add(pic);
                }
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static Palette decodePalette(SubPictureDVD pic, Palette pal) {
        Palette miniPal = new Palette(4, true);
        int i = 0;
        while (i < 4) {
            int a = pic.alpha[i] * 255 / 15;
            if (a >= Core.getAlphaCrop()) {
                miniPal.setRGB(i, pal.getR()[pic.pal[i]] & 0xFF, pal.getG()[pic.pal[i]] & 0xFF, pal.getB()[pic.pal[i]] & 0xFF);
                miniPal.setAlpha(i, a);
            } else {
                miniPal.setARGB(i, 0);
            }
            ++i;
        }
        return miniPal;
    }

    static Bitmap decodeImage(SubPictureDVD pic, FileBuffer fBuf, int transIdx) throws CoreException {
        int sizeOdd;
        int sizeEven;
        int w = pic.originalWidth;
        int h = pic.originalHeight;
        int warnings = 0;
        ImageObjectFragment info = pic.rleFragments.get(0);
        long startOfs = info.imageBufferOfs;
        if (w > pic.width || h > pic.height) {
            Core.printWarn("Subpicture too large: " + w + "x" + h + " at offset " + ToolBox.hex(startOfs, 8) + "\n");
        }
        Bitmap bm = new Bitmap(w, h, transIdx);
        byte[] buf = new byte[pic.rleSize];
        int index = 0;
        if (pic.oddOfs > pic.evenOfs) {
            sizeEven = pic.oddOfs - pic.evenOfs;
            sizeOdd = pic.rleSize - pic.oddOfs;
        } else {
            sizeOdd = pic.evenOfs - pic.oddOfs;
            sizeEven = pic.rleSize - pic.evenOfs;
        }
        if (sizeEven <= 0 || sizeOdd <= 0) {
            throw new CoreException("Corrupt buffer offset information");
        }
        try {
            try {
                int p = 0;
                while (p < pic.rleFragments.size()) {
                    info = pic.rleFragments.get(p);
                    int i = 0;
                    while (i < info.imagePacketSize) {
                        buf[index + i] = (byte)fBuf.getByte(info.imageBufferOfs + (long)i);
                        ++i;
                    }
                    index += info.imagePacketSize;
                    ++p;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                SubDVD.decodeLine(buf, pic.evenOfs, sizeEven, bm.getImg(), 0, w, w * (h / 2 + (h & 1)));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                SubDVD.decodeLine(buf, pic.oddOfs, sizeOdd, bm.getImg(), w, w, h / 2 * w);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            if (warnings > 0) {
                Core.printWarn("problems during RLE decoding of picture at offset " + ToolBox.hex(startOfs, 8) + "\n");
            }
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    void readSubFrame(SubPictureDVD pic, long endOfs, FileBuffer buffer) throws CoreException {
        int i;
        long ofs = pic.offset;
        long ctrlOfs = -1L;
        int ctrlOfsRel = 0;
        int rleSize = 0;
        int rleBufferFound = 0;
        int ctrlSize = -1;
        int ctrlHeaderCopied = 0;
        byte[] ctrlHeader = null;
        boolean firstPackFound = false;
        try {
            do {
                int packetStreamID;
                int stuffOfs;
                long startOfs = ofs;
                if (buffer.getDWord(ofs) != 442) {
                    throw new CoreException("Missing packet identifier at ofs " + ToolBox.hex(ofs, 8));
                }
                ofs += 13L;
                if (buffer.getDWord(ofs += (long)(1 + (stuffOfs = buffer.getByte(ofs) & 7))) != 445) {
                    throw new CoreException("Missing packet identifier at ofs " + ToolBox.hex(ofs, 8));
                }
                int length = buffer.getWord(ofs += 4L);
                long nextOfs = ofs + 2L + (long)length;
                int packHeaderSize = (int)((ofs += 2L) - startOfs);
                boolean firstPack = (buffer.getByte(++ofs) & 0x80) == 128;
                int ptsLength = buffer.getByte(++ofs);
                ofs += (long)(1 + ptsLength);
                if ((packetStreamID = buffer.getByte(ofs++) & 0xF) != this.streamID) {
                    if (nextOfs % 2048L != 0L) {
                        ofs = (nextOfs / 2048L + 1L) * 2048L;
                        Core.printWarn("Offset to next fragment is invalid. Fixed to:" + ToolBox.hex(ofs, 8) + "\n");
                    } else {
                        ofs = nextOfs;
                    }
                    ctrlOfs += 2048L;
                    continue;
                }
                int headerSize = (int)(ofs - startOfs);
                if (firstPack && ptsLength >= 5) {
                    int size = buffer.getWord(ofs);
                    ctrlOfsRel = buffer.getWord(ofs += 2L);
                    rleSize = ctrlOfsRel - 2;
                    ctrlSize = size - ctrlOfsRel - 2;
                    if (ctrlSize < 0) {
                        throw new CoreException("Invalid control buffer size");
                    }
                    ctrlHeader = new byte[ctrlSize];
                    ctrlOfs = (long)ctrlOfsRel + ofs;
                    headerSize = (int)((ofs += 2L) - startOfs);
                    pic.rleFragments = new ArrayList();
                    firstPackFound = true;
                } else if (firstPackFound) {
                    ctrlOfs += (long)headerSize;
                } else {
                    Core.printWarn("Invalid fragment skipped at ofs " + ToolBox.hex(startOfs, 8) + "\n");
                }
                int diff = (int)(nextOfs - ctrlOfs - (long)ctrlHeaderCopied);
                if (diff < 0) {
                    diff = 0;
                }
                int copied = ctrlHeaderCopied;
                try {
                    i = 0;
                    while (i < diff && ctrlHeaderCopied < ctrlSize) {
                        ctrlHeader[ctrlHeaderCopied] = (byte)buffer.getByte(ctrlOfs + (long)i + (long)copied);
                        ++ctrlHeaderCopied;
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new CoreException("Inconsistent control buffer access (" + ex.getMessage() + ")");
                }
                ImageObjectFragment rleFrag = new ImageObjectFragment();
                rleFrag.imageBufferOfs = ofs;
                rleFrag.imagePacketSize = length - headerSize - diff + packHeaderSize;
                pic.rleFragments.add(rleFrag);
                rleBufferFound += rleFrag.imagePacketSize;
                if (ctrlHeaderCopied != ctrlSize && nextOfs % 2048L != 0L) {
                    ofs = (nextOfs / 2048L + 1L) * 2048L;
                    Core.printWarn("Offset to next fragment is invalid. Fixed to:" + ToolBox.hex(ofs, 8) + "\n");
                    rleBufferFound = (int)((long)rleBufferFound + (ofs - nextOfs));
                    continue;
                }
                ofs = nextOfs;
            } while (ofs < endOfs && ctrlHeaderCopied < ctrlSize);
            if (ctrlHeaderCopied != ctrlSize) {
                Core.printWarn("Control buffer size inconsistent.\n");
                int i2 = ctrlHeaderCopied;
                while (i2 < ctrlSize) {
                    ctrlHeader[i2] = -1;
                    ++i2;
                }
            }
            if (rleBufferFound != rleSize) {
                Core.printWarn("RLE buffer size inconsistent.\n");
            }
            pic.rleSize = rleBufferFound;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        pic.pal = new int[4];
        pic.alpha = new int[4];
        int alphaSum = 0;
        int[] alphaUpdate = new int[4];
        int delay = -1;
        boolean ColAlphaUpdate = false;
        Core.print("SP_DCSQT at ofs: " + ToolBox.hex(ctrlOfs, 8) + "\n");
        try {
            int index = 0;
            int endSeqOfs = ToolBox.getWord(ctrlHeader, index) - ctrlOfsRel - 2;
            if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                Core.printWarn("Invalid end sequence offset -> no end time\n");
                endSeqOfs = ctrlSize;
            }
            index += 2;
            block19: while (index < endSeqOfs) {
                int cmd = ToolBox.getByte(ctrlHeader, index++);
                switch (cmd) {
                    case 0: {
                        pic.isforced = true;
                        ++this.numForcedFrames;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 3: {
                        int b = ToolBox.getByte(ctrlHeader, index++);
                        pic.pal[3] = b >> 4;
                        pic.pal[2] = b & 0xF;
                        b = ToolBox.getByte(ctrlHeader, index++);
                        pic.pal[1] = b >> 4;
                        pic.pal[0] = b & 0xF;
                        Core.print("Palette:   " + pic.pal[0] + ", " + pic.pal[1] + ", " + pic.pal[2] + ", " + pic.pal[3] + "\n");
                        break;
                    }
                    case 4: {
                        int b = ToolBox.getByte(ctrlHeader, index++);
                        pic.alpha[3] = b >> 4;
                        pic.alpha[2] = b & 0xF;
                        b = ToolBox.getByte(ctrlHeader, index++);
                        pic.alpha[1] = b >> 4;
                        pic.alpha[0] = b & 0xF;
                        i = 0;
                        while (i < 4) {
                            alphaSum += pic.alpha[i] & 0xFF;
                            ++i;
                        }
                        Core.print("Alpha:     " + pic.alpha[0] + ", " + pic.alpha[1] + ", " + pic.alpha[2] + ", " + pic.alpha[3] + "\n");
                        break;
                    }
                    case 5: {
                        int xOfs = ToolBox.getByte(ctrlHeader, index) << 4 | ToolBox.getByte(ctrlHeader, index + 1) >> 4;
                        pic.setOfsX(this.ofsXglob + xOfs);
                        pic.setImageWidth(((ToolBox.getByte(ctrlHeader, index + 1) & 0xF) << 8 | ToolBox.getByte(ctrlHeader, index + 2)) - xOfs + 1);
                        int yOfs = ToolBox.getByte(ctrlHeader, index + 3) << 4 | ToolBox.getByte(ctrlHeader, index + 4) >> 4;
                        pic.setOfsY(this.ofsYglob + yOfs);
                        pic.setImageHeight(((ToolBox.getByte(ctrlHeader, index + 4) & 0xF) << 8 | ToolBox.getByte(ctrlHeader, index + 5)) - yOfs + 1);
                        Core.print("Area info: (" + pic.getOfsX() + ", " + pic.getOfsY() + ") - (" + (pic.getOfsX() + pic.getImageWidth() - 1) + ", " + (pic.getOfsY() + pic.getImageHeight() - 1) + ")\n");
                        index += 6;
                        break;
                    }
                    case 6: {
                        pic.evenOfs = ToolBox.getWord(ctrlHeader, index) - 4;
                        pic.oddOfs = ToolBox.getWord(ctrlHeader, index + 2) - 4;
                        index += 4;
                        Core.print("RLE ofs:   " + ToolBox.hex(pic.evenOfs, 4) + ", " + ToolBox.hex(pic.oddOfs, 4) + "\n");
                        break;
                    }
                    case 7: {
                        ColAlphaUpdate = true;
                        int alphaUpdateSum = 0;
                        int b = ToolBox.getByte(ctrlHeader, index + 10);
                        alphaUpdate[3] = b >> 4;
                        alphaUpdate[2] = b & 0xF;
                        b = ToolBox.getByte(ctrlHeader, index + 11);
                        alphaUpdate[1] = b >> 4;
                        alphaUpdate[0] = b & 0xF;
                        int i3 = 0;
                        while (i3 < 4) {
                            alphaUpdateSum += alphaUpdate[i3] & 0xFF;
                            ++i3;
                        }
                        if (alphaUpdateSum > alphaSum) {
                            alphaSum = alphaUpdateSum;
                            i3 = 0;
                            while (i3 < 4) {
                                pic.alpha[i3] = alphaUpdate[i3];
                                ++i3;
                            }
                            b = ToolBox.getByte(ctrlHeader, index + 8);
                            pic.pal[3] = b >> 4;
                            pic.pal[2] = b & 0xF;
                            b = ToolBox.getByte(ctrlHeader, index + 9);
                            pic.pal[1] = b >> 4;
                            pic.pal[0] = b & 0xF;
                        }
                        index = endSeqOfs;
                        delay = ToolBox.getWord(ctrlHeader, index) * 1024;
                        endSeqOfs = ToolBox.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                        if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                            Core.printWarn("Invalid end sequence offset -> no end time\n");
                            endSeqOfs = ctrlSize;
                        }
                        index += 4;
                        break;
                    }
                    case 255: {
                        break block19;
                    }
                    default: {
                        Core.printWarn("Unknown control sequence " + ToolBox.hex(cmd, 2) + " skipped\n");
                    }
                }
            }
            if (endSeqOfs != ctrlSize) {
                index = endSeqOfs;
                delay = ToolBox.getWord(ctrlHeader, index) * 1024;
                pic.endTime = pic.startTime + (long)delay;
            } else {
                pic.endTime = pic.startTime;
            }
            if (ColAlphaUpdate) {
                Core.printWarn("Palette update/alpha fading detected - result may be erratic.\n");
            }
            if (alphaSum == 0) {
                if (Core.getFixZeroAlpha()) {
                    int i4 = 0;
                    while (i4 < 4) {
                        pic.alpha[i4] = lastAlpha[i4];
                        ++i4;
                    }
                    Core.printWarn("Invisible caption due to zero alpha - used alpha info of last caption.\n");
                } else {
                    Core.printWarn("Invisible caption due to zero alpha (not fixed due to user setting).\n");
                }
            }
            lastAlpha = pic.alpha;
            pic.setOriginal();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new CoreException("Index " + ex.getMessage() + " out of bounds in control header.");
        }
    }

    static void writeIdx(String fname, SubPicture pic, int[] offsets, int[] timestamps, Palette pal) throws CoreException {
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new FileWriter(fname));
                out.write("# VobSub index file, v7 (do not modify this line!)");
                out.newLine();
                out.write("# Created by BDSup2Sub 4.0.0");
                out.newLine();
                out.newLine();
                out.write("# Frame size");
                out.newLine();
                out.write("size: " + pic.width + "x" + (pic.height - 2 * Core.getCropOfsY()));
                out.newLine();
                out.newLine();
                out.write("# Origin - upper-left corner");
                out.newLine();
                out.write("org: 0, 0");
                out.newLine();
                out.newLine();
                out.write("# Scaling");
                out.newLine();
                out.write("scale: 100%, 100%");
                out.newLine();
                out.newLine();
                out.write("# Alpha blending");
                out.newLine();
                out.write("alpha: 100%");
                out.newLine();
                out.newLine();
                out.write("# Smoothing");
                out.newLine();
                out.write("smooth: OFF");
                out.newLine();
                out.newLine();
                out.write("# Fade in/out in milliseconds");
                out.newLine();
                out.write("fadein/out: 0, 0");
                out.newLine();
                out.newLine();
                out.write("# Force subtitle placement relative to (org.x, org.y)");
                out.newLine();
                out.write("align: OFF at LEFT TOP");
                out.newLine();
                out.newLine();
                out.write("# For correcting non-progressive desync. (in millisecs or hh:mm:ss:ms)");
                out.newLine();
                out.write("time offset: 0");
                out.newLine();
                out.newLine();
                out.write("# ON: displays only forced subtitles, OFF: shows everything");
                out.newLine();
                out.write("forced subs: OFF");
                out.newLine();
                out.newLine();
                out.write("# The palette of the generated file");
                out.newLine();
                out.write("palette: ");
                int i = 0;
                while (i < pal.getSize()) {
                    int[] rbg = pal.getRGB(i);
                    int val = rbg[0] << 16 | rbg[1] << 8 | rbg[2];
                    out.write(ToolBox.hex(val, 6).substring(2));
                    if (i != pal.getSize() - 1) {
                        out.write(", ");
                    }
                    ++i;
                }
                out.newLine();
                out.newLine();
                out.write("# Custom colors (transp idxs and the four colors)");
                out.newLine();
                out.write("custom colors: OFF, tridx: 1000, colors: 000000, 444444, 888888, cccccc");
                out.newLine();
                out.newLine();
                out.write("# Language index in use");
                out.newLine();
                out.write("langidx: 0");
                out.newLine();
                out.newLine();
                out.write("# " + Core.getLanguages()[Core.getLanguageIdx()][0]);
                out.newLine();
                out.write("id: " + Core.getLanguages()[Core.getLanguageIdx()][1] + ", index: 0");
                out.newLine();
                out.write("# Decomment next line to activate alternative name in DirectVobSub / Windows Media Player 6.x");
                out.newLine();
                out.write("# alt: " + Core.getLanguages()[Core.getLanguageIdx()][0]);
                out.newLine();
                out.write("# Vob/Cell ID: 1, 1 (PTS: 0)");
                out.newLine();
                i = 0;
                while (i < timestamps.length) {
                    out.write("timestamp: " + ToolBox.ptsToTimeStrIdx(timestamps[i]));
                    out.write(", filepos: " + ToolBox.hex(offsets[i], 9).substring(2));
                    out.newLine();
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void decode(SubPictureDVD pic) throws CoreException {
        this.palette = SubDVD.decodePalette(pic, this.srcPalette);
        this.bitmap = SubDVD.decodeImage(pic, this.buffer, this.palette.getTransparentIndex());
        BitmapBounds bounds = this.bitmap.getBounds(this.palette, Core.getAlphaCrop());
        if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
            int w = bounds.xMax - bounds.xMin + 1;
            int h = bounds.yMax - bounds.yMin + 1;
            if (w < 2) {
                w = 2;
            }
            if (h < 2) {
                h = 2;
            }
            this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, w, h);
            pic.setImageWidth(w);
            pic.setImageHeight(h);
            pic.setOfsX(pic.originalX + bounds.xMin);
            pic.setOfsY(pic.originalY + bounds.yMin);
        }
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette, Core.getAlphaThr());
    }

    @Override
    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    @Override
    public int[] getFramePal(int index) {
        return this.subPictures.get((int)index).pal;
    }

    @Override
    public int[] getOriginalFramePal(int index) {
        return this.subPictures.get((int)index).originalPal;
    }

    @Override
    public int[] getFrameAlpha(int index) {
        return this.subPictures.get((int)index).alpha;
    }

    @Override
    public int[] getOriginalFrameAlpha(int index) {
        return this.subPictures.get((int)index).originalAlpha;
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette);
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette);
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public int getNumFrames() {
        return this.subPictures.size();
    }

    @Override
    public int getNumForcedFrames() {
        return this.numForcedFrames;
    }

    @Override
    public boolean isForced(int index) {
        return this.subPictures.get((int)index).isforced;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get((int)index).endTime;
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get((int)index).startTime;
    }

    @Override
    public long getStartOffset(int index) {
        return this.subPictures.get((int)index).offset;
    }

    @Override
    public int getLanguageIdx() {
        return this.languageIdx;
    }

    @Override
    public Palette getSrcPalette() {
        return this.srcPalette;
    }

    @Override
    public void setSrcPalette(Palette pal) {
        this.srcPalette = pal;
    }
}

