/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.Filters.Filter;
import deadbeef.Filters.Filters;
import deadbeef.GUI.MainFrame;
import deadbeef.GUI.Progress;
import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.ErasePatch;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.PaletteBitmap;
import deadbeef.SupTools.SubDVD;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureDVD;
import deadbeef.SupTools.Substream;
import deadbeef.SupTools.SubstreamDVD;
import deadbeef.SupTools.SupBD;
import deadbeef.SupTools.SupDVD;
import deadbeef.SupTools.SupHD;
import deadbeef.SupTools.SupXml;
import deadbeef.Tools.PngEncoderB;
import deadbeef.Tools.Props;
import deadbeef.Tools.ToolBox;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.swing.JFrame;

public class Core
extends Thread {
    static final String progName = "BDSup2Sub";
    static final String progNameVer = "BDSup2Sub 4.0.0";
    static final String authorDate = "0xdeadbeef 02-12/2009";
    static final String iniName = "bdsup2sup.ini";
    private static final String[] scalingFilters = new String[]{"Bilinear", "Triangle", "Bicubic", "Bell", "B-Spline", "Hermite", "Lanczos3", "Mitchell"};
    private static final String[] modes = new String[]{"SUB/IDX", "SUP/IFO", "SUP(BD)", "XML/PNG"};
    private static final String[] paletteModeNames = new String[]{"keep existing", "create new", "dithered"};
    private static final int[][] resolutions = new int[][]{{720, 480}, {720, 576}, {1280, 720}, {1440, 1080}, {1920, 1080}};
    private static final String[] resolutionNames = new String[]{"NTSC (720x480)", "PAL (720x576)", "720p (1280x720)", "1080p- (1440x1080)", "1080p (1920x1080)"};
    private static final String[] resolutionNamesXml = new String[]{"480i", "576i", "720p", "1440x1080", "1080p"};
    public static final double FPS_24P = 23.976023976023978;
    public static final double FPS_23_975 = 23.975;
    public static final double FPS_24HZ = 24.0;
    public static final double FPS_PAL = 25.0;
    public static final double FPS_NTSC = 29.97002997002997;
    public static final double FPS_PAL_I = 50.0;
    public static final double FPS_NTSC_I = 59.94005994005994;
    private static final int minDim = 8;
    public static final double minScale = 0.5;
    public static final double maxScale = 2.0;
    private static final int numRecent = 5;
    private static String[][] languages = new String[][]{{"German", "de", "deu"}, {"English", "en", "eng"}, {"French", "fr", "fra"}, {"Italian", "it", "ita"}, {"Spanish", "es", "spa"}, {"Abkhazian", "ab", "abk"}, {"Afar", "aa", "aar"}, {"Afrikaans", "af", "afr"}, {"Albanian", "sq", "sqi"}, {"Amharic", "am", "amh"}, {"Arabic", "ar", "ara"}, {"Aragonese", "an", "arg"}, {"Armenian", "hy", "hye"}, {"Assamese", "as", "asm"}, {"Avaric", "av", "ava"}, {"Avestan", "ae", "ave"}, {"Aymara", "ay", "aym"}, {"Azerbaijani", "az", "aze"}, {"Bambara", "bm", "bam"}, {"Bashkir", "ba", "bak"}, {"Basque", "eu", "eus"}, {"Belarusian", "be", "bel"}, {"Bengali", "bn", "ben"}, {"Bihari", "bh", "bih"}, {"Bislama", "bi", "bis"}, {"Bosnian", "bs", "bos"}, {"Breton", "br", "bre"}, {"Bulgarian", "bg", "bul"}, {"Burmese", "my", "mya"}, {"Cambodian", "km", "khm"}, {"Catalan", "ca", "cat"}, {"Chamorro", "ch", "cha"}, {"Chechen", "ce", "che"}, {"Chichewa", "ny", "nya"}, {"Chinese", "zh", "zho"}, {"Chuvash", "cv", "chv"}, {"Cornish", "kw", "cor"}, {"Corsican", "co", "cos"}, {"Cree", "cr", "cre"}, {"Croatian", "hr", "hrv"}, {"Czech", "cs", "ces"}, {"Danish", "da", "dan"}, {"Divehi", "dv", "div"}, {"Dzongkha", "dz", "dzo"}, {"Dutch", "nl", "nld"}, {"Esperanto", "eo", "epo"}, {"Estonian", "et", "est"}, {"Ewe", "ee", "ewe"}, {"Faroese", "fo", "fao"}, {"Fiji", "fj", "fij"}, {"Finnish", "fi", "fin"}, {"Frisian", "fy", "fry"}, {"Fulah", "ff", "ful"}, {"Gaelic", "gd", "gla"}, {"Galician", "gl", "glg"}, {"Ganda", "lg", "lug"}, {"Georgian", "ka", "kat"}, {"Greek", "el", "ell"}, {"Greenlandic", "kl", "kal"}, {"Guarani", "gn", "grn"}, {"Gujarati", "gu", "guj"}, {"Haitian", "ht", "hat"}, {"Hausa", "ha", "hau"}, {"Hebrew", "he", "heb"}, {"Herero", "hz", "her"}, {"Hindi", "hi", "hin"}, {"Hiri Motu", "ho", "hmo"}, {"Hungarian", "hu", "hun"}, {"Icelandic", "is", "isl"}, {"Ido", "io", "ido"}, {"Igbo", "ig", "ibo"}, {"Indonesian", "id", "ind"}, {"Interlingua", "ia", "ina"}, {"Interlingue", "ie", "ile"}, {"Inupiaq", "ik", "ipk"}, {"Inuktitut", "iu", "iku"}, {"Irish", "ga", "gle"}, {"Japanese", "ja", "jpn"}, {"Javanese", "jv", "jav"}, {"Kannada", "kn", "kan"}, {"Kanuri", "kr", "kau"}, {"Kashmiri", "ks", "kas"}, {"Kazakh", "kk", "kaz"}, {"Kikuyu", "ki", "kik"}, {"Kinyarwanda", "rw", "kin"}, {"Kirghiz", "ky", "kir"}, {"Komi", "kv", "kom"}, {"Kongo", "kg", "kon"}, {"Korean", "ko", "kor"}, {"Kuanyama", "kj", "kua"}, {"Kurdish", "ku", "kur"}, {"Lao", "lo", "lao"}, {"Latin", "la", "lat"}, {"Latvian", "lv", "lav"}, {"Limburgan", "li", "lim"}, {"Lingala", "ln", "lin"}, {"Lithuanian", "lt", "lit"}, {"Luba", "lu", "lub"}, {"Luxembourgish", "lb", "ltz"}, {"Macedonian", "mk", "mkd"}, {"Malagasy", "mg", "mlg"}, {"Malay", "ms", "msa"}, {"Malayalam", "ml", "mal"}, {"Maltese", "mt", "mlt"}, {"Marshallese", "mh", "mah"}, {"Manx", "gv", "glv"}, {"Maori", "mi", "mri"}, {"Marathi", "mr", "mar"}, {"Mongolian", "mn", "mon"}, {"Nauru", "na", "nau"}, {"Navajo", "nv", "nav"}, {"Ndebele", "nd", "nde"}, {"Ndonga", "ng", "ndo"}, {"Nepali", "ne", "nep"}, {"Norwegian", "no", "nor"}, {"Occitan", "oc", "oci"}, {"Ojibwa", "oj", "oji"}, {"Oriya", "or", "ori"}, {"Oromo", "om", "orm"}, {"Ossetian", "os", "oss"}, {"Pali", "pi", "pli"}, {"Panjabi", "pa", "pan"}, {"Pashto", "ps", "pus"}, {"Persian", "fa", "fas"}, {"Polish", "pl", "pol"}, {"Portuguese", "pt", "por"}, {"Quechua", "qu", "que"}, {"Romansh", "rm", "roh"}, {"Romanian", "ro", "ron"}, {"Rundi", "rn", "run"}, {"Russian", "ru", "rus"}, {"Sami", "se", "sme"}, {"Samoan", "sm", "smo"}, {"Sango", "sg", "sag"}, {"Sanskrit", "sa", "san"}, {"Sardinian", "sc", "srd"}, {"Serbian", "sr", "srp"}, {"Shona", "sn", "sna"}, {"Sichuan Yi", "ii", "iii"}, {"Sindhi", "sd", "snd"}, {"Sinhalese", "si", "sin"}, {"Slavonic", "cu", "chu"}, {"Slovak", "sk", "slk"}, {"Slovenian", "sl", "slv"}, {"Somali", "so", "som"}, {"Sotho", "st", "sot"}, {"Sundanese", "su", "sun"}, {"Swahili", "sw", "swa"}, {"Swati", "ss", "ssw"}, {"Swedish", "sv", "swe"}, {"Tagalog", "tl", "tgl"}, {"Tahitian", "ty", "tah"}, {"Tajik", "tg", "tgk"}, {"Tamil", "ta", "tam"}, {"Tatar", "tt", "tar"}, {"Telugu", "te", "tel"}, {"Thai", "th", "tha"}, {"Tibetan", "bo", "bod"}, {"Tigrinya", "ti", "tir"}, {"Tonga", "to", "ton"}, {"Tsonga", "ts", "tso"}, {"Tswana", "tn", "tsn"}, {"Turkish", "tr", "tur"}, {"Turkmen", "tk", "tuk"}, {"Twi", "tw", "twi"}, {"Uighur", "ug", "uig"}, {"Ukrainian", "uk", "ukr"}, {"Urdu", "ur", "urd"}, {"Uzbek", "uz", "uzb"}, {"Venda", "ve", "ven"}, {"Vietnamese", "vi", "vie"}, {"Volap\u00fck", "vo", "vol"}, {"Welsh", "cy", "cym"}, {"Walloon", "wa", "wln"}, {"Wolof", "wo", "wol"}, {"Xhosa", "xh", "xho"}, {"Yiddish", "yi", "yid"}, {"Yoruba", "yo", "yor"}, {"Zhuang", "za", "zha"}, {"Zulu", "zu", "zul"}};
    private static final byte[] defaultPalR;
    private static final byte[] defaultPalG;
    private static final byte[] defaultPalB;
    private static final byte[] defaultAlpha;
    private static final Palette defaultDVDPalette;
    private static Palette currentDVDPalette;
    private static final boolean convertResolutionDefault = false;
    private static final Resolution resolutionTrgDefault;
    private static final boolean convertFPSdefault = false;
    private static final double fpsSrcDefault = 23.976023976023978;
    private static final double fpsTrgDefault = 25.0;
    private static final int delayPTSdefault = 0;
    private static final boolean fixShortFramesDefault = false;
    private static final int minTimePTSdefault = 45000;
    private static final boolean applyFreeScaleDefault = false;
    private static final double freeScaleXdefault = 1.0;
    private static final double freeScaleYdefault = 1.0;
    private static boolean convertResolutionSet;
    private static boolean resolutionTrgSet;
    private static boolean convertFpsSet;
    private static boolean fpsTrgSet;
    private static boolean delayPtsSet;
    private static boolean fixShortFramesSet;
    private static boolean minTimePtsSet;
    private static boolean applyFreeScaleSet;
    private static Palette defaultSourceDVDPalette;
    private static Palette currentSourceDVDPalette;
    private static final int[] alphaDefault;
    public static Props props;
    private static String fnameProps;
    private static int languageIdx;
    private static Bitmap trgBitmapUnpatched;
    private static Bitmap trgBitmap;
    private static Palette trgPal;
    private static SubPictureDVD subVobTrg;
    private static SupBD supBD;
    private static SupHD supHD;
    private static SupXml supXml;
    private static SubDVD subDVD;
    private static SupDVD supDVD;
    private static Substream substream;
    private static SubPicture[] subPictures;
    private static int[] lumThr;
    private static int alphaThr;
    private static final OutputMode outModeDefault;
    private static boolean outModeSet;
    private static OutputMode outMode;
    private static InputMode inMode;
    private static Resolution resolutionTrg;
    private static boolean convertFPS;
    private static boolean convertResolution;
    private static boolean exportForced;
    private static SetState forceAll;
    private static boolean swapCrCb;
    private static boolean fixShortFrames;
    private static boolean fpsSrcCertain;
    private static double fpsSrc;
    private static boolean fpsSrcSet;
    private static double fpsTrg;
    private static int delayPTS;
    private static int minTimePTS;
    private static int cropOfsY;
    private static boolean useBT601;
    private static boolean paletteModeSet;
    private static final PaletteMode paletteModeDefault;
    private static PaletteMode paletteMode;
    private static boolean verbatimSet;
    private static boolean verbatim;
    private static boolean keepFps;
    private static final ScalingFilters scalingFilterDefault;
    private static ScalingFilters scalingFilter;
    private static boolean scalingFilterSet;
    private static int mergePTSdiff;
    private static boolean mergePTSdiffSet;
    private static int alphaCrop;
    private static boolean alphaCropSet;
    private static boolean fixZeroAlpha;
    private static boolean fixZeroAlphaSet;
    private static boolean writePGCEditPalSet;
    private static boolean writePGCEditPal;
    private static double cineBarFactor;
    private static int moveOffsetY;
    private static int moveOffsetX;
    private static MoveModeY moveModeY;
    private static MoveModeX moveModeX;
    private static boolean moveCaptions;
    private static boolean applyFreeScale;
    private static double freeScaleX;
    private static double freeScaleY;
    private static StreamID currentStreamID;
    private static String fileName;
    private static MainFrame mainFrame;
    private static Progress progress;
    private static int progressMax;
    private static int progressLast;
    private static int errors;
    private static int warnings;
    private static boolean cliMode;
    private static RunType runType;
    private static State state;
    private static Exception threadException;
    private static volatile boolean ready;
    private static final Object semaphore;
    private static ArrayList<String> recentFiles;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = -16;
        byArray[2] = -52;
        byArray[3] = -103;
        byArray[4] = 51;
        byArray[5] = 17;
        byArray[6] = -6;
        byArray[7] = -69;
        byArray[8] = 51;
        byArray[9] = 17;
        byArray[10] = -6;
        byArray[11] = -69;
        byArray[12] = -6;
        byArray[13] = -69;
        byArray[14] = 51;
        byArray[15] = 17;
        defaultPalR = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[1] = -16;
        byArray2[2] = -52;
        byArray2[3] = -103;
        byArray2[4] = 51;
        byArray2[5] = 17;
        byArray2[6] = 51;
        byArray2[7] = 17;
        byArray2[8] = -6;
        byArray2[9] = -69;
        byArray2[10] = -6;
        byArray2[11] = -69;
        byArray2[12] = 51;
        byArray2[13] = 17;
        byArray2[14] = -6;
        byArray2[15] = -69;
        defaultPalG = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[1] = -16;
        byArray3[2] = -52;
        byArray3[3] = -103;
        byArray3[4] = -6;
        byArray3[5] = -69;
        byArray3[6] = 51;
        byArray3[7] = 17;
        byArray3[8] = 51;
        byArray3[9] = 17;
        byArray3[10] = 51;
        byArray3[11] = 17;
        byArray3[12] = -6;
        byArray3[13] = -69;
        byArray3[14] = -6;
        byArray3[15] = -69;
        defaultPalB = byArray3;
        defaultAlpha = new byte[16];
        defaultDVDPalette = new Palette(defaultPalR, defaultPalG, defaultPalB, defaultAlpha, true);
        currentDVDPalette = new Palette(defaultPalR, defaultPalG, defaultPalB, defaultAlpha, true);
        resolutionTrgDefault = Resolution.PAL;
        convertResolutionSet = false;
        resolutionTrgSet = false;
        convertFpsSet = false;
        fpsTrgSet = false;
        delayPtsSet = false;
        fixShortFramesSet = false;
        minTimePtsSet = false;
        applyFreeScaleSet = false;
        defaultSourceDVDPalette = null;
        currentSourceDVDPalette = null;
        int[] nArray = new int[4];
        nArray[1] = 15;
        nArray[2] = 15;
        nArray[3] = 15;
        alphaDefault = nArray;
        languageIdx = 0;
        subVobTrg = null;
        supBD = null;
        supHD = null;
        supXml = null;
        subDVD = null;
        supDVD = null;
        substream = null;
        lumThr = new int[]{210, 160};
        alphaThr = 80;
        outModeDefault = OutputMode.VOBSUB;
        outModeSet = false;
        outMode = outModeDefault;
        inMode = InputMode.VOBSUB;
        resolutionTrg = resolutionTrgDefault;
        convertFPS = false;
        convertResolution = false;
        exportForced = false;
        forceAll = SetState.KEEP;
        swapCrCb = false;
        fixShortFrames = false;
        fpsSrcCertain = false;
        fpsSrc = 23.976023976023978;
        fpsSrcSet = false;
        fpsTrg = 25.0;
        delayPTS = 0;
        minTimePTS = 45000;
        cropOfsY = 0;
        paletteModeSet = false;
        paletteMode = paletteModeDefault = PaletteMode.CREATE_NEW;
        verbatimSet = false;
        verbatim = false;
        keepFps = false;
        scalingFilter = scalingFilterDefault = ScalingFilters.BILINEAR;
        scalingFilterSet = false;
        mergePTSdiff = 18000;
        mergePTSdiffSet = false;
        alphaCrop = 14;
        alphaCropSet = false;
        fixZeroAlpha = false;
        fixZeroAlphaSet = false;
        writePGCEditPalSet = false;
        writePGCEditPal = false;
        cineBarFactor = 0.11904761904761904;
        moveOffsetY = 10;
        moveOffsetX = 10;
        moveModeY = MoveModeY.KEEP;
        moveModeX = MoveModeX.KEEP;
        moveCaptions = false;
        applyFreeScale = false;
        freeScaleX = 1.0;
        freeScaleY = 1.0;
        currentStreamID = StreamID.UNKNOWN;
        mainFrame = null;
        progress = null;
        cliMode = true;
        state = State.INACTIVE;
        ready = false;
        semaphore = new Object();
        recentFiles = new ArrayList();
    }

    @Override
    public void run() {
        state = State.ACTIVE;
        threadException = null;
        try {
            try {
                switch (runType) {
                    case CREATESUB: {
                        Core.writeSub(fileName);
                        break;
                    }
                    case READSUP: {
                        Core.readSup(fileName);
                        break;
                    }
                    case READVOBSUB: {
                        Core.readVobSub(fileName);
                        break;
                    }
                    case READSUPIFO: {
                        Core.readSupIfo(fileName);
                        break;
                    }
                    case READXML: {
                        Core.readXml(fileName);
                        break;
                    }
                    case MOVEALL: {
                        Core.moveAllToBounds();
                    }
                }
            }
            catch (Exception ex) {
                threadException = ex;
                state = State.INACTIVE;
            }
        }
        finally {
            state = State.INACTIVE;
        }
    }

    public static void init(Object c) {
        if (c != null) {
            int n;
            int n2;
            Enum[] enumArray;
            cliMode = false;
            String s = String.valueOf(c.getClass().getName().replace('.', '/')) + ".class";
            URL url = c.getClass().getClassLoader().getResource(s);
            try {
                fnameProps = URLDecoder.decode(url.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int pos = fnameProps.toLowerCase().indexOf("file:");
            if (pos != -1) {
                fnameProps = fnameProps.substring(pos + 5);
            }
            if ((pos = fnameProps.toLowerCase().indexOf(s.toLowerCase())) != -1) {
                fnameProps = fnameProps.substring(0, pos);
            }
            if ((pos = (s = ToolBox.exchangeSeparators(fnameProps.toLowerCase())).lastIndexOf(".jar")) != -1 && (pos = s.substring(0, pos).lastIndexOf(47)) != -1) {
                fnameProps = fnameProps.substring(0, pos + 1);
            }
            fnameProps = String.valueOf(fnameProps) + iniName;
            props = new Props();
            props.setHeader("BDSup2Sub 4.0.0 settings - don't modify manually");
            props.load(fnameProps);
            if (!verbatimSet) {
                verbatim = props.get("verbatim", "false").equals("true");
            } else {
                props.set("verbatim", verbatim ? "true" : "false");
            }
            if (!writePGCEditPalSet) {
                writePGCEditPal = props.get("writePGCEditPal", "false").equals("true");
            } else {
                props.set("writePGCEditPal", writePGCEditPal ? "true" : "false");
            }
            if (!mergePTSdiffSet) {
                mergePTSdiff = props.get("mergePTSdiff", 18000);
            } else {
                props.set("mergePTSdiff", mergePTSdiff);
            }
            if (!alphaCropSet) {
                alphaCrop = props.get("alphaCrop", 14);
            } else {
                props.set("alphaCrop", alphaCrop);
            }
            if (!fixZeroAlphaSet) {
                fixZeroAlpha = props.get("fixZeroAlpha", "false").equals("true");
            } else {
                props.set("fixZeroAlpha", fixZeroAlpha ? "true" : "false");
            }
            if (!scalingFilterSet) {
                String filter = props.get("filter", Core.getScalingFilterName(scalingFilterDefault));
                enumArray = ScalingFilters.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    Enum sf = enumArray[n];
                    if (Core.getScalingFilterName((ScalingFilters)sf).equalsIgnoreCase(filter)) {
                        scalingFilter = sf;
                        break;
                    }
                    ++n;
                }
            } else {
                props.set("filter", Core.getScalingFilterName(scalingFilter));
            }
            if (!paletteModeSet) {
                String pMode = props.get("paletteMode", Core.getPaletteModeName(paletteModeDefault));
                enumArray = PaletteMode.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    Enum pm = enumArray[n];
                    if (Core.getPaletteModeName((PaletteMode)pm).equalsIgnoreCase(pMode)) {
                        paletteMode = pm;
                        break;
                    }
                    ++n;
                }
            } else {
                props.set("paletteMode", Core.getPaletteModeName(paletteMode));
            }
            if (!outModeSet) {
                String oMode = props.get("outputMode", Core.getOutputFormatName(outModeDefault));
                enumArray = OutputMode.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    Enum om = enumArray[n];
                    if (Core.getOutputFormatName((OutputMode)om).equalsIgnoreCase(oMode)) {
                        outMode = om;
                        break;
                    }
                    ++n;
                }
            } else {
                props.set("outputMode", Core.getOutputFormatName(outMode));
            }
            int i = 0;
            while (i < 5 && (s = props.get("recent_" + i, "")).length() > 0) {
                recentFiles.add(s);
                ++i;
            }
            if (!convertResolutionSet) {
                convertResolution = Core.restoreConvertResolution();
            }
            if (convertResolution && !resolutionTrgSet) {
                resolutionTrg = Core.restoreResolution();
            }
            if (!convertFpsSet) {
                convertFPS = Core.restoreConvertFPS();
            }
            if (convertFPS) {
                if (!fpsSrcCertain && !fpsSrcSet) {
                    fpsSrc = Core.restoreFpsSrc();
                }
                if (!fpsTrgSet) {
                    fpsTrg = Core.restoreFpsTrg();
                }
            }
            if (!delayPtsSet) {
                delayPTS = Core.restoreDelayPTS();
            }
            if (!fixShortFramesSet) {
                fixShortFrames = Core.restoreFixShortFrames();
            }
            if (!minTimePtsSet) {
                minTimePTS = Core.restoreMinTimePTS();
            }
            if (!applyFreeScaleSet && (applyFreeScale = Core.restoreApplyFreeScale())) {
                freeScaleX = Core.restoreFreeScaleX();
                freeScaleY = Core.restoreFreeScaleY();
            }
        }
    }

    public static void loadedHook() {
        fpsSrcSet = false;
    }

    public static void close() {
        ready = false;
        if (supBD != null) {
            supBD.close();
        }
        if (supHD != null) {
            supHD.close();
        }
        if (supXml != null) {
            supXml.close();
        }
        if (subDVD != null) {
            subDVD.close();
        }
        if (supDVD != null) {
            supDVD.close();
        }
    }

    public static void exit() {
        Core.storeProps();
        if (supBD != null) {
            supBD.close();
        }
        if (supHD != null) {
            supHD.close();
        }
        if (supXml != null) {
            supXml.close();
        }
        if (subDVD != null) {
            subDVD.close();
        }
        if (supDVD != null) {
            supDVD.close();
        }
    }

    public static void storeProps() {
        if (props != null) {
            props.save(fnameProps);
        }
    }

    public static void addRecent(String s) {
        int size = recentFiles.size();
        boolean found = false;
        int i = 0;
        while (i < size) {
            if (s.equals(recentFiles.get(i))) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            recentFiles.add(0, s);
            while ((size = recentFiles.size()) > 5) {
                recentFiles.remove(size - 1);
            }
            i = 0;
            while (i < size) {
                props.set("recent_" + i, recentFiles.get(i));
                ++i;
            }
        }
    }

    public static ArrayList<String> getRecentFiles() {
        return recentFiles;
    }

    public static StreamID getStreamID(byte[] id) {
        StreamID sid = id[0] == 80 && id[1] == 71 ? StreamID.BDSUP : (id[0] == 83 && id[1] == 80 ? StreamID.SUP : (id[0] == 0 && id[1] == 0 && id[2] == 1 && id[3] == -70 ? StreamID.DVDSUB : (id[0] == 35 && id[1] == 32 && id[2] == 86 && id[3] == 111 ? StreamID.IDX : (id[0] == 60 && id[1] == 63 && id[2] == 120 && id[3] == 109 ? StreamID.XML : (id[0] == 68 && id[1] == 86 && id[2] == 68 && id[3] == 86 ? StreamID.IFO : StreamID.UNKNOWN)))));
        return sid;
    }

    public static long syncTimePTS(long t, double fps) {
        long retval;
        if (fps == 29.97002997002997 || fps == 25.0 || fps == 24.0) {
            int tpfi = (int)((90000.0 + fps / 2.0) / fps);
            int tpfh = tpfi / 2;
            retval = (t + (long)tpfh) / (long)tpfi * (long)tpfi;
        } else if (fpsTrg == 23.976023976023978) {
            retval = (t + 1877L) * 4L / 15015L * 15015L / 4L;
        } else {
            double tpf = 90000.0 / fpsTrg;
            retval = (long)((double)((long)((double)t / tpf)) * tpf + 0.5);
        }
        return retval;
    }

    public static void readStreamThreaded(String fname, JFrame parent, StreamID sid) throws Exception {
        boolean xml = ToolBox.getExtension(fname).equalsIgnoreCase("xml");
        boolean idx = ToolBox.getExtension(fname).equalsIgnoreCase("idx");
        boolean ifo = ToolBox.getExtension(fname).equalsIgnoreCase("ifo");
        fileName = fname;
        progressMax = (int)new File(fname).length();
        progressLast = 0;
        progress = new Progress((Frame)parent, true);
        progress.setMinMax(0, 100);
        progress.setTitle("Loading");
        progress.setText("Loading subtitle stream");
        runType = xml || sid == StreamID.XML ? RunType.READXML : (idx || sid == StreamID.DVDSUB || sid == StreamID.IDX ? RunType.READVOBSUB : (ifo || sid == StreamID.IFO ? RunType.READSUPIFO : RunType.READSUP));
        currentStreamID = sid;
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        state = State.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    public static void createSubThreaded(String fname, JFrame parent) throws Exception {
        fileName = fname;
        progressMax = substream.getNumFrames();
        progressLast = 0;
        progress = new Progress((Frame)parent, true);
        progress.setMinMax(0, 100);
        progress.setTitle("Exporting");
        if (outMode == OutputMode.VOBSUB) {
            progress.setText("Exporting SUB/IDX");
        } else if (outMode == OutputMode.BDSUP) {
            progress.setText("Exporting SUP(BD)");
        } else if (outMode == OutputMode.XML) {
            progress.setText("Exporting XML/PNG");
        } else {
            progress.setText("Exporting SUP/IFO");
        }
        runType = RunType.CREATESUB;
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        state = State.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    private static void determineFramePal(int index) {
        if (inMode != InputMode.VOBSUB && inMode != InputMode.SUPIFO || paletteMode != PaletteMode.KEEP_EXISTING) {
            int[] rgbSrc = substream.getPalette().getRGB(substream.getPrimaryColorIndex());
            Palette trgPallete = currentDVDPalette;
            int minDistance = 0xFFFFFF;
            int colIdx = 0;
            int idx = 1;
            while (idx < trgPallete.getSize()) {
                int bd;
                int gd;
                int[] rgb = trgPallete.getRGB(idx);
                int rd = rgbSrc[0] - rgb[0];
                int distance = rd * rd + (gd = rgbSrc[1] - rgb[1]) * gd + (bd = rgbSrc[2] - rgb[2]) * bd;
                if (distance < minDistance) {
                    colIdx = idx;
                    minDistance = distance;
                    if (minDistance == 0) break;
                }
                if (idx == 1) {
                    --idx;
                }
                idx += 2;
            }
            int[] palFrame = new int[]{0, colIdx, colIdx == 1 ? colIdx + 2 : colIdx + 1, 0};
            Core.subVobTrg.alpha = alphaDefault;
            Core.subVobTrg.pal = palFrame;
            trgPal = SubDVD.decodePalette(subVobTrg, trgPallete);
        } else {
            Palette miniPal = new Palette(4, true);
            SubstreamDVD substreamDVD = inMode == InputMode.VOBSUB ? subDVD : supDVD;
            int[] alpha = substreamDVD.getFrameAlpha(index);
            int[] palFrame = substreamDVD.getFramePal(index);
            int i = 0;
            while (i < 4) {
                int a = alpha[i] * 255 / 15;
                if (a >= alphaCrop) {
                    miniPal.setARGB(i, currentSourceDVDPalette.getARGB(palFrame[i]));
                    miniPal.setAlpha(i, a);
                } else {
                    miniPal.setARGB(i, 0);
                }
                ++i;
            }
            Core.subVobTrg.alpha = alpha;
            Core.subVobTrg.pal = palFrame;
            trgPal = miniPal;
        }
    }

    public static void readSup(String fname) throws CoreException {
        byte[] id;
        Core.printX("Loading " + fname + "\n");
        Core.resetErrors();
        Core.resetWarnings();
        String fnl = ToolBox.getFileName(fname.toLowerCase());
        int i = 0;
        while (i < languages.length) {
            if (fnl.indexOf(languages[i][0].toLowerCase()) >= 0) {
                languageIdx = i;
                Core.printX("Selected language '" + languages[i][0] + " (" + languages[i][1] + ")' by filename\n");
                break;
            }
            ++i;
        }
        if (substream != null) {
            substream.close();
        }
        if ((id = ToolBox.getFileID(fname, 2)) != null && id[0] == 80 && id[1] == 71) {
            supBD = new SupBD(fname);
            substream = supBD;
            supHD = null;
            inMode = InputMode.BDSUP;
        } else {
            supHD = new SupHD(fname);
            substream = supHD;
            supBD = null;
            inMode = InputMode.HDDVDSUP;
        }
        substream.decode(0);
        subVobTrg = new SubPictureDVD();
        int maxLum = substream.getPalette().getY()[substream.getPrimaryColorIndex()] & 0xFF;
        lumThr = new int[2];
        if (maxLum > 30) {
            Core.lumThr[0] = maxLum * 2 / 3;
            Core.lumThr[1] = maxLum / 3;
        } else {
            Core.lumThr[0] = 210;
            Core.lumThr[1] = 160;
        }
        if (!fpsSrcSet) {
            if (substream == supBD) {
                fpsSrc = supBD.getFps(0);
                fpsSrcCertain = true;
                if (keepFps) {
                    Core.setFPSTrg(fpsSrc);
                }
            } else {
                useBT601 = false;
                fpsSrcCertain = false;
                fpsSrc = 23.976023976023978;
            }
        }
    }

    public static void readXml(String fname) throws CoreException {
        Core.printX("Loading " + fname + "\n");
        Core.resetErrors();
        Core.resetWarnings();
        if (substream != null) {
            substream.close();
        }
        supXml = new SupXml(fname);
        substream = supXml;
        inMode = InputMode.XML;
        substream.decode(0);
        subVobTrg = new SubPictureDVD();
        int maxLum = substream.getPalette().getY()[substream.getPrimaryColorIndex()] & 0xFF;
        lumThr = new int[2];
        if (maxLum > 30) {
            Core.lumThr[0] = maxLum * 2 / 3;
            Core.lumThr[1] = maxLum / 3;
        } else {
            Core.lumThr[0] = 210;
            Core.lumThr[1] = 160;
        }
        int i = 0;
        while (i < languages.length) {
            if (languages[i][2].equalsIgnoreCase(supXml.getLanguage())) {
                languageIdx = i;
                break;
            }
            ++i;
        }
        if (!fpsSrcSet) {
            fpsSrc = supXml.getFps();
            fpsSrcCertain = true;
            if (keepFps) {
                Core.setFPSTrg(fpsSrc);
            }
        }
    }

    public static void readVobSub(String fname) throws CoreException {
        Core.readDVDSubstream(fname, true);
    }

    public static void readSupIfo(String fname) throws CoreException {
        Core.readDVDSubstream(fname, false);
    }

    public static void readDVDSubstream(String fname, boolean isVobSub) throws CoreException {
        SubstreamDVD substreamDVD;
        String fnI;
        String fnS;
        Core.printX("Loading " + fname + "\n");
        Core.resetErrors();
        Core.resetWarnings();
        if (substream != null) {
            substream.close();
        }
        if (isVobSub) {
            if (currentStreamID == StreamID.DVDSUB) {
                fnS = fname;
                fnI = String.valueOf(ToolBox.stripExtension(fname)) + ".idx";
            } else {
                fnI = fname;
                fnS = String.valueOf(ToolBox.stripExtension(fname)) + ".sub";
            }
            subDVD = new SubDVD(fnS, fnI);
            substream = subDVD;
            inMode = InputMode.VOBSUB;
            substreamDVD = subDVD;
        } else {
            fnI = fname;
            fnS = String.valueOf(ToolBox.stripExtension(fname)) + ".sup";
            supDVD = new SupDVD(fnS, fnI);
            substream = supDVD;
            inMode = InputMode.SUPIFO;
            substreamDVD = supDVD;
        }
        substream.decode(0);
        subVobTrg = new SubPictureDVD();
        defaultSourceDVDPalette = substreamDVD.getSrcPalette();
        currentSourceDVDPalette = new Palette(defaultSourceDVDPalette);
        int primColIdx = substream.getPrimaryColorIndex();
        int yMax = substream.getPalette().getY()[primColIdx] & 0xFF;
        lumThr = new int[2];
        if (yMax > 10) {
            int yMin = yMax;
            int i = 0;
            while (i < 4) {
                int y = substream.getPalette().getY()[i] & 0xFF;
                int a = substream.getPalette().getAlpha(i);
                if (y < yMin && a > alphaThr) {
                    yMin = y;
                }
                ++i;
            }
            Core.lumThr[0] = yMin + (yMax - yMin) * 9 / 10;
            Core.lumThr[1] = yMin + (yMax - yMin) * 3 / 10;
        } else {
            Core.lumThr[0] = 210;
            Core.lumThr[1] = 160;
        }
        languageIdx = substreamDVD.getLanguageIdx();
        if (!fpsSrcSet) {
            int h = Core.substream.getSubPicture((int)0).height;
            switch (h) {
                case 480: {
                    fpsSrc = 29.97002997002997;
                    useBT601 = true;
                    fpsSrcCertain = true;
                    break;
                }
                case 576: {
                    fpsSrc = 25.0;
                    useBT601 = true;
                    fpsSrcCertain = true;
                    break;
                }
                default: {
                    useBT601 = false;
                    fpsSrc = 23.976023976023978;
                    fpsSrcCertain = false;
                }
            }
        }
    }

    private static void validateTimes(int idx, SubPicture subPic, SubPicture subPicNext, SubPicture subPicPrev) {
        long ts_next;
        long ts = subPic.startTime;
        long te = subPic.endTime;
        long delay = 450000L;
        ++idx;
        long te_last = subPicPrev != null ? subPicPrev.endTime : -1L;
        if (ts < te_last) {
            Core.printWarn("start time of frame " + idx + " < end of last frame -> fixed\n");
            ts = te_last;
        }
        if ((ts_next = subPicNext != null ? subPicNext.startTime : 0L) == 0L) {
            ts_next = te > ts ? te : ts + delay;
        }
        if (te <= ts) {
            if (te == 0L) {
                Core.printWarn("missing end time of frame " + idx + " -> fixed\n");
            } else {
                Core.printWarn("end time of frame " + idx + " < start time -> fixed\n");
            }
            te = ts + delay;
            if (te > ts_next) {
                te = ts_next;
            }
        } else if (te > ts_next) {
            Core.printWarn("end time of frame " + idx + " > start time of next frame -> fixed\n");
            ts = ts_next;
        }
        if (te - ts < (long)minTimePTS) {
            if (fixShortFrames) {
                te = ts + (long)minTimePTS;
                if (te > ts_next) {
                    te = ts_next;
                }
                Core.printWarn("duration of frame " + idx + " was shorter than " + ToolBox.formatDouble((double)minTimePTS / 90.0) + "ms -> fixed\n");
            } else {
                Core.printWarn("duration of frame " + idx + " is shorter than " + ToolBox.formatDouble((double)minTimePTS / 90.0) + "ms\n");
            }
        }
        if (subPic.startTime != ts) {
            subPic.startTime = Core.syncTimePTS(ts, fpsTrg);
        }
        if (subPic.endTime != te) {
            subPic.endTime = Core.syncTimePTS(te, fpsTrg);
        }
    }

    public static boolean updateTrgPic(int index) {
        int spaceSrc;
        int spaceTrg;
        double fy;
        double fx;
        SubPicture picSrc = substream.getSubPicture(index);
        SubPicture picTrg = subPictures[index];
        double scaleX = (double)picTrg.width / (double)picSrc.width;
        double scaleY = (double)picTrg.height / (double)picSrc.height;
        if (applyFreeScale) {
            fx = freeScaleX;
            fy = freeScaleY;
        } else {
            fx = 1.0;
            fy = 1.0;
        }
        int wOld = picTrg.getImageWidth();
        int hOld = picTrg.getImageHeight();
        int wNew = (int)((double)picSrc.getImageWidth() * scaleX * fx + 0.5);
        if (wNew < 8) {
            wNew = picSrc.getImageWidth();
        } else if (wNew > picTrg.width) {
            wNew = picTrg.width;
        }
        int hNew = (int)((double)picSrc.getImageHeight() * scaleY * fy + 0.5);
        if (hNew < 8) {
            hNew = picSrc.getImageHeight();
        } else if (hNew > picTrg.height) {
            hNew = picTrg.height;
        }
        picTrg.setImageWidth(wNew);
        picTrg.setImageHeight(hNew);
        if (wNew != wOld) {
            int xOfs = (int)((double)picSrc.getOfsX() * scaleX + 0.5);
            spaceTrg = picTrg.width - wNew;
            spaceSrc = (int)((double)(picSrc.width - picSrc.getImageWidth()) * scaleX + 0.5);
            if ((xOfs += (spaceTrg - spaceSrc) / 2) < 0) {
                xOfs = 0;
            } else if (xOfs + wNew > picTrg.width) {
                xOfs = picTrg.width - wNew;
            }
            picTrg.setOfsX(xOfs);
        }
        if (hNew != hOld) {
            int yOfs = (int)((double)picSrc.getOfsY() * scaleY + 0.5);
            spaceTrg = picTrg.height - hNew;
            spaceSrc = (int)((double)(picSrc.height - picSrc.getImageHeight()) * scaleY + 0.5);
            if ((yOfs += (spaceTrg - spaceSrc) / 2) + hNew > picTrg.height) {
                yOfs = picTrg.height - hNew;
            }
            picTrg.setOfsY(yOfs);
        }
        return wNew != wOld || hNew != hOld;
    }

    public static void setForceAll() {
        if (subPictures != null) {
            int i = 0;
            while (i < subPictures.length) {
                switch (forceAll) {
                    case SET: {
                        Core.subPictures[i].isforced = true;
                        break;
                    }
                    case CLEAR: {
                        Core.subPictures[i].isforced = false;
                    }
                }
                ++i;
            }
        }
    }

    public static void scanSubtitles() {
        SubPicture picSrc;
        double fy;
        double fx;
        subPictures = new SubPicture[substream.getNumFrames()];
        double factTS = 1.0;
        factTS = convertFPS ? fpsSrc / fpsTrg : 1.0;
        if (!convertResolution && Core.getNumFrames() > 0) {
            resolutionTrg = Core.getResolution(Core.getSubPictureSrc((int)0).width, Core.getSubPictureSrc((int)0).height);
        }
        if (applyFreeScale) {
            fx = freeScaleX;
            fy = freeScaleY;
        } else {
            fx = 1.0;
            fy = 1.0;
        }
        int i = 0;
        while (i < subPictures.length) {
            double scaleY;
            double scaleX;
            picSrc = substream.getSubPicture(i);
            Core.subPictures[i] = picSrc.copy();
            long ts = picSrc.startTime;
            long te = picSrc.endTime;
            if (!convertFPS) {
                Core.subPictures[i].startTime = ts + (long)delayPTS;
                Core.subPictures[i].endTime = te + (long)delayPTS;
            } else {
                Core.subPictures[i].startTime = (long)((double)ts * factTS + 0.5) + (long)delayPTS;
                Core.subPictures[i].endTime = (long)((double)te * factTS + 0.5) + (long)delayPTS;
            }
            Core.subPictures[i].startTime = Core.syncTimePTS(Core.subPictures[i].startTime, fpsTrg);
            Core.subPictures[i].endTime = Core.syncTimePTS(Core.subPictures[i].endTime, fpsTrg);
            SubPicture picTrg = subPictures[i];
            switch (forceAll) {
                case SET: {
                    picTrg.isforced = true;
                    break;
                }
                case CLEAR: {
                    picTrg.isforced = false;
                }
            }
            if (convertResolution) {
                picTrg.width = Core.getResolution(resolutionTrg)[0];
                picTrg.height = Core.getResolution(resolutionTrg)[1];
                scaleX = (double)picTrg.width / (double)picSrc.width;
                scaleY = (double)picTrg.height / (double)picSrc.height;
            } else {
                picTrg.width = picSrc.width;
                picTrg.height = picSrc.height;
                scaleX = 1.0;
                scaleY = 1.0;
            }
            int w = (int)((double)picSrc.getImageWidth() * scaleX * fx + 0.5);
            if (w < 8) {
                w = picSrc.getImageWidth();
            } else if (w > picTrg.width) {
                w = picTrg.width;
            }
            int h = (int)((double)picSrc.getImageHeight() * scaleY * fy + 0.5);
            if (h < 8) {
                h = picSrc.getImageHeight();
            } else if (h > picTrg.height) {
                h = picTrg.height;
            }
            picTrg.setImageWidth(w);
            picTrg.setImageHeight(h);
            int xOfs = (int)((double)picSrc.getOfsX() * scaleX + 0.5);
            int spaceSrc = (int)((double)(picSrc.width - picSrc.getImageWidth()) * scaleX + 0.5);
            int spaceTrg = picTrg.width - w;
            if ((xOfs += (spaceTrg - spaceSrc) / 2) < 0) {
                xOfs = 0;
            } else if (xOfs + w > picTrg.width) {
                xOfs = picTrg.width - w;
            }
            picTrg.setOfsX(xOfs);
            int yOfs = (int)((double)picSrc.getOfsY() * scaleY + 0.5);
            spaceSrc = (int)((double)(picSrc.height - picSrc.getImageHeight()) * scaleY + 0.5);
            spaceTrg = picTrg.height - h;
            if ((yOfs += (spaceTrg - spaceSrc) / 2) + h > picTrg.height) {
                yOfs = picTrg.height - h;
            }
            picTrg.setOfsY(yOfs);
            ++i;
        }
        SubPicture picPrev = null;
        int i2 = 0;
        while (i2 < subPictures.length) {
            SubPicture picNext = i2 < subPictures.length - 1 ? subPictures[i2 + 1] : null;
            picSrc = subPictures[i2];
            Core.validateTimes(i2, subPictures[i2], picNext, picPrev);
            picPrev = picSrc;
            ++i2;
        }
    }

    public static void reScanSubtitles(Resolution resOld, double fpsTrgOld, int delayOld, boolean convertFpsOld, double fsXOld, double fsYOld) {
        SubPicture picOld;
        double factY;
        double factX;
        double fsYNew;
        double fsXNew;
        double factTS = 1.0;
        if (applyFreeScale) {
            fsXNew = freeScaleX;
            fsYNew = freeScaleY;
        } else {
            fsXNew = 1.0;
            fsYNew = 1.0;
        }
        factTS = convertFPS && !convertFpsOld ? fpsSrc / fpsTrg : (!convertFPS && convertFpsOld ? fpsTrgOld / fpsSrc : (convertFPS && convertFpsOld && fpsTrg != fpsTrgOld ? fpsTrgOld / fpsTrg : 1.0));
        if (!convertResolution && Core.getNumFrames() > 0) {
            resolutionTrg = Core.getResolution(Core.getSubPictureSrc((int)0).width, Core.getSubPictureSrc((int)0).height);
        }
        if (resOld != resolutionTrg) {
            int[] rOld = Core.getResolution(resOld);
            int[] rNew = Core.getResolution(resolutionTrg);
            factX = (double)rNew[0] / (double)rOld[0];
            factY = (double)rNew[1] / (double)rOld[1];
        } else {
            factX = 1.0;
            factY = 1.0;
        }
        int i = 0;
        while (i < subPictures.length) {
            double scaleY;
            double scaleX;
            picOld = subPictures[i];
            SubPicture picSrc = substream.getSubPicture(i);
            Core.subPictures[i] = picOld.copy();
            switch (forceAll) {
                case SET: {
                    Core.subPictures[i].isforced = true;
                    break;
                }
                case CLEAR: {
                    Core.subPictures[i].isforced = false;
                }
            }
            long ts = picOld.startTime;
            long te = picOld.endTime;
            if (factTS == 1.0) {
                Core.subPictures[i].startTime = ts - (long)delayOld + (long)delayPTS;
                Core.subPictures[i].endTime = te - (long)delayOld + (long)delayPTS;
            } else {
                Core.subPictures[i].startTime = (long)((double)ts * factTS + 0.5) - (long)delayOld + (long)delayPTS;
                Core.subPictures[i].endTime = (long)((double)te * factTS + 0.5) - (long)delayOld + (long)delayPTS;
            }
            Core.subPictures[i].startTime = Core.syncTimePTS(Core.subPictures[i].startTime, fpsTrg);
            Core.subPictures[i].endTime = Core.syncTimePTS(Core.subPictures[i].endTime, fpsTrg);
            if (convertResolution) {
                Core.subPictures[i].width = Core.getResolution(resolutionTrg)[0];
                Core.subPictures[i].height = Core.getResolution(resolutionTrg)[1];
                scaleX = (double)Core.subPictures[i].width / (double)picSrc.width;
                scaleY = (double)Core.subPictures[i].height / (double)picSrc.height;
            } else {
                Core.subPictures[i].width = picSrc.width;
                Core.subPictures[i].height = picSrc.height;
                scaleX = 1.0;
                scaleY = 1.0;
            }
            int w = (int)((double)picSrc.getImageWidth() * scaleX * fsXNew + 0.5);
            if (w < 8) {
                w = picSrc.getImageWidth();
            } else if (w > Core.subPictures[i].width) {
                w = Core.subPictures[i].width;
                fsXNew = (double)w / (double)picSrc.getImageWidth() / scaleX;
            }
            int h = (int)((double)picSrc.getImageHeight() * scaleY * fsYNew + 0.5);
            if (h < 8) {
                h = picSrc.getImageHeight();
            } else if (h > Core.subPictures[i].height) {
                h = Core.subPictures[i].height;
                fsYNew = (double)h / (double)picSrc.getImageHeight() / scaleY;
            }
            subPictures[i].setImageWidth(w);
            subPictures[i].setImageHeight(h);
            int xOfs = (int)((double)picOld.getOfsX() * factX + 0.5);
            if (fsXNew != fsXOld) {
                int spaceTrgOld = (int)((double)(picOld.width - picOld.getImageWidth()) * factX + 0.5);
                int spaceTrg = Core.subPictures[i].width - w;
                xOfs += (spaceTrg - spaceTrgOld) / 2;
            }
            if (xOfs < 0) {
                xOfs = 0;
            } else if (xOfs + w > Core.subPictures[i].width) {
                xOfs = Core.subPictures[i].width - w;
            }
            subPictures[i].setOfsX(xOfs);
            int yOfs = (int)((double)picOld.getOfsY() * factY + 0.5);
            if (fsYNew != fsYOld) {
                int spaceTrgOld = (int)((double)(picOld.height - picOld.getImageHeight()) * factY + 0.5);
                int spaceTrg = Core.subPictures[i].height - h;
                yOfs += (spaceTrg - spaceTrgOld) / 2;
            }
            if (yOfs < 0) {
                yOfs = 0;
            }
            if (yOfs + h > Core.subPictures[i].height) {
                yOfs = Core.subPictures[i].height - h;
            }
            subPictures[i].setOfsY(yOfs);
            double fx = factX * fsXNew / fsXOld;
            double fy = factY * fsYNew / fsYOld;
            if (Core.subPictures[i].erasePatch != null) {
                for (ErasePatch ep : Core.subPictures[i].erasePatch) {
                    ep.x = (int)((double)ep.x * fx + 0.5);
                    ep.y = (int)((double)ep.y * fy + 0.5);
                    ep.w = (int)((double)ep.w * fx + 0.5);
                    ep.h = (int)((double)ep.h * fy + 0.5);
                }
            }
            ++i;
        }
        SubPicture subPicPrev = null;
        int i2 = 0;
        while (i2 < subPictures.length) {
            SubPicture subPicNext = i2 < subPictures.length - 1 ? subPictures[i2 + 1] : null;
            picOld = subPictures[i2];
            Core.validateTimes(i2, subPictures[i2], subPicNext, subPicPrev);
            subPicPrev = picOld;
            ++i2;
        }
    }

    public static void convertSup(int index, int displayNum, int displayMax) throws CoreException {
        Core.convertSup(index, displayNum, displayMax, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertSup(int index, int displayNum, int displayMax, boolean skipScaling) throws CoreException {
        int h;
        int w;
        int startOfs = (int)substream.getStartOffset(index);
        SubPicture subPic = substream.getSubPicture(index);
        Core.printX("Decoding frame " + displayNum + "/" + displayMax + (substream == supXml ? "\n" : " at offset " + ToolBox.hex(startOfs, 8) + "\n"));
        Object object = semaphore;
        synchronized (object) {
            substream.decode(index);
            w = subPic.getImageWidth();
            h = subPic.getImageHeight();
            if (outMode == OutputMode.VOBSUB || outMode == OutputMode.SUPIFO) {
                Core.determineFramePal(index);
            }
            Core.updateTrgPic(index);
        }
        SubPicture picTrg = subPictures[index];
        picTrg.wasDecoded = true;
        int trgWidth = picTrg.getImageWidth();
        int trgHeight = picTrg.getImageHeight();
        if (trgWidth < 8 || trgHeight < 8 || w < 8 || h < 8) {
            trgWidth = w;
            trgHeight = h;
        }
        if (!skipScaling) {
            Bitmap tBm;
            Filter f;
            switch (scalingFilter) {
                case BELL: {
                    f = Filters.getBellFilter();
                    break;
                }
                case BICUBIC: {
                    f = Filters.getBiCubicFilter();
                    break;
                }
                case BSPLINE: {
                    f = Filters.getBSplineFilter();
                    break;
                }
                case HERMITE: {
                    f = Filters.getHermiteFilter();
                    break;
                }
                case LANCZOS3: {
                    f = Filters.getLanczos3Filter();
                    break;
                }
                case TRIANGLE: {
                    f = Filters.getTriangleFilter();
                    break;
                }
                case MITCHELL: {
                    f = Filters.getMitchellFilter();
                    break;
                }
                default: {
                    f = null;
                }
            }
            Palette tPal = trgPal;
            if (outMode == OutputMode.VOBSUB || outMode == OutputMode.SUPIFO) {
                tBm = w == trgWidth && h == trgHeight ? ((inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO) && paletteMode == PaletteMode.KEEP_EXISTING ? substream.getBitmap() : substream.getBitmap().convertLm(substream.getPalette(), alphaThr, lumThr)) : ((inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO) && paletteMode == PaletteMode.KEEP_EXISTING ? (f != null ? substream.getBitmap().scaleFilter(trgWidth, trgHeight, substream.getPalette(), f) : substream.getBitmap().scaleBilinear(trgWidth, trgHeight, substream.getPalette())) : (f != null ? substream.getBitmap().scaleFilterLm(trgWidth, trgHeight, substream.getPalette(), alphaThr, lumThr, f) : substream.getBitmap().scaleBilinearLm(trgWidth, trgHeight, substream.getPalette(), alphaThr, lumThr)));
            } else {
                tPal = substream.getPalette();
                if (w == trgWidth && h == trgHeight) {
                    tBm = substream.getBitmap();
                } else if (paletteMode == PaletteMode.KEEP_EXISTING) {
                    tBm = f != null ? substream.getBitmap().scaleFilter(trgWidth, trgHeight, substream.getPalette(), f) : substream.getBitmap().scaleBilinear(trgWidth, trgHeight, substream.getPalette());
                } else {
                    boolean dither = paletteMode == PaletteMode.CREATE_DITHERED;
                    PaletteBitmap pb = f != null ? substream.getBitmap().scaleFilter(trgWidth, trgHeight, substream.getPalette(), f, dither) : substream.getBitmap().scaleBilinear(trgWidth, trgHeight, substream.getPalette(), dither);
                    tBm = pb.bitmap;
                    tPal = pb.palette;
                }
            }
            if (picTrg.erasePatch != null) {
                trgBitmapUnpatched = new Bitmap(tBm);
                int col = tPal.getTransparentIndex();
                for (ErasePatch ep : picTrg.erasePatch) {
                    tBm.fillRect(ep.x, ep.y, ep.w, ep.h, col);
                }
            } else {
                trgBitmapUnpatched = tBm;
            }
            trgBitmap = tBm;
            trgPal = tPal;
        }
        if (cliMode) {
            Core.moveToBounds(picTrg, displayNum, cineBarFactor, moveOffsetX, moveOffsetY, moveModeX, moveModeY, cropOfsY);
        }
    }

    public static void writeSub(String fname) throws CoreException {
        String fnp;
        FilterOutputStream out = null;
        ArrayList<Integer> offsets = null;
        ArrayList<Integer> timestamps = null;
        int frameNum = 0;
        String fn = "";
        int maxNum = exportForced ? Core.countForcedIncluded() : Core.countIncluded();
        try {
            try {
                if (outMode == OutputMode.VOBSUB) {
                    fname = String.valueOf(ToolBox.stripExtension(fname)) + ".sub";
                    out = new BufferedOutputStream(new FileOutputStream(fname));
                    offsets = new ArrayList<Integer>();
                    timestamps = new ArrayList<Integer>();
                } else if (outMode == OutputMode.SUPIFO) {
                    fname = String.valueOf(ToolBox.stripExtension(fname)) + ".sup";
                    out = new BufferedOutputStream(new FileOutputStream(fname));
                } else if (outMode == OutputMode.BDSUP) {
                    fname = String.valueOf(ToolBox.stripExtension(fname)) + ".sup";
                    out = new BufferedOutputStream(new FileOutputStream(fname));
                } else {
                    fn = ToolBox.stripExtension(fname);
                    fname = String.valueOf(fn) + ".xml";
                }
                Core.printX("\nWriting " + fname + "\n");
                Core.resetErrors();
                Core.resetWarnings();
                int offset = 0;
                int i = 0;
                while (i < substream.getNumFrames()) {
                    if (Core.isCancelled()) {
                        throw new CoreException("Cancelled by user!");
                    }
                    Core.setProgress(i);
                    if (!(Core.subPictures[i].exclude || exportForced && !Core.subPictures[i].isforced)) {
                        byte[] buf;
                        if (outMode == OutputMode.VOBSUB) {
                            offsets.add(offset);
                            Core.convertSup(i, frameNum / 2 + 1, maxNum);
                            subVobTrg.copyInfo(subPictures[i]);
                            buf = SubDVD.createSubFrame(subVobTrg, trgBitmap);
                            out.write(buf);
                            offset += buf.length;
                            timestamps.add((int)Core.subPictures[i].startTime);
                        } else if (outMode == OutputMode.SUPIFO) {
                            Core.convertSup(i, frameNum / 2 + 1, maxNum);
                            subVobTrg.copyInfo(subPictures[i]);
                            buf = SupDVD.createSupFrame(subVobTrg, trgBitmap);
                            out.write(buf);
                        } else if (outMode == OutputMode.BDSUP) {
                            Core.subPictures[i].compNum = frameNum;
                            Core.convertSup(i, frameNum / 2 + 1, maxNum);
                            buf = SupBD.createSupFrame(subPictures[i], trgBitmap, trgPal);
                            out.write(buf);
                        } else {
                            Core.convertSup(i, frameNum / 2 + 1, maxNum);
                            fnp = SupXml.getPNGname(fn, i + 1);
                            out = new BufferedOutputStream(new FileOutputStream(fnp));
                            PngEncoderB pngEncoder = new PngEncoderB(trgBitmap.getImage(trgPal));
                            byte[] buf2 = pngEncoder.pngEncode(true);
                            out.write(buf2);
                            out.close();
                        }
                        frameNum += 2;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        boolean importedDVDPalette = inMode == InputMode.VOBSUB || inMode == InputMode.SUPIFO;
        Palette trgPallete = null;
        if (outMode == OutputMode.VOBSUB) {
            int[] ofs = new int[offsets.size()];
            int i = 0;
            while (i < ofs.length) {
                ofs[i] = (Integer)offsets.get(i);
                ++i;
            }
            int[] ts = new int[timestamps.size()];
            int i2 = 0;
            while (i2 < ts.length) {
                ts[i2] = (Integer)timestamps.get(i2);
                ++i2;
            }
            fname = String.valueOf(ToolBox.stripExtension(fname)) + ".idx";
            Core.printX("\nWriting " + fname + "\n");
            trgPallete = !importedDVDPalette || paletteMode != PaletteMode.KEEP_EXISTING ? currentDVDPalette : currentSourceDVDPalette;
            SubDVD.writeIdx(fname, subPictures[0], ofs, ts, trgPallete);
        } else if (outMode == OutputMode.XML) {
            Core.printX("\nWriting " + fname + "\n");
            SupXml.writeXml(fname, subPictures);
        } else if (outMode == OutputMode.SUPIFO) {
            trgPallete = !importedDVDPalette || paletteMode != PaletteMode.KEEP_EXISTING ? currentDVDPalette : currentSourceDVDPalette;
            fname = String.valueOf(ToolBox.stripExtension(fname)) + ".ifo";
            Core.printX("\nWriting " + fname + "\n");
            SupDVD.writeIFO(fname, subPictures[0], trgPallete);
        }
        if (trgPallete != null && writePGCEditPal) {
            fnp = String.valueOf(ToolBox.stripExtension(fname)) + ".txt";
            Core.printX("\nWriting " + fnp + "\n");
            Core.writePGCEditPal(fnp, trgPallete);
        }
        state = State.FINISHED;
    }

    public static double getDefaultFPS(Resolution r) {
        double fps;
        switch (Core.getResolution(r)[1]) {
            case 480: {
                fps = 29.97002997002997;
                break;
            }
            case 576: {
                fps = 25.0;
                break;
            }
            default: {
                fps = 23.976023976023978;
            }
        }
        return fps;
    }

    public static double getFPS(String s) {
        double d;
        if ((s = ToolBox.trim(s.toLowerCase())).equals("pal") || s.equals("25p") || s.equals("25")) {
            return 25.0;
        }
        if (s.equals("ntsc") || s.equals("30p") || s.equals("29.97") || s.equals("29.970")) {
            return 29.97002997002997;
        }
        if (s.equals("24p") || s.equals("23.976")) {
            return 23.976023976023978;
        }
        if (s.equals("23.975")) {
            return 23.975;
        }
        if (s.equals("24")) {
            return 24.0;
        }
        if (s.equals("50i") || s.equals("50")) {
            return 50.0;
        }
        if (s.equals("60i") || s.equals("59.94")) {
            return 59.94005994005994;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return -1.0;
        }
        if (Math.abs(d - 23.975) < 0.001) {
            return 23.975;
        }
        if (Math.abs(d - 23.976023976023978) < 0.001) {
            return 23.976023976023978;
        }
        if (Math.abs(d - 24.0) < 0.001) {
            return 23.976023976023978;
        }
        if (Math.abs(d - 25.0) < 0.001) {
            return 25.0;
        }
        if (Math.abs(d - 29.97002997002997) < 0.001) {
            return 29.97002997002997;
        }
        if (Math.abs(d - 59.94005994005994) < 0.001) {
            return 59.94005994005994;
        }
        if (Math.abs(d - 50.0) < 0.001) {
            return 50.0;
        }
        return d;
    }

    public static void moveAllThreaded(JFrame parent) throws Exception {
        progressMax = substream.getNumFrames();
        progressLast = 0;
        progress = new Progress((Frame)parent, true);
        progress.setMinMax(0, 100);
        progress.setTitle("Moving");
        progress.setText("Moving all captions");
        runType = RunType.MOVEALL;
        Thread t = new Thread(new Core());
        t.start();
        progress.setVisible(true);
        while (t.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        state = State.INACTIVE;
        Exception ex = threadException;
        if (ex != null) {
            throw ex;
        }
    }

    public static void moveAllToBounds() throws CoreException {
        String sy = null;
        switch (moveModeY) {
            case INSIDE: {
                sy = "inside";
                break;
            }
            case OUTSIDE: {
                sy = "outside";
            }
        }
        String sx = null;
        switch (moveModeX) {
            case CENTER: {
                sx = "center vertically";
                break;
            }
            case LEFT: {
                sx = "left";
                break;
            }
            case RIGHT: {
                sx = "right";
            }
        }
        String s = "Moving captions ";
        if (sy != null) {
            s = String.valueOf(s) + sy + " cinemascope bars";
            if (sx != null) {
                s = String.valueOf(s) + " and to the " + sx;
            }
            Core.print(String.valueOf(s) + ".\n");
        } else if (sx != null) {
            Core.print(String.valueOf(s) + "to the " + sx + ".\n");
        }
        if (!cliMode) {
            int idx = 0;
            while (idx < subPictures.length) {
                Core.setProgress(idx);
                if (!Core.subPictures[idx].wasDecoded) {
                    Core.convertSup(idx, idx + 1, subPictures.length, true);
                }
                Core.moveToBounds(subPictures[idx], idx + 1, cineBarFactor, moveOffsetX, moveOffsetY, moveModeX, moveModeY, cropOfsY);
                ++idx;
            }
        }
    }

    public static void moveToBounds(SubPicture pic, int idx, double barFactor, int offsetX, int offsetY, MoveModeX mmx, MoveModeY mmy, int cropOffsetY) {
        int barHeight = (int)((double)pic.height * barFactor + 0.5);
        int y1 = pic.getOfsY();
        int h = pic.height;
        int w = pic.width;
        int hi = pic.getImageHeight();
        int wi = pic.getImageWidth();
        int y2 = y1 + hi;
        if (mmy != MoveModeY.KEEP) {
            CaptionType c = y1 < h / 2 && y2 < h / 2 ? CaptionType.UP : (y1 > h / 2 && y2 > h / 2 ? CaptionType.DOWN : CaptionType.FULL);
            switch (c) {
                case FULL: {
                    Core.printWarn("Caption " + idx + " not moved (too large)\n");
                    break;
                }
                case UP: {
                    if (mmy == MoveModeY.INSIDE) {
                        pic.setOfsY(barHeight + offsetY);
                    } else {
                        pic.setOfsY(offsetY);
                    }
                    Core.print("Caption " + idx + " moved to y position " + pic.getOfsY() + "\n");
                    break;
                }
                case DOWN: {
                    if (mmy == MoveModeY.INSIDE) {
                        pic.setOfsY(h - barHeight - offsetY - hi);
                    } else {
                        pic.setOfsY(h - offsetY - hi);
                    }
                    Core.print("Caption " + idx + " moved to y position " + pic.getOfsY() + "\n");
                }
            }
            if (pic.getOfsY() < cropOffsetY) {
                pic.getOfsY();
            } else {
                int yMax = pic.height - pic.getImageHeight() - cropOffsetY;
                if (pic.getOfsY() > yMax) {
                    pic.setOfsY(yMax);
                }
            }
        }
        switch (mmx) {
            case LEFT: {
                if (w - wi >= offsetX) {
                    pic.setOfsX(offsetX);
                    break;
                }
                pic.setOfsX((w - wi) / 2);
                break;
            }
            case RIGHT: {
                if (w - wi >= offsetX) {
                    pic.setOfsX(w - wi - offsetX);
                    break;
                }
                pic.setOfsX((w - wi) / 2);
                break;
            }
            case CENTER: {
                pic.setOfsX((w - wi) / 2);
            }
        }
    }

    public static void print(String s) {
        if (verbatim) {
            if (mainFrame != null) {
                mainFrame.printOut(s);
            } else {
                System.out.print(s);
            }
        }
    }

    public static void printX(String s) {
        if (mainFrame != null) {
            mainFrame.printOut(s);
        } else {
            System.out.print(s);
        }
    }

    public static void printErr(String s) {
        ++errors;
        s = "ERROR: " + s;
        if (mainFrame != null) {
            mainFrame.printErr(s);
        } else {
            System.out.print(s);
        }
    }

    public static void printWarn(String s) {
        ++warnings;
        s = "WARNING: " + s;
        if (mainFrame != null) {
            mainFrame.printWarn(s);
        } else {
            System.out.print(s);
        }
    }

    public static void writePGCEditPal(String fname, Palette p) throws CoreException {
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new FileWriter(fname));
                out.write("# Palette file for PGCEdit - colors given as R,G,B components (0..255)");
                out.newLine();
                int i = 0;
                while (i < p.getSize()) {
                    int[] rgb = p.getRGB(i);
                    out.write("Color " + i + "=" + rgb[0] + ", " + rgb[1] + ", " + rgb[2]);
                    out.newLine();
                    ++i;
                }
            }
            catch (IOException ex) {
                throw new CoreException(ex.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static int countForcedIncluded() {
        int n = 0;
        SubPicture[] subPictureArray = subPictures;
        int n2 = subPictures.length;
        int n3 = 0;
        while (n3 < n2) {
            SubPicture pic = subPictureArray[n3];
            if (pic.isforced && !pic.exclude) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private static int countIncluded() {
        int n = 0;
        SubPicture[] subPictureArray = subPictures;
        int n2 = subPictures.length;
        int n3 = 0;
        while (n3 < n2) {
            SubPicture pic = subPictureArray[n3];
            if (!pic.exclude) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static int[] getLumThr() {
        return lumThr;
    }

    public static void setLumThr(int[] lt) {
        lumThr = lt;
    }

    public static int getAlphaThr() {
        return alphaThr;
    }

    public static void setAlphaThr(int at) {
        alphaThr = at;
    }

    public static boolean isReady() {
        return ready;
    }

    public static void setReady(boolean r) {
        ready = r;
    }

    public static Resolution getOutputResolution() {
        return resolutionTrg;
    }

    public static void setOutputResolution(Resolution r) {
        resolutionTrg = r;
        if (props == null) {
            resolutionTrgSet = true;
        }
    }

    public static void storeOutputResolution(Resolution r) {
        props.set("resolutionTrg", Core.getResolutionName(r));
    }

    public static boolean getConvertFPSdefault() {
        return false;
    }

    public static boolean getConvertResolutionDefault() {
        return false;
    }

    public static Resolution getResolutionDefault() {
        return resolutionTrgDefault;
    }

    public static double getFpsSrcDefault() {
        return 23.976023976023978;
    }

    public static double getFpsTrgDefault() {
        return 25.0;
    }

    public static int getDelayPTSdefault() {
        return 0;
    }

    public static boolean getFixShortFramesDefault() {
        return false;
    }

    public static int getMinTimePTSdefault() {
        return 45000;
    }

    public static boolean getApplyFreeScaleDefault() {
        return false;
    }

    public static double getFreeScaleXdefault() {
        return 1.0;
    }

    public static double getFreeScaleYdefault() {
        return 1.0;
    }

    public static boolean restoreConvertFPS() {
        return props.get("convertFPS", convertFPS);
    }

    public static boolean restoreConvertResolution() {
        return props.get("convertResolution", convertResolution);
    }

    public static Resolution restoreResolution() {
        String s = props.get("resolutionTrg", Core.getResolutionName(resolutionTrg));
        Resolution[] resolutionArray = Resolution.values();
        int n = resolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution r = resolutionArray[n2];
            if (Core.getResolutionName(r).equalsIgnoreCase(s)) {
                return r;
            }
            ++n2;
        }
        return resolutionTrg;
    }

    public static double restoreFpsSrc() {
        return Core.getFPS(props.get("fpsSrc", String.valueOf(fpsSrc)));
    }

    public static double restoreFpsTrg() {
        return Core.getFPS(props.get("fpsTrg", String.valueOf(fpsTrg)));
    }

    public static int restoreDelayPTS() {
        return props.get("delayPTS", delayPTS);
    }

    public static boolean restoreFixShortFrames() {
        return props.get("fixShortFrames", fixShortFrames);
    }

    public static int restoreMinTimePTS() {
        return props.get("minTimePTS", minTimePTS);
    }

    public static boolean restoreApplyFreeScale() {
        return props.get("applyFreeScale", applyFreeScale);
    }

    public static double restoreFreeScaleX() {
        return props.get("freeScaleX", freeScaleX);
    }

    public static double restoreFreeScaleY() {
        return props.get("freeScaleY", freeScaleY);
    }

    public static Resolution getResolution(int w, int h) {
        if (w <= resolutions[0][0] && h <= resolutions[0][1]) {
            return Resolution.NTSC;
        }
        if (w <= resolutions[1][0] && h <= resolutions[1][1]) {
            return Resolution.PAL;
        }
        if (w <= resolutions[2][0] && h <= resolutions[2][1]) {
            return Resolution.HD_720;
        }
        if (w <= resolutions[3][0] && h <= resolutions[3][1]) {
            return Resolution.HD_1440x1080;
        }
        if (w <= resolutions[3][0] && h <= resolutions[3][1]) {
            return Resolution.HD_1440x1080;
        }
        return Resolution.HD_1080;
    }

    public static void cancel() {
        state = State.CANCELED;
    }

    public static boolean isCancelled() {
        return state == State.CANCELED;
    }

    public static State getStatus() {
        return state;
    }

    public static boolean getConvertFPS() {
        return convertFPS;
    }

    public static void setConvertFPS(boolean b) {
        convertFPS = b;
        if (props == null) {
            convertFpsSet = true;
        }
    }

    public static void storeConvertFPS(boolean b) {
        props.set("convertFPS", b);
    }

    public static boolean getConvertResolution() {
        return convertResolution;
    }

    public static void setConvertResolution(boolean b) {
        convertResolution = b;
        if (props == null) {
            convertResolutionSet = true;
        }
    }

    public static void storeConvertResolution(boolean b) {
        props.set("convertResolution", b);
    }

    public static boolean getExportForced() {
        return exportForced;
    }

    public static void setExportForced(boolean b) {
        exportForced = b;
    }

    public static SetState getForceAll() {
        return forceAll;
    }

    public static void setForceAll(SetState f) {
        forceAll = f;
    }

    public static double getFPSSrc() {
        return fpsSrc;
    }

    public static void setFPSSrc(double src) {
        fpsSrc = src;
        if (props == null) {
            fpsSrcSet = true;
            fpsSrcCertain = true;
        }
    }

    public static void storeFPSSrc(double src) {
        props.set("fpsSrc", src);
    }

    public static double getFPSTrg() {
        return fpsTrg;
    }

    public static void setFPSTrg(double trg) {
        fpsTrg = trg;
        delayPTS = (int)Core.syncTimePTS(delayPTS, trg);
        minTimePTS = (int)Core.syncTimePTS(minTimePTS, trg);
        if (props == null) {
            fpsTrgSet = true;
        }
    }

    public static void storeFPSTrg(double trg) {
        props.set("fpsTrg", trg);
    }

    public static int getDelayPTS() {
        return delayPTS;
    }

    public static void setDelayPTS(int delay) {
        delayPTS = delay;
        if (props == null) {
            delayPtsSet = true;
        }
    }

    public static void storeDelayPTS(int delay) {
        props.set("delayPTS", delay);
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static void setMainFrame(MainFrame mf) {
        mainFrame = mf;
    }

    public static int getErrors() {
        return errors;
    }

    public static void resetErrors() {
        errors = 0;
    }

    public static int getWarnings() {
        return warnings;
    }

    public static void resetWarnings() {
        warnings = 0;
    }

    public static void setProgress(int p) {
        int val;
        if (progress != null && (val = (int)((long)p * 100L / (long)progressMax)) > progressLast) {
            progressLast = val;
            progress.setProgress(val);
        }
    }

    public static String getOutputFormatName(OutputMode m) {
        return modes[m.ordinal()];
    }

    public static OutputMode getOutputMode() {
        return outMode;
    }

    public static void setOutputMode(OutputMode m) {
        if (props != null) {
            props.set("outputMode", Core.getOutputFormatName(m));
        } else {
            outModeSet = true;
        }
        outMode = m;
    }

    public static InputMode getInputMode() {
        return inMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getSrcImage() {
        Object object = semaphore;
        synchronized (object) {
            return substream.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getSrcImage(int idx) throws CoreException {
        Object object = semaphore;
        synchronized (object) {
            substream.decode(idx);
            return substream.getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getTrgImage() {
        Object object = semaphore;
        synchronized (object) {
            return trgBitmap.getImage(trgPal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getTrgImagePatched(SubPicture pic) {
        Object object = semaphore;
        synchronized (object) {
            if (pic.erasePatch != null) {
                Bitmap trgBitmapPatched = new Bitmap(trgBitmapUnpatched);
                int col = trgPal.getTransparentIndex();
                for (ErasePatch ep : pic.erasePatch) {
                    trgBitmapPatched.fillRect(ep.x, ep.y, ep.w, ep.h, col);
                }
                return trgBitmapPatched.getImage(trgPal);
            }
            return trgBitmapUnpatched.getImage(trgPal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgWidth(int index) {
        Object object = semaphore;
        synchronized (object) {
            return Core.subPictures[index].width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgHeight(int index) {
        Object object = semaphore;
        synchronized (object) {
            return Core.subPictures[index].height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgImgWidth(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getImageWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgImgHeight(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getImageHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getTrgExcluded(int index) {
        Object object = semaphore;
        synchronized (object) {
            return Core.subPictures[index].exclude;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgOfsX(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getOfsX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTrgOfsY(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index].getOfsY();
        }
    }

    public static int getNumFrames() {
        if (substream == null) {
            return 0;
        }
        return substream.getNumFrames();
    }

    public static int getNumForcedFrames() {
        if (substream == null) {
            return 0;
        }
        return substream.getNumForcedFrames();
    }

    public static String getTrgInfoStr(int index) {
        SubPicture pic = subPictures[index];
        String text = "screen size: " + Core.getTrgWidth(index) + "x" + Core.getTrgHeight(index) + "    ";
        text = String.valueOf(text) + "image size: " + Core.getTrgImgWidth(index) + "x" + Core.getTrgImgHeight(index) + "    ";
        text = String.valueOf(text) + "pos: (" + pic.getOfsX() + "," + pic.getOfsY() + ") - (" + (pic.getOfsX() + Core.getTrgImgWidth(index)) + "," + (pic.getOfsY() + Core.getTrgImgHeight(index)) + ")    ";
        text = String.valueOf(text) + "start: " + ToolBox.ptsToTimeStr(pic.startTime) + "    ";
        text = String.valueOf(text) + "end: " + ToolBox.ptsToTimeStr(pic.endTime) + "    ";
        text = String.valueOf(text) + "forced: " + (pic.isforced ? "yes" : "no");
        return text;
    }

    public static String getSrcInfoStr(int index) {
        SubPicture pic = substream.getSubPicture(index);
        String text = "screen size: " + pic.width + "x" + pic.height + "    ";
        text = String.valueOf(text) + "image size: " + pic.getImageWidth() + "x" + pic.getImageHeight() + "    ";
        text = String.valueOf(text) + "pos: (" + pic.getOfsX() + "," + pic.getOfsY() + ") - (" + (pic.getOfsX() + pic.getImageWidth()) + "," + (pic.getOfsY() + pic.getImageHeight()) + ")    ";
        text = String.valueOf(text) + "start: " + ToolBox.ptsToTimeStr(pic.startTime) + "    ";
        text = String.valueOf(text) + "end: " + ToolBox.ptsToTimeStr(pic.endTime) + "    ";
        text = String.valueOf(text) + "forced: " + (pic.isforced ? "yes" : "no");
        return text;
    }

    public static int[] getResolution(Resolution r) {
        return resolutions[r.ordinal()];
    }

    public static String getResolutionName(Resolution r) {
        return resolutionNames[r.ordinal()];
    }

    public static String getResolutionNameXml(Resolution r) {
        return resolutionNamesXml[r.ordinal()];
    }

    public static Palette getCurrentDVDPalette() {
        return currentDVDPalette;
    }

    public static void setCurrentDVDPalette(Palette pal) {
        currentDVDPalette = pal;
    }

    public static Palette getDefaultDVDPalette() {
        return defaultDVDPalette;
    }

    public static int getLanguageIdx() {
        return languageIdx;
    }

    public static void setLanguageIdx(int idx) {
        languageIdx = idx;
    }

    public static boolean getFixShortFrames() {
        return fixShortFrames;
    }

    public static void setFixShortFrames(boolean b) {
        fixShortFrames = b;
        if (props == null) {
            fixShortFramesSet = true;
        }
    }

    public static void storeFixShortFrames(boolean b) {
        props.set("fixShortFrames", b);
    }

    public static int getMinTimePTS() {
        return minTimePTS;
    }

    public static void setMinTimePTS(int t) {
        minTimePTS = t;
        if (props == null) {
            minTimePtsSet = true;
        }
    }

    public static void storeMinTimePTS(int t) {
        props.set("minTimePTS", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubPicture getSubPictureTrg(int index) {
        Object object = semaphore;
        synchronized (object) {
            return subPictures[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubPicture getSubPictureSrc(int index) {
        Object object = semaphore;
        synchronized (object) {
            return substream.getSubPicture(index);
        }
    }

    public static boolean getSwapCrCb() {
        return swapCrCb;
    }

    public static void setSwapCrCb(boolean b) {
        swapCrCb = b;
    }

    public static String getProgName() {
        return progName;
    }

    public static String getProgVerName() {
        return progNameVer;
    }

    public static String getAuthorDate() {
        return authorDate;
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static void setCropOfsY(int ofs) {
        cropOfsY = ofs;
    }

    public static int getCropOfsY() {
        return cropOfsY;
    }

    public static boolean usesBT601() {
        return useBT601;
    }

    public static PaletteMode getPaletteMode() {
        return paletteMode;
    }

    public static void setPaletteMode(PaletteMode m) {
        if (props != null) {
            props.set("paletteMode", Core.getPaletteModeName(m));
        } else {
            paletteModeSet = true;
        }
        paletteMode = m;
    }

    public static String getPaletteModeName(PaletteMode m) {
        return paletteModeNames[m.ordinal()];
    }

    public static boolean getVerbatim() {
        return verbatim;
    }

    public static void setVerbatim(boolean e) {
        verbatim = e;
        if (props != null) {
            props.set("verbatim", e ? "true" : "false");
        } else {
            verbatimSet = true;
        }
    }

    public static void setProgressMax(int max) {
        progressMax = max;
    }

    public static boolean getKeepFps() {
        return keepFps;
    }

    public static void setKeepFps(boolean e) {
        keepFps = e;
    }

    public static boolean getFpsSrcCertain() {
        return fpsSrcCertain;
    }

    public static void setFpsSrcCertain(boolean c) {
        fpsSrcCertain = c;
    }

    public static ScalingFilters getScalingFilter() {
        return scalingFilter;
    }

    public static void setScalingFilter(ScalingFilters f) {
        if (props != null) {
            props.set("filter", Core.getScalingFilterName(f));
        } else {
            scalingFilterSet = true;
        }
        scalingFilter = f;
    }

    public static String getScalingFilterName(ScalingFilters f) {
        return scalingFilters[f.ordinal()];
    }

    public static int getMergePTSdiff() {
        return mergePTSdiff;
    }

    public static void setMergePTSdiff(int d) {
        mergePTSdiff = d;
        if (props != null) {
            props.set("mergePTSdiff", d);
        } else {
            mergePTSdiffSet = true;
        }
    }

    public static int getAlphaCrop() {
        return alphaCrop;
    }

    public static void setAlphaCrop(int a) {
        alphaCrop = a;
        if (props != null) {
            props.set("alphaCrop", a);
        } else {
            alphaCropSet = true;
        }
    }

    public static boolean getApplyFreeScale() {
        return applyFreeScale;
    }

    public static void setApplyFreeScale(boolean f) {
        applyFreeScale = f;
        if (props == null) {
            applyFreeScaleSet = true;
        }
    }

    public static void storeApplyFreeScale(boolean f) {
        props.set("applyFreeScale", f);
    }

    public static double getFreeScaleX() {
        return freeScaleX;
    }

    public static double getFreeScaleY() {
        return freeScaleY;
    }

    public static void setFreeScale(double x, double y) {
        if (x < 0.5) {
            x = 0.5;
        } else if (x > 2.0) {
            x = 2.0;
        }
        freeScaleX = x;
        if (y < 0.5) {
            y = 0.5;
        } else if (y > 2.0) {
            y = 2.0;
        }
        freeScaleY = y;
    }

    public static void storeFreeScale(double x, double y) {
        if (x < 0.5) {
            x = 0.5;
        } else if (x > 2.0) {
            x = 2.0;
        }
        props.set("freeScaleX", x);
        if (y < 0.5) {
            y = 0.5;
        } else if (y > 2.0) {
            y = 2.0;
        }
        props.set("freeScaleY", y);
    }

    public static void setMoveModeY(MoveModeY m) {
        moveModeY = m;
        moveCaptions = moveModeY != MoveModeY.KEEP || moveModeX != MoveModeX.KEEP;
    }

    public static MoveModeY getMoveModeY() {
        return moveModeY;
    }

    public static void setMoveModeX(MoveModeX m) {
        moveModeX = m;
        moveCaptions = moveModeY != MoveModeY.KEEP || moveModeX != MoveModeX.KEEP;
    }

    public static MoveModeX getMoveModeX() {
        return moveModeX;
    }

    public static void setCineBarFactor(double f) {
        cineBarFactor = f;
    }

    public static void setMoveOffsetY(int ofs) {
        moveOffsetY = ofs;
    }

    public static int getMoveOffsetY() {
        return moveOffsetY;
    }

    public static void setMoveOffsetX(int ofs) {
        moveOffsetX = ofs;
    }

    public static int getMoveOffsetX() {
        return moveOffsetX;
    }

    public static boolean getMoveCaptions() {
        return moveCaptions;
    }

    public static void setMoveCaptions(boolean m) {
        moveCaptions = m;
    }

    public static StreamID getCurrentStreamID() {
        return currentStreamID;
    }

    public static void setCurrentStreamID(StreamID sid) {
        currentStreamID = sid;
    }

    public static boolean getWritePGCEditPal() {
        return writePGCEditPal;
    }

    public static void setWritePGCEditPal(boolean e) {
        writePGCEditPal = e;
        if (props != null) {
            props.set("writePGCEditPal", e ? "true" : "false");
        } else {
            writePGCEditPalSet = true;
        }
    }

    public static boolean getFixZeroAlpha() {
        return fixZeroAlpha;
    }

    public static void setFixZeroAlpha(boolean e) {
        fixZeroAlpha = e;
        if (props != null) {
            props.set("fixZeroAlpha", e ? "true" : "false");
        } else {
            fixZeroAlphaSet = true;
        }
    }

    public static Palette getDefSrcDVDPalette() {
        return defaultSourceDVDPalette;
    }

    public static Palette getCurSrcDVDPalette() {
        return currentSourceDVDPalette;
    }

    public static void setCurSrcDVDPalette(Palette pal) {
        currentSourceDVDPalette = pal;
        SubstreamDVD substreamDVD = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDVD = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDVD = supDVD;
        }
        substreamDVD.setSrcPalette(currentSourceDVDPalette);
    }

    public static int[] getFramePal(int index) {
        SubstreamDVD substreamDVD = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDVD = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDVD = supDVD;
        }
        if (substreamDVD != null) {
            return substreamDVD.getFramePal(index);
        }
        return null;
    }

    public static int[] getFrameAlpha(int index) {
        SubstreamDVD substreamDVD = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDVD = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDVD = supDVD;
        }
        if (substreamDVD != null) {
            return substreamDVD.getFrameAlpha(index);
        }
        return null;
    }

    public static int[] getOriginalFramePal(int index) {
        SubstreamDVD substreamDVD = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDVD = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDVD = supDVD;
        }
        if (substreamDVD != null) {
            return substreamDVD.getOriginalFramePal(index);
        }
        return null;
    }

    public static int[] getOriginalFrameAlpha(int index) {
        SubstreamDVD substreamDVD = null;
        if (inMode == InputMode.VOBSUB) {
            substreamDVD = subDVD;
        } else if (inMode == InputMode.SUPIFO) {
            substreamDVD = supDVD;
        }
        if (substreamDVD != null) {
            return substreamDVD.getOriginalFrameAlpha(index);
        }
        return null;
    }

    private static enum CaptionType {
        UP,
        DOWN,
        FULL;

    }

    public static enum InputMode {
        VOBSUB,
        BDSUP,
        XML,
        HDDVDSUP,
        SUPIFO;

    }

    public static enum MoveModeX {
        KEEP,
        CENTER,
        LEFT,
        RIGHT;

    }

    public static enum MoveModeY {
        KEEP,
        INSIDE,
        OUTSIDE;

    }

    public static enum OutputMode {
        VOBSUB,
        SUPIFO,
        BDSUP,
        XML;

    }

    public static enum PaletteMode {
        KEEP_EXISTING,
        CREATE_NEW,
        CREATE_DITHERED;

    }

    public static enum Resolution {
        NTSC,
        PAL,
        HD_720,
        HD_1440x1080,
        HD_1080;

    }

    public static enum RunType {
        READSUP,
        READXML,
        READVOBSUB,
        READSUPIFO,
        CREATESUB,
        CREATESUP,
        MOVEALL;

    }

    public static enum ScalingFilters {
        BILINEAR,
        TRIANGLE,
        BICUBIC,
        BELL,
        BSPLINE,
        HERMITE,
        LANCZOS3,
        MITCHELL;

    }

    public static enum SetState {
        KEEP,
        SET,
        CLEAR;

    }

    public static enum State {
        INACTIVE,
        ACTIVE,
        CANCELED,
        FINISHED;

    }

    public static enum StreamID {
        BDSUP,
        SUP,
        DVDSUB,
        XML,
        IFO,
        IDX,
        UNKNOWN;

    }
}

