/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.EditPane;
import deadbeef.GUI.SelectListener;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.ErasePatch;
import deadbeef.SupTools.SubPicture;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditDialog
extends JDialog
implements SelectListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelUp = null;
    private JPanel jPanelLayout = null;
    private JPanel jPanelOffsets = null;
    private JPanel jPanelTimes = null;
    private JPanel jPanelButtons = null;
    private JPanel jPanelCheck = null;
    private JLabel jLabelInfo = null;
    private JButton jButtonPrev = null;
    private JButton jButtonNext = null;
    private JButton jButtonStoreNext = null;
    private JButton jButtonStorePrev = null;
    private EditPane jPanelPreview = null;
    private JSlider jSliderVertical = null;
    private JSlider jSliderHorizontal = null;
    private JLabel jLabelX = null;
    private JLabel jLabelY = null;
    private JButton jButtonCancel = null;
    private JButton jButtonOk = null;
    private JTextField jTextFieldX = null;
    private JTextField jTextFieldY = null;
    private JButton jButtonCenter = null;
    private JLabel jLabelStart = null;
    private JLabel jLabelEnd = null;
    private JLabel jLabelDuration = null;
    private JTextField jTextFieldStart = null;
    private JTextField jTextFieldEnd = null;
    private JTextField jTextFieldDuration = null;
    private JButton jButtonMin = null;
    private JButton jButtonMax = null;
    private JButton jButtonTop = null;
    private JButton jButtonBottom = null;
    private JButton jButtonStore = null;
    private JCheckBox jCheckBoxForced = null;
    private JCheckBox jCheckBoxExclude = null;
    private JPanel jPanelPatches = null;
    private JButton jButtonAddPatch = null;
    private JButton jButtonUndoPatch = null;
    private JButton jButtonUndoAllPatches = null;
    private static int miniWidth = 768;
    private static int miniHeight = 432;
    private final Color errBgnd = new Color(-1987412);
    private final Color warnBgnd = new Color(-64);
    private final Color okBgnd = UIManager.getColor("TextField.background");
    private BufferedImage image = null;
    private boolean enableSliders = false;
    private int index;
    private SubPicture subPic;
    private SubPicture subPicNext;
    private SubPicture subPicPrev;
    private int frameTime;
    private volatile boolean edited = false;
    private volatile boolean isReady = false;

    public EditDialog(Frame owner, boolean modal) {
        super(owner, modal);
        Core.Resolution r = Core.getOutputResolution();
        switch (r) {
            case NTSC: 
            case PAL: {
                miniWidth = 720;
                miniHeight = 405;
                break;
            }
            default: {
                miniWidth = 640;
                miniHeight = 320;
            }
        }
        this.initialize();
        Point p = owner.getLocation();
        this.setLocation(p.x + owner.getWidth() / 2 - this.getWidth() / 2, p.y + owner.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        this.frameTime = (int)(90000.0 / Core.getFPSTrg());
        this.jPanelPreview.setAllowSelection(true);
        this.jPanelPreview.addSelectListener(this);
    }

    private void initialize() {
        this.setSize(miniWidth + 36, miniHeight + 280);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditDialog.this.dispose();
            }
        });
    }

    private void setEdited(boolean e) {
        this.edited = e;
        this.jButtonStore.setEnabled(e);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelUp = new GridBagConstraints();
            gridBagPanelUp.gridx = 0;
            gridBagPanelUp.anchor = 18;
            gridBagPanelUp.weightx = 1.0;
            gridBagPanelUp.weighty = 1.0;
            gridBagPanelUp.gridwidth = 2;
            gridBagPanelUp.fill = 2;
            gridBagPanelUp.gridy = 0;
            GridBagConstraints gridBagPanelLayout = new GridBagConstraints();
            gridBagPanelLayout.gridx = 0;
            gridBagPanelLayout.anchor = 18;
            gridBagPanelLayout.weightx = 1.0;
            gridBagPanelLayout.weighty = 1.0;
            gridBagPanelLayout.fill = 2;
            gridBagPanelLayout.gridy = 1;
            gridBagPanelLayout.gridwidth = 2;
            GridBagConstraints gridBagPanelTimes = new GridBagConstraints();
            gridBagPanelTimes.gridx = 0;
            gridBagPanelTimes.anchor = 18;
            gridBagPanelTimes.weightx = 1.0;
            gridBagPanelTimes.weighty = 1.0;
            gridBagPanelTimes.fill = 2;
            gridBagPanelTimes.gridy = 2;
            GridBagConstraints gridBagPanelOffsets = new GridBagConstraints();
            gridBagPanelOffsets.gridx = 1;
            gridBagPanelOffsets.anchor = 18;
            gridBagPanelOffsets.weightx = 1.0;
            gridBagPanelOffsets.weighty = 1.0;
            gridBagPanelOffsets.fill = 1;
            gridBagPanelOffsets.gridy = 2;
            GridBagConstraints gridBagPanelCheck = new GridBagConstraints();
            gridBagPanelCheck.gridx = 0;
            gridBagPanelCheck.fill = 1;
            gridBagPanelCheck.anchor = 18;
            gridBagPanelCheck.weightx = 1.0;
            gridBagPanelCheck.weighty = 1.0;
            gridBagPanelCheck.gridy = 3;
            GridBagConstraints gridBagPanelPatches = new GridBagConstraints();
            gridBagPanelPatches.gridx = 1;
            gridBagPanelPatches.fill = 1;
            gridBagPanelPatches.anchor = 18;
            gridBagPanelPatches.weightx = 1.0;
            gridBagPanelPatches.weighty = 1.0;
            gridBagPanelPatches.gridy = 3;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.fill = 2;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 1.0;
            gridBagPanelButtons.gridy = 4;
            gridBagPanelButtons.gridwidth = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelUp(), gridBagPanelUp);
            this.jContentPane.add((Component)this.getJPanelLayout(), gridBagPanelLayout);
            this.jContentPane.add((Component)this.getJPanelOffsets(), gridBagPanelOffsets);
            this.jContentPane.add((Component)this.getJPanelTimes(), gridBagPanelTimes);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
            this.jContentPane.add((Component)this.getJPanelCheck(), gridBagPanelCheck);
            this.jContentPane.add((Component)this.getJPanelPatches(), gridBagPanelPatches);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelUp() {
        if (this.jPanelUp == null) {
            GridBagConstraints gridBagButtonStorePrev = new GridBagConstraints();
            gridBagButtonStorePrev.gridx = 1;
            gridBagButtonStorePrev.gridy = 0;
            gridBagButtonStorePrev.anchor = 18;
            gridBagButtonStorePrev.insets = new Insets(2, 4, 2, 6);
            GridBagConstraints gridBagButtonStoreNext = new GridBagConstraints();
            gridBagButtonStoreNext.gridx = 2;
            gridBagButtonStoreNext.gridy = 0;
            gridBagButtonStoreNext.anchor = 18;
            gridBagButtonStoreNext.insets = new Insets(2, 4, 2, 12);
            GridBagConstraints gridBagButtonNext = new GridBagConstraints();
            gridBagButtonNext.gridx = 4;
            gridBagButtonNext.anchor = 18;
            gridBagButtonNext.insets = new Insets(2, 4, 2, 6);
            gridBagButtonNext.gridy = 0;
            GridBagConstraints gridBagButtonPrev = new GridBagConstraints();
            gridBagButtonPrev.gridx = 3;
            gridBagButtonPrev.anchor = 18;
            gridBagButtonPrev.insets = new Insets(2, 4, 2, 4);
            gridBagButtonPrev.gridy = 0;
            GridBagConstraints gridBagInfo = new GridBagConstraints();
            gridBagInfo.weightx = 1.0;
            gridBagInfo.anchor = 17;
            gridBagInfo.insets = new Insets(4, 6, 0, 4);
            gridBagInfo.weighty = 1.0;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setText("Info");
            this.jPanelUp = new JPanel();
            this.jPanelUp.setPreferredSize(new Dimension(400, 25));
            this.jPanelUp.setMinimumSize(new Dimension(400, 25));
            this.jPanelUp.setLayout(new GridBagLayout());
            this.jPanelUp.add((Component)this.jLabelInfo, gridBagInfo);
            this.jPanelUp.add((Component)this.getJButtonPrev(), gridBagButtonPrev);
            this.jPanelUp.add((Component)this.getJButtonNext(), gridBagButtonNext);
            this.jPanelUp.add((Component)this.getJButtonStoreNext(), gridBagButtonStoreNext);
            this.jPanelUp.add((Component)this.getJButtonStorePrev(), gridBagButtonStorePrev);
        }
        return this.jPanelUp;
    }

    private JPanel getJPanelLayout() {
        if (this.jPanelLayout == null) {
            GridBagConstraints gridBagSliderHorizontal = new GridBagConstraints();
            gridBagSliderHorizontal.fill = 2;
            gridBagSliderHorizontal.gridy = 1;
            gridBagSliderHorizontal.weightx = 1.0;
            gridBagSliderHorizontal.gridx = 0;
            GridBagConstraints gridBagSliderVertical = new GridBagConstraints();
            gridBagSliderVertical.fill = 3;
            gridBagSliderVertical.gridy = 0;
            gridBagSliderVertical.weightx = 1.0;
            gridBagSliderVertical.insets = new Insets(0, 0, 0, 2);
            gridBagSliderVertical.gridx = 1;
            GridBagConstraints gridBagPanelPreview = new GridBagConstraints();
            gridBagPanelPreview.gridx = 0;
            gridBagPanelPreview.anchor = 18;
            gridBagPanelPreview.weighty = 0.0;
            gridBagPanelPreview.gridy = 0;
            gridBagPanelPreview.insets = new Insets(0, 4, 0, 0);
            this.jPanelLayout = new JPanel();
            this.jPanelLayout.setLayout(new GridBagLayout());
            this.jPanelLayout.add((Component)this.getJPanelPreview(), gridBagPanelPreview);
            this.jPanelLayout.add((Component)this.getJSliderVertical(), gridBagSliderVertical);
            this.jPanelLayout.add((Component)this.getJSliderHorizontal(), gridBagSliderHorizontal);
        }
        return this.jPanelLayout;
    }

    private JPanel getJPanelOffsets() {
        if (this.jPanelOffsets == null) {
            GridBagConstraints gridBagButtonBottom = new GridBagConstraints();
            gridBagButtonBottom.gridx = 3;
            gridBagButtonBottom.anchor = 18;
            gridBagButtonBottom.weightx = 120.0;
            gridBagButtonBottom.insets = new Insets(1, 0, 0, 0);
            gridBagButtonBottom.weighty = 10.0;
            gridBagButtonBottom.gridy = 1;
            GridBagConstraints gridBagButtonTop = new GridBagConstraints();
            gridBagButtonTop.gridx = 2;
            gridBagButtonTop.anchor = 18;
            gridBagButtonTop.weightx = 10.0;
            gridBagButtonTop.insets = new Insets(1, 0, 0, 0);
            gridBagButtonTop.weighty = 10.0;
            gridBagButtonTop.gridy = 1;
            GridBagConstraints gridBagButtonCenter = new GridBagConstraints();
            gridBagButtonCenter.gridx = 2;
            gridBagButtonCenter.anchor = 18;
            gridBagButtonCenter.insets = new Insets(0, 0, 2, 0);
            gridBagButtonCenter.weightx = 10.0;
            gridBagButtonCenter.gridy = 0;
            GridBagConstraints gridBagTextY = new GridBagConstraints();
            gridBagTextY.fill = 0;
            gridBagTextY.gridy = 1;
            gridBagTextY.weightx = 6.0;
            gridBagTextY.anchor = 18;
            gridBagTextY.insets = new Insets(2, 0, 0, 0);
            gridBagTextY.weighty = 10.0;
            gridBagTextY.gridx = 1;
            GridBagConstraints gridBagTextX = new GridBagConstraints();
            gridBagTextX.fill = 0;
            gridBagTextX.gridy = 0;
            gridBagTextX.weightx = 6.0;
            gridBagTextX.anchor = 18;
            gridBagTextX.insets = new Insets(1, 0, 2, 0);
            gridBagTextX.weighty = 0.0;
            gridBagTextX.gridx = 1;
            GridBagConstraints gridBagLabelY = new GridBagConstraints();
            gridBagLabelY.gridx = 0;
            gridBagLabelY.anchor = 18;
            gridBagLabelY.weightx = 0.0;
            gridBagLabelY.weighty = 10.0;
            gridBagLabelY.insets = new Insets(4, 6, 0, 4);
            gridBagLabelY.gridy = 1;
            this.jLabelY = new JLabel();
            this.jLabelY.setText("Y Offset  ");
            this.jLabelY.setPreferredSize(new Dimension(80, 14));
            this.jLabelY.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelX = new GridBagConstraints();
            gridBagLabelX.gridx = 0;
            gridBagLabelX.anchor = 18;
            gridBagLabelX.weightx = 0.0;
            gridBagLabelX.weighty = 0.0;
            gridBagLabelX.insets = new Insets(4, 6, 2, 4);
            gridBagLabelX.gridy = 0;
            this.jLabelX = new JLabel();
            this.jLabelX.setText("X Offset  ");
            this.jLabelX.setPreferredSize(new Dimension(80, 14));
            this.jLabelX.setMinimumSize(new Dimension(80, 14));
            this.jPanelOffsets = new JPanel();
            this.jPanelOffsets.setLayout(new GridBagLayout());
            this.jPanelOffsets.setBorder(BorderFactory.createTitledBorder(null, "Position", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelOffsets.add((Component)this.jLabelX, gridBagLabelX);
            this.jPanelOffsets.add((Component)this.jLabelY, gridBagLabelY);
            this.jPanelOffsets.add((Component)this.getJTextFieldX(), gridBagTextX);
            this.jPanelOffsets.add((Component)this.getJTextFieldY(), gridBagTextY);
            this.jPanelOffsets.add((Component)this.getJButtonCenter(), gridBagButtonCenter);
            this.jPanelOffsets.add((Component)this.getJButtonTop(), gridBagButtonTop);
            this.jPanelOffsets.add((Component)this.getJButtonBottom(), gridBagButtonBottom);
        }
        return this.jPanelOffsets;
    }

    private JPanel getJPanelTimes() {
        if (this.jPanelTimes == null) {
            GridBagConstraints gridBagButtonMax = new GridBagConstraints();
            gridBagButtonMax.gridx = 3;
            gridBagButtonMax.weightx = 120.0;
            gridBagButtonMax.anchor = 17;
            gridBagButtonMax.gridy = 2;
            GridBagConstraints gridBagButtonMin = new GridBagConstraints();
            gridBagButtonMin.gridx = 2;
            gridBagButtonMin.weightx = 10.0;
            gridBagButtonMin.anchor = 17;
            gridBagButtonMin.gridy = 2;
            GridBagConstraints gridBagTextDuration = new GridBagConstraints();
            gridBagTextDuration.fill = 0;
            gridBagTextDuration.gridy = 2;
            gridBagTextDuration.weightx = 6.0;
            gridBagTextDuration.anchor = 17;
            gridBagTextDuration.insets = new Insets(2, 0, 0, 0);
            gridBagTextDuration.gridx = 1;
            GridBagConstraints gridBagTextEnd = new GridBagConstraints();
            gridBagTextEnd.fill = 0;
            gridBagTextEnd.gridy = 1;
            gridBagTextEnd.weightx = 6.0;
            gridBagTextEnd.insets = new Insets(2, 0, 2, 0);
            gridBagTextEnd.anchor = 17;
            gridBagTextEnd.gridx = 1;
            GridBagConstraints gridBagTextStart = new GridBagConstraints();
            gridBagTextStart.fill = 0;
            gridBagTextStart.gridy = 0;
            gridBagTextStart.weightx = 6.0;
            gridBagTextStart.anchor = 17;
            gridBagTextStart.insets = new Insets(2, 0, 2, 0);
            gridBagTextStart.gridx = 1;
            GridBagConstraints gridBagLabelDuration = new GridBagConstraints();
            gridBagLabelDuration.gridx = 0;
            gridBagLabelDuration.anchor = 17;
            gridBagLabelDuration.insets = new Insets(0, 6, 0, 4);
            gridBagLabelDuration.weightx = 0.0;
            gridBagLabelDuration.weighty = 0.0;
            gridBagLabelDuration.gridy = 2;
            this.jLabelDuration = new JLabel();
            this.jLabelDuration.setText("Duration (ms)");
            this.jLabelDuration.setPreferredSize(new Dimension(80, 14));
            this.jLabelDuration.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelEnd = new GridBagConstraints();
            gridBagLabelEnd.gridx = 0;
            gridBagLabelEnd.anchor = 17;
            gridBagLabelEnd.insets = new Insets(0, 6, 2, 4);
            gridBagLabelEnd.weightx = 0.0;
            gridBagLabelEnd.weighty = 0.0;
            gridBagLabelEnd.gridy = 1;
            this.jLabelEnd = new JLabel();
            this.jLabelEnd.setText("End Time");
            this.jLabelEnd.setPreferredSize(new Dimension(80, 14));
            this.jLabelEnd.setMinimumSize(new Dimension(80, 14));
            GridBagConstraints gridBagLabelStart = new GridBagConstraints();
            gridBagLabelStart.gridx = 0;
            gridBagLabelStart.anchor = 17;
            gridBagLabelStart.insets = new Insets(0, 6, 2, 4);
            gridBagLabelStart.weightx = 0.0;
            gridBagLabelStart.weighty = 0.0;
            gridBagLabelStart.gridy = 0;
            this.jLabelStart = new JLabel();
            this.jLabelStart.setText("Start Time");
            this.jLabelStart.setPreferredSize(new Dimension(80, 14));
            this.jLabelStart.setMinimumSize(new Dimension(80, 14));
            this.jPanelTimes = new JPanel();
            this.jPanelTimes.setLayout(new GridBagLayout());
            this.jPanelTimes.setBorder(BorderFactory.createTitledBorder(null, "Times", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelTimes.add((Component)this.jLabelStart, gridBagLabelStart);
            this.jPanelTimes.add((Component)this.jLabelEnd, gridBagLabelEnd);
            this.jPanelTimes.add((Component)this.jLabelDuration, gridBagLabelDuration);
            this.jPanelTimes.add((Component)this.getJTextFieldStart(), gridBagTextStart);
            this.jPanelTimes.add((Component)this.getJTextFieldEnd(), gridBagTextEnd);
            this.jPanelTimes.add((Component)this.getJTextFieldDuration(), gridBagTextDuration);
            this.jPanelTimes.add((Component)this.getJButtonMin(), gridBagButtonMin);
            this.jPanelTimes.add((Component)this.getJButtonMax(), gridBagButtonMax);
        }
        return this.jPanelTimes;
    }

    private JPanel getJPanelCheck() {
        if (this.jPanelCheck == null) {
            GridBagConstraints gridBagCheckExclude = new GridBagConstraints();
            gridBagCheckExclude.gridx = 0;
            gridBagCheckExclude.gridy = 1;
            gridBagCheckExclude.weighty = 1.0;
            gridBagCheckExclude.anchor = 18;
            gridBagCheckExclude.weightx = 1.0;
            gridBagCheckExclude.insets = new Insets(0, 6, 0, 4);
            GridBagConstraints gridBagCheckForced = new GridBagConstraints();
            gridBagCheckForced.gridx = 0;
            gridBagCheckForced.gridy = 0;
            gridBagCheckForced.anchor = 18;
            gridBagCheckForced.weighty = 1.0;
            gridBagCheckForced.weightx = 1.0;
            gridBagCheckForced.insets = new Insets(0, 6, 0, 4);
            this.jPanelCheck = new JPanel();
            this.jPanelCheck.setLayout(new GridBagLayout());
            this.jPanelCheck.setPreferredSize(new Dimension(400, 23));
            this.jPanelCheck.setBorder(BorderFactory.createTitledBorder(null, "Flags", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelCheck.add((Component)this.getJCheckBoxForced(), gridBagCheckForced);
            this.jPanelCheck.add((Component)this.getJCheckBoxExclude(), gridBagCheckExclude);
        }
        return this.jPanelCheck;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonStore = new GridBagConstraints();
            gridBagButtonStore.gridx = 1;
            gridBagButtonStore.weightx = 30.0;
            gridBagButtonStore.insets = new Insets(0, 0, 2, 0);
            gridBagButtonStore.gridy = 0;
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.insets = new Insets(0, 0, 2, 9);
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.gridx = 2;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.insets = new Insets(0, 6, 2, 0);
            gridBagButtonCancel.weightx = 1.0;
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.setPreferredSize(new Dimension(400, 23));
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
            this.jPanelButtons.add((Component)this.getJButtonStore(), gridBagButtonStore);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("  <  ");
            this.jButtonPrev.setMnemonic(37);
            this.jButtonPrev.setToolTipText("Lose changes and skip to previous frame");
            this.jButtonPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.index > 0) {
                        EditDialog.this.setIndex(EditDialog.this.index - 1);
                        EditDialog.this.setEdited(false);
                    }
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("  >  ");
            this.jButtonNext.setMnemonic(39);
            this.jButtonNext.setToolTipText("Lose changes and skip to next frame");
            this.jButtonNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.index < Core.getNumFrames() - 1) {
                        EditDialog.this.setIndex(EditDialog.this.index + 1);
                        EditDialog.this.setEdited(false);
                    }
                }
            });
        }
        return this.jButtonNext;
    }

    private EditPane getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new EditPane();
            this.jPanelPreview.setLayout(new GridBagLayout());
            Dimension dim = new Dimension(miniWidth, miniHeight);
            this.jPanelPreview.setPreferredSize(dim);
            this.jPanelPreview.setSize(dim);
            this.jPanelPreview.setMinimumSize(dim);
            this.jPanelPreview.setMaximumSize(dim);
        }
        return this.jPanelPreview;
    }

    private JSlider getJSliderVertical() {
        if (this.jSliderVertical == null) {
            this.jSliderVertical = new JSlider();
            this.jSliderVertical.setOrientation(1);
            this.jSliderVertical.setToolTipText("Move subtitle vertically");
            this.jSliderVertical.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (EditDialog.this.enableSliders) {
                        int y = ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.jSliderVertical.getValue();
                        if (y < Core.getCropOfsY()) {
                            y = Core.getCropOfsY();
                        } else if (y > ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - Core.getCropOfsY()) {
                            y = ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - Core.getCropOfsY();
                        }
                        if (y != EditDialog.this.subPic.getOfsY()) {
                            EditDialog.this.subPic.setOfsY(y);
                            EditDialog.this.jTextFieldY.setText("" + EditDialog.this.subPic.getOfsY());
                            EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                            EditDialog.this.jPanelPreview.setScreenRatio(2.3333333333333335);
                            EditDialog.this.jPanelPreview.repaint();
                            EditDialog.this.setEdited(true);
                        }
                    }
                }
            });
        }
        return this.jSliderVertical;
    }

    private JSlider getJSliderHorizontal() {
        if (this.jSliderHorizontal == null) {
            this.jSliderHorizontal = new JSlider();
            this.jSliderHorizontal.setToolTipText("Move subtitle horizontally");
            this.jSliderHorizontal.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (EditDialog.this.enableSliders) {
                        int x = EditDialog.this.jSliderHorizontal.getValue();
                        if (x < 0) {
                            x = 0;
                        } else if (x > ((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth()) {
                            x = ((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth();
                        }
                        if (x != EditDialog.this.subPic.getOfsX()) {
                            EditDialog.this.subPic.setOfsX(x);
                            EditDialog.this.jTextFieldX.setText("" + EditDialog.this.subPic.getOfsX());
                            EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                            EditDialog.this.jPanelPreview.repaint();
                            EditDialog.this.setEdited(true);
                        }
                    }
                }
            });
        }
        return this.jSliderHorizontal;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.setToolTipText("Lose changes and return");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("  Ok  ");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.setToolTipText("Save changes and return");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.edited) {
                        EditDialog.this.store();
                    }
                    EditDialog.this.dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldX() {
        if (this.jTextFieldX == null) {
            this.jTextFieldX = new JTextField();
            this.jTextFieldX.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldX.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldX.setToolTipText("Set X coordinate of upper left corner of subtitle");
            this.jTextFieldX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.isReady) {
                        int x = ToolBox.getInt(EditDialog.this.jTextFieldX.getText());
                        if (x == -1) {
                            x = EditDialog.this.subPic.getOfsX();
                        } else if (x < 0) {
                            x = 0;
                        } else if (x > ((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth()) {
                            x = ((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth();
                        }
                        if (x != EditDialog.this.subPic.getOfsX()) {
                            EditDialog.this.enableSliders = false;
                            EditDialog.this.subPic.setOfsX(x);
                            EditDialog.this.jSliderHorizontal.setValue(EditDialog.this.subPic.getOfsX());
                            EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                            EditDialog.this.jPanelPreview.repaint();
                            EditDialog.this.setEdited(true);
                            EditDialog.this.enableSliders = true;
                        }
                        EditDialog.this.jTextFieldX.setText("" + EditDialog.this.subPic.getOfsX());
                        EditDialog.this.jTextFieldX.setBackground(EditDialog.this.okBgnd);
                    }
                }
            });
            this.jTextFieldX.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (EditDialog.this.isReady) {
                        int x = ToolBox.getInt(EditDialog.this.jTextFieldX.getText());
                        if (x < 0 || x > ((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth()) {
                            EditDialog.this.jTextFieldX.setBackground(EditDialog.this.errBgnd);
                        } else {
                            if (x != EditDialog.this.subPic.getOfsX()) {
                                EditDialog.this.enableSliders = false;
                                EditDialog.this.subPic.setOfsX(x);
                                EditDialog.this.jSliderHorizontal.setValue(EditDialog.this.subPic.getOfsX());
                                EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                                EditDialog.this.jPanelPreview.repaint();
                                EditDialog.this.setEdited(true);
                                EditDialog.this.enableSliders = true;
                            }
                            EditDialog.this.jTextFieldX.setBackground(EditDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldX;
    }

    private JTextField getJTextFieldY() {
        if (this.jTextFieldY == null) {
            this.jTextFieldY = new JTextField();
            this.jTextFieldY.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldY.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldY.setToolTipText("Set Y coordinate of upper left corner of subtitle");
            this.jTextFieldY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int y = ToolBox.getInt(EditDialog.this.jTextFieldY.getText());
                    if (y == -1) {
                        y = EditDialog.this.subPic.getOfsY();
                    } else if (y < Core.getCropOfsY()) {
                        y = Core.getCropOfsY();
                    } else if (y > ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - Core.getCropOfsY()) {
                        y = ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - Core.getCropOfsY();
                    }
                    if (y != EditDialog.this.subPic.getOfsY()) {
                        EditDialog.this.enableSliders = false;
                        EditDialog.this.subPic.setOfsY(y);
                        EditDialog.this.jSliderVertical.setValue(((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getOfsY());
                        EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                        EditDialog.this.jPanelPreview.repaint();
                        EditDialog.this.setEdited(true);
                        EditDialog.this.enableSliders = true;
                    }
                    EditDialog.this.jTextFieldY.setText("" + EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jTextFieldY.setBackground(EditDialog.this.okBgnd);
                }
            });
            this.jTextFieldY.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (EditDialog.this.isReady) {
                        int y = ToolBox.getInt(EditDialog.this.jTextFieldY.getText());
                        if (y < Core.getCropOfsY() || y > ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - Core.getCropOfsY()) {
                            EditDialog.this.jTextFieldY.setBackground(EditDialog.this.errBgnd);
                        } else {
                            if (y != EditDialog.this.subPic.getOfsY()) {
                                EditDialog.this.enableSliders = false;
                                EditDialog.this.subPic.setOfsY(y);
                                EditDialog.this.jSliderVertical.setValue(((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getOfsY());
                                EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                                EditDialog.this.jPanelPreview.repaint();
                                EditDialog.this.setEdited(true);
                                EditDialog.this.enableSliders = true;
                            }
                            EditDialog.this.jTextFieldY.setBackground(EditDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldY;
    }

    private JButton getJButtonCenter() {
        if (this.jButtonCenter == null) {
            this.jButtonCenter = new JButton();
            this.jButtonCenter.setText("Center");
            this.jButtonCenter.setMnemonic('c');
            this.jButtonCenter.setToolTipText("Center subpicture horizontally");
            this.jButtonCenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.subPic.setOfsX((((EditDialog)EditDialog.this).subPic.width - EditDialog.this.subPic.getImageWidth()) / 2);
                    EditDialog.this.enableSliders = false;
                    EditDialog.this.jSliderHorizontal.setValue(EditDialog.this.subPic.getOfsX());
                    EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jPanelPreview.repaint();
                    EditDialog.this.jTextFieldX.setText("" + EditDialog.this.subPic.getOfsX());
                    EditDialog.this.setEdited(true);
                    EditDialog.this.enableSliders = true;
                }
            });
        }
        return this.jButtonCenter;
    }

    private JTextField getJTextFieldStart() {
        if (this.jTextFieldStart == null) {
            this.jTextFieldStart = new JTextField();
            this.jTextFieldStart.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldStart.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldStart.setToolTipText("Set start time of subtitle");
            this.jTextFieldStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = Core.syncTimePTS(ToolBox.timeStrToPTS(EditDialog.this.jTextFieldStart.getText()), Core.getFPSTrg());
                        if (t >= ((EditDialog)EditDialog.this).subPic.endTime) {
                            t = ((EditDialog)EditDialog.this).subPic.endTime - (long)EditDialog.this.frameTime;
                        }
                        if (EditDialog.this.subPicPrev != null && ((EditDialog)EditDialog.this).subPicPrev.endTime > t) {
                            t = ((EditDialog)EditDialog.this).subPicPrev.endTime + (long)EditDialog.this.frameTime;
                        }
                        if (t >= 0L) {
                            ((EditDialog)EditDialog.this).subPic.startTime = Core.syncTimePTS(t, Core.getFPSTrg());
                            EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.jTextFieldStart.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.startTime));
                        EditDialog.this.jTextFieldStart.setBackground(EditDialog.this.okBgnd);
                        EditDialog.this.isReady = true;
                    }
                }
            });
            this.jTextFieldStart.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = Core.syncTimePTS(ToolBox.timeStrToPTS(EditDialog.this.jTextFieldStart.getText()), Core.getFPSTrg());
                        if (t < 0L || t >= ((EditDialog)EditDialog.this).subPic.endTime || EditDialog.this.subPicPrev != null && ((EditDialog)EditDialog.this).subPicPrev.endTime > t) {
                            EditDialog.this.jTextFieldStart.setBackground(EditDialog.this.errBgnd);
                        } else {
                            ((EditDialog)EditDialog.this).subPic.startTime = t;
                            EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                            if (!EditDialog.this.jTextFieldStart.getText().equalsIgnoreCase(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.startTime))) {
                                EditDialog.this.jTextFieldStart.setBackground(EditDialog.this.warnBgnd);
                            } else {
                                EditDialog.this.jTextFieldStart.setBackground(EditDialog.this.okBgnd);
                            }
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.isReady = true;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldStart;
    }

    private JTextField getJTextFieldEnd() {
        if (this.jTextFieldEnd == null) {
            this.jTextFieldEnd = new JTextField();
            this.jTextFieldEnd.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldEnd.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldEnd.setToolTipText("Set end time of subtitle");
            this.jTextFieldEnd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = Core.syncTimePTS(ToolBox.timeStrToPTS(EditDialog.this.jTextFieldEnd.getText()), Core.getFPSTrg());
                        if (t <= ((EditDialog)EditDialog.this).subPic.startTime) {
                            t = ((EditDialog)EditDialog.this).subPic.startTime + (long)EditDialog.this.frameTime;
                        }
                        if (EditDialog.this.subPicNext != null && ((EditDialog)EditDialog.this).subPicNext.startTime < t) {
                            t = ((EditDialog)EditDialog.this).subPicNext.startTime;
                        }
                        if (t >= 0L) {
                            ((EditDialog)EditDialog.this).subPic.endTime = Core.syncTimePTS(t, Core.getFPSTrg());
                            EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime));
                        EditDialog.this.jTextFieldEnd.setBackground(EditDialog.this.okBgnd);
                        EditDialog.this.isReady = true;
                    }
                }
            });
            this.jTextFieldEnd.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = Core.syncTimePTS(ToolBox.timeStrToPTS(EditDialog.this.jTextFieldEnd.getText()), Core.getFPSTrg());
                        if (t < 0L || t <= ((EditDialog)EditDialog.this).subPic.startTime || EditDialog.this.subPicNext != null && ((EditDialog)EditDialog.this).subPicNext.startTime < t) {
                            EditDialog.this.jTextFieldEnd.setBackground(EditDialog.this.errBgnd);
                        } else {
                            ((EditDialog)EditDialog.this).subPic.endTime = t;
                            EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                            if (!EditDialog.this.jTextFieldEnd.getText().equalsIgnoreCase(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime))) {
                                EditDialog.this.jTextFieldEnd.setBackground(EditDialog.this.warnBgnd);
                            } else {
                                EditDialog.this.jTextFieldEnd.setBackground(EditDialog.this.okBgnd);
                            }
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.isReady = true;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldEnd;
    }

    private JTextField getJTextFieldDuration() {
        if (this.jTextFieldDuration == null) {
            this.jTextFieldDuration = new JTextField();
            this.jTextFieldDuration.setPreferredSize(new Dimension(80, 20));
            this.jTextFieldDuration.setMinimumSize(new Dimension(80, 20));
            this.jTextFieldDuration.setToolTipText("Set display duration of subtitle in milliseconds");
            this.jTextFieldDuration.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = (long)(ToolBox.getDouble(EditDialog.this.jTextFieldDuration.getText()) * 90.0);
                        if (t >= 0L && t < (long)EditDialog.this.frameTime) {
                            t = EditDialog.this.frameTime;
                        }
                        if (t > 0L) {
                            if (EditDialog.this.subPicNext != null && ((EditDialog)EditDialog.this).subPicNext.startTime < (t += ((EditDialog)EditDialog.this).subPic.startTime)) {
                                t = ((EditDialog)EditDialog.this).subPicNext.startTime;
                            }
                            ((EditDialog)EditDialog.this).subPic.endTime = Core.syncTimePTS(t, Core.getFPSTrg());
                            EditDialog.this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime));
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                        EditDialog.this.jTextFieldDuration.setBackground(EditDialog.this.okBgnd);
                        EditDialog.this.isReady = true;
                    }
                }
            });
            this.jTextFieldDuration.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (EditDialog.this.isReady) {
                        EditDialog.this.isReady = false;
                        long t = (long)(ToolBox.getDouble(EditDialog.this.jTextFieldDuration.getText()) * 90.0);
                        if (t < (long)EditDialog.this.frameTime) {
                            EditDialog.this.jTextFieldDuration.setBackground(EditDialog.this.errBgnd);
                        } else {
                            if (EditDialog.this.subPicNext != null && ((EditDialog)EditDialog.this).subPicNext.startTime < (t += ((EditDialog)EditDialog.this).subPic.startTime)) {
                                t = ((EditDialog)EditDialog.this).subPicNext.startTime;
                            }
                            ((EditDialog)EditDialog.this).subPic.endTime = Core.syncTimePTS(t, Core.getFPSTrg());
                            EditDialog.this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime));
                            EditDialog.this.setEdited(true);
                            if (!EditDialog.this.jTextFieldDuration.getText().equalsIgnoreCase(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0))) {
                                EditDialog.this.jTextFieldDuration.setBackground(EditDialog.this.warnBgnd);
                            } else {
                                EditDialog.this.jTextFieldDuration.setBackground(EditDialog.this.okBgnd);
                            }
                            EditDialog.this.setEdited(true);
                        }
                        EditDialog.this.isReady = true;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldDuration;
    }

    private JButton getJButtonMin() {
        if (this.jButtonMin == null) {
            this.jButtonMin = new JButton();
            this.jButtonMin.setText("   Min   ");
            this.jButtonMin.setMnemonic('n');
            this.jButtonMin.setToolTipText("Set minimum duration");
            this.jButtonMin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long t = Core.getMinTimePTS();
                    if (t >= 0L) {
                        if (EditDialog.this.subPicNext != null && ((EditDialog)EditDialog.this).subPicNext.startTime < (t += ((EditDialog)EditDialog.this).subPic.startTime)) {
                            t = ((EditDialog)EditDialog.this).subPicNext.startTime;
                        }
                        ((EditDialog)EditDialog.this).subPic.endTime = Core.syncTimePTS(t, Core.getFPSTrg());
                        EditDialog.this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime));
                        EditDialog.this.setEdited(true);
                    }
                    EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                }
            });
        }
        return this.jButtonMin;
    }

    private JButton getJButtonMax() {
        if (this.jButtonMax == null) {
            this.jButtonMax = new JButton();
            this.jButtonMax.setText("   Max  ");
            this.jButtonMax.setMnemonic('m');
            this.jButtonMax.setToolTipText("Set maximum duration");
            this.jButtonMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long t = EditDialog.this.subPicNext != null ? ((EditDialog)EditDialog.this).subPicNext.startTime : ((EditDialog)EditDialog.this).subPic.endTime + 900000L;
                    ((EditDialog)EditDialog.this).subPic.endTime = Core.syncTimePTS(t, Core.getFPSTrg());
                    EditDialog.this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(((EditDialog)EditDialog.this).subPic.endTime));
                    EditDialog.this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(((EditDialog)EditDialog.this).subPic.endTime - ((EditDialog)EditDialog.this).subPic.startTime) / 90.0));
                    EditDialog.this.setEdited(true);
                }
            });
        }
        return this.jButtonMax;
    }

    private JButton getJButtonTop() {
        if (this.jButtonTop == null) {
            this.jButtonTop = new JButton();
            this.jButtonTop.setText("   Top  ");
            this.jButtonTop.setMnemonic('t');
            this.jButtonTop.setToolTipText("Move to upper cinemascope bar");
            this.jButtonTop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cineH = ((EditDialog)EditDialog.this).subPic.height * 5 / 42;
                    int y = cineH - EditDialog.this.subPic.getImageHeight();
                    if (y < 10) {
                        y = 10;
                    }
                    if (y < Core.getCropOfsY()) {
                        y = Core.getCropOfsY();
                    }
                    EditDialog.this.enableSliders = false;
                    EditDialog.this.subPic.setOfsY(y);
                    EditDialog.this.jSliderVertical.setValue(((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jPanelPreview.repaint();
                    EditDialog.this.jTextFieldY.setText("" + EditDialog.this.subPic.getOfsY());
                    EditDialog.this.setEdited(true);
                    EditDialog.this.enableSliders = true;
                }
            });
        }
        return this.jButtonTop;
    }

    private JButton getJButtonBottom() {
        if (this.jButtonBottom == null) {
            this.jButtonBottom = new JButton();
            this.jButtonBottom.setText("Bottom");
            this.jButtonBottom.setMnemonic('b');
            this.jButtonBottom.setToolTipText("Move to lower cinemascope bar");
            this.jButtonBottom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cineH = ((EditDialog)EditDialog.this).subPic.height * 5 / 42;
                    int y = ((EditDialog)EditDialog.this).subPic.height - cineH;
                    if (y + EditDialog.this.subPic.getImageHeight() > ((EditDialog)EditDialog.this).subPic.height - Core.getCropOfsY()) {
                        y = ((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getImageHeight() - 10;
                    }
                    EditDialog.this.enableSliders = false;
                    EditDialog.this.subPic.setOfsY(y);
                    EditDialog.this.jSliderVertical.setValue(((EditDialog)EditDialog.this).subPic.height - EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jPanelPreview.setOffsets(EditDialog.this.subPic.getOfsX(), EditDialog.this.subPic.getOfsY());
                    EditDialog.this.jPanelPreview.repaint();
                    EditDialog.this.jTextFieldY.setText("" + EditDialog.this.subPic.getOfsY());
                    EditDialog.this.setEdited(true);
                    EditDialog.this.enableSliders = true;
                }
            });
        }
        return this.jButtonBottom;
    }

    public void error(String s) {
        Core.printErr(s);
        JOptionPane.showMessageDialog(this, s, "Error!", 2);
    }

    public int getIndex() {
        return this.index;
    }

    private void store() {
        SubPicture s = Core.getSubPictureTrg(this.index);
        s.endTime = this.subPic.endTime;
        s.startTime = this.subPic.startTime;
        s.setOfsX(this.subPic.getOfsX());
        s.setOfsY(this.subPic.getOfsY());
        s.isforced = this.subPic.isforced;
        s.exclude = this.subPic.exclude;
        s.erasePatch = this.subPic.erasePatch;
    }

    public void setIndex(int idx) {
        this.isReady = false;
        this.index = idx;
        this.subPicPrev = idx > 0 ? Core.getSubPictureTrg(idx - 1) : null;
        this.subPicNext = idx < Core.getNumFrames() - 1 ? Core.getSubPictureTrg(idx + 1) : null;
        try {
            Core.convertSup(idx, idx + 1, Core.getNumFrames());
            this.subPic = Core.getSubPictureTrg(idx).copy();
            this.image = Core.getTrgImagePatched(this.subPic);
            if (this.subPic.erasePatch != null && this.subPic.erasePatch.size() > 0) {
                this.jButtonUndoPatch.setEnabled(true);
                this.jButtonUndoAllPatches.setEnabled(true);
            }
            this.enableSliders = false;
            this.jSliderHorizontal.setMaximum(this.subPic.width);
            this.jSliderHorizontal.setValue(this.subPic.getOfsX());
            this.jSliderVertical.setMaximum(this.subPic.height);
            this.jSliderVertical.setValue(this.subPic.height - this.subPic.getOfsY());
            this.enableSliders = true;
            this.jLabelInfo.setText("Frame " + (idx + 1) + " of " + Core.getNumFrames());
            this.jTextFieldStart.setText(ToolBox.ptsToTimeStr(this.subPic.startTime));
            this.jTextFieldEnd.setText(ToolBox.ptsToTimeStr(this.subPic.endTime));
            this.jTextFieldDuration.setText(ToolBox.formatDouble((double)(this.subPic.endTime - this.subPic.startTime) / 90.0));
            this.jTextFieldX.setText("" + this.subPic.getOfsX());
            this.jTextFieldY.setText("" + this.subPic.getOfsY());
            this.jPanelPreview.setOffsets(this.subPic.getOfsX(), this.subPic.getOfsY());
            this.jPanelPreview.setDim(this.subPic.width, this.subPic.height);
            this.jPanelPreview.setCropOfsY(Core.getCropOfsY());
            this.jPanelPreview.setImage(this.image, this.subPic.getImageWidth(), this.subPic.getImageHeight());
            this.jPanelPreview.repaint();
            this.jPanelPreview.setExcluded(this.subPic.exclude);
            this.jCheckBoxExclude.setSelected(this.subPic.exclude);
            this.jCheckBoxForced.setSelected(this.subPic.isforced);
            this.isReady = true;
        }
        catch (CoreException ex) {
            this.error(ex.getMessage());
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
            Core.exit();
            System.exit(4);
        }
    }

    private JButton getJButtonStore() {
        if (this.jButtonStore == null) {
            this.jButtonStore = new JButton();
            this.jButtonStore.setText("Save Changes");
            this.jButtonStore.setMnemonic('s');
            this.jButtonStore.setEnabled(false);
            this.jButtonStore.setToolTipText("Save changes and continue editing");
            this.jButtonStore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.store();
                    EditDialog.this.setEdited(false);
                }
            });
        }
        return this.jButtonStore;
    }

    private JCheckBox getJCheckBoxForced() {
        if (this.jCheckBoxForced == null) {
            this.jCheckBoxForced = new JCheckBox();
            this.jCheckBoxForced.setText("Forced Caption");
            this.jCheckBoxForced.setMnemonic('f');
            this.jCheckBoxForced.setToolTipText("Force display of this subtitle");
            this.jCheckBoxForced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((EditDialog)EditDialog.this).subPic.isforced = EditDialog.this.jCheckBoxForced.isSelected();
                    EditDialog.this.setEdited(true);
                }
            });
        }
        return this.jCheckBoxForced;
    }

    private JCheckBox getJCheckBoxExclude() {
        if (this.jCheckBoxExclude == null) {
            this.jCheckBoxExclude = new JCheckBox();
            this.jCheckBoxExclude.setText("Exclude from export");
            this.jCheckBoxExclude.setMnemonic('x');
            this.jCheckBoxExclude.setToolTipText("Exclude this subtitle from export");
            this.jCheckBoxExclude.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((EditDialog)EditDialog.this).subPic.exclude = EditDialog.this.jCheckBoxExclude.isSelected();
                    EditDialog.this.jPanelPreview.setExcluded(((EditDialog)EditDialog.this).subPic.exclude);
                    EditDialog.this.jPanelPreview.repaint();
                    EditDialog.this.setEdited(true);
                }
            });
        }
        return this.jCheckBoxExclude;
    }

    @Override
    public void selectionPerformed(boolean valid) {
        this.jButtonAddPatch.setEnabled(valid);
    }

    private JPanel getJPanelPatches() {
        if (this.jPanelPatches == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.weightx = 10.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 18;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 18;
            this.jPanelPatches = new JPanel();
            this.jPanelPatches.setLayout(new GridBagLayout());
            this.jPanelPatches.setBorder(BorderFactory.createTitledBorder(null, "Erase Patches", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelPatches.add((Component)this.getJButtonAddPatch(), gridBagConstraints);
            this.jPanelPatches.add((Component)this.getJButtonUndoPatch(), gridBagConstraints1);
            this.jPanelPatches.add((Component)this.getJButtonUndoAllPatches(), gridBagConstraints2);
        }
        return this.jPanelPatches;
    }

    private JButton getJButtonAddPatch() {
        if (this.jButtonAddPatch == null) {
            this.jButtonAddPatch = new JButton();
            this.jButtonAddPatch.setText("Erase");
            this.jButtonAddPatch.setMnemonic('e');
            this.jButtonAddPatch.setToolTipText("Add erase patch to make the selected area transparent");
            this.jButtonAddPatch.setEnabled(false);
            this.jButtonAddPatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] sel = EditDialog.this.jPanelPreview.getSelection();
                    if (sel != null) {
                        if (((EditDialog)EditDialog.this).subPic.erasePatch == null) {
                            ((EditDialog)EditDialog.this).subPic.erasePatch = new ArrayList();
                        }
                        ErasePatch ep = new ErasePatch(sel[0], sel[1], sel[2] - sel[0] + 1, sel[3] - sel[1] + 1);
                        ((EditDialog)EditDialog.this).subPic.erasePatch.add(ep);
                        EditDialog.this.jButtonUndoPatch.setEnabled(true);
                        EditDialog.this.jButtonUndoAllPatches.setEnabled(true);
                        EditDialog.this.image = Core.getTrgImagePatched(EditDialog.this.subPic);
                        EditDialog.this.jPanelPreview.setImage(EditDialog.this.image, EditDialog.this.subPic.getImageWidth(), EditDialog.this.subPic.getImageHeight());
                        EditDialog.this.setEdited(true);
                    }
                    EditDialog.this.jButtonAddPatch.setEnabled(false);
                    EditDialog.this.jPanelPreview.removeSelection();
                    EditDialog.this.jPanelPreview.repaint();
                }
            });
        }
        return this.jButtonAddPatch;
    }

    private JButton getJButtonUndoPatch() {
        if (this.jButtonUndoPatch == null) {
            this.jButtonUndoPatch = new JButton();
            this.jButtonUndoPatch.setText("Undo Erase");
            this.jButtonUndoPatch.setMnemonic('u');
            this.jButtonUndoPatch.setToolTipText("Remove one erase patch from the stack (undo one delete step)");
            this.jButtonUndoPatch.setEnabled(false);
            this.jButtonUndoPatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((EditDialog)EditDialog.this).subPic.erasePatch != null && ((EditDialog)EditDialog.this).subPic.erasePatch.size() > 0) {
                        ((EditDialog)EditDialog.this).subPic.erasePatch.remove(((EditDialog)EditDialog.this).subPic.erasePatch.size() - 1);
                        if (((EditDialog)EditDialog.this).subPic.erasePatch.size() == 0) {
                            ((EditDialog)EditDialog.this).subPic.erasePatch = null;
                            EditDialog.this.jButtonUndoPatch.setEnabled(false);
                            EditDialog.this.jButtonUndoAllPatches.setEnabled(false);
                        }
                        EditDialog.this.image = Core.getTrgImagePatched(EditDialog.this.subPic);
                        EditDialog.this.jPanelPreview.setImage(EditDialog.this.image, EditDialog.this.subPic.getImageWidth(), EditDialog.this.subPic.getImageHeight());
                        EditDialog.this.jPanelPreview.repaint();
                        EditDialog.this.setEdited(true);
                    }
                }
            });
        }
        return this.jButtonUndoPatch;
    }

    private JButton getJButtonUndoAllPatches() {
        if (this.jButtonUndoAllPatches == null) {
            this.jButtonUndoAllPatches = new JButton();
            this.jButtonUndoAllPatches.setText("Undo All");
            this.jButtonUndoAllPatches.setMnemonic('a');
            this.jButtonUndoAllPatches.setEnabled(false);
            this.jButtonUndoAllPatches.setToolTipText("Remove all erase patches from the stack (undo all delete steps)");
            this.jButtonUndoAllPatches.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((EditDialog)EditDialog.this).subPic.erasePatch != null) {
                        ((EditDialog)EditDialog.this).subPic.erasePatch.clear();
                        ((EditDialog)EditDialog.this).subPic.erasePatch = null;
                        EditDialog.this.image = Core.getTrgImagePatched(EditDialog.this.subPic);
                        EditDialog.this.jPanelPreview.setImage(EditDialog.this.image, EditDialog.this.subPic.getImageWidth(), EditDialog.this.subPic.getImageHeight());
                        EditDialog.this.jPanelPreview.repaint();
                        EditDialog.this.setEdited(true);
                    }
                    EditDialog.this.jButtonUndoPatch.setEnabled(false);
                    EditDialog.this.jButtonUndoAllPatches.setEnabled(false);
                }
            });
        }
        return this.jButtonUndoAllPatches;
    }

    private JButton getJButtonStoreNext() {
        if (this.jButtonStoreNext == null) {
            this.jButtonStoreNext = new JButton();
            this.jButtonStoreNext.setText("<html><font color=\"red\"><b>&nbsp;&gt;&nbsp;</b></font></html>");
            this.jButtonStoreNext.setToolTipText("Store changes and skip to next frame");
            this.jButtonStoreNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.edited) {
                        EditDialog.this.store();
                    }
                    if (EditDialog.this.index < Core.getNumFrames() - 1) {
                        EditDialog.this.setIndex(EditDialog.this.index + 1);
                        EditDialog.this.setEdited(false);
                    }
                }
            });
        }
        return this.jButtonStoreNext;
    }

    private JButton getJButtonStorePrev() {
        if (this.jButtonStorePrev == null) {
            this.jButtonStorePrev = new JButton();
            this.jButtonStorePrev.setText("<html><font color=\"red\"><b>&nbsp;&lt;&nbsp;</b></font></html>");
            this.jButtonStorePrev.setToolTipText("Store changes and skip to previous frame");
            this.jButtonStorePrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditDialog.this.edited) {
                        EditDialog.this.store();
                    }
                    if (EditDialog.this.index > 0) {
                        EditDialog.this.setIndex(EditDialog.this.index - 1);
                        EditDialog.this.setEdited(false);
                    }
                }
            });
        }
        return this.jButtonStorePrev;
    }
}

