// Copyright (c) 2010, Amar Takhar <verm@aegisub.org>
//
// Permission to use, copy, modify, and distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

/// @file io.h
/// @brief Public interface for IO methods.
/// @ingroup libaegisub

#include <libaegisub/exception.h>
#include <libaegisub/fs_fwd.h>

#include <boost/filesystem/path.hpp>
#include <iosfwd>
#include <memory>

namespace agi {
	namespace io {

DEFINE_EXCEPTION(IOError, Exception);
DEFINE_EXCEPTION(IOFatal, IOError);

std::unique_ptr<std::istream> Open(fs::path const& file, bool binary = false);

class Save {
	std::unique_ptr<std::ostream> fp;
	const fs::path file_name;
	const fs::path tmp_name;

public:
	Save(fs::path const& file, bool binary = false);
	~Save() noexcept(false);
	std::ostream& Get() { return *fp; }
};

	} // namespace io
} // namespace agi
